/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.eumagent.runtime.networkrequests;

import com.appdynamics.eumagent.runtime.HttpRequestTracker;
import com.appdynamics.eumagent.runtime.Instrumentation;
import com.appdynamics.eumagent.runtime.InstrumentationCallbacks;
import com.appdynamics.eumagent.runtime.ServerCorrelationHeaders;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class OkHttp3 {
    public static final String OKHTTP3_INSTRUMENTATION_SOURCE = "AppDynamics.OkHttp3Client";

    public static class AppDynamicsInterceptor
    implements Interceptor {
        @Override
        public Response intercept(Interceptor.Chain chain) throws IOException {
            okhttp3.Request request = chain.request();
            HttpRequestTracker tracker = null;
            try {
                tracker = Instrumentation.beginHttpRequest((URL)request.url().url());
                tracker.withInstrumentationSource(OkHttp3.OKHTTP3_INSTRUMENTATION_SOURCE).withRequestHeaderFields(request.headers().toMultimap());
            }
            catch (Throwable e) {
                InstrumentationCallbacks.safeLog((String)"Trying to create a OkHttp3 tracker", (Throwable)e);
            }
            IOException clientIOException = null;
            RuntimeException clientRuntimeException = null;
            Response response = null;
            try {
                response = chain.proceed(request);
            }
            catch (IOException e) {
                clientIOException = e;
            }
            catch (RuntimeException e) {
                clientRuntimeException = e;
            }
            try {
                if (tracker != null) {
                    if (clientIOException != null) {
                        tracker.withException((Exception)clientIOException);
                    } else if (clientRuntimeException != null) {
                        tracker.withException((Exception)clientRuntimeException);
                    } else {
                        int responseCode = response.code();
                        String statusLine = null;
                        if (responseCode >= 400) {
                            statusLine = response.message();
                        }
                        tracker.withResponseCode(responseCode).withStatusLine(statusLine).withResponseHeaderFields(response.headers().toMultimap()).reportDone();
                    }
                }
            }
            catch (Throwable e) {
                InstrumentationCallbacks.safeLog((String)"Trying to report OkHttp3 tracker", (Throwable)e);
            }
            if (clientIOException != null) {
                throw clientIOException;
            }
            if (clientRuntimeException != null) {
                throw clientRuntimeException;
            }
            return response;
        }
    }

    public static class Request {

        public static class Builder {

            public static class build {
                public static Object Enter(Object builderObject) {
                    try {
                        Request.Builder builder = (Request.Builder)builderObject;
                        Map headers = ServerCorrelationHeaders.generate();
                        for (Map.Entry header : headers.entrySet()) {
                            for (String value : (List)header.getValue()) {
                                builder.header((String)header.getKey(), value);
                            }
                        }
                    }
                    catch (Throwable e) {
                        InstrumentationCallbacks.safeLog((String)"Trying to add correlation headers.", (Throwable)e);
                    }
                    return null;
                }
            }
        }
    }

    public static class OkHttpClient {

        public static class Constructor {

            public static class INIT {
                public static OkHttpClient.Builder WrapLastArg(OkHttpClient.Builder builder) {
                    try {
                        List interceptors = builder.interceptors();
                        for (Interceptor interceptor : interceptors) {
                            if (!(interceptor instanceof AppDynamicsInterceptor)) continue;
                            return builder;
                        }
                        builder.addInterceptor((Interceptor)new AppDynamicsInterceptor());
                    }
                    catch (Throwable e) {
                        InstrumentationCallbacks.safeLog((String)"Trying to add our OkHttp3 interceptor", (Throwable)e);
                    }
                    return builder;
                }
            }
        }
    }
}

