/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci;

import com.appdynamics.android.bci.BCILifecycleListener;
import com.appdynamics.android.logging.BCILogger;
import com.appdynamics.android.util.BuildUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;

public class OpaqueCallbackInjector
extends BCILifecycleListener.Adapter {
    protected final BCILogger logger = BCILogger.getLoggerFor(this.getClass());
    private final Set<Class> classesToInject = new HashSet<Class>();

    public void addClassToInject(String className) {
        if (className == null) {
            return;
        }
        className = className.replace('/', '.');
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            Class<?> mainClassToInject = classLoader.loadClass(className);
            this.recursivelyAddClasses(mainClassToInject);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void recursivelyAddClasses(Class rootClass) {
        Class<?>[] allClassesToInject;
        this.classesToInject.add(rootClass);
        for (Class<?> classToInject : allClassesToInject = rootClass.getDeclaredClasses()) {
            this.recursivelyAddClasses(classToInject);
        }
    }

    public void writeOpaqueCallbacks(File classesDirectory) throws IOException {
        this.logger.info("Starting to inject opaque callbacks", new Object[0]);
        for (Class classToInject : this.classesToInject) {
            InputStream in;
            FileOutputStream out;
            block10: {
                this.logger.info("Injecting: %s", classToInject.getName());
                out = null;
                in = null;
                try {
                    int len;
                    String classAsPath = classToInject.getName().replace('.', '/') + ".class";
                    this.logger.info("  as path: %s", classAsPath);
                    in = classToInject.getClassLoader().getResourceAsStream(classAsPath);
                    if (in == null) {
                        throw new RuntimeException("Failed to open stream to inject class '" + classAsPath + "', if you have the Gradle Daemon enabled, please reset it.");
                    }
                    File file = new File(classesDirectory.getAbsolutePath() + File.separator + classAsPath);
                    if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                        throw new IOException("Unable to create parent directory: " + file.getParentFile());
                    }
                    out = new FileOutputStream(file);
                    byte[] buffer = new byte[1024];
                    while ((len = in.read(buffer)) != -1) {
                        out.write(buffer, 0, len);
                    }
                    if (out == null) break block10;
                }
                catch (Exception ex) {
                    try {
                        throw new IOException(ex);
                    }
                    catch (Throwable throwable) {
                        if (out != null) {
                            BuildUtils.closeQuietly(out);
                        }
                        if (in != null) {
                            BuildUtils.closeQuietly(out);
                        }
                        throw throwable;
                    }
                }
                BuildUtils.closeQuietly(out);
            }
            if (in == null) continue;
            BuildUtils.closeQuietly(out);
        }
    }
}

