/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.adapters;

import com.appdynamics.android.bci.BaseClassVisitor;
import com.appdynamics.android.bci.configs.MethodDetourConfig;
import com.appdynamics.android.logging.BCIRunSummary;
import com.appdynamics.repackaged.asm.ClassVisitor;
import com.appdynamics.repackaged.asm.MethodVisitor;

public class MethodDetourAdapter
extends BaseClassVisitor {
    private MethodDetourConfig config;
    private boolean isTargetClass = true;

    public MethodDetourAdapter(ClassVisitor cv, MethodDetourConfig config) {
        super(cv);
        this.config = config;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.isTargetClass = this.config.methodCallMatcher.isTargetClass(name);
    }

    @Override
    public MethodVisitor visitMethod(int access, String methodName, String methodDesc, String signature, String[] exceptions) {
        MethodVisitor baseMV = super.visitMethod(access, methodName, methodDesc, signature, exceptions);
        if (this.isTargetClass) {
            return new BaseClassVisitor.BaseMethodVisitor(baseMV, access, methodName, methodDesc){

                @Override
                public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                    if (((MethodDetourAdapter)MethodDetourAdapter.this).config.methodCallMatcher.isMethodCallMatched(opcode, owner, name, desc)) {
                        BCIRunSummary.getDefaultInstance().featureInjected(((MethodDetourAdapter)MethodDetourAdapter.this).config.featureName, MethodDetourAdapter.this.className);
                        this.mv.visitMethodInsn(184, ((MethodDetourAdapter)MethodDetourAdapter.this).config.detourClass, ((MethodDetourAdapter)MethodDetourAdapter.this).config.detourMethod.getName(), ((MethodDetourAdapter)MethodDetourAdapter.this).config.detourMethod.getDescriptor());
                    } else {
                        super.visitMethodInsn(opcode, owner, name, desc);
                    }
                }
            };
        }
        return baseMV;
    }
}

