/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci;

import com.appdynamics.android.bci.BaseClassVisitor;
import com.appdynamics.android.bci.QName;
import com.appdynamics.android.logging.BCIRunSummary;
import com.appdynamics.repackaged.asm.ClassVisitor;
import com.appdynamics.repackaged.asm.MethodVisitor;

public class ReplaceMethodCallAdapter
extends BaseClassVisitor {
    private final QName methodToReplace;
    private final String originalSignature;
    private final QName methodToCall;
    private final String newSignature;
    private final ClassVisitor classVisitor;
    private final String feature;

    public ReplaceMethodCallAdapter(QName methodToReplace, String originalSignature, QName methodToCall, String newSignature, ClassVisitor classVisitor, String feature) {
        super(classVisitor);
        this.methodToReplace = methodToReplace;
        this.originalSignature = originalSignature;
        this.methodToCall = methodToCall;
        this.newSignature = newSignature;
        this.classVisitor = classVisitor;
        this.feature = feature;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor methodVisitor = this.classVisitor.visitMethod(access, name, desc, signature, exceptions);
        final String sig = this.newSignature;
        if (methodVisitor != null) {
            methodVisitor = new BaseClassVisitor.BaseMethodVisitor(methodVisitor, access, name, desc){

                @Override
                public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                    boolean shouldChange;
                    boolean bl = shouldChange = (opcode == 182 || opcode == 185) && ReplaceMethodCallAdapter.this.methodToReplace.equals(new QName(owner, name)) && desc.equals(ReplaceMethodCallAdapter.this.originalSignature);
                    if (shouldChange) {
                        BCIRunSummary.getDefaultInstance().featureInjected(ReplaceMethodCallAdapter.this.feature, ReplaceMethodCallAdapter.this.className);
                        ReplaceMethodCallAdapter.this.logInjectedWithLineNumber("Replaced %s.%s with call to %s.%s", owner, name, ((ReplaceMethodCallAdapter)ReplaceMethodCallAdapter.this).methodToCall.owner, ((ReplaceMethodCallAdapter)ReplaceMethodCallAdapter.this).methodToCall.name);
                        super.visitMethodInsn(184, ((ReplaceMethodCallAdapter)ReplaceMethodCallAdapter.this).methodToCall.owner, ((ReplaceMethodCallAdapter)ReplaceMethodCallAdapter.this).methodToCall.name, sig);
                    } else {
                        super.visitMethodInsn(opcode, owner, name, desc);
                    }
                }
            };
        }
        return methodVisitor;
    }
}

