/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci;

import com.appdynamics.android.bci.BCILifecycleListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class BCILifecycleListenerWrapper
implements BCILifecycleListener {
    private final List<BCILifecycleListener> adapters = new ArrayList<BCILifecycleListener>(0);

    @Override
    public void beginInstrumentation() {
        for (BCILifecycleListener listener : this.adapters) {
            listener.beginInstrumentation();
        }
    }

    @Override
    public void beginInstrumentationOfClassContainer(File inputFile) {
        for (BCILifecycleListener listener : this.adapters) {
            listener.beginInstrumentationOfClassContainer(inputFile);
        }
    }

    @Override
    public void endInstrumentationOfClassContainer(File inputFile) {
        for (BCILifecycleListener listener : this.adapters) {
            listener.endInstrumentationOfClassContainer(inputFile);
        }
    }

    @Override
    public Set<String> injectBuildInfoAndInfoPointRegister(File classesDirectory, Collection<String> pastInfoPoints) {
        Set<String> result = Collections.emptySet();
        for (BCILifecycleListener listener : this.adapters) {
            Set<String> thisListenerResult = listener.injectBuildInfoAndInfoPointRegister(classesDirectory, pastInfoPoints);
            if (thisListenerResult == null || thisListenerResult.isEmpty()) continue;
            result = thisListenerResult;
        }
        return result;
    }

    @Override
    public void endInstrumentation() {
        for (BCILifecycleListener listener : this.adapters) {
            listener.endInstrumentation();
        }
    }

    protected void addLifecycleListener(BCILifecycleListener bciLifecycleListener, BCILifecycleListener ... others) {
        this.adapters.add(bciLifecycleListener);
        for (BCILifecycleListener listener : others) {
            this.adapters.add(listener);
        }
    }

    protected void removeLifecycleListener(BCILifecycleListener bciLifecycleListener) {
        this.adapters.add(bciLifecycleListener);
    }
}

