/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.subscription;

import com.apollographql.subscription.callback.SubscriptionCallback;
import com.apollographql.subscription.callback.SubscriptionCallbackHandler;
import graphql.ExecutionResult;
import graphql.GraphQLError;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.Ordered;
import org.springframework.graphql.ExecutionGraphQlResponse;
import org.springframework.graphql.server.WebGraphQlInterceptor;
import org.springframework.graphql.server.WebGraphQlRequest;
import org.springframework.graphql.server.WebGraphQlResponse;
import org.springframework.graphql.server.WebSocketGraphQlRequest;
import org.springframework.graphql.support.DefaultExecutionGraphQlResponse;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.server.ResponseStatusException;
import reactor.core.publisher.Mono;

public class CallbackWebGraphQLInterceptor
implements WebGraphQlInterceptor,
Ordered {
    private static final Log logger = LogFactory.getLog(CallbackWebGraphQLInterceptor.class);
    private final SubscriptionCallbackHandler subscriptionCallbackHandler;
    private final int order;
    private final Set<String> contextualHeaders;

    public CallbackWebGraphQLInterceptor(SubscriptionCallbackHandler subscriptionCallbackHandler) {
        this(subscriptionCallbackHandler, Integer.MAX_VALUE);
    }

    public CallbackWebGraphQLInterceptor(SubscriptionCallbackHandler subscriptionCallbackHandler, int order) {
        this(subscriptionCallbackHandler, order, new HashSet<String>());
    }

    public CallbackWebGraphQLInterceptor(SubscriptionCallbackHandler subscriptionCallbackHandler, Set<String> contextualHeaders) {
        this(subscriptionCallbackHandler, Integer.MAX_VALUE, contextualHeaders);
    }

    public CallbackWebGraphQLInterceptor(SubscriptionCallbackHandler subscriptionCallbackHandler, int order, Set<String> contextualHeaders) {
        this.subscriptionCallbackHandler = subscriptionCallbackHandler;
        this.order = order;
        this.contextualHeaders = contextualHeaders;
    }

    public Mono<WebGraphQlResponse> intercept(WebGraphQlRequest request, WebGraphQlInterceptor.Chain chain) {
        if (!this.isWebSocketRequest(request) && request.getDocument().startsWith("subscription")) {
            return SubscriptionCallback.parseSubscriptionCallbackExtension(request.getExtensions()).flatMap(callback -> {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Starting subscription using callback: " + String.valueOf(callback)));
                }
                SubscriptionCallback callbackWithContextualData = callback.withContext(this.parseContextualHeaders(request));
                return this.subscriptionCallbackHandler.handleSubscriptionUsingCallback(request, callbackWithContextualData).map(response -> this.callbackResponse(request, (ExecutionResult)response));
            }).onErrorResume(error -> {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)"Unable to start subscription using callback protocol", error);
                }
                return Mono.error((Throwable)new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST));
            });
        }
        return chain.next(request);
    }

    private boolean isWebSocketRequest(WebGraphQlRequest request) {
        return request instanceof WebSocketGraphQlRequest;
    }

    private WebGraphQlResponse callbackResponse(WebGraphQlRequest request, ExecutionResult callbackResult) {
        DefaultExecutionGraphQlResponse callbackExecutionResponse = new DefaultExecutionGraphQlResponse(request.toExecutionInput(), callbackResult);
        WebGraphQlResponse callbackGraphQLResponse = new WebGraphQlResponse((ExecutionGraphQlResponse)callbackExecutionResponse);
        callbackGraphQLResponse.getResponseHeaders().add("subscription-protocol", "callback/1.0");
        return callbackGraphQLResponse;
    }

    private WebGraphQlResponse errorCallbackResponse(WebGraphQlRequest request) {
        ExecutionResult errorCallbackResult = ExecutionResult.newExecutionResult().addError(GraphQLError.newError().message("Unable to start subscription using callback protocol", new Object[0]).build()).build();
        return this.callbackResponse(request, errorCallbackResult);
    }

    public int getOrder() {
        return this.order;
    }

    private Map<String, List<String>> parseContextualHeaders(WebGraphQlRequest request) {
        if (!this.contextualHeaders.isEmpty()) {
            HashMap<String, List<String>> contextualHeaders = new HashMap<String, List<String>>();
            HttpHeaders headers = request.getHeaders();
            for (String header : this.contextualHeaders) {
                if (!headers.containsHeader(header)) continue;
                List headerValue = headers.get(header);
                contextualHeaders.put(header, headerValue);
            }
            return contextualHeaders;
        }
        return new HashMap<String, List<String>>();
    }
}

