/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.federation.graphqljava;

import com.apollographql.federation.graphqljava.FederationDirectives;
import com.apollographql.federation.graphqljava.SchemaTransformer;
import com.apollographql.federation.graphqljava._Any;
import com.apollographql.federation.graphqljava._FieldSet;
import com.apollographql.federation.graphqljava.directives.LinkDirectiveProcessor;
import graphql.language.DirectiveDefinition;
import graphql.language.FieldDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.SDLDefinition;
import graphql.language.SDLNamedDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.File;
import java.io.Reader;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class Federation {
    public static final String FEDERATION_SPEC_V2_0 = "https://specs.apollo.dev/federation/v2.0";
    public static final String FEDERATION_SPEC_V2_1 = "https://specs.apollo.dev/federation/v2.1";
    public static final String FEDERATION_SPEC_V2_2 = "https://specs.apollo.dev/federation/v2.2";
    public static final String FEDERATION_SPEC_V2_3 = "https://specs.apollo.dev/federation/v2.3";
    private static final SchemaGenerator.Options generatorOptions = SchemaGenerator.Options.defaultOptions();

    private Federation() {
    }

    @NotNull
    public static SchemaTransformer transform(GraphQLSchema schema) {
        return new SchemaTransformer(schema, false);
    }

    @NotNull
    public static SchemaTransformer transform(GraphQLSchema schema, boolean queryTypeShouldBeEmpty) {
        return new SchemaTransformer(schema, queryTypeShouldBeEmpty);
    }

    public static SchemaTransformer transform(TypeDefinitionRegistry typeRegistry, RuntimeWiring runtimeWiring) {
        boolean queryTypeShouldBeEmpty = Federation.ensureQueryTypeExists(typeRegistry);
        Stream<SDLNamedDefinition> importedDefinitions = LinkDirectiveProcessor.loadFederationImportedDefinitions(typeRegistry);
        RuntimeWiring federatedRuntimeWiring = importedDefinitions != null ? Federation.ensureFederationV2DirectiveDefinitionsExist(typeRegistry, runtimeWiring, importedDefinitions) : Federation.ensureFederationDirectiveDefinitionsExist(typeRegistry, runtimeWiring);
        GraphQLSchema schema = new SchemaGenerator().makeExecutableSchema(generatorOptions, typeRegistry, federatedRuntimeWiring);
        return Federation.transform(schema, queryTypeShouldBeEmpty).setFederation2(importedDefinitions != null);
    }

    public static SchemaTransformer transform(TypeDefinitionRegistry typeRegistry) {
        return Federation.transform(typeRegistry, Federation.emptyWiring());
    }

    public static SchemaTransformer transform(String sdl, RuntimeWiring runtimeWiring) {
        return Federation.transform(new SchemaParser().parse(sdl), runtimeWiring);
    }

    public static SchemaTransformer transform(Reader sdl, RuntimeWiring runtimeWiring) {
        return Federation.transform(new SchemaParser().parse(sdl), runtimeWiring);
    }

    public static SchemaTransformer transform(File sdl, RuntimeWiring runtimeWiring) {
        return Federation.transform(new SchemaParser().parse(sdl), runtimeWiring);
    }

    public static SchemaTransformer transform(String sdl) {
        return Federation.transform(sdl, Federation.emptyWiring());
    }

    public static SchemaTransformer transform(Reader sdl) {
        return Federation.transform(sdl, Federation.emptyWiring());
    }

    public static SchemaTransformer transform(File sdl) {
        return Federation.transform(sdl, Federation.emptyWiring());
    }

    private static RuntimeWiring emptyWiring() {
        return RuntimeWiring.newRuntimeWiring().build();
    }

    private static boolean ensureQueryTypeExists(TypeDefinitionRegistry typeRegistry) {
        boolean addDummyField;
        String queryName = typeRegistry.schemaDefinition().flatMap(sdef -> sdef.getOperationTypeDefinitions().stream().filter(op -> "query".equals(op.getName())).findFirst().map(def -> def.getTypeName().getName())).orElse("Query");
        TypeDefinition newQueryType = (TypeDefinition)typeRegistry.getType(queryName).orElse(ObjectTypeDefinition.newObjectTypeDefinition().name(queryName).build());
        boolean bl = addDummyField = newQueryType instanceof ObjectTypeDefinition && ((ObjectTypeDefinition)newQueryType).getFieldDefinitions().isEmpty() && Optional.ofNullable((List)typeRegistry.objectTypeExtensions().get(queryName)).map(List::isEmpty).orElse(true) != false;
        if (addDummyField) {
            newQueryType = ((ObjectTypeDefinition)newQueryType).transform((T objectTypeDefinitionBuilder) -> objectTypeDefinitionBuilder.fieldDefinition(FieldDefinition.newFieldDefinition().name("_dummy").type((Type)new TypeName("String")).build()));
        }
        typeRegistry.remove((SDLDefinition)newQueryType);
        typeRegistry.add((SDLDefinition)newQueryType);
        return addDummyField;
    }

    private static RuntimeWiring ensureFederationV2DirectiveDefinitionsExist(TypeDefinitionRegistry typeRegistry, RuntimeWiring runtimeWiring, Stream<SDLNamedDefinition> importedDefinitions) {
        HashSet scalarTypesToAdd = new HashSet();
        importedDefinitions.forEach(def -> {
            if (def instanceof DirectiveDefinition && !typeRegistry.getDirectiveDefinition(def.getName()).isPresent()) {
                typeRegistry.add((SDLDefinition)def);
            }
            if (def instanceof ScalarTypeDefinition && !runtimeWiring.getScalars().containsKey(def.getName())) {
                typeRegistry.add((SDLDefinition)def);
                scalarTypesToAdd.add(GraphQLScalarType.newScalar().name(def.getName()).description(null).coercing(_Any.type.getCoercing()).build());
            }
        });
        if (!scalarTypesToAdd.isEmpty()) {
            return runtimeWiring.transform((T wiring) -> scalarTypesToAdd.forEach(arg_0 -> ((RuntimeWiring.Builder)wiring).scalar(arg_0)));
        }
        return runtimeWiring;
    }

    private static RuntimeWiring ensureFederationDirectiveDefinitionsExist(TypeDefinitionRegistry typeRegistry, RuntimeWiring runtimeWiring) {
        FederationDirectives.federation1DirectiveDefinitions.stream().filter(def -> !typeRegistry.getDirectiveDefinition(def.getName()).isPresent()).forEachOrdered(arg_0 -> ((TypeDefinitionRegistry)typeRegistry).add(arg_0));
        if (!typeRegistry.getType("_FieldSet").isPresent()) {
            typeRegistry.add((SDLDefinition)_FieldSet.definition);
        }
        if (!runtimeWiring.getScalars().containsKey("_FieldSet")) {
            return runtimeWiring.transform((T wiring) -> wiring.scalar(_FieldSet.type));
        }
        return runtimeWiring;
    }
}

