/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.federation.graphqljava.directives;

import com.apollographql.federation.graphqljava.exceptions.UnsupportedRenameException;
import graphql.language.DirectiveDefinition;
import graphql.language.EnumTypeDefinition;
import graphql.language.NamedNode;
import graphql.language.Node;
import graphql.language.NodeVisitorStub;
import graphql.language.ScalarTypeDefinition;
import graphql.language.TypeName;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import graphql.util.TreeTransformerUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class LinkImportsRenamingVisitor
extends NodeVisitorStub {
    private static final Set<String> BUILT_IN_SCALARS = new HashSet<String>(Arrays.asList("String", "Boolean", "Int", "Float", "ID"));
    private final Map<String, String> fed2Imports;

    public LinkImportsRenamingVisitor(Map<String, String> fed2Imports) {
        this.fed2Imports = fed2Imports;
    }

    protected TraversalControl visitNode(Node node, TraverserContext<Node> context) {
        if (node instanceof NamedNode) {
            TypeName newNode = null;
            if (node instanceof TypeName) {
                String newName = this.newName(((NamedNode)node).getName(), this.fed2Imports, false);
                newNode = ((TypeName)node).transform(builder -> builder.name(newName));
            } else if (node instanceof ScalarTypeDefinition) {
                String newName = this.newName(((NamedNode)node).getName(), this.fed2Imports, false);
                newNode = ((ScalarTypeDefinition)node).transform(builder -> builder.name(newName));
            } else if (node instanceof DirectiveDefinition) {
                String newName = this.newName(((NamedNode)node).getName(), this.fed2Imports, true);
                newNode = ((DirectiveDefinition)node).transform(builder -> builder.name(newName));
            } else if (node instanceof EnumTypeDefinition) {
                String newName = this.newName(((NamedNode)node).getName(), this.fed2Imports, true);
                newNode = ((EnumTypeDefinition)node).transform(builder -> builder.name(newName));
            }
            if (newNode != null) {
                return TreeTransformerUtil.changeNode(context, newNode);
            }
        }
        return super.visitNode(node, context);
    }

    private String newName(String name, Map<String, String> fed2Imports, boolean isDirective) {
        String key = isDirective ? "@" + name : name;
        if (BUILT_IN_SCALARS.contains(key)) {
            return name;
        }
        if (fed2Imports.containsKey(key)) {
            String newName = fed2Imports.get(key);
            if (("@tag".equals(key) || "@inaccessible".equals(key)) && !newName.equals(key)) {
                throw new UnsupportedRenameException(key);
            }
            if (isDirective) {
                return newName.substring(1);
            }
            return newName;
        }
        if (name.equals("inaccessible") || name.equals("tag")) {
            return name;
        }
        if (name.equals("Import") || name.equals("Purpose")) {
            return "link__" + name;
        }
        return "federation__" + name;
    }
}

