/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.federation.graphqljava;

import com.apollographql.federation.graphqljava.FederationDirectives;
import com.apollographql.federation.graphqljava.LinkImportsRenamingVisitor;
import com.apollographql.federation.graphqljava.SchemaTransformer;
import com.apollographql.federation.graphqljava._Any;
import com.apollographql.federation.graphqljava._FieldSet;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.AstTransformer;
import graphql.language.DirectiveDefinition;
import graphql.language.FieldDefinition;
import graphql.language.Node;
import graphql.language.NodeVisitor;
import graphql.language.ObjectField;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectValue;
import graphql.language.SDLDefinition;
import graphql.language.SDLNamedDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.Value;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.TypeResolver;
import graphql.schema.idl.EnumValuesProvider;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeRuntimeWiring;
import java.io.File;
import java.io.Reader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Federation {
    private static final SchemaGenerator.Options generatorOptions = SchemaGenerator.Options.defaultOptions();

    private Federation() {
    }

    @NotNull
    public static SchemaTransformer transform(GraphQLSchema schema) {
        return new SchemaTransformer(schema, false);
    }

    @NotNull
    public static SchemaTransformer transform(GraphQLSchema schema, boolean queryTypeShouldBeEmpty) {
        return new SchemaTransformer(schema, queryTypeShouldBeEmpty);
    }

    public static SchemaTransformer transform(TypeDefinitionRegistry typeRegistry, RuntimeWiring runtimeWiring) {
        boolean queryTypeShouldBeEmpty = Federation.ensureQueryTypeExists(typeRegistry);
        @Nullable Map<String, String> fed2Imports = Federation.fed2DirectiveImports(typeRegistry);
        RuntimeWiring newRuntimeWiring = fed2Imports != null ? Federation.ensureFederation2DirectiveDefinitionsExist(typeRegistry, runtimeWiring, fed2Imports) : Federation.ensureFederationDirectiveDefinitionsExist(typeRegistry, runtimeWiring);
        GraphQLSchema original = new SchemaGenerator().makeExecutableSchema(generatorOptions, typeRegistry, newRuntimeWiring);
        return Federation.transform(original, queryTypeShouldBeEmpty).setFederation2(fed2Imports != null);
    }

    public static SchemaTransformer transform(TypeDefinitionRegistry typeRegistry) {
        return Federation.transform(typeRegistry, Federation.emptyWiring());
    }

    public static SchemaTransformer transform(String sdl, RuntimeWiring runtimeWiring) {
        return Federation.transform(new SchemaParser().parse(sdl), runtimeWiring);
    }

    public static SchemaTransformer transform(Reader sdl, RuntimeWiring runtimeWiring) {
        return Federation.transform(new SchemaParser().parse(sdl), runtimeWiring);
    }

    public static SchemaTransformer transform(File sdl, RuntimeWiring runtimeWiring) {
        return Federation.transform(new SchemaParser().parse(sdl), runtimeWiring);
    }

    public static SchemaTransformer transform(String sdl) {
        return Federation.transform(sdl, Federation.emptyWiring());
    }

    public static SchemaTransformer transform(Reader sdl) {
        return Federation.transform(sdl, Federation.emptyWiring());
    }

    public static SchemaTransformer transform(File sdl) {
        return Federation.transform(sdl, Federation.emptyWiring());
    }

    private static RuntimeWiring emptyWiring() {
        return RuntimeWiring.newRuntimeWiring().build();
    }

    private static boolean ensureQueryTypeExists(TypeDefinitionRegistry typeRegistry) {
        boolean addDummyField;
        String queryName = typeRegistry.schemaDefinition().flatMap(sdef -> sdef.getOperationTypeDefinitions().stream().filter(op -> "query".equals(op.getName())).findFirst().map(def -> def.getTypeName().getName())).orElse("Query");
        TypeDefinition newQueryType = (TypeDefinition)typeRegistry.getType(queryName).orElse(ObjectTypeDefinition.newObjectTypeDefinition().name(queryName).build());
        boolean bl = addDummyField = newQueryType instanceof ObjectTypeDefinition && ((ObjectTypeDefinition)newQueryType).getFieldDefinitions().isEmpty() && Optional.ofNullable(typeRegistry.objectTypeExtensions().get(queryName)).map(List::isEmpty).orElse(true) != false;
        if (addDummyField) {
            newQueryType = ((ObjectTypeDefinition)newQueryType).transform((T objectTypeDefinitionBuilder) -> objectTypeDefinitionBuilder.fieldDefinition(FieldDefinition.newFieldDefinition().name("_dummy").type((Type)new TypeName("String")).build()));
        }
        typeRegistry.remove((SDLDefinition)newQueryType);
        typeRegistry.add((SDLDefinition)newQueryType);
        return addDummyField;
    }

    private static Stream<SDLNamedDefinition> renameDefinitions(List<SDLNamedDefinition> sdlNamedDefinition, Map<String, String> fed2Imports) {
        return sdlNamedDefinition.stream().map(definition -> (SDLNamedDefinition)new AstTransformer().transform((Node)definition, (NodeVisitor)new LinkImportsRenamingVisitor(fed2Imports)));
    }

    private static RuntimeWiring ensureFederation2DirectiveDefinitionsExist(TypeDefinitionRegistry typeRegistry, RuntimeWiring runtimeWiring, @Nullable Map<String, String> fed2Imports) {
        RuntimeWiring newRuntimeWiring = runtimeWiring;
        HashSet<GraphQLScalarType> scalarTypesToAdd = new HashSet<GraphQLScalarType>();
        Stream<SDLNamedDefinition> renamedDefinitions = Federation.renameDefinitions(FederationDirectives.federation2Definitions, fed2Imports);
        renamedDefinitions.forEach(def -> {
            if (!typeRegistry.getDirectiveDefinition(def.getName()).isPresent()) {
                typeRegistry.add((SDLDefinition)def);
            }
            if (def instanceof ScalarTypeDefinition && !runtimeWiring.getScalars().containsKey(def.getName())) {
                scalarTypesToAdd.add(GraphQLScalarType.newScalar().name(def.getName()).description(null).coercing(_Any.defaultCoercing).build());
            }
        });
        return Federation.copyRuntimeWiring(newRuntimeWiring, scalarTypesToAdd);
    }

    private static RuntimeWiring ensureFederationDirectiveDefinitionsExist(TypeDefinitionRegistry typeRegistry, RuntimeWiring runtimeWiring) {
        Set<DirectiveDefinition> directivesToAdd = FederationDirectives.federation1DirectiveDefinitions;
        directivesToAdd.stream().filter(def -> !typeRegistry.getDirectiveDefinition(def.getName()).isPresent()).forEachOrdered(arg_0 -> ((TypeDefinitionRegistry)typeRegistry).add(arg_0));
        if (!typeRegistry.getType("_FieldSet").isPresent()) {
            typeRegistry.add((SDLDefinition)_FieldSet.definition);
        }
        RuntimeWiring newRuntimeWiring = runtimeWiring;
        if (!runtimeWiring.getScalars().containsKey("_FieldSet")) {
            newRuntimeWiring = Federation.copyRuntimeWiring(newRuntimeWiring, Collections.singleton(_FieldSet.type));
        }
        return newRuntimeWiring;
    }

    private static RuntimeWiring copyRuntimeWiring(RuntimeWiring runtimeWiring, Set<GraphQLScalarType> additionalScalars) {
        RuntimeWiring.Builder builder = RuntimeWiring.newRuntimeWiring();
        runtimeWiring.getDataFetchers().entrySet().stream().map(entry -> {
            String name = (String)entry.getKey();
            TypeRuntimeWiring.Builder typeWiring = TypeRuntimeWiring.newTypeWiring((String)name);
            typeWiring.dataFetchers((Map)entry.getValue());
            if (runtimeWiring.getDefaultDataFetcherForType(name) != null) {
                typeWiring.defaultDataFetcher(runtimeWiring.getDefaultDataFetcherForType(name));
            }
            if (runtimeWiring.getTypeResolvers().get(name) != null) {
                typeWiring.typeResolver((TypeResolver)runtimeWiring.getTypeResolvers().get(name));
            }
            if (runtimeWiring.getEnumValuesProviders().get(name) != null) {
                typeWiring.enumValues((EnumValuesProvider)runtimeWiring.getEnumValuesProviders().get(name));
            }
            return typeWiring.build();
        }).forEach(arg_0 -> ((RuntimeWiring.Builder)builder).type(arg_0));
        if (runtimeWiring.getWiringFactory() != null) {
            builder.wiringFactory(runtimeWiring.getWiringFactory());
        }
        if (runtimeWiring.getCodeRegistry() != null) {
            builder.codeRegistry(runtimeWiring.getCodeRegistry());
        }
        runtimeWiring.getScalars().forEach((name, scalar) -> builder.scalar(scalar));
        additionalScalars.forEach(arg_0 -> ((RuntimeWiring.Builder)builder).scalar(arg_0));
        if (runtimeWiring.getFieldVisibility() != null) {
            builder.fieldVisibility(runtimeWiring.getFieldVisibility());
        }
        runtimeWiring.getRegisteredDirectiveWiring().forEach((arg_0, arg_1) -> ((RuntimeWiring.Builder)builder).directive(arg_0, arg_1));
        runtimeWiring.getDirectiveWiring().forEach(arg_0 -> ((RuntimeWiring.Builder)builder).directiveWiring(arg_0));
        builder.comparatorRegistry(runtimeWiring.getComparatorRegistry());
        runtimeWiring.getSchemaGeneratorPostProcessings().forEach(arg_0 -> ((RuntimeWiring.Builder)builder).transformer(arg_0));
        RuntimeWiring runtimeWiringCopy = builder.build();
        runtimeWiring.getTypeResolvers().forEach((key, value) -> runtimeWiringCopy.getTypeResolvers().putIfAbsent(key, value));
        return runtimeWiringCopy;
    }

    @Nullable
    private static Map<String, String> fed2DirectiveImports(TypeDefinitionRegistry typeDefinitionRegistry) {
        List linkDirectives = typeDefinitionRegistry.getSchemaExtensionDefinitions().stream().flatMap(schemaExtensionDefinition -> schemaExtensionDefinition.getDirectives().stream().filter(directive -> directive.getName().equals("link"))).filter(directive -> {
            Optional<Argument> arg = directive.getArguments().stream().filter(argument -> argument.getName().equals("url")).findFirst();
            if (!arg.isPresent()) {
                return false;
            }
            Value value = arg.get().getValue();
            if (!(value instanceof StringValue)) {
                return false;
            }
            StringValue stringValue = (StringValue)value;
            return stringValue.getValue().equals("https://specs.apollo.dev/federation/v2.0");
        }).collect(Collectors.toList());
        if (linkDirectives.isEmpty()) {
            return null;
        }
        Map<String, String> imports = linkDirectives.stream().flatMap(directive -> {
            Optional<Argument> arg = directive.getArguments().stream().filter(argument -> argument.getName().equals("import")).findFirst();
            if (!arg.isPresent()) {
                return Stream.empty();
            }
            Value value = arg.get().getValue();
            if (!(value instanceof ArrayValue)) {
                return Stream.empty();
            }
            ArrayValue arrayValue = (ArrayValue)value;
            ArrayList<AbstractMap.SimpleEntry<String, String>> entries = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
            for (Value imp : arrayValue.getValues()) {
                if (imp instanceof StringValue) {
                    String name = ((StringValue)imp).getValue();
                    entries.add(new AbstractMap.SimpleEntry<String, String>(name, name));
                    continue;
                }
                if (imp instanceof ObjectValue) {
                    String as;
                    ObjectValue objectValue = (ObjectValue)imp;
                    Optional<ObjectField> nameField = objectValue.getObjectFields().stream().filter(field -> field.getName().equals("name")).findFirst();
                    Optional<ObjectField> asField = objectValue.getObjectFields().stream().filter(field -> field.getName().equals("as")).findFirst();
                    if (!nameField.isPresent()) {
                        throw new RuntimeException("Unsupported import: " + imp);
                    }
                    Value nameValue = nameField.get().getValue();
                    if (!(nameValue instanceof StringValue)) {
                        throw new RuntimeException("Unsupported import: " + imp);
                    }
                    if (!asField.isPresent()) {
                        as = null;
                    } else {
                        Value asValue = asField.get().getValue();
                        if (!(asValue instanceof StringValue)) {
                            throw new RuntimeException("Unsupported import: " + imp);
                        }
                        as = ((StringValue)asValue).getValue();
                    }
                    entries.add(new AbstractMap.SimpleEntry<String, Object>(((StringValue)nameValue).getValue(), as));
                    continue;
                }
                throw new RuntimeException("Unsupported import: " + imp.toString());
            }
            return entries.stream();
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (value1, value2) -> value2));
        imports.put("@link", "@link");
        return imports;
    }
}

