/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.federation.graphqljava.printer;

import com.apollographql.federation.graphqljava.FederationDirectives;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.idl.SchemaPrinter;
import graphql.schema.visibility.GraphqlFieldVisibility;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public final class ServiceSDLPrinter {
    private static final Set<String> STANDARD_DIRECTIVES = new HashSet<String>(Arrays.asList("deprecated", "include", "skip", "specifiedBy"));

    private ServiceSDLPrinter() {
    }

    public static String generateServiceSDL(GraphQLSchema schema, boolean queryTypeShouldBeEmpty) {
        HashSet<String> hiddenDirectiveDefinitions = new HashSet<String>();
        hiddenDirectiveDefinitions.addAll(STANDARD_DIRECTIVES);
        hiddenDirectiveDefinitions.addAll(FederationDirectives.allNames);
        HashSet<String> hiddenTypeDefinitions = new HashSet<String>();
        hiddenTypeDefinitions.add("_Any");
        hiddenTypeDefinitions.add("_Entity");
        hiddenTypeDefinitions.add("_FieldSet");
        hiddenTypeDefinitions.add("_Service");
        if (queryTypeShouldBeEmpty) {
            final String queryTypeName = schema.getQueryType().getName();
            final GraphqlFieldVisibility oldFieldVisibility = schema.getCodeRegistry().getFieldVisibility();
            GraphqlFieldVisibility newFieldVisibility = new GraphqlFieldVisibility(){

                public List<GraphQLFieldDefinition> getFieldDefinitions(GraphQLFieldsContainer fieldsContainer) {
                    return fieldsContainer.getName().equals(queryTypeName) ? Collections.emptyList() : oldFieldVisibility.getFieldDefinitions(fieldsContainer);
                }

                public GraphQLFieldDefinition getFieldDefinition(GraphQLFieldsContainer fieldsContainer, String fieldName) {
                    return fieldsContainer.getName().equals(queryTypeName) ? null : oldFieldVisibility.getFieldDefinition(fieldsContainer, fieldName);
                }
            };
            GraphQLCodeRegistry newCodeRegistry = schema.getCodeRegistry().transform(codeRegistryBuilder -> codeRegistryBuilder.fieldVisibility(newFieldVisibility));
            schema = schema.transform(schemaBuilder -> schemaBuilder.codeRegistry(newCodeRegistry));
        }
        Predicate<GraphQLSchemaElement> excludeFedTypeDefinitions = element -> !(element instanceof GraphQLNamedSchemaElement) || !hiddenTypeDefinitions.contains(((GraphQLNamedSchemaElement)element).getName());
        Predicate<GraphQLSchemaElement> excludeFedDirectiveDefinitions = element -> !(element instanceof GraphQLDirective) || !hiddenDirectiveDefinitions.contains(((GraphQLDirective)element).getName());
        SchemaPrinter.Options options = SchemaPrinter.Options.defaultOptions().includeScalarTypes(true).includeSchemaDefinition(true).includeDirectives(FederationDirectives.allNames::contains).includeSchemaElement(element -> excludeFedTypeDefinitions.test((GraphQLSchemaElement)element) && excludeFedDirectiveDefinitions.test((GraphQLSchemaElement)element));
        return new SchemaPrinter(options).print(schema).trim();
    }

    public static String generateServiceSDLV2(GraphQLSchema schema) {
        HashSet<String> standardDirectives = new HashSet<String>(Arrays.asList("deprecated", "include", "skip", "specifiedBy"));
        return new SchemaPrinter(SchemaPrinter.Options.defaultOptions().includeSchemaDefinition(true).includeScalarTypes(true).includeDirectives(def -> !standardDirectives.contains(def))).print(schema).trim();
    }
}

