/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.federation.graphqljava;

import com.apollographql.federation.graphqljava.FederationDirectives;
import com.apollographql.federation.graphqljava.FederationError;
import com.apollographql.federation.graphqljava.FederationSdlPrinter;
import com.apollographql.federation.graphqljava._Any;
import com.apollographql.federation.graphqljava._Entity;
import com.apollographql.federation.graphqljava._Service;
import graphql.schema.Coercing;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetcherFactory;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.TypeResolver;
import graphql.schema.idl.errors.SchemaProblem;
import graphql.schema.visibility.GraphqlFieldVisibility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class SchemaTransformer {
    private static final Object DUMMY = new Object();
    private static final Set<String> STANDARD_DIRECTIVES = new HashSet<String>(Arrays.asList("deprecated", "include", "skip", "specifiedBy"));
    private final GraphQLSchema originalSchema;
    private final boolean queryTypeShouldBeEmpty;
    private TypeResolver entityTypeResolver = null;
    private DataFetcher entitiesDataFetcher = null;
    private DataFetcherFactory entitiesDataFetcherFactory = null;
    private Coercing coercingForAny = _Any.defaultCoercing;
    private boolean isFederation2 = false;

    SchemaTransformer(GraphQLSchema originalSchema, boolean queryTypeShouldBeEmpty) {
        this.originalSchema = originalSchema;
        this.queryTypeShouldBeEmpty = queryTypeShouldBeEmpty;
    }

    @NotNull
    public SchemaTransformer resolveEntityType(TypeResolver entityTypeResolver) {
        this.entityTypeResolver = entityTypeResolver;
        return this;
    }

    @NotNull
    public SchemaTransformer fetchEntities(DataFetcher entitiesDataFetcher) {
        this.entitiesDataFetcher = entitiesDataFetcher;
        this.entitiesDataFetcherFactory = null;
        return this;
    }

    @NotNull
    public SchemaTransformer fetchEntitiesFactory(DataFetcherFactory entitiesDataFetcherFactory) {
        this.entitiesDataFetcher = null;
        this.entitiesDataFetcherFactory = entitiesDataFetcherFactory;
        return this;
    }

    public SchemaTransformer coercingForAny(Coercing coercing) {
        this.coercingForAny = coercing;
        return this;
    }

    public SchemaTransformer setFederation2(boolean isFederation2) {
        this.isFederation2 = isFederation2;
        return this;
    }

    @NotNull
    public final GraphQLSchema build() throws SchemaProblem {
        String sdl;
        ArrayList<FederationError> errors = new ArrayList<FederationError>();
        GraphQLSchema.Builder newSchema = GraphQLSchema.newSchema((GraphQLSchema)this.originalSchema);
        GraphQLObjectType originalQueryType = this.originalSchema.getQueryType();
        GraphQLObjectType.Builder newQueryType = GraphQLObjectType.newObject((GraphQLObjectType)originalQueryType);
        if (this.queryTypeShouldBeEmpty) {
            newQueryType.clearFields();
        }
        newQueryType.field(_Service.field);
        Set entityTypeNames = this.originalSchema.getAllTypesAsList().stream().filter(t -> t instanceof GraphQLDirectiveContainer && !((GraphQLDirectiveContainer)t).getDirectives("key").isEmpty()).map(GraphQLNamedSchemaElement::getName).collect(Collectors.toSet());
        Set<String> entityConcreteTypeNames = this.originalSchema.getAllTypesAsList().stream().filter(type -> type instanceof GraphQLObjectType).filter(type -> entityTypeNames.contains(type.getName()) || ((GraphQLObjectType)type).getInterfaces().stream().anyMatch(itf -> entityTypeNames.contains(itf.getName()))).map(GraphQLNamedSchemaElement::getName).collect(Collectors.toSet());
        if (!entityConcreteTypeNames.isEmpty()) {
            newQueryType.field(_Entity.field(entityConcreteTypeNames));
            GraphQLType originalAnyType = this.originalSchema.getType("_Any");
            if (originalAnyType == null) {
                newSchema.additionalType((GraphQLType)_Any.type(this.coercingForAny));
            }
        }
        newSchema.query(newQueryType.build());
        GraphQLCodeRegistry.Builder newCodeRegistry = GraphQLCodeRegistry.newCodeRegistry((GraphQLCodeRegistry)this.originalSchema.getCodeRegistry());
        if (this.isFederation2) {
            HashSet<String> standardDirectives = new HashSet<String>(Arrays.asList("deprecated", "include", "skip", "specifiedBy"));
            sdl = new FederationSdlPrinter(FederationSdlPrinter.Options.defaultOptions().includeScalarTypes(true).includeDirectiveDefinitions(def -> !standardDirectives.contains(def.getName()))).print(newSchema.build()).trim();
        } else {
            sdl = SchemaTransformer.sdl(this.originalSchema, this.queryTypeShouldBeEmpty);
        }
        newCodeRegistry.dataFetcher(FieldCoordinates.coordinates((String)originalQueryType.getName(), (String)"_service"), environment -> DUMMY);
        newCodeRegistry.dataFetcher(FieldCoordinates.coordinates((String)"_Service", (String)"sdl"), environment -> sdl);
        if (!entityConcreteTypeNames.isEmpty()) {
            if (this.entityTypeResolver != null) {
                newCodeRegistry.typeResolver("_Entity", this.entityTypeResolver);
            } else if (!newCodeRegistry.hasTypeResolver("_Entity")) {
                errors.add(new FederationError("Missing a type resolver for _Entity"));
            }
            FieldCoordinates _entities = FieldCoordinates.coordinates((String)originalQueryType.getName(), (String)"_entities");
            if (this.entitiesDataFetcher != null) {
                newCodeRegistry.dataFetcher(_entities, this.entitiesDataFetcher);
            } else if (this.entitiesDataFetcherFactory != null) {
                newCodeRegistry.dataFetcher(_entities, this.entitiesDataFetcherFactory);
            } else if (!newCodeRegistry.hasDataFetcher(_entities)) {
                errors.add(new FederationError("Missing a data fetcher for _entities"));
            }
        }
        if (!errors.isEmpty()) {
            throw new SchemaProblem(errors);
        }
        return newSchema.codeRegistry(newCodeRegistry.build()).build();
    }

    public static String sdl(GraphQLSchema schema) {
        return SchemaTransformer.sdl(schema, false);
    }

    public static String sdl(GraphQLSchema schema, boolean queryTypeShouldBeEmpty) {
        HashSet<String> hiddenDirectiveDefinitions = new HashSet<String>();
        hiddenDirectiveDefinitions.addAll(STANDARD_DIRECTIVES);
        hiddenDirectiveDefinitions.addAll(FederationDirectives.allNames);
        HashSet<String> hiddenTypeDefinitions = new HashSet<String>();
        hiddenTypeDefinitions.add("_Any");
        hiddenTypeDefinitions.add("_Entity");
        hiddenTypeDefinitions.add("_FieldSet");
        hiddenTypeDefinitions.add("_Service");
        if (queryTypeShouldBeEmpty) {
            final String queryTypeName = schema.getQueryType().getName();
            final GraphqlFieldVisibility oldFieldVisibility = schema.getCodeRegistry().getFieldVisibility();
            GraphqlFieldVisibility newFieldVisibility = new GraphqlFieldVisibility(){

                public List<GraphQLFieldDefinition> getFieldDefinitions(GraphQLFieldsContainer fieldsContainer) {
                    return fieldsContainer.getName().equals(queryTypeName) ? Collections.emptyList() : oldFieldVisibility.getFieldDefinitions(fieldsContainer);
                }

                public GraphQLFieldDefinition getFieldDefinition(GraphQLFieldsContainer fieldsContainer, String fieldName) {
                    return fieldsContainer.getName().equals(queryTypeName) ? null : oldFieldVisibility.getFieldDefinition(fieldsContainer, fieldName);
                }
            };
            GraphQLCodeRegistry newCodeRegistry = schema.getCodeRegistry().transform(codeRegistryBuilder -> codeRegistryBuilder.fieldVisibility(newFieldVisibility));
            schema = schema.transform(schemaBuilder -> schemaBuilder.codeRegistry(newCodeRegistry));
        }
        FederationSdlPrinter.Options options = FederationSdlPrinter.Options.defaultOptions().includeScalarTypes(true).includeSchemaDefinition(true).includeDirectives(true).includeDirectiveDefinitions(def -> !hiddenDirectiveDefinitions.contains(def.getName())).includeTypeDefinitions(def -> !hiddenTypeDefinitions.contains(def.getName()));
        return new FederationSdlPrinter(options).print(schema);
    }
}

