(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'kotlinx-coroutines-core', 'apollo-android-apollo-runtime-js-legacy', 'apollo-android-apollo-api-js-legacy', 'apollo-android-apollo-mockserver-js-legacy', 'fs', 'kotlin-test'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('kotlinx-coroutines-core'), require('apollo-android-apollo-runtime-js-legacy'), require('apollo-android-apollo-api-js-legacy'), require('apollo-android-apollo-mockserver-js-legacy'), require('fs'), require('kotlin-test'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'apollo-android-apollo-testing-support-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'apollo-android-apollo-testing-support-js-legacy'.");
    }if (typeof this['kotlinx-coroutines-core'] === 'undefined') {
      throw new Error("Error loading module 'apollo-android-apollo-testing-support-js-legacy'. Its dependency 'kotlinx-coroutines-core' was not found. Please, check whether 'kotlinx-coroutines-core' is loaded prior to 'apollo-android-apollo-testing-support-js-legacy'.");
    }if (typeof this['apollo-android-apollo-runtime-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'apollo-android-apollo-testing-support-js-legacy'. Its dependency 'apollo-android-apollo-runtime-js-legacy' was not found. Please, check whether 'apollo-android-apollo-runtime-js-legacy' is loaded prior to 'apollo-android-apollo-testing-support-js-legacy'.");
    }if (typeof this['apollo-android-apollo-api-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'apollo-android-apollo-testing-support-js-legacy'. Its dependency 'apollo-android-apollo-api-js-legacy' was not found. Please, check whether 'apollo-android-apollo-api-js-legacy' is loaded prior to 'apollo-android-apollo-testing-support-js-legacy'.");
    }if (typeof this['apollo-android-apollo-mockserver-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'apollo-android-apollo-testing-support-js-legacy'. Its dependency 'apollo-android-apollo-mockserver-js-legacy' was not found. Please, check whether 'apollo-android-apollo-mockserver-js-legacy' is loaded prior to 'apollo-android-apollo-testing-support-js-legacy'.");
    }if (typeof fs === 'undefined') {
      throw new Error("Error loading module 'apollo-android-apollo-testing-support-js-legacy'. Its dependency 'fs' was not found. Please, check whether 'fs' is loaded prior to 'apollo-android-apollo-testing-support-js-legacy'.");
    }if (typeof this['kotlin-test'] === 'undefined') {
      throw new Error("Error loading module 'apollo-android-apollo-testing-support-js-legacy'. Its dependency 'kotlin-test' was not found. Please, check whether 'kotlin-test' is loaded prior to 'apollo-android-apollo-testing-support-js-legacy'.");
    }root['apollo-android-apollo-testing-support-js-legacy'] = factory(typeof this['apollo-android-apollo-testing-support-js-legacy'] === 'undefined' ? {} : this['apollo-android-apollo-testing-support-js-legacy'], kotlin, this['kotlinx-coroutines-core'], this['apollo-android-apollo-runtime-js-legacy'], this['apollo-android-apollo-api-js-legacy'], this['apollo-android-apollo-mockserver-js-legacy'], fs, this['kotlin-test']);
  }
}(this, function (_, Kotlin, $module$kotlinx_coroutines_core, $module$apollo_android_apollo_runtime_js_legacy, $module$apollo_android_apollo_api_js_legacy, $module$apollo_android_apollo_mockserver_js_legacy, $module$fs, $module$kotlin_test) {
  'use strict';
  var println = Kotlin.kotlin.io.println_s8jyv4$;
  var Unit = Kotlin.kotlin.Unit;
  var CoroutineImpl = Kotlin.kotlin.coroutines.CoroutineImpl;
  var onStart = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.onStart_fev64r$;
  var onEach = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.onEach_706ovd$;
  var catch_0 = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.catch_xmh1mw$;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var ApolloInterceptor = $module$apollo_android_apollo_runtime_js_legacy.com.apollographql.apollo3.interceptor.ApolloInterceptor;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var TokenProvider = $module$apollo_android_apollo_runtime_js_legacy.com.apollographql.apollo3.network.http.TokenProvider;
  var COROUTINE_SUSPENDED = Kotlin.kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED;
  var L500 = Kotlin.Long.fromInt(500);
  var withTimeout = $module$kotlinx_coroutines_core.kotlinx.coroutines.withTimeout_ms3uf5$;
  var CustomScalarAdapters = $module$apollo_android_apollo_api_js_legacy.com.apollographql.apollo3.api.CustomScalarAdapters;
  var L0 = Kotlin.Long.ZERO;
  var composeJsonResponse = $module$apollo_android_apollo_api_js_legacy.com.apollographql.apollo3.api.composeJsonResponse_ka042b$;
  var enqueue = $module$apollo_android_apollo_mockserver_js_legacy.com.apollographql.apollo3.mockserver.enqueue_sfupap$;
  var readFileSync = $module$fs.readFileSync;
  var throwCCE = Kotlin.throwCCE;
  var assertEquals = $module$kotlin_test.kotlin.test.assertEquals_3m0tl5$;
  var coroutines = Kotlin.kotlin.coroutines;
  var coroutines_0 = $module$kotlinx_coroutines_core.kotlinx.coroutines;
  var promise = $module$kotlinx_coroutines_core.kotlinx.coroutines.promise_pda6u4$;
  function TestLoggerExecutor() {
    TestLoggerExecutor_instance = this;
  }
  function Coroutine$TestLoggerExecutor$intercept$lambda(closure$request_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$request = closure$request_0;
  }
  Coroutine$TestLoggerExecutor$intercept$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$TestLoggerExecutor$intercept$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$TestLoggerExecutor$intercept$lambda.prototype.constructor = Coroutine$TestLoggerExecutor$intercept$lambda;
  Coroutine$TestLoggerExecutor$intercept$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return println('Started `' + this.local$closure$request.operation.name() + '` GraphQL operation execution ...'), Unit;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function TestLoggerExecutor$intercept$lambda(closure$request_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$TestLoggerExecutor$intercept$lambda(closure$request_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$TestLoggerExecutor$intercept$lambda_0(closure$request_0, response_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$request = closure$request_0;
    this.local$response = response_0;
  }
  Coroutine$TestLoggerExecutor$intercept$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$TestLoggerExecutor$intercept$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$TestLoggerExecutor$intercept$lambda_0.prototype.constructor = Coroutine$TestLoggerExecutor$intercept$lambda_0;
  Coroutine$TestLoggerExecutor$intercept$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return println('Finished `' + this.local$closure$request.operation.name() + '` GraphQL operation execution, response: ' + this.local$response), Unit;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function TestLoggerExecutor$intercept$lambda_0(closure$request_0) {
    return function (response_0, continuation_0, suspended) {
      var instance = new Coroutine$TestLoggerExecutor$intercept$lambda_0(closure$request_0, response_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$TestLoggerExecutor$intercept$lambda_1(closure$request_0, $receiver_0, e_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$request = closure$request_0;
    this.local$e = e_0;
  }
  Coroutine$TestLoggerExecutor$intercept$lambda_1.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$TestLoggerExecutor$intercept$lambda_1.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$TestLoggerExecutor$intercept$lambda_1.prototype.constructor = Coroutine$TestLoggerExecutor$intercept$lambda_1;
  Coroutine$TestLoggerExecutor$intercept$lambda_1.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            println('Failed `' + this.local$closure$request.operation.name() + '` GraphQL operation execution due to error: ' + this.local$e);
            throw this.local$e;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function TestLoggerExecutor$intercept$lambda_1(closure$request_0) {
    return function ($receiver_0, e_0, continuation_0, suspended) {
      var instance = new Coroutine$TestLoggerExecutor$intercept$lambda_1(closure$request_0, $receiver_0, e_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  TestLoggerExecutor.prototype.intercept_1p4qq8$ = function (request, chain) {
    println('Preparing `' + request.operation.name() + '` GraphQL operation for execution ...');
    return catch_0(onEach(onStart(chain.proceed_7w1ucr$(request), TestLoggerExecutor$intercept$lambda(request)), TestLoggerExecutor$intercept$lambda_0(request)), TestLoggerExecutor$intercept$lambda_1(request));
  };
  TestLoggerExecutor.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'TestLoggerExecutor',
    interfaces: [ApolloInterceptor]
  };
  var TestLoggerExecutor_instance = null;
  function TestLoggerExecutor_getInstance() {
    if (TestLoggerExecutor_instance === null) {
      new TestLoggerExecutor();
    }return TestLoggerExecutor_instance;
  }
  function TestTokenProvider(currentAccessToken, newAccessToken) {
    this.newAccessToken = newAccessToken;
    this.accessToken = currentAccessToken;
  }
  TestTokenProvider.prototype.currentToken = function (continuation) {
    return this.accessToken;
  };
  TestTokenProvider.prototype.refreshToken_61zpoe$ = function (previousToken, continuation) {
    this.accessToken = this.newAccessToken;
    return this.accessToken;
  };
  TestTokenProvider.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TestTokenProvider',
    interfaces: [TokenProvider]
  };
  function Coroutine$receiveOrTimeout$lambda(this$receiveOrTimeout_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$this$receiveOrTimeout = this$receiveOrTimeout_0;
  }
  Coroutine$receiveOrTimeout$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$receiveOrTimeout$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$receiveOrTimeout$lambda.prototype.constructor = Coroutine$receiveOrTimeout$lambda;
  Coroutine$receiveOrTimeout$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$receiveOrTimeout.receive(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function receiveOrTimeout$lambda(this$receiveOrTimeout_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$receiveOrTimeout$lambda(this$receiveOrTimeout_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function receiveOrTimeout($receiver, timeoutMillis, continuation) {
    if (timeoutMillis === void 0)
      timeoutMillis = L500;
    return withTimeout(timeoutMillis, receiveOrTimeout$lambda($receiver), continuation);
  }
  function enqueue_0($receiver, operation, data, customScalarAdapters, delayMs) {
    if (customScalarAdapters === void 0)
      customScalarAdapters = CustomScalarAdapters.Key.Empty;
    if (delayMs === void 0)
      delayMs = L0;
    var json = composeJsonResponse(operation, data, customScalarAdapters);
    enqueue($receiver, json, delayMs);
  }
  function readFile$ObjectLiteral() {
    this.encoding_9n1lsl$_0 = 'utf8';
  }
  Object.defineProperty(readFile$ObjectLiteral.prototype, 'encoding', {
    configurable: true,
    get: function () {
      return this.encoding_9n1lsl$_0;
    },
    set: function (encoding) {
      this.encoding_9n1lsl$_0 = encoding;
    }
  });
  readFile$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: []
  };
  function readFile(path) {
    var tmp$;
    var pathPrefix = '../../../../../tests/integration-tests/';
    var options = new readFile$ObjectLiteral();
    return typeof (tmp$ = readFileSync(pathPrefix + path, options)) === 'string' ? tmp$ : throwCCE();
  }
  function checkFile(actualText, path) {
    assertEquals(actualText, readFile(path));
  }
  function Coroutine$runTest$lambda($receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
  }
  Coroutine$runTest$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$runTest$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$runTest$lambda.prototype.constructor = Coroutine$runTest$lambda;
  Coroutine$runTest$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return Unit;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function runTest$lambda($receiver_0, continuation_0, suspended) {
    var instance = new Coroutine$runTest$lambda($receiver_0, this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$runTest$lambda_0($receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
  }
  Coroutine$runTest$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$runTest$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$runTest$lambda_0.prototype.constructor = Coroutine$runTest$lambda_0;
  Coroutine$runTest$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return Unit;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function runTest$lambda_0($receiver_0, continuation_0, suspended) {
    var instance = new Coroutine$runTest$lambda_0($receiver_0, this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$runTest$lambda_1(closure$before_0, closure$block_0, closure$after_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 8;
    this.local$closure$before = closure$before_0;
    this.local$closure$block = closure$block_0;
    this.local$closure$after = closure$after_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$runTest$lambda_1.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$runTest$lambda_1.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$runTest$lambda_1.prototype.constructor = Coroutine$runTest$lambda_1;
  Coroutine$runTest$lambda_1.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 1;
            this.result_0 = this.local$closure$before(this.local$$receiver, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            this.exceptionState_0 = 5;
            this.state_0 = 2;
            this.result_0 = this.local$closure$block(this.local$$receiver, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 2:
            this.exceptionState_0 = 8;
            this.finallyPath_0 = [3];
            this.state_0 = 6;
            this.$returnValue = this.result_0;
            continue;
          case 3:
            return this.$returnValue;
          case 4:
            return;
          case 5:
            this.finallyPath_0 = [8];
            this.state_0 = 6;
            continue;
          case 6:
            this.exceptionState_0 = 8;
            this.state_0 = 7;
            this.result_0 = this.local$closure$after(this.local$$receiver, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 7:
            this.state_0 = this.finallyPath_0.shift();
            continue;
          case 8:
            throw this.exception_0;
          default:this.state_0 = 8;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 8) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function runTest$lambda_1(closure$before_0, closure$block_0, closure$after_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$runTest$lambda_1(closure$before_0, closure$block_0, closure$after_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function runTest(context, before, after, block) {
    if (context === void 0)
      context = coroutines.EmptyCoroutineContext;
    if (before === void 0)
      before = runTest$lambda;
    if (after === void 0)
      after = runTest$lambda_0;
    return promise(coroutines_0.GlobalScope, context, void 0, runTest$lambda_1(before, block, after));
  }
  var package$com = _.com || (_.com = {});
  var package$apollographql = package$com.apollographql || (package$com.apollographql = {});
  var package$apollo3 = package$apollographql.apollo3 || (package$apollographql.apollo3 = {});
  var package$testing = package$apollo3.testing || (package$apollo3.testing = {});
  Object.defineProperty(package$testing, 'TestLoggerExecutor', {
    get: TestLoggerExecutor_getInstance
  });
  package$testing.TestTokenProvider = TestTokenProvider;
  package$testing.receiveOrTimeout_l7ld7t$ = receiveOrTimeout;
  package$testing.enqueue_jcel9r$ = enqueue_0;
  package$testing.readFile_61zpoe$ = readFile;
  package$testing.checkFile_puj7f4$ = checkFile;
  package$testing.runTest_8ptlm0$ = runTest;
  Kotlin.defineModule('apollo-android-apollo-testing-support-js-legacy', _);
  return _;
}));

//# sourceMappingURL=apollo-android-apollo-testing-support-js-legacy.js.map
