/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.internal.interceptor;

import com.apollographql.apollo3.CacheInfo;
import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.ExecutionContext;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.OperationKt;
import com.apollographql.apollo3.api.ResponseAdapterCache;
import com.apollographql.apollo3.api.cache.http.HttpCache;
import com.apollographql.apollo3.api.internal.ApolloLogger;
import com.apollographql.apollo3.exception.ApolloException;
import com.apollographql.apollo3.exception.ApolloHttpException;
import com.apollographql.apollo3.exception.ApolloParseException;
import com.apollographql.apollo3.http.OkHttpExecutionContext;
import com.apollographql.apollo3.interceptor.ApolloInterceptor;
import com.apollographql.apollo3.interceptor.ApolloInterceptorChain;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001c\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/apollographql/apollo3/internal/interceptor/ApolloParseInterceptor;", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor;", "httpCache", "Lcom/apollographql/apollo3/api/cache/http/HttpCache;", "responseAdapterCache", "Lcom/apollographql/apollo3/api/ResponseAdapterCache;", "logger", "Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "(Lcom/apollographql/apollo3/api/cache/http/HttpCache;Lcom/apollographql/apollo3/api/ResponseAdapterCache;Lcom/apollographql/apollo3/api/internal/ApolloLogger;)V", "disposed", "", "getDisposed", "()Z", "setDisposed", "(Z)V", "dispose", "", "interceptAsync", "request", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor$InterceptorRequest;", "chain", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptorChain;", "dispatcher", "Ljava/util/concurrent/Executor;", "callBack", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor$CallBack;", "parse", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor$InterceptorResponse;", "operation", "Lcom/apollographql/apollo3/api/Operation;", "Lcom/apollographql/apollo3/api/Operation$Data;", "httpResponse", "Lokhttp3/Response;", "Companion", "apollo-runtime"})
public final class ApolloParseInterceptor
implements ApolloInterceptor {
    private volatile boolean disposed;
    private final HttpCache httpCache;
    private final ResponseAdapterCache responseAdapterCache;
    private final ApolloLogger logger;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final boolean getDisposed() {
        return this.disposed;
    }

    public final void setDisposed(boolean bl) {
        this.disposed = bl;
    }

    @Override
    public void interceptAsync(@NotNull ApolloInterceptor.InterceptorRequest request, @NotNull ApolloInterceptorChain chain, @NotNull Executor dispatcher, @NotNull ApolloInterceptor.CallBack callBack) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
        if (this.disposed) {
            return;
        }
        chain.proceedAsync(request, dispatcher, new ApolloInterceptor.CallBack(this, request, callBack){
            final /* synthetic */ ApolloParseInterceptor this$0;
            final /* synthetic */ ApolloInterceptor.InterceptorRequest $request;
            final /* synthetic */ ApolloInterceptor.CallBack $callBack;

            public void onResponse(@NotNull ApolloInterceptor.InterceptorResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    if (this.this$0.getDisposed()) {
                        return;
                    }
                    Operation<?> operation = this.$request.getOperation();
                    if (operation == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.apollographql.apollo3.api.Operation<com.apollographql.apollo3.api.Operation.Data>");
                    }
                    ApolloInterceptor.InterceptorResponse result = this.this$0.parse(operation, response.getHttpResponse().get());
                    this.$callBack.onResponse(result);
                    this.$callBack.onCompleted();
                }
                catch (ApolloException e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(@NotNull ApolloException e) {
                Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
                if (this.this$0.getDisposed()) {
                    return;
                }
                this.$callBack.onFailure(e);
            }

            public void onCompleted() {
            }

            public void onFetch(@NotNull ApolloInterceptor.FetchSourceType sourceType) {
                Intrinsics.checkNotNullParameter((Object)((Object)sourceType), (String)"sourceType");
                this.$callBack.onFetch(sourceType);
            }
            {
                this.this$0 = this$0;
                this.$request = $captured_local_variable$1;
                this.$callBack = $captured_local_variable$2;
            }
        });
    }

    @Override
    public void dispose() {
        this.disposed = true;
    }

    @NotNull
    public final ApolloInterceptor.InterceptorResponse parse(@NotNull Operation<Operation.Data> operation, @NotNull Response httpResponse) throws ApolloHttpException, ApolloParseException {
        ApolloInterceptor.InterceptorResponse interceptorResponse;
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)httpResponse, (String)"httpResponse");
        String cacheKey = httpResponse.request().header("X-APOLLO-CACHE-KEY");
        if (httpResponse.isSuccessful()) {
            try {
                OkHttpExecutionContext httpExecutionContext = new OkHttpExecutionContext(httpResponse);
                ResponseBody responseBody = httpResponse.body();
                Intrinsics.checkNotNull((Object)responseBody);
                BufferedSource bufferedSource = responseBody.source();
                Intrinsics.checkNotNullExpressionValue((Object)bufferedSource, (String)"httpResponse.body()!!.source()");
                ApolloResponse parsedResponse = OperationKt.parseResponseBody(operation, (BufferedSource)bufferedSource, (ResponseAdapterCache)this.responseAdapterCache);
                parsedResponse = ApolloResponse.copy$default((ApolloResponse)parsedResponse, null, null, null, null, null, (ExecutionContext)parsedResponse.getExecutionContext().plus((ExecutionContext)httpExecutionContext).plus((ExecutionContext)new CacheInfo(httpResponse.cacheResponse() != null)), (int)31, null);
                if (parsedResponse.hasErrors() && this.httpCache != null) {
                    String string = cacheKey;
                    Intrinsics.checkNotNull((Object)string);
                    this.httpCache.removeQuietly(string);
                }
                interceptorResponse = new ApolloInterceptor.InterceptorResponse(httpResponse, parsedResponse);
            }
            catch (Exception rethrown) {
                this.logger.e((Throwable)rethrown, "Failed to parse network response for operation: %s", new Object[]{operation.name()});
                ApolloParseInterceptor.Companion.closeQuietly((Closeable)httpResponse);
                HttpCache httpCache = this.httpCache;
                if (httpCache != null) {
                    String string = cacheKey;
                    Intrinsics.checkNotNull((Object)string);
                    httpCache.removeQuietly(string);
                }
                throw (Throwable)new ApolloParseException("Failed to parse http response", (Throwable)rethrown);
            }
        } else {
            this.logger.e("Failed to parse network response: %s", new Object[]{httpResponse});
            int n = httpResponse.code();
            Headers headers = httpResponse.headers();
            Intrinsics.checkNotNullExpressionValue((Object)headers, (String)"httpResponse.headers()");
            Map map = ApolloParseInterceptor.Companion.toMap(headers);
            Object object = httpResponse.body();
            if (object == null || (object = object.string()) == null) {
                object = "";
            }
            throw (Throwable)new ApolloHttpException(n, map, (String)object, null);
        }
        return interceptorResponse;
    }

    public ApolloParseInterceptor(@Nullable HttpCache httpCache, @NotNull ResponseAdapterCache responseAdapterCache, @NotNull ApolloLogger logger) {
        Intrinsics.checkNotNullParameter((Object)responseAdapterCache, (String)"responseAdapterCache");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.httpCache = httpCache;
        this.responseAdapterCache = responseAdapterCache;
        this.logger = logger;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0018\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b*\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/apollographql/apollo3/internal/interceptor/ApolloParseInterceptor$Companion;", "", "()V", "closeQuietly", "", "closeable", "Ljava/io/Closeable;", "toMap", "", "", "Lokhttp3/Headers;", "apollo-runtime"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        private final Map<String, String> toMap(Headers $this$toMap) {
            void $this$mapTo$iv$iv;
            Set set = $this$toMap.names();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"this.names()");
            Iterable $this$map$iv = set;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string2 = $this$toMap.get((String)it);
                Intrinsics.checkNotNull((Object)string2);
                Pair pair = TuplesKt.to((Object)it, (Object)string2);
                collection.add(pair);
            }
            return MapsKt.toMap((Iterable)((List)destination$iv$iv));
        }

        private final void closeQuietly(Closeable closeable) {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

