/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.internal;

import com.apollographql.apollo3.ApolloSubscriptionCall;
import com.apollographql.apollo3.ResponseExtensionsKt;
import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.ResponseAdapterCache;
import com.apollographql.apollo3.api.Subscription;
import com.apollographql.apollo3.api.internal.ApolloLogger;
import com.apollographql.apollo3.cache.CacheHeaders;
import com.apollographql.apollo3.cache.normalized.ApolloStore;
import com.apollographql.apollo3.exception.ApolloCanceledException;
import com.apollographql.apollo3.exception.ApolloException;
import com.apollographql.apollo3.exception.ApolloNetworkException;
import com.apollographql.apollo3.internal.CallState;
import com.apollographql.apollo3.internal.RealApolloSubscriptionCall$WhenMappings;
import com.apollographql.apollo3.internal.subscription.ApolloSubscriptionException;
import com.apollographql.apollo3.internal.subscription.SubscriptionManager;
import com.apollographql.apollo3.internal.subscription.SubscriptionResponse;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001%BC\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0016J\u0016\u0010\u001f\u001a\u00020\u001d2\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!H\u0016J\u0010\u0010\"\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010#H\u0002J\b\u0010$\u001a\u00020\u001dH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0010\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00180\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/apollographql/apollo3/internal/RealApolloSubscriptionCall;", "D", "Lcom/apollographql/apollo3/api/Subscription$Data;", "Lcom/apollographql/apollo3/ApolloSubscriptionCall;", "subscription", "Lcom/apollographql/apollo3/api/Subscription;", "subscriptionManager", "Lcom/apollographql/apollo3/internal/subscription/SubscriptionManager;", "apolloStore", "Lcom/apollographql/apollo3/cache/normalized/ApolloStore;", "cachePolicy", "Lcom/apollographql/apollo3/ApolloSubscriptionCall$CachePolicy;", "dispatcher", "Ljava/util/concurrent/Executor;", "logger", "Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "responseAdapterCache", "Lcom/apollographql/apollo3/api/ResponseAdapterCache;", "(Lcom/apollographql/apollo3/api/Subscription;Lcom/apollographql/apollo3/internal/subscription/SubscriptionManager;Lcom/apollographql/apollo3/cache/normalized/ApolloStore;Lcom/apollographql/apollo3/ApolloSubscriptionCall$CachePolicy;Ljava/util/concurrent/Executor;Lcom/apollographql/apollo3/api/internal/ApolloLogger;Lcom/apollographql/apollo3/api/ResponseAdapterCache;)V", "isCanceled", "", "()Z", "state", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/apollographql/apollo3/internal/CallState;", "kotlin.jvm.PlatformType", "subscriptionCallback", "Lcom/apollographql/apollo3/internal/RealApolloSubscriptionCall$SubscriptionManagerCallback;", "cancel", "", "clone", "execute", "callback", "Lcom/apollographql/apollo3/ApolloSubscriptionCall$Callback;", "resolveFromCache", "Lcom/apollographql/apollo3/api/ApolloResponse;", "terminate", "SubscriptionManagerCallback", "apollo-runtime"})
public final class RealApolloSubscriptionCall<D extends Subscription.Data>
implements ApolloSubscriptionCall<D> {
    private final AtomicReference<CallState> state;
    private SubscriptionManagerCallback<D> subscriptionCallback;
    private final Subscription<D> subscription;
    private final SubscriptionManager subscriptionManager;
    private final ApolloStore apolloStore;
    private final ApolloSubscriptionCall.CachePolicy cachePolicy;
    private final Executor dispatcher;
    private final ApolloLogger logger;
    private final ResponseAdapterCache responseAdapterCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(@NotNull ApolloSubscriptionCall.Callback<D> callback) throws ApolloCanceledException {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        RealApolloSubscriptionCall realApolloSubscriptionCall = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realApolloSubscriptionCall) {
            boolean bl3 = false;
            CallState callState = this.state.get();
            if (callState == null) throw (Throwable)new IllegalStateException("Unknown state");
            switch (RealApolloSubscriptionCall$WhenMappings.$EnumSwitchMapping$0[callState.ordinal()]) {
                case 1: {
                    this.state.set(CallState.ACTIVE);
                    if (this.cachePolicy == ApolloSubscriptionCall.CachePolicy.CACHE_AND_NETWORK) {
                        this.dispatcher.execute(new Runnable(this, callback){
                            final /* synthetic */ RealApolloSubscriptionCall this$0;
                            final /* synthetic */ ApolloSubscriptionCall.Callback $callback$inlined;
                            {
                                this.this$0 = realApolloSubscriptionCall;
                                this.$callback$inlined = callback;
                            }

                            public final void run() {
                                ApolloResponse cachedResponse = RealApolloSubscriptionCall.access$resolveFromCache(this.this$0);
                                if (cachedResponse != null) {
                                    this.$callback$inlined.onResponse(cachedResponse);
                                }
                            }
                        });
                    }
                    SubscriptionManagerCallback<D> subscriptionManagerCallback = this.subscriptionCallback = new SubscriptionManagerCallback<D>(callback, this);
                    Intrinsics.checkNotNull(subscriptionManagerCallback);
                    this.subscriptionManager.subscribe(this.subscription, subscriptionManagerCallback);
                    break;
                }
                case 2: {
                    throw (Throwable)new ApolloCanceledException(null, null, 3, null);
                }
                case 3: 
                case 4: {
                    throw (Throwable)new IllegalStateException("Already Executed");
                }
                default: {
                    throw (Throwable)new IllegalStateException("Unknown state");
                }
            }
            Unit unit = Unit.INSTANCE;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void cancel() {
        RealApolloSubscriptionCall realApolloSubscriptionCall = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realApolloSubscriptionCall) {
            boolean bl3 = false;
            CallState callState = this.state.get();
            if (callState == null) throw (Throwable)new IllegalStateException("Unknown state");
            switch (RealApolloSubscriptionCall$WhenMappings.$EnumSwitchMapping$1[callState.ordinal()]) {
                case 1: {
                    this.state.set(CallState.CANCELED);
                    break;
                }
                case 2: {
                    try {
                        this.subscriptionManager.unsubscribe(this.subscription);
                        break;
                    }
                    finally {
                        this.state.set(CallState.CANCELED);
                        SubscriptionManagerCallback<D> subscriptionManagerCallback = this.subscriptionCallback;
                        Intrinsics.checkNotNull(subscriptionManagerCallback);
                        subscriptionManagerCallback.release();
                    }
                }
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    throw (Throwable)new IllegalStateException("Unknown state");
                }
            }
            Unit unit = Unit.INSTANCE;
            return;
        }
    }

    @Override
    @NotNull
    public ApolloSubscriptionCall<D> clone() {
        return new RealApolloSubscriptionCall<D>(this.subscription, this.subscriptionManager, this.apolloStore, this.cachePolicy, this.dispatcher, this.logger, this.responseAdapterCache);
    }

    @Override
    public boolean isCanceled() {
        return this.state.get() == CallState.CANCELED;
    }

    @Override
    @NotNull
    public ApolloSubscriptionCall<D> cachePolicy(@NotNull ApolloSubscriptionCall.CachePolicy cachePolicy) {
        Intrinsics.checkNotNullParameter((Object)((Object)cachePolicy), (String)"cachePolicy");
        return new RealApolloSubscriptionCall<D>(this.subscription, this.subscriptionManager, this.apolloStore, cachePolicy, this.dispatcher, this.logger, this.responseAdapterCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void terminate() {
        RealApolloSubscriptionCall realApolloSubscriptionCall = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realApolloSubscriptionCall) {
            boolean bl3 = false;
            CallState callState = this.state.get();
            if (callState == null) throw (Throwable)new IllegalStateException("Unknown state");
            switch (RealApolloSubscriptionCall$WhenMappings.$EnumSwitchMapping$2[callState.ordinal()]) {
                case 1: {
                    this.state.set(CallState.TERMINATED);
                    SubscriptionManagerCallback<D> subscriptionManagerCallback = this.subscriptionCallback;
                    Intrinsics.checkNotNull(subscriptionManagerCallback);
                    subscriptionManagerCallback.release();
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    CallState callState2 = this.state.get();
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)callState2), (String)"state.get()");
                    throw (Throwable)new IllegalStateException(CallState.IllegalStateMessage.Companion.forCurrentState(callState2).expected(CallState.ACTIVE, CallState.CANCELED));
                }
                default: {
                    throw (Throwable)new IllegalStateException("Unknown state");
                }
            }
            Unit unit = Unit.INSTANCE;
            return;
        }
    }

    private final ApolloResponse<D> resolveFromCache() {
        ApolloResponse apolloResponse;
        Subscription.Data data2 = (Subscription.Data)BuildersKt.runBlocking$default(null, (Function2)new Function2<CoroutineScope, Continuation<? super D>, Object>(this, null){
            int label;
            final /* synthetic */ RealApolloSubscriptionCall this$0;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = ApolloStore.readOperation$default((ApolloStore)RealApolloSubscriptionCall.access$getApolloStore$p(this.this$0), (Operation)((Operation)RealApolloSubscriptionCall.access$getSubscription$p(this.this$0)), (ResponseAdapterCache)RealApolloSubscriptionCall.access$getResponseAdapterCache$p(this.this$0), (CacheHeaders)CacheHeaders.NONE, null, (Continuation)this, (int)8, null);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = realApolloSubscriptionCall;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super D>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }, (int)1, null);
        if (data2 != null) {
            this.logger.d("Cache HIT for subscription `%s`", new Object[]{this.subscription});
            boolean $i$f$uuid4 = false;
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"UUID.randomUUID()");
            apolloResponse = ResponseExtensionsKt.withCacheInfo(new ApolloResponse(uUID, (Operation)this.subscription, (Operation.Data)data2, null, null, null, 56, null), true);
        } else {
            this.logger.d("Cache MISS for subscription `%s`", new Object[]{this.subscription});
            apolloResponse = null;
        }
        return apolloResponse;
    }

    public RealApolloSubscriptionCall(@NotNull Subscription<D> subscription, @NotNull SubscriptionManager subscriptionManager, @NotNull ApolloStore apolloStore, @NotNull ApolloSubscriptionCall.CachePolicy cachePolicy, @NotNull Executor dispatcher, @NotNull ApolloLogger logger, @NotNull ResponseAdapterCache responseAdapterCache) {
        Intrinsics.checkNotNullParameter(subscription, (String)"subscription");
        Intrinsics.checkNotNullParameter((Object)subscriptionManager, (String)"subscriptionManager");
        Intrinsics.checkNotNullParameter((Object)apolloStore, (String)"apolloStore");
        Intrinsics.checkNotNullParameter((Object)((Object)cachePolicy), (String)"cachePolicy");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)responseAdapterCache, (String)"responseAdapterCache");
        this.subscription = subscription;
        this.subscriptionManager = subscriptionManager;
        this.apolloStore = apolloStore;
        this.cachePolicy = cachePolicy;
        this.dispatcher = dispatcher;
        this.logger = logger;
        this.responseAdapterCache = responseAdapterCache;
        this.state = new AtomicReference<CallState>(CallState.IDLE);
    }

    public static final /* synthetic */ ApolloStore access$getApolloStore$p(RealApolloSubscriptionCall $this) {
        return $this.apolloStore;
    }

    public static final /* synthetic */ ResponseAdapterCache access$getResponseAdapterCache$p(RealApolloSubscriptionCall $this) {
        return $this.responseAdapterCache;
    }

    public static final /* synthetic */ ApolloResponse access$resolveFromCache(RealApolloSubscriptionCall $this) {
        return $this.resolveFromCache();
    }

    public static final /* synthetic */ Subscription access$getSubscription$p(RealApolloSubscriptionCall $this) {
        return $this.subscription;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B%\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\nH\u0016J\u0006\u0010\u0016\u001a\u00020\nJ\u0006\u0010\u0017\u001a\u00020\nR\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/apollographql/apollo3/internal/RealApolloSubscriptionCall$SubscriptionManagerCallback;", "D", "Lcom/apollographql/apollo3/api/Subscription$Data;", "Lcom/apollographql/apollo3/internal/subscription/SubscriptionManager$Callback;", "originalCallback", "Lcom/apollographql/apollo3/ApolloSubscriptionCall$Callback;", "delegate", "Lcom/apollographql/apollo3/internal/RealApolloSubscriptionCall;", "(Lcom/apollographql/apollo3/ApolloSubscriptionCall$Callback;Lcom/apollographql/apollo3/internal/RealApolloSubscriptionCall;)V", "onCompleted", "", "onConnected", "onError", "error", "Lcom/apollographql/apollo3/internal/subscription/ApolloSubscriptionException;", "onNetworkError", "t", "", "onResponse", "response", "Lcom/apollographql/apollo3/internal/subscription/SubscriptionResponse;", "onTerminated", "release", "terminate", "apollo-runtime"})
    private static final class SubscriptionManagerCallback<D extends Subscription.Data>
    implements SubscriptionManager.Callback<D> {
        private ApolloSubscriptionCall.Callback<D> originalCallback;
        private RealApolloSubscriptionCall<D> delegate;

        /*
         * WARNING - void declaration
         */
        @Override
        public void onResponse(@NotNull SubscriptionResponse<D> response) {
            Intrinsics.checkNotNullParameter(response, (String)"response");
            ApolloSubscriptionCall.Callback<D> callback = this.originalCallback;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = (Subscription.Data)response.getResponse().getData();
            if (callback != null) {
                void data2;
                if ((Subscription.Data)data2.element != null) {
                    RealApolloSubscriptionCall<D> realApolloSubscriptionCall = this.delegate;
                    Intrinsics.checkNotNull(realApolloSubscriptionCall);
                    if (((RealApolloSubscriptionCall)realApolloSubscriptionCall).cachePolicy != ApolloSubscriptionCall.CachePolicy.NO_CACHE) {
                        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Set<? extends String>>, Object>(this, response, (Ref.ObjectRef)data2, null){
                            int label;
                            final /* synthetic */ SubscriptionManagerCallback this$0;
                            final /* synthetic */ SubscriptionResponse $response;
                            final /* synthetic */ Ref.ObjectRef $data;

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        RealApolloSubscriptionCall realApolloSubscriptionCall = SubscriptionManagerCallback.access$getDelegate$p(this.this$0);
                                        Intrinsics.checkNotNull((Object)realApolloSubscriptionCall);
                                        ApolloStore apolloStore = RealApolloSubscriptionCall.access$getApolloStore$p(realApolloSubscriptionCall);
                                        Operation operation = (Operation)this.$response.getSubscription();
                                        Operation.Data data2 = (Operation.Data)((Subscription.Data)this.$data.element);
                                        RealApolloSubscriptionCall realApolloSubscriptionCall2 = SubscriptionManagerCallback.access$getDelegate$p(this.this$0);
                                        Intrinsics.checkNotNull((Object)realApolloSubscriptionCall2);
                                        this.label = 1;
                                        Object object3 = apolloStore.writeOperation(operation, data2, RealApolloSubscriptionCall.access$getResponseAdapterCache$p(realApolloSubscriptionCall2), CacheHeaders.NONE, true, (Continuation)this);
                                        if (object3 != object2) return object3;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return object3;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }
                            {
                                this.this$0 = subscriptionManagerCallback;
                                this.$response = subscriptionResponse;
                                this.$data = objectRef;
                                super(2, continuation);
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                Function2<CoroutineScope, Continuation<? super Set<? extends String>>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                return function2;
                            }

                            public final Object invoke(Object object, Object object2) {
                                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)1, null);
                    }
                }
                callback.onResponse(response.getResponse());
            }
        }

        @Override
        public void onError(@NotNull ApolloSubscriptionException error) {
            ApolloSubscriptionCall.Callback<D> callback;
            Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
            ApolloSubscriptionCall.Callback<D> callback2 = callback = this.originalCallback;
            if (callback2 != null) {
                callback2.onFailure(error);
            }
            this.terminate();
        }

        @Override
        public void onNetworkError(@NotNull Throwable t) {
            ApolloSubscriptionCall.Callback<D> callback;
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            ApolloSubscriptionCall.Callback<D> callback2 = callback = this.originalCallback;
            if (callback2 != null) {
                callback2.onFailure((ApolloException)new ApolloNetworkException("Subscription failed", t));
            }
            this.terminate();
        }

        @Override
        public void onCompleted() {
            ApolloSubscriptionCall.Callback<D> callback;
            ApolloSubscriptionCall.Callback<D> callback2 = callback = this.originalCallback;
            if (callback2 != null) {
                callback2.onCompleted();
            }
            this.terminate();
        }

        @Override
        public void onTerminated() {
            ApolloSubscriptionCall.Callback<D> callback;
            ApolloSubscriptionCall.Callback<D> callback2 = callback = this.originalCallback;
            if (callback2 != null) {
                callback2.onTerminated();
            }
            this.terminate();
        }

        @Override
        public void onConnected() {
            block0: {
                ApolloSubscriptionCall.Callback<D> callback;
                ApolloSubscriptionCall.Callback<D> callback2 = callback = this.originalCallback;
                if (callback2 == null) break block0;
                callback2.onConnected();
            }
        }

        public final void terminate() {
            block0: {
                RealApolloSubscriptionCall<D> delegate;
                RealApolloSubscriptionCall<D> realApolloSubscriptionCall = delegate = this.delegate;
                if (realApolloSubscriptionCall == null) break block0;
                ((RealApolloSubscriptionCall)realApolloSubscriptionCall).terminate();
            }
        }

        public final void release() {
            this.originalCallback = null;
            this.delegate = null;
        }

        public SubscriptionManagerCallback(@Nullable ApolloSubscriptionCall.Callback<D> originalCallback, @Nullable RealApolloSubscriptionCall<D> delegate) {
            this.originalCallback = originalCallback;
            this.delegate = delegate;
        }

        public static final /* synthetic */ RealApolloSubscriptionCall access$getDelegate$p(SubscriptionManagerCallback $this) {
            return $this.delegate;
        }

        public static final /* synthetic */ void access$setDelegate$p(SubscriptionManagerCallback $this, RealApolloSubscriptionCall realApolloSubscriptionCall) {
            $this.delegate = realApolloSubscriptionCall;
        }
    }
}

