/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.interceptor;

import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.Error;
import com.apollographql.apollo3.api.Mutation;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.Query;
import com.apollographql.apollo3.api.internal.ApolloLogger;
import com.apollographql.apollo3.api.internal.Function;
import com.apollographql.apollo3.api.internal.Optional;
import com.apollographql.apollo3.exception.ApolloException;
import com.apollographql.apollo3.interceptor.ApolloInterceptor;
import com.apollographql.apollo3.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo3.interceptor.ApolloInterceptorFactory;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J(\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0016\u0010\u0019\u001a\u00020\u00052\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bJ\u0016\u0010\u001d\u001a\u00020\u00052\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bR\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006 "}, d2={"Lcom/apollographql/apollo3/interceptor/ApolloAutoPersistedOperationInterceptor;", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor;", "logger", "Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "useHttpGetMethodForPersistedOperations", "", "(Lcom/apollographql/apollo3/api/internal/ApolloLogger;Z)V", "disposed", "getUseHttpGetMethodForPersistedOperations", "()Z", "dispose", "", "handleProtocolNegotiation", "Lcom/apollographql/apollo3/api/internal/Optional;", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor$InterceptorRequest;", "request", "response", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor$InterceptorResponse;", "interceptAsync", "chain", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptorChain;", "dispatcher", "Ljava/util/concurrent/Executor;", "callBack", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor$CallBack;", "isPersistedQueryNotFound", "errors", "", "Lcom/apollographql/apollo3/api/Error;", "isPersistedQueryNotSupported", "Companion", "Factory", "apollo-runtime"})
public final class ApolloAutoPersistedOperationInterceptor
implements ApolloInterceptor {
    private volatile boolean disposed;
    private final ApolloLogger logger;
    private final boolean useHttpGetMethodForPersistedOperations;
    private static final String PROTOCOL_NEGOTIATION_ERROR_QUERY_NOT_FOUND = "PersistedQueryNotFound";
    private static final String PROTOCOL_NEGOTIATION_ERROR_NOT_SUPPORTED = "PersistedQueryNotSupported";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void interceptAsync(@NotNull ApolloInterceptor.InterceptorRequest request, @NotNull ApolloInterceptorChain chain, @NotNull Executor dispatcher, @NotNull ApolloInterceptor.CallBack callBack) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
        ApolloInterceptor.InterceptorRequest newRequest = request.toBuilder().sendQueryDocument(false).autoPersistQueries(true).useHttpGetMethodForQueries(request.getUseHttpGetMethodForQueries() || this.useHttpGetMethodForPersistedOperations).build();
        chain.proceedAsync(newRequest, dispatcher, new ApolloInterceptor.CallBack(this, request, chain, dispatcher, callBack){
            final /* synthetic */ ApolloAutoPersistedOperationInterceptor this$0;
            final /* synthetic */ ApolloInterceptor.InterceptorRequest $request;
            final /* synthetic */ ApolloInterceptorChain $chain;
            final /* synthetic */ Executor $dispatcher;
            final /* synthetic */ ApolloInterceptor.CallBack $callBack;

            public void onResponse(@NotNull ApolloInterceptor.InterceptorResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (ApolloAutoPersistedOperationInterceptor.access$getDisposed$p(this.this$0)) {
                    return;
                }
                Optional<ApolloInterceptor.InterceptorRequest> retryRequest = this.this$0.handleProtocolNegotiation(this.$request, response);
                if (retryRequest.isPresent()) {
                    this.$chain.proceedAsync(retryRequest.get(), this.$dispatcher, this.$callBack);
                } else {
                    this.$callBack.onResponse(response);
                    this.$callBack.onCompleted();
                }
            }

            public void onFetch(@NotNull ApolloInterceptor.FetchSourceType sourceType) {
                Intrinsics.checkNotNullParameter((Object)((Object)sourceType), (String)"sourceType");
                this.$callBack.onFetch(sourceType);
            }

            public void onFailure(@NotNull ApolloException e) {
                Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
                this.$callBack.onFailure(e);
            }

            public void onCompleted() {
            }
            {
                this.this$0 = this$0;
                this.$request = $captured_local_variable$1;
                this.$chain = $captured_local_variable$2;
                this.$dispatcher = $captured_local_variable$3;
                this.$callBack = $captured_local_variable$4;
            }
        });
    }

    @Override
    public void dispose() {
        this.disposed = true;
    }

    @NotNull
    public final Optional<ApolloInterceptor.InterceptorRequest> handleProtocolNegotiation(@NotNull ApolloInterceptor.InterceptorRequest request, @NotNull ApolloInterceptor.InterceptorResponse response) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Optional<ApolloResponse<?>> optional = response.parsedResponse;
        if (optional == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.apollographql.apollo3.api.internal.Optional<com.apollographql.apollo3.api.ApolloResponse<com.apollographql.apollo3.api.Operation.Data>>");
        }
        return optional.flatMap((Function)new Function<ApolloResponse<? extends Operation.Data>, Optional<ApolloInterceptor.InterceptorRequest>>(this, request){
            final /* synthetic */ ApolloAutoPersistedOperationInterceptor this$0;
            final /* synthetic */ ApolloInterceptor.InterceptorRequest $request;

            @NotNull
            public Optional<ApolloInterceptor.InterceptorRequest> apply(@NotNull ApolloResponse<? extends Operation.Data> response) {
                Intrinsics.checkNotNullParameter(response, (String)"response");
                if (response.hasErrors()) {
                    if (this.this$0.isPersistedQueryNotFound(response.getErrors())) {
                        ApolloAutoPersistedOperationInterceptor.access$getLogger$p(this.this$0).w("GraphQL server couldn't find Automatic Persisted Query for operation name: " + this.$request.getOperation().name() + " id: " + this.$request.getOperation().operationId(), new Object[0]);
                        ApolloInterceptor.InterceptorRequest retryRequest = this.$request.toBuilder().autoPersistQueries(true).sendQueryDocument(true).build();
                        return Optional.Companion.of(retryRequest);
                    }
                    if (this.this$0.isPersistedQueryNotSupported(response.getErrors())) {
                        ApolloAutoPersistedOperationInterceptor.access$getLogger$p(this.this$0).e("GraphQL server doesn't support Automatic Persisted Queries", new Object[0]);
                        return Optional.Companion.of(this.$request);
                    }
                }
                return Optional.Companion.absent();
            }
            {
                this.this$0 = this$0;
                this.$request = $captured_local_variable$1;
            }
        });
    }

    public final boolean isPersistedQueryNotFound(@Nullable List<Error> errors) {
        List<Error> list = errors;
        Intrinsics.checkNotNull(list);
        for (Error error : list) {
            if (!StringsKt.equals((String)PROTOCOL_NEGOTIATION_ERROR_QUERY_NOT_FOUND, (String)error.getMessage(), (boolean)true)) continue;
            return true;
        }
        return false;
    }

    public final boolean isPersistedQueryNotSupported(@Nullable List<Error> errors) {
        List<Error> list = errors;
        Intrinsics.checkNotNull(list);
        for (Error error : list) {
            if (!StringsKt.equals((String)PROTOCOL_NEGOTIATION_ERROR_NOT_SUPPORTED, (String)error.getMessage(), (boolean)true)) continue;
            return true;
        }
        return false;
    }

    public final boolean getUseHttpGetMethodForPersistedOperations() {
        return this.useHttpGetMethodForPersistedOperations;
    }

    public ApolloAutoPersistedOperationInterceptor(@NotNull ApolloLogger logger, boolean useHttpGetMethodForPersistedOperations) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.useHttpGetMethodForPersistedOperations = useHttpGetMethodForPersistedOperations;
    }

    public static final /* synthetic */ boolean access$getDisposed$p(ApolloAutoPersistedOperationInterceptor $this) {
        return $this.disposed;
    }

    public static final /* synthetic */ void access$setDisposed$p(ApolloAutoPersistedOperationInterceptor $this, boolean bl) {
        $this.disposed = bl;
    }

    public static final /* synthetic */ ApolloLogger access$getLogger$p(ApolloAutoPersistedOperationInterceptor $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/apollographql/apollo3/interceptor/ApolloAutoPersistedOperationInterceptor$Factory;", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptorFactory;", "useHttpGet", "", "persistQueries", "persistMutations", "(ZZZ)V", "getPersistMutations", "()Z", "getPersistQueries", "getUseHttpGet", "newInterceptor", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor;", "logger", "Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "operation", "Lcom/apollographql/apollo3/api/Operation;", "apollo-runtime"})
    public static final class Factory
    implements ApolloInterceptorFactory {
        private final boolean useHttpGet;
        private final boolean persistQueries;
        private final boolean persistMutations;

        @Override
        @Nullable
        public ApolloInterceptor newInterceptor(@NotNull ApolloLogger logger, @NotNull Operation<?> operation) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            if (operation instanceof Query && !this.persistQueries) {
                return null;
            }
            return operation instanceof Mutation && !this.persistMutations ? null : (ApolloInterceptor)new ApolloAutoPersistedOperationInterceptor(logger, this.useHttpGet);
        }

        public final boolean getUseHttpGet() {
            return this.useHttpGet;
        }

        public final boolean getPersistQueries() {
            return this.persistQueries;
        }

        public final boolean getPersistMutations() {
            return this.persistMutations;
        }

        @JvmOverloads
        public Factory(boolean useHttpGet, boolean persistQueries, boolean persistMutations) {
            this.useHttpGet = useHttpGet;
            this.persistQueries = persistQueries;
            this.persistMutations = persistMutations;
        }

        public /* synthetic */ Factory(boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = true;
            }
            if ((n & 4) != 0) {
                bl3 = true;
            }
            this(bl, bl2, bl3);
        }

        @JvmOverloads
        public Factory(boolean useHttpGet, boolean persistQueries) {
            this(useHttpGet, persistQueries, false, 4, null);
        }

        @JvmOverloads
        public Factory(boolean useHttpGet) {
            this(useHttpGet, false, false, 6, null);
        }

        @JvmOverloads
        public Factory() {
            this(false, false, false, 7, null);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/apollographql/apollo3/interceptor/ApolloAutoPersistedOperationInterceptor$Companion;", "", "()V", "PROTOCOL_NEGOTIATION_ERROR_NOT_SUPPORTED", "", "PROTOCOL_NEGOTIATION_ERROR_QUERY_NOT_FOUND", "apollo-runtime"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

