/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.internal;

import com.apollographql.apollo3.ApolloPrefetch;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.ResponseAdapterCache;
import com.apollographql.apollo3.api.cache.http.HttpCachePolicy;
import com.apollographql.apollo3.api.internal.ApolloLogger;
import com.apollographql.apollo3.api.internal.Optional;
import com.apollographql.apollo3.exception.ApolloCanceledException;
import com.apollographql.apollo3.exception.ApolloException;
import com.apollographql.apollo3.exception.ApolloHttpException;
import com.apollographql.apollo3.exception.ApolloNetworkException;
import com.apollographql.apollo3.interceptor.ApolloInterceptor;
import com.apollographql.apollo3.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo3.internal.ApolloCallTracker;
import com.apollographql.apollo3.internal.CallState;
import com.apollographql.apollo3.internal.RealApolloPrefetch$WhenMappings;
import com.apollographql.apollo3.internal.interceptor.ApolloServerInterceptor;
import com.apollographql.apollo3.internal.interceptor.RealApolloInterceptorChain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BA\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010/\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u00020\"02H\u0002J\b\u00103\u001a\u000200H\u0016J\b\u00104\u001a\u00020\u0001H\u0016J\u0012\u00105\u001a\u0002002\b\u00101\u001a\u0004\u0018\u00010\"H\u0016J\b\u00106\u001a\u000207H\u0002J\f\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0016J\f\u00108\u001a\b\u0012\u0004\u0012\u00020\"02R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0019\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"0!\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001f\u0010)\u001a\u0010\u0012\f\u0012\n +*\u0004\u0018\u00010*0*0!\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010$R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.\u00a8\u00069"}, d2={"Lcom/apollographql/apollo3/internal/RealApolloPrefetch;", "Lcom/apollographql/apollo3/ApolloPrefetch;", "operation", "Lcom/apollographql/apollo3/api/Operation;", "serverUrl", "Lokhttp3/HttpUrl;", "httpCallFactory", "Lokhttp3/Call$Factory;", "responseAdapterCache", "Lcom/apollographql/apollo3/api/ResponseAdapterCache;", "dispatcher", "Ljava/util/concurrent/Executor;", "logger", "Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "tracker", "Lcom/apollographql/apollo3/internal/ApolloCallTracker;", "(Lcom/apollographql/apollo3/api/Operation;Lokhttp3/HttpUrl;Lokhttp3/Call$Factory;Lcom/apollographql/apollo3/api/ResponseAdapterCache;Ljava/util/concurrent/Executor;Lcom/apollographql/apollo3/api/internal/ApolloLogger;Lcom/apollographql/apollo3/internal/ApolloCallTracker;)V", "getDispatcher", "()Ljava/util/concurrent/Executor;", "getHttpCallFactory", "()Lokhttp3/Call$Factory;", "interceptorChain", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptorChain;", "getInterceptorChain", "()Lcom/apollographql/apollo3/interceptor/ApolloInterceptorChain;", "isCanceled", "", "()Z", "getLogger", "()Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "getOperation", "()Lcom/apollographql/apollo3/api/Operation;", "originalCallback", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/apollographql/apollo3/ApolloPrefetch$Callback;", "getOriginalCallback", "()Ljava/util/concurrent/atomic/AtomicReference;", "getResponseAdapterCache", "()Lcom/apollographql/apollo3/api/ResponseAdapterCache;", "getServerUrl", "()Lokhttp3/HttpUrl;", "state", "Lcom/apollographql/apollo3/internal/CallState;", "kotlin.jvm.PlatformType", "getState", "getTracker", "()Lcom/apollographql/apollo3/internal/ApolloCallTracker;", "activate", "", "callback", "Lcom/apollographql/apollo3/api/internal/Optional;", "cancel", "clone", "enqueue", "interceptorCallbackProxy", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor$CallBack;", "terminate", "apollo-runtime"})
public final class RealApolloPrefetch
implements ApolloPrefetch {
    @NotNull
    private final ApolloInterceptorChain interceptorChain;
    @NotNull
    private final AtomicReference<CallState> state;
    @NotNull
    private final AtomicReference<ApolloPrefetch.Callback> originalCallback;
    @NotNull
    private final Operation<?> operation;
    @NotNull
    private final HttpUrl serverUrl;
    @NotNull
    private final Call.Factory httpCallFactory;
    @NotNull
    private final ResponseAdapterCache responseAdapterCache;
    @NotNull
    private final Executor dispatcher;
    @NotNull
    private final ApolloLogger logger;
    @NotNull
    private final ApolloCallTracker tracker;

    @NotNull
    public final ApolloInterceptorChain getInterceptorChain() {
        return this.interceptorChain;
    }

    @NotNull
    public final AtomicReference<CallState> getState() {
        return this.state;
    }

    @NotNull
    public final AtomicReference<ApolloPrefetch.Callback> getOriginalCallback() {
        return this.originalCallback;
    }

    @Override
    public void enqueue(@Nullable ApolloPrefetch.Callback callback) {
        try {
            this.activate(Optional.Companion.fromNullable(callback));
        }
        catch (ApolloCanceledException e) {
            if (callback != null) {
                callback.onFailure((ApolloException)e);
            } else {
                this.logger.e((Throwable)e, "Operation: %s was canceled", new Object[]{this.operation().name()});
            }
            return;
        }
        ApolloInterceptor.InterceptorRequest request = ApolloInterceptor.InterceptorRequest.Companion.builder(this.operation).build();
        this.interceptorChain.proceedAsync(request, this.dispatcher, this.interceptorCallbackProxy());
    }

    @Override
    @NotNull
    public Operation<?> operation() {
        return this.operation;
    }

    private final ApolloInterceptor.CallBack interceptorCallbackProxy() {
        return new ApolloInterceptor.CallBack(this){
            final /* synthetic */ RealApolloPrefetch this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(@NotNull ApolloInterceptor.InterceptorResponse response) {
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                try (Response httpResponse = response.getHttpResponse().get();){
                    Optional<ApolloPrefetch.Callback> callback = this.this$0.terminate();
                    if (!callback.isPresent()) {
                        this.this$0.getLogger().d("onResponse for prefetch operation: %s. No callback present.", new Object[]{this.this$0.operation().name()});
                        return;
                    }
                    if (httpResponse.isSuccessful()) {
                        callback.get().onSuccess();
                    } else {
                        int n = httpResponse.code();
                        Headers headers = httpResponse.headers();
                        Intrinsics.checkExpressionValueIsNotNull((Object)headers, (String)"httpResponse.headers()");
                        Map<String, String> map = this.toMap(headers);
                        Object object = httpResponse.body();
                        if (object == null || (object = object.string()) == null) {
                            object = "";
                        }
                        callback.get().onHttpError(new ApolloHttpException(n, map, (String)object, null));
                    }
                }
            }

            /*
             * WARNING - void declaration
             */
            private final Map<String, String> toMap(Headers $this$toMap) {
                void $this$mapTo$iv$iv;
                Set set = $this$toMap.names();
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"this.names()");
                Iterable $this$map$iv = set;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string2 = $this$toMap.get((String)it);
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    Pair pair = TuplesKt.to((Object)it, (Object)string2);
                    collection.add(pair);
                }
                return MapsKt.toMap((Iterable)((List)destination$iv$iv));
            }

            public void onFailure(@NotNull ApolloException e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                Optional<ApolloPrefetch.Callback> callback = this.this$0.terminate();
                if (!callback.isPresent()) {
                    this.this$0.getLogger().e((Throwable)e, "onFailure for prefetch operation: %s. No callback present.", new Object[]{this.this$0.operation().name()});
                    return;
                }
                if (e instanceof ApolloHttpException) {
                    callback.get().onHttpError((ApolloHttpException)e);
                } else if (e instanceof ApolloNetworkException) {
                    callback.get().onNetworkError((ApolloNetworkException)e);
                } else {
                    callback.get().onFailure(e);
                }
            }

            public void onCompleted() {
            }

            public void onFetch(@NotNull ApolloInterceptor.FetchSourceType sourceType) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)sourceType), (String)"sourceType");
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    @Override
    @NotNull
    public ApolloPrefetch clone() {
        return new RealApolloPrefetch(this.operation, this.serverUrl, this.httpCallFactory, this.responseAdapterCache, this.dispatcher, this.logger, this.tracker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void cancel() {
        CallState callState = this.state.get();
        if (callState == null) throw (Throwable)new IllegalStateException("Unknown state");
        switch (RealApolloPrefetch$WhenMappings.$EnumSwitchMapping$0[callState.ordinal()]) {
            case 1: {
                try {
                    this.interceptorChain.dispose();
                    return;
                }
                finally {
                    this.tracker.unregisterPrefetchCall(this);
                    this.originalCallback.set(null);
                    this.state.set(CallState.CANCELED);
                }
            }
            case 2: {
                this.state.set(CallState.CANCELED);
                return;
            }
            case 3: 
            case 4: {
                return;
            }
            default: {
                throw (Throwable)new IllegalStateException("Unknown state");
            }
        }
    }

    @Override
    public boolean isCanceled() {
        return this.state.get() == CallState.CANCELED;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final synchronized void activate(Optional<ApolloPrefetch.Callback> callback) throws ApolloCanceledException {
        CallState callState = this.state.get();
        if (callState == null) throw (Throwable)new IllegalStateException("Unknown state");
        switch (RealApolloPrefetch$WhenMappings.$EnumSwitchMapping$1[callState.ordinal()]) {
            case 1: {
                this.originalCallback.set(callback.orNull());
                this.tracker.registerPrefetchCall(this);
                break;
            }
            case 2: {
                throw (Throwable)new ApolloCanceledException(null, null, 3, null);
            }
            case 3: 
            case 4: {
                throw (Throwable)new IllegalStateException("Already Executed");
            }
            default: {
                throw (Throwable)new IllegalStateException("Unknown state");
            }
        }
        this.state.set(CallState.ACTIVE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final synchronized Optional<ApolloPrefetch.Callback> terminate() {
        CallState callState = this.state.get();
        if (callState == null) throw (Throwable)new IllegalStateException("Unknown state");
        switch (RealApolloPrefetch$WhenMappings.$EnumSwitchMapping$2[callState.ordinal()]) {
            case 1: {
                this.tracker.unregisterPrefetchCall(this);
                this.state.set(CallState.TERMINATED);
                Optional<Object> optional = Optional.Companion.fromNullable(this.originalCallback.getAndSet(null));
                return optional;
            }
            case 2: {
                Optional<Object> optional = Optional.Companion.fromNullable(this.originalCallback.getAndSet(null));
                return optional;
            }
            case 3: 
            case 4: {
                CallState callState2 = this.state.get();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)callState2), (String)"state.get()");
                throw (Throwable)new IllegalStateException(CallState.IllegalStateMessage.Companion.forCurrentState(callState2).expected(CallState.ACTIVE, CallState.CANCELED));
            }
            default: {
                throw (Throwable)new IllegalStateException("Unknown state");
            }
        }
    }

    @NotNull
    public final Operation<?> getOperation() {
        return this.operation;
    }

    @NotNull
    public final HttpUrl getServerUrl() {
        return this.serverUrl;
    }

    @NotNull
    public final Call.Factory getHttpCallFactory() {
        return this.httpCallFactory;
    }

    @NotNull
    public final ResponseAdapterCache getResponseAdapterCache() {
        return this.responseAdapterCache;
    }

    @NotNull
    public final Executor getDispatcher() {
        return this.dispatcher;
    }

    @NotNull
    public final ApolloLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public final ApolloCallTracker getTracker() {
        return this.tracker;
    }

    public RealApolloPrefetch(@NotNull Operation<?> operation, @NotNull HttpUrl serverUrl, @NotNull Call.Factory httpCallFactory, @NotNull ResponseAdapterCache responseAdapterCache, @NotNull Executor dispatcher, @NotNull ApolloLogger logger, @NotNull ApolloCallTracker tracker) {
        Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
        Intrinsics.checkParameterIsNotNull((Object)serverUrl, (String)"serverUrl");
        Intrinsics.checkParameterIsNotNull((Object)httpCallFactory, (String)"httpCallFactory");
        Intrinsics.checkParameterIsNotNull((Object)responseAdapterCache, (String)"responseAdapterCache");
        Intrinsics.checkParameterIsNotNull((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)tracker, (String)"tracker");
        this.operation = operation;
        this.serverUrl = serverUrl;
        this.httpCallFactory = httpCallFactory;
        this.responseAdapterCache = responseAdapterCache;
        this.dispatcher = dispatcher;
        this.logger = logger;
        this.tracker = tracker;
        this.state = new AtomicReference<CallState>(CallState.IDLE);
        this.originalCallback = new AtomicReference();
        this.interceptorChain = new RealApolloInterceptorChain(CollectionsKt.listOf((Object)new ApolloServerInterceptor(this.serverUrl, this.httpCallFactory, HttpCachePolicy.NETWORK_ONLY, true, this.responseAdapterCache, this.logger)));
    }
}

