/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.internal.fetcher;

import com.apollographql.apollo3.api.exception.ApolloException;
import com.apollographql.apollo3.api.internal.ApolloLogger;
import com.apollographql.apollo3.fetcher.ResponseFetcher;
import com.apollographql.apollo3.interceptor.ApolloInterceptor;
import com.apollographql.apollo3.interceptor.ApolloInterceptorChain;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/apollographql/apollo3/internal/fetcher/NetworkFirstFetcher;", "Lcom/apollographql/apollo3/fetcher/ResponseFetcher;", "()V", "provideInterceptor", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor;", "logger", "Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "NetworkFirstInterceptor", "apollo-runtime"})
public final class NetworkFirstFetcher
implements ResponseFetcher {
    @Override
    @NotNull
    public ApolloInterceptor provideInterceptor(@Nullable ApolloLogger logger) {
        return new NetworkFirstInterceptor(logger);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/apollographql/apollo3/internal/fetcher/NetworkFirstFetcher$NetworkFirstInterceptor;", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor;", "logger", "Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "(Lcom/apollographql/apollo3/api/internal/ApolloLogger;)V", "disposed", "", "getDisposed", "()Z", "setDisposed", "(Z)V", "getLogger", "()Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "dispose", "", "interceptAsync", "request", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor$InterceptorRequest;", "chain", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptorChain;", "dispatcher", "Ljava/util/concurrent/Executor;", "callBack", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor$CallBack;", "apollo-runtime"})
    private static final class NetworkFirstInterceptor
    implements ApolloInterceptor {
        @Nullable
        private final ApolloLogger logger;
        private volatile boolean disposed;

        public NetworkFirstInterceptor(@Nullable ApolloLogger logger) {
            this.logger = logger;
        }

        @Nullable
        public final ApolloLogger getLogger() {
            return this.logger;
        }

        public final boolean getDisposed() {
            return this.disposed;
        }

        public final void setDisposed(boolean bl) {
            this.disposed = bl;
        }

        @Override
        public void interceptAsync(@NotNull ApolloInterceptor.InterceptorRequest request, @NotNull ApolloInterceptorChain chain, @NotNull Executor dispatcher, @NotNull ApolloInterceptor.CallBack callBack) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
            Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
            ApolloInterceptor.InterceptorRequest networkRequest = request.toBuilder().fetchFromCache(false).build();
            chain.proceedAsync(networkRequest, dispatcher, new ApolloInterceptor.CallBack(callBack, this, request, chain, dispatcher){
                final /* synthetic */ ApolloInterceptor.CallBack $callBack;
                final /* synthetic */ NetworkFirstInterceptor this$0;
                final /* synthetic */ ApolloInterceptor.InterceptorRequest $request;
                final /* synthetic */ ApolloInterceptorChain $chain;
                final /* synthetic */ Executor $dispatcher;
                {
                    this.$callBack = $callBack;
                    this.this$0 = $receiver;
                    this.$request = $request;
                    this.$chain = $chain;
                    this.$dispatcher = $dispatcher;
                }

                public void onResponse(@NotNull ApolloInterceptor.InterceptorResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    this.$callBack.onResponse(response);
                }

                public void onFailure(@NotNull ApolloException networkException) {
                    Intrinsics.checkNotNullParameter((Object)networkException, (String)"networkException");
                    Object[] objectArray = this.this$0.getLogger();
                    Intrinsics.checkNotNull((Object)objectArray);
                    Object[] objectArray2 = objectArray;
                    objectArray = new Object[]{this.$request.getOperation().name()};
                    objectArray2.d((Throwable)networkException, "Failed to fetch network response for operation %s, trying to return cached one", objectArray);
                    if (!this.this$0.getDisposed()) {
                        ApolloInterceptor.InterceptorRequest cacheRequest = this.$request.toBuilder().fetchFromCache(true).build();
                        this.$chain.proceedAsync(cacheRequest, this.$dispatcher, new ApolloInterceptor.CallBack(this.$callBack, networkException){
                            final /* synthetic */ ApolloInterceptor.CallBack $callBack;
                            final /* synthetic */ ApolloException $networkException;
                            {
                                this.$callBack = $callBack;
                                this.$networkException = $networkException;
                            }

                            public void onResponse(@NotNull ApolloInterceptor.InterceptorResponse response) {
                                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                                this.$callBack.onResponse(response);
                            }

                            public void onFetch(@NotNull ApolloInterceptor.FetchSourceType sourceType) {
                                Intrinsics.checkNotNullParameter((Object)((Object)sourceType), (String)"sourceType");
                                this.$callBack.onFetch(sourceType);
                            }

                            public void onFailure(@NotNull ApolloException cacheException) {
                                Intrinsics.checkNotNullParameter((Object)cacheException, (String)"cacheException");
                                this.$callBack.onFailure(this.$networkException);
                            }

                            public void onCompleted() {
                                this.$callBack.onCompleted();
                            }
                        });
                    }
                }

                public void onCompleted() {
                    this.$callBack.onCompleted();
                }

                public void onFetch(@NotNull ApolloInterceptor.FetchSourceType sourceType) {
                    Intrinsics.checkNotNullParameter((Object)((Object)sourceType), (String)"sourceType");
                    this.$callBack.onFetch(sourceType);
                }
            });
        }

        @Override
        public void dispose() {
            this.disposed = true;
        }
    }
}

