/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.internal.interceptor;

import com.apollographql.apollo3.api.ApolloRequest;
import com.apollographql.apollo3.api.CustomScalarAdapters;
import com.apollographql.apollo3.api.ExecutionContext;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.Query;
import com.apollographql.apollo3.api.cache.http.HttpCachePolicy;
import com.apollographql.apollo3.api.exception.ApolloException;
import com.apollographql.apollo3.api.exception.ApolloNetworkException;
import com.apollographql.apollo3.api.http.DefaultHttpRequestComposer;
import com.apollographql.apollo3.api.http.HttpBody;
import com.apollographql.apollo3.api.http.HttpMethod;
import com.apollographql.apollo3.api.http.HttpRequestComposerParams;
import com.apollographql.apollo3.api.internal.ApolloLogger;
import com.apollographql.apollo3.api.internal.json.BufferedSinkJsonWriter;
import com.apollographql.apollo3.api.json.JsonWriter;
import com.apollographql.apollo3.cache.CacheHeaders;
import com.apollographql.apollo3.interceptor.ApolloInterceptor;
import com.apollographql.apollo3.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo3.request.RequestHeaders;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 =2\u00020\u0001:\u0001=B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ*\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\b\u0010.\u001a\u00020%H\u0016J\u0016\u0010/\u001a\u00020%2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203J2\u00104\u001a\u00020\u001c2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u00105\u001a\u00020\t2\u0006\u00106\u001a\u00020\tJ2\u00107\u001a\u00020\u001c2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u00105\u001a\u00020\t2\u0006\u00106\u001a\u00020\tJ(\u00108\u001a\u00020%2\u0006\u00100\u001a\u0002012\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u00102\u001a\u000203H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/apollographql/apollo3/internal/interceptor/ApolloServerInterceptor;", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor;", "serverUrl", "Lokhttp3/HttpUrl;", "httpCallFactory", "Lokhttp3/Call$Factory;", "cachePolicy", "Lcom/apollographql/apollo3/api/cache/http/HttpCachePolicy$Policy;", "prefetch", "", "customScalarAdapters", "Lcom/apollographql/apollo3/api/CustomScalarAdapters;", "logger", "Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "(Lokhttp3/HttpUrl;Lokhttp3/Call$Factory;Lcom/apollographql/apollo3/api/cache/http/HttpCachePolicy$Policy;ZLcom/apollographql/apollo3/api/CustomScalarAdapters;Lcom/apollographql/apollo3/api/internal/ApolloLogger;)V", "composer", "Lcom/apollographql/apollo3/api/http/DefaultHttpRequestComposer;", "getComposer", "()Lcom/apollographql/apollo3/api/http/DefaultHttpRequestComposer;", "getCustomScalarAdapters", "()Lcom/apollographql/apollo3/api/CustomScalarAdapters;", "disposed", "getDisposed", "()Z", "setDisposed", "(Z)V", "httpCallRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Lokhttp3/Call;", "getHttpCallRef", "()Ljava/util/concurrent/atomic/AtomicReference;", "setHttpCallRef", "(Ljava/util/concurrent/atomic/AtomicReference;)V", "getLogger", "()Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "getPrefetch", "decorateRequest", "", "requestBuilder", "Lokhttp3/Request$Builder;", "operation", "Lcom/apollographql/apollo3/api/Operation;", "cacheHeaders", "Lcom/apollographql/apollo3/cache/CacheHeaders;", "requestHeaders", "Lcom/apollographql/apollo3/request/RequestHeaders;", "dispose", "executeHttpCall", "request", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor$InterceptorRequest;", "callBack", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor$CallBack;", "httpGetCall", "writeQueryDocument", "autoPersistQueries", "httpPostCall", "interceptAsync", "chain", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptorChain;", "dispatcher", "Ljava/util/concurrent/Executor;", "Companion", "apollo-runtime"})
public final class ApolloServerInterceptor
implements ApolloInterceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HttpUrl serverUrl;
    @NotNull
    private final Call.Factory httpCallFactory;
    @Nullable
    private final HttpCachePolicy.Policy cachePolicy;
    private final boolean prefetch;
    @NotNull
    private final CustomScalarAdapters customScalarAdapters;
    @NotNull
    private final ApolloLogger logger;
    @NotNull
    private AtomicReference<Call> httpCallRef;
    private volatile boolean disposed;
    @NotNull
    private final DefaultHttpRequestComposer composer;
    @NotNull
    public static final String HEADER_ACCEPT_TYPE = "Accept";
    @NotNull
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    @NotNull
    public static final String HEADER_APOLLO_OPERATION_ID = "X-APOLLO-OPERATION-ID";
    @NotNull
    public static final String HEADER_APOLLO_OPERATION_NAME = "X-APOLLO-OPERATION-NAME";
    @NotNull
    public static final String JSON_CONTENT_TYPE = "application/json";

    public ApolloServerInterceptor(@NotNull HttpUrl serverUrl, @NotNull Call.Factory httpCallFactory, @Nullable HttpCachePolicy.Policy cachePolicy, boolean prefetch, @NotNull CustomScalarAdapters customScalarAdapters, @NotNull ApolloLogger logger) {
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        Intrinsics.checkNotNullParameter((Object)httpCallFactory, (String)"httpCallFactory");
        Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.serverUrl = serverUrl;
        this.httpCallFactory = httpCallFactory;
        this.cachePolicy = cachePolicy;
        this.prefetch = prefetch;
        this.customScalarAdapters = customScalarAdapters;
        this.logger = logger;
        this.httpCallRef = new AtomicReference();
        String string = this.serverUrl.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serverUrl.toString()");
        this.composer = new DefaultHttpRequestComposer(string, null, 2, null);
    }

    public final boolean getPrefetch() {
        return this.prefetch;
    }

    @NotNull
    public final CustomScalarAdapters getCustomScalarAdapters() {
        return this.customScalarAdapters;
    }

    @NotNull
    public final ApolloLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public final AtomicReference<Call> getHttpCallRef() {
        return this.httpCallRef;
    }

    public final void setHttpCallRef(@NotNull AtomicReference<Call> atomicReference) {
        Intrinsics.checkNotNullParameter(atomicReference, (String)"<set-?>");
        this.httpCallRef = atomicReference;
    }

    public final boolean getDisposed() {
        return this.disposed;
    }

    public final void setDisposed(boolean bl) {
        this.disposed = bl;
    }

    @NotNull
    public final DefaultHttpRequestComposer getComposer() {
        return this.composer;
    }

    @Override
    public void interceptAsync(@NotNull ApolloInterceptor.InterceptorRequest request, @NotNull ApolloInterceptorChain chain, @NotNull Executor dispatcher, @NotNull ApolloInterceptor.CallBack callBack) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
        dispatcher.execute(() -> ApolloServerInterceptor.interceptAsync$lambda-0(this, request, callBack));
    }

    @Override
    public void dispose() {
        this.disposed = true;
        Call httpCall = this.httpCallRef.getAndSet(null);
        Call call = httpCall;
        if (call != null) {
            call.cancel();
        }
    }

    public final void executeHttpCall(@NotNull ApolloInterceptor.InterceptorRequest request, @NotNull ApolloInterceptor.CallBack callBack) {
        Call previousCall;
        Call call;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
        if (this.disposed) {
            return;
        }
        callBack.onFetch(ApolloInterceptor.FetchSourceType.NETWORK);
        Call httpCall = null;
        try {
            call = request.getUseHttpGetMethodForQueries() && request.getOperation() instanceof Query ? this.httpGetCall(request.getOperation(), request.getCacheHeaders(), request.getRequestHeaders(), request.getSendQueryDocument(), request.getAutoPersistQueries()) : this.httpPostCall(request.getOperation(), request.getCacheHeaders(), request.getRequestHeaders(), request.getSendQueryDocument(), request.getAutoPersistQueries());
        }
        catch (IOException e) {
            Object[] objectArray = new Object[]{request.getOperation().name()};
            this.logger.e((Throwable)e, "Failed to prepare http call for operation %s", objectArray);
            callBack.onFailure((ApolloException)new ApolloNetworkException("Failed to prepare http call", (Throwable)e));
            return;
        }
        httpCall = call;
        Call call2 = previousCall = this.httpCallRef.getAndSet(httpCall);
        if (call2 != null) {
            call2.cancel();
        }
        if (httpCall.isCanceled() || this.disposed) {
            this.httpCallRef.compareAndSet(httpCall, null);
            return;
        }
        httpCall.enqueue(new Callback(this, httpCall, request, callBack){
            final /* synthetic */ ApolloServerInterceptor this$0;
            final /* synthetic */ Call $httpCall;
            final /* synthetic */ ApolloInterceptor.InterceptorRequest $request;
            final /* synthetic */ ApolloInterceptor.CallBack $callBack;
            {
                this.this$0 = $receiver;
                this.$httpCall = $httpCall;
                this.$request = $request;
                this.$callBack = $callBack;
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (this.this$0.getDisposed()) {
                    return;
                }
                if (this.this$0.getHttpCallRef().compareAndSet(this.$httpCall, null)) {
                    Object[] objectArray = new Object[]{this.$request.getOperation().name()};
                    this.this$0.getLogger().e((Throwable)e, "Failed to execute http call for operation %s", objectArray);
                    this.$callBack.onFailure((ApolloException)new ApolloNetworkException("Failed to execute http call", (Throwable)e));
                }
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (this.this$0.getDisposed()) {
                    return;
                }
                if (this.this$0.getHttpCallRef().compareAndSet(this.$httpCall, null)) {
                    this.$callBack.onResponse(new ApolloInterceptor.InterceptorResponse(response, null, 2, null));
                    this.$callBack.onCompleted();
                }
            }
        });
    }

    @NotNull
    public final Call httpGetCall(@NotNull Operation<?> operation, @NotNull CacheHeaders cacheHeaders, @NotNull RequestHeaders requestHeaders, boolean writeQueryDocument, boolean autoPersistQueries) throws IOException {
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        Intrinsics.checkNotNullParameter((Object)requestHeaders, (String)"requestHeaders");
        Request.Builder requestBuilder = new Request.Builder().url(Companion.httpGetUrl(this.serverUrl, operation, this.customScalarAdapters, writeQueryDocument, autoPersistQueries)).get();
        Intrinsics.checkNotNullExpressionValue((Object)requestBuilder, (String)"requestBuilder");
        this.decorateRequest(requestBuilder, operation, cacheHeaders, requestHeaders);
        Call call = this.httpCallFactory.newCall(requestBuilder.build());
        Intrinsics.checkNotNullExpressionValue((Object)call, (String)"httpCallFactory.newCall(requestBuilder.build())");
        return call;
    }

    @NotNull
    public final Call httpPostCall(@NotNull Operation<?> operation, @NotNull CacheHeaders cacheHeaders, @NotNull RequestHeaders requestHeaders, boolean writeQueryDocument, boolean autoPersistQueries) throws IOException {
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        Intrinsics.checkNotNullParameter((Object)requestHeaders, (String)"requestHeaders");
        HttpBody httpBody = this.composer.compose(new ApolloRequest(operation, null, null, 6, null).withExecutionContext((ExecutionContext)this.customScalarAdapters).withExecutionContext((ExecutionContext)new HttpRequestComposerParams(HttpMethod.Post, autoPersistQueries, writeQueryDocument, MapsKt.emptyMap()))).getBody();
        Intrinsics.checkNotNull((Object)httpBody);
        HttpBody body = httpBody;
        RequestBody requestBody2 = new RequestBody(body){
            final /* synthetic */ HttpBody $body;
            {
                this.$body = $body;
            }

            @Nullable
            public MediaType contentType() {
                return MediaType.parse((String)this.$body.getContentType());
            }

            public long contentLength() {
                return this.$body.getContentLength();
            }

            public void writeTo(@NotNull BufferedSink sink) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                this.$body.writeTo(sink);
            }
        };
        Request.Builder requestBuilder = new Request.Builder().url(this.serverUrl).post(requestBody2);
        Intrinsics.checkNotNullExpressionValue((Object)requestBuilder, (String)"requestBuilder");
        this.decorateRequest(requestBuilder, operation, cacheHeaders, requestHeaders);
        Call call = this.httpCallFactory.newCall(requestBuilder.build());
        Intrinsics.checkNotNullExpressionValue((Object)call, (String)"httpCallFactory.newCall(requestBuilder.build())");
        return call;
    }

    public final void decorateRequest(@NotNull Request.Builder requestBuilder, @NotNull Operation<?> operation, @NotNull CacheHeaders cacheHeaders, @NotNull RequestHeaders requestHeaders) throws IOException {
        Intrinsics.checkNotNullParameter((Object)requestBuilder, (String)"requestBuilder");
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        Intrinsics.checkNotNullParameter((Object)requestHeaders, (String)"requestHeaders");
        requestBuilder.header(HEADER_ACCEPT_TYPE, JSON_CONTENT_TYPE).header(HEADER_CONTENT_TYPE, JSON_CONTENT_TYPE).header(HEADER_APOLLO_OPERATION_ID, operation.id()).header(HEADER_APOLLO_OPERATION_NAME, operation.name()).tag((Object)operation.id());
        for (String header : requestHeaders.headers()) {
            String value = requestHeaders.headerValue(header);
            requestBuilder.header(header, value);
        }
        if (this.cachePolicy != null) {
            boolean skipCacheHttpResponse = StringsKt.equals((String)"true", (String)cacheHeaders.headerValue("do-not-store"), (boolean)true);
            String cacheKey = Companion.cacheKey(operation, this.customScalarAdapters);
            requestBuilder.header("X-APOLLO-CACHE-KEY", cacheKey).header("X-APOLLO-CACHE-FETCH-STRATEGY", this.cachePolicy.fetchStrategy.name()).header("X-APOLLO-EXPIRE-TIMEOUT", String.valueOf(this.cachePolicy.expireTimeoutMs())).header("X-APOLLO-EXPIRE-AFTER-READ", Boolean.toString(this.cachePolicy.expireAfterRead)).header("X-APOLLO-PREFETCH", Boolean.toString(this.prefetch)).header("X-APOLLO-CACHE-DO-NOT-STORE", Boolean.toString(skipCacheHttpResponse));
        }
    }

    private static final void interceptAsync$lambda-0(ApolloServerInterceptor this$0, ApolloInterceptor.InterceptorRequest $request, ApolloInterceptor.CallBack $callBack) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Intrinsics.checkNotNullParameter((Object)$callBack, (String)"$callBack");
        this$0.executeHttpCall($request, $callBack);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eJ$\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u001a\u0010\u0012\u001a\u00020\u00042\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J4\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/apollographql/apollo3/internal/interceptor/ApolloServerInterceptor$Companion;", "", "()V", "HEADER_ACCEPT_TYPE", "", "HEADER_APOLLO_OPERATION_ID", "HEADER_APOLLO_OPERATION_NAME", "HEADER_CONTENT_TYPE", "JSON_CONTENT_TYPE", "addExtensionsUrlQueryParameter", "", "urlBuilder", "Lokhttp3/HttpUrl$Builder;", "operation", "Lcom/apollographql/apollo3/api/Operation;", "addVariablesUrlQueryParameter", "customScalarAdapters", "Lcom/apollographql/apollo3/api/CustomScalarAdapters;", "cacheKey", "httpGetUrl", "Lokhttp3/HttpUrl;", "serverUrl", "writeQueryDocument", "", "autoPersistQueries", "apollo-runtime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String cacheKey(@NotNull Operation<?> operation, @NotNull CustomScalarAdapters customScalarAdapters) throws IOException {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
            return DefaultHttpRequestComposer.Companion.buildParamsMap(operation, customScalarAdapters, true, true).md5().hex();
        }

        @NotNull
        public final HttpUrl httpGetUrl(@NotNull HttpUrl serverUrl, @NotNull Operation<?> operation, @Nullable CustomScalarAdapters customScalarAdapters, boolean writeQueryDocument, boolean autoPersistQueries) throws IOException {
            Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            HttpUrl.Builder urlBuilder = serverUrl.newBuilder();
            if (!autoPersistQueries || writeQueryDocument) {
                urlBuilder.addQueryParameter("query", operation.document());
            }
            Intrinsics.checkNotNullExpressionValue((Object)urlBuilder, (String)"urlBuilder");
            this.addVariablesUrlQueryParameter(urlBuilder, operation, customScalarAdapters);
            urlBuilder.addQueryParameter("operationName", operation.name());
            if (autoPersistQueries) {
                this.addExtensionsUrlQueryParameter(urlBuilder, operation);
            }
            HttpUrl httpUrl = urlBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)httpUrl, (String)"urlBuilder.build()");
            return httpUrl;
        }

        public final void addVariablesUrlQueryParameter(@NotNull HttpUrl.Builder urlBuilder, @NotNull Operation<?> operation, @Nullable CustomScalarAdapters customScalarAdapters) throws IOException {
            Intrinsics.checkNotNullParameter((Object)urlBuilder, (String)"urlBuilder");
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Buffer buffer = new Buffer();
            BufferedSinkJsonWriter jsonWriter = new BufferedSinkJsonWriter((BufferedSink)buffer);
            jsonWriter.beginObject();
            JsonWriter jsonWriter2 = (JsonWriter)jsonWriter;
            Intrinsics.checkNotNull((Object)customScalarAdapters);
            operation.serializeVariables(jsonWriter2, customScalarAdapters);
            jsonWriter.endObject();
            jsonWriter.close();
            urlBuilder.addQueryParameter("variables", buffer.readUtf8());
        }

        public final void addExtensionsUrlQueryParameter(@NotNull HttpUrl.Builder urlBuilder, @NotNull Operation<?> operation) throws IOException {
            Intrinsics.checkNotNullParameter((Object)urlBuilder, (String)"urlBuilder");
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Buffer buffer = new Buffer();
            BufferedSinkJsonWriter jsonWriter = new BufferedSinkJsonWriter((BufferedSink)buffer);
            jsonWriter.beginObject();
            jsonWriter.name("persistedQuery").beginObject().name("version").value(1).name("sha256Hash").value(operation.id()).endObject();
            jsonWriter.endObject();
            jsonWriter.close();
            urlBuilder.addQueryParameter("extensions", buffer.readUtf8());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

