package com.apollographql.apollo3.cache.normalized.sql.`internal`.json.apollonormalizedcachesqlite

import com.apollographql.apollo3.cache.normalized.sql.`internal`.json.JsonDatabase
import com.apollographql.apollo3.cache.normalized.sql.`internal`.json.JsonQueries
import com.apollographql.apollo3.cache.normalized.sql.`internal`.json.RecordForKey
import com.apollographql.apollo3.cache.normalized.sql.`internal`.json.Records
import com.apollographql.apollo3.cache.normalized.sql.`internal`.json.RecordsForKeys
import com.squareup.sqldelight.Query
import com.squareup.sqldelight.TransacterImpl
import com.squareup.sqldelight.`internal`.copyOnWriteList
import com.squareup.sqldelight.db.SqlCursor
import com.squareup.sqldelight.db.SqlDriver
import kotlin.Any
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Unit
import kotlin.collections.Collection
import kotlin.collections.MutableList
import kotlin.reflect.KClass

internal val KClass<JsonDatabase>.schema: SqlDriver.Schema
  get() = JsonDatabaseImpl.Schema

internal fun KClass<JsonDatabase>.newInstance(driver: SqlDriver): JsonDatabase =
    JsonDatabaseImpl(driver)

private class JsonDatabaseImpl(
  driver: SqlDriver
) : TransacterImpl(driver), JsonDatabase {
  public override val jsonQueries: JsonQueriesImpl = JsonQueriesImpl(this, driver)

  public object Schema : SqlDriver.Schema {
    public override val version: Int
      get() = 1

    public override fun create(driver: SqlDriver): Unit {
      driver.execute(null, """
          |CREATE TABLE records (
          |  _id INTEGER PRIMARY KEY AUTOINCREMENT,
          |  key TEXT NOT NULL,
          |  record TEXT NOT NULL
          |)
          """.trimMargin(), 0)
      driver.execute(null, "CREATE INDEX idx_records_key ON records(key)", 0)
    }

    public override fun migrate(
      driver: SqlDriver,
      oldVersion: Int,
      newVersion: Int
    ): Unit {
    }
  }
}

private class JsonQueriesImpl(
  private val database: JsonDatabaseImpl,
  private val driver: SqlDriver
) : TransacterImpl(driver), JsonQueries {
  internal val recordForKey: MutableList<Query<*>> = copyOnWriteList()

  internal val recordsForKeys: MutableList<Query<*>> = copyOnWriteList()

  internal val selectRecords: MutableList<Query<*>> = copyOnWriteList()

  internal val changes: MutableList<Query<*>> = copyOnWriteList()

  public override fun <T : Any> recordForKey(key: String, mapper: (key: String,
      record: String) -> T): Query<T> = RecordForKeyQuery(key) { cursor ->
    mapper(
      cursor.getString(0)!!,
      cursor.getString(1)!!
    )
  }

  public override fun recordForKey(key: String): Query<RecordForKey> = recordForKey(key) { key_,
      record ->
    RecordForKey(
      key_,
      record
    )
  }

  public override fun <T : Any> recordsForKeys(key: Collection<String>, mapper: (key: String,
      record: String) -> T): Query<T> = RecordsForKeysQuery(key) { cursor ->
    mapper(
      cursor.getString(0)!!,
      cursor.getString(1)!!
    )
  }

  public override fun recordsForKeys(key: Collection<String>): Query<RecordsForKeys> =
      recordsForKeys(key) { key_, record ->
    RecordsForKeys(
      key_,
      record
    )
  }

  public override fun <T : Any> selectRecords(mapper: (
    _id: Long,
    key: String,
    record: String
  ) -> T): Query<T> = Query(-316451569, selectRecords, driver, "json.sq", "selectRecords",
      "SELECT * FROM records") { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2)!!
    )
  }

  public override fun selectRecords(): Query<Records> = selectRecords { _id, key, record ->
    Records(
      _id,
      key,
      record
    )
  }

  public override fun changes(): Query<Long> = Query(-1095725844, changes, driver, "json.sq",
      "changes", "SELECT changes()") { cursor ->
    cursor.getLong(0)!!
  }

  public override fun insert(key: String, record: String): Unit {
    driver.execute(1943613296, """INSERT INTO records (key, record) VALUES (?,?)""", 2) {
      bindString(1, key)
      bindString(2, record)
    }
    notifyQueries(1943613296, {database.jsonQueries.recordForKey +
        database.jsonQueries.selectRecords + database.jsonQueries.recordsForKeys})
  }

  public override fun update(record: String, key: String): Unit {
    driver.execute(-2006407808, """UPDATE records SET record=? WHERE key=?""", 2) {
      bindString(1, record)
      bindString(2, key)
    }
    notifyQueries(-2006407808, {database.jsonQueries.recordForKey +
        database.jsonQueries.selectRecords + database.jsonQueries.recordsForKeys})
  }

  public override fun delete(key: String): Unit {
    driver.execute(1791947362, """DELETE FROM records WHERE key=?""", 1) {
      bindString(1, key)
    }
    notifyQueries(1791947362, {database.jsonQueries.recordForKey +
        database.jsonQueries.selectRecords + database.jsonQueries.recordsForKeys})
  }

  public override fun deleteRecords(key: Collection<String>): Unit {
    val keyIndexes = createArguments(count = key.size)
    driver.execute(null, """DELETE FROM records WHERE key IN $keyIndexes""", key.size) {
      key.forEachIndexed { index, key_ ->
          bindString(index + 1, key_)
          }
    }
    notifyQueries(-1244679808, {database.jsonQueries.recordForKey +
        database.jsonQueries.selectRecords + database.jsonQueries.recordsForKeys})
  }

  public override fun deleteRecordsWithKeyMatching(`value`: String, value_: String): Unit {
    driver.execute(1083807030, """DELETE FROM records WHERE key LIKE ? ESCAPE ?""", 2) {
      bindString(1, value)
      bindString(2, value_)
    }
    notifyQueries(1083807030, {database.jsonQueries.recordForKey +
        database.jsonQueries.selectRecords + database.jsonQueries.recordsForKeys})
  }

  public override fun deleteAll(): Unit {
    driver.execute(1755405279, """DELETE FROM records""", 0)
    notifyQueries(1755405279, {database.jsonQueries.recordForKey +
        database.jsonQueries.selectRecords + database.jsonQueries.recordsForKeys})
  }

  private inner class RecordForKeyQuery<out T : Any>(
    public val key: String,
    mapper: (SqlCursor) -> T
  ) : Query<T>(recordForKey, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(-1788979202,
        """SELECT key, record FROM records WHERE key=?""", 1) {
      bindString(1, key)
    }

    public override fun toString(): String = "json.sq:recordForKey"
  }

  private inner class RecordsForKeysQuery<out T : Any>(
    public val key: Collection<String>,
    mapper: (SqlCursor) -> T
  ) : Query<T>(recordsForKeys, mapper) {
    public override fun execute(): SqlCursor {
      val keyIndexes = createArguments(count = key.size)
      return driver.executeQuery(null,
          """SELECT key, record FROM records WHERE key IN $keyIndexes""", key.size) {
        key.forEachIndexed { index, key_ ->
            bindString(index + 1, key_)
            }
      }
    }

    public override fun toString(): String = "json.sq:recordsForKeys"
  }
}
