package com.apollographql.apollo3.cache.`internal`.blob

import com.squareup.sqldelight.Query
import com.squareup.sqldelight.Transacter
import kotlin.Any
import kotlin.ByteArray
import kotlin.Long
import kotlin.String
import kotlin.Unit
import kotlin.collections.Collection

public interface BlobQueries : Transacter {
  public fun <T : Any> recordForKey(key: String, mapper: (key: String, blob: ByteArray) -> T):
      Query<T>

  public fun recordForKey(key: String): Query<Blobs>

  public fun <T : Any> recordsForKeys(key: Collection<String>, mapper: (key: String,
      blob: ByteArray) -> T): Query<T>

  public fun recordsForKeys(key: Collection<String>): Query<Blobs>

  public fun <T : Any> selectRecords(mapper: (key: String, blob: ByteArray) -> T): Query<T>

  public fun selectRecords(): Query<Blobs>

  public fun changes(): Query<Long>

  public fun insert(key: String, blob: ByteArray): Unit

  public fun update(blob: ByteArray, key: String): Unit

  public fun delete(key: String): Unit

  public fun deleteRecords(key: Collection<String>): Unit

  public fun deleteRecordsWithKeyMatching(`value`: String, value_: String): Unit

  public fun deleteAll(): Unit
}
