/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.normalized.sql.internal;

import com.apollographql.apollo3.cache.internal.blob.BlobDatabase;
import com.apollographql.apollo3.cache.internal.json.JsonDatabase;
import com.apollographql.apollo3.cache.normalized.sql.internal.BlobRecordDatabase;
import com.apollographql.apollo3.cache.normalized.sql.internal.FactoryImplementationsKt;
import com.apollographql.apollo3.cache.normalized.sql.internal.JsonRecordDatabase;
import com.apollographql.apollo3.cache.normalized.sql.internal.RecordDatabase;
import com.apollographql.apollo3.exception.ApolloExceptionHandlerKt;
import com.squareup.sqldelight.db.SqlCursor;
import com.squareup.sqldelight.db.SqlDriver;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\b"}, d2={"createRecordDatabase", "Lcom/apollographql/apollo3/cache/normalized/sql/internal/RecordDatabase;", "driver", "Lcom/squareup/sqldelight/db/SqlDriver;", "withDates", "", "getSchema", "Lcom/squareup/sqldelight/db/SqlDriver$Schema;", "apollo-normalized-cache-sqlite"})
public final class FactoryHelpersKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final RecordDatabase createRecordDatabase(@NotNull SqlDriver driver, boolean withDates) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        FactoryImplementationsKt.maybeCreateOrMigrateSchema(driver, FactoryHelpersKt.getSchema(withDates));
        List tableNames = new ArrayList();
        try {
            Closeable $this$use$iv = (Closeable)SqlDriver.DefaultImpls.executeQuery$default((SqlDriver)driver, null, (String)"SELECT name FROM sqlite_master WHERE type='table' ORDER BY name;", (int)0, null, (int)8, null);
            boolean $i$f$use = false;
            Closeable closeable = $this$use$iv;
            Throwable throwable = null;
            try {
                SqlCursor cursor = (SqlCursor)closeable;
                boolean bl = false;
                while (cursor.next()) {
                    String string = cursor.getString(0);
                    if (string == null) {
                        string = "";
                    }
                    tableNames.add(string);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            ApolloExceptionHandlerKt.getApolloExceptionHandler().invoke((Object)new Exception("An exception occurred while looking up the table names", e));
        }
        String expectedTableName = withDates ? "blobs" : "records";
        if (!(tableNames.isEmpty() || tableNames.contains(expectedTableName))) {
            boolean bl = false;
            String string = "Apollo: Cannot find the '" + expectedTableName + "' table, did you change the 'withDates' parameter? (found '" + tableNames + "' instead)";
            throw new IllegalStateException(string.toString());
        }
        return withDates ? (RecordDatabase)new BlobRecordDatabase(BlobDatabase.Companion.invoke(driver).getBlobQueries()) : (RecordDatabase)new JsonRecordDatabase(JsonDatabase.Companion.invoke(driver).getJsonQueries());
    }

    @NotNull
    public static final SqlDriver.Schema getSchema(boolean withDates) {
        return withDates ? BlobDatabase.Companion.getSchema() : JsonDatabase.Companion.getSchema();
    }
}

