/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.normalized.sql;

import com.apollographql.apollo3.annotations.ApolloExperimental;
import com.apollographql.apollo3.cache.normalized.api.CacheHeaders;
import com.apollographql.apollo3.cache.normalized.api.CacheKey;
import com.apollographql.apollo3.cache.normalized.api.NormalizedCache;
import com.apollographql.apollo3.cache.normalized.api.Record;
import com.apollographql.apollo3.cache.normalized.api.RecordMerger;
import com.apollographql.apollo3.cache.normalized.sql.internal.RecordDatabase;
import com.apollographql.apollo3.exception.ApolloExceptionHandlerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J$\u0010\u0007\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b0\bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\rH\u0002J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0013H\u0002J-\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002\u00a2\u0006\u0002\u0010\u001bJ3\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u00152\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00132\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010 \u001a\u00020!H\u0016J$\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00132\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010 \u001a\u00020!H\u0016J)\u0010#\u001a\u0002H$\"\u0004\b\u0000\u0010$2\u0006\u0010%\u001a\u00020\r2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H$0'H\u0002\u00a2\u0006\u0002\u0010(J&\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J,\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0\u00152\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00132\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u0018\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u000f\u001a\u00020\rH\u0016J\u0010\u0010*\u001a\u00020-2\u0006\u0010.\u001a\u00020\nH\u0016J\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020!H\u0002\u00a2\u0006\u0002\u0010/J\u001b\u00100\u001a\u00020\u000b*\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002\u00a2\u0006\u0002\u00101R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/apollographql/apollo3/cache/normalized/sql/SqlNormalizedCache;", "Lcom/apollographql/apollo3/cache/normalized/api/NormalizedCache;", "recordDatabase", "Lcom/apollographql/apollo3/cache/normalized/sql/internal/RecordDatabase;", "(Lcom/apollographql/apollo3/cache/normalized/sql/internal/RecordDatabase;)V", "clearAll", "", "dump", "", "Lkotlin/reflect/KClass;", "", "Lcom/apollographql/apollo3/cache/normalized/api/Record;", "internalDeleteRecord", "", "key", "cascade", "internalGetRecords", "", "keys", "", "internalUpdateRecord", "", "record", "recordMerger", "Lcom/apollographql/apollo3/cache/normalized/api/RecordMerger;", "date", "", "(Lcom/apollographql/apollo3/cache/normalized/api/Record;Lcom/apollographql/apollo3/cache/normalized/api/RecordMerger;Ljava/lang/Long;)Ljava/util/Set;", "internalUpdateRecords", "records", "(Ljava/util/Collection;Lcom/apollographql/apollo3/cache/normalized/api/RecordMerger;Ljava/lang/Long;)Ljava/util/Set;", "loadRecord", "cacheHeaders", "Lcom/apollographql/apollo3/cache/normalized/api/CacheHeaders;", "loadRecords", "maybeTransaction", "T", "condition", "block", "Lkotlin/Function0;", "(ZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "merge", "remove", "cacheKey", "Lcom/apollographql/apollo3/cache/normalized/api/CacheKey;", "", "pattern", "(Lcom/apollographql/apollo3/cache/normalized/api/CacheHeaders;)Ljava/lang/Long;", "withDate", "(Lcom/apollographql/apollo3/cache/normalized/api/Record;Ljava/lang/Long;)Lcom/apollographql/apollo3/cache/normalized/api/Record;", "apollo-normalized-cache-sqlite-incubating"})
@SourceDebugExtension(value={"SMAP\nSqlNormalizedCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlNormalizedCache.kt\ncom/apollographql/apollo3/cache/normalized/sql/SqlNormalizedCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,211:1\n1202#2,2:212\n1230#2,4:214\n1863#2,2:218\n1246#2,4:222\n1368#2:226\n1454#2,5:227\n462#3:220\n412#3:221\n*S KotlinDebug\n*F\n+ 1 SqlNormalizedCache.kt\ncom/apollographql/apollo3/cache/normalized/sql/SqlNormalizedCache\n*L\n118#1:212,2\n118#1:214,4\n128#1:218,2\n176#1:222,4\n206#1:226\n206#1:227,5\n176#1:220\n176#1:221\n*E\n"})
public final class SqlNormalizedCache
implements NormalizedCache {
    @NotNull
    private final RecordDatabase recordDatabase;

    public SqlNormalizedCache(@NotNull RecordDatabase recordDatabase) {
        Intrinsics.checkNotNullParameter((Object)recordDatabase, (String)"recordDatabase");
        this.recordDatabase = recordDatabase;
    }

    private final <T> T maybeTransaction(boolean condition, Function0<? extends T> block) {
        return (T)(condition ? RecordDatabase.transaction$default(this.recordDatabase, false, new Function0<T>(block){
            final /* synthetic */ Function0<T> $block;
            {
                this.$block = $block;
                super(0);
            }

            public final T invoke() {
                return (T)this.$block.invoke();
            }
        }, 1, null) : block.invoke());
    }

    @Nullable
    public Record loadRecord(@NotNull String key, @NotNull CacheHeaders cacheHeaders) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        boolean evictAfterRead = cacheHeaders.hasHeader("evict-after-read");
        return (Record)this.maybeTransaction(evictAfterRead, (Function0)new Function0<Record>(this, key, evictAfterRead){
            final /* synthetic */ SqlNormalizedCache this$0;
            final /* synthetic */ String $key;
            final /* synthetic */ boolean $evictAfterRead;
            {
                this.this$0 = $receiver;
                this.$key = $key;
                this.$evictAfterRead = $evictAfterRead;
                super(0);
            }

            public final Record invoke() {
                Record record;
                Record record2;
                try {
                    record2 = SqlNormalizedCache.access$getRecordDatabase$p(this.this$0).select(this.$key);
                }
                catch (Exception e) {
                    ApolloExceptionHandlerKt.getApolloExceptionHandler().invoke((Object)new Exception("Unable to read a record from the database", e));
                    record2 = null;
                }
                Record record3 = record2;
                if (record3 != null) {
                    record2 = record3;
                    boolean bl = this.$evictAfterRead;
                    SqlNormalizedCache sqlNormalizedCache = this.this$0;
                    String string = this.$key;
                    Record it = record2;
                    boolean bl2 = false;
                    if (bl) {
                        SqlNormalizedCache.access$getRecordDatabase$p(sqlNormalizedCache).delete(string);
                    }
                    record = record2;
                } else {
                    record = null;
                }
                return record;
            }
        });
    }

    @NotNull
    public Collection<Record> loadRecords(@NotNull Collection<String> keys, @NotNull CacheHeaders cacheHeaders) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        boolean evictAfterRead = cacheHeaders.hasHeader("evict-after-read");
        return (Collection)this.maybeTransaction(evictAfterRead, (Function0)new Function0<List<? extends Record>>(this, keys, evictAfterRead){
            final /* synthetic */ SqlNormalizedCache this$0;
            final /* synthetic */ Collection<String> $keys;
            final /* synthetic */ boolean $evictAfterRead;
            {
                this.this$0 = $receiver;
                this.$keys = $keys;
                this.$evictAfterRead = $evictAfterRead;
                super(0);
            }

            public final List<Record> invoke() {
                List list;
                try {
                    list = SqlNormalizedCache.access$internalGetRecords(this.this$0, this.$keys);
                }
                catch (Exception e) {
                    ApolloExceptionHandlerKt.getApolloExceptionHandler().invoke((Object)new Exception("Unable to read records from the database", e));
                    list = CollectionsKt.emptyList();
                }
                boolean bl = this.$evictAfterRead;
                SqlNormalizedCache sqlNormalizedCache = this.this$0;
                List it = list;
                boolean bl2 = false;
                if (bl) {
                    Iterable $this$forEach$iv = it;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Record record = (Record)element$iv;
                        boolean bl3 = false;
                        SqlNormalizedCache.access$getRecordDatabase$p(sqlNormalizedCache).delete(record.getKey());
                    }
                }
                return list;
            }
        });
    }

    public void clearAll() {
        this.recordDatabase.deleteAll();
    }

    public boolean remove(@NotNull CacheKey cacheKey, boolean cascade) {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        return (Boolean)RecordDatabase.transaction$default(this.recordDatabase, false, (Function0)new Function0<Boolean>(this, cacheKey, cascade){
            final /* synthetic */ SqlNormalizedCache this$0;
            final /* synthetic */ CacheKey $cacheKey;
            final /* synthetic */ boolean $cascade;
            {
                this.this$0 = $receiver;
                this.$cacheKey = $cacheKey;
                this.$cascade = $cascade;
                super(0);
            }

            public final Boolean invoke() {
                return SqlNormalizedCache.access$internalDeleteRecord(this.this$0, this.$cacheKey.getKey(), this.$cascade);
            }
        }, 1, null);
    }

    public int remove(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return ((Number)RecordDatabase.transaction$default(this.recordDatabase, false, (Function0)new Function0<Integer>(this, pattern){
            final /* synthetic */ SqlNormalizedCache this$0;
            final /* synthetic */ String $pattern;
            {
                this.this$0 = $receiver;
                this.$pattern = $pattern;
                super(0);
            }

            public final Integer invoke() {
                SqlNormalizedCache.access$getRecordDatabase$p(this.this$0).deleteMatching(this.$pattern);
                return (int)SqlNormalizedCache.access$getRecordDatabase$p(this.this$0).changes();
            }
        }, 1, null)).intValue();
    }

    private final Long date(CacheHeaders $this$date) {
        String string = $this$date.headerValue("apollo-date");
        return string != null ? Long.valueOf(Long.parseLong(string)) : null;
    }

    @ApolloExperimental
    @NotNull
    public Set<String> merge(@NotNull Record record, @NotNull CacheHeaders cacheHeaders, @NotNull RecordMerger recordMerger) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        Intrinsics.checkNotNullParameter((Object)recordMerger, (String)"recordMerger");
        if (cacheHeaders.hasHeader("do-not-store")) {
            return SetsKt.emptySet();
        }
        try {
            set = this.internalUpdateRecord(record, recordMerger, this.date(cacheHeaders));
        }
        catch (Exception e) {
            ApolloExceptionHandlerKt.getApolloExceptionHandler().invoke((Object)new Exception("Unable to merge a record from the database", e));
            set = SetsKt.emptySet();
        }
        return set;
    }

    @ApolloExperimental
    @NotNull
    public Set<String> merge(@NotNull Collection<Record> records, @NotNull CacheHeaders cacheHeaders, @NotNull RecordMerger recordMerger) {
        Set set;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        Intrinsics.checkNotNullParameter((Object)recordMerger, (String)"recordMerger");
        if (cacheHeaders.hasHeader("do-not-store")) {
            return SetsKt.emptySet();
        }
        try {
            set = this.internalUpdateRecords(records, recordMerger, this.date(cacheHeaders));
        }
        catch (Exception e) {
            ApolloExceptionHandlerKt.getApolloExceptionHandler().invoke((Object)new Exception("Unable to merge records from the database", e));
            set = SetsKt.emptySet();
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<KClass<?>, Map<String, Record>> dump() {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Iterable iterable = this.recordDatabase.selectAll();
        KClass kClass = Reflection.getOrCreateKotlinClass(this.getClass());
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var4_5 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Record record = (Record)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getKey(), element$iv$iv);
        }
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)kClass, (Object)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean internalDeleteRecord(String key, boolean cascade) {
        List list;
        Record record;
        if (cascade && (record = this.recordDatabase.select(key)) != null && (list = record.referencedFields()) != null) {
            void $this$forEach$iv;
            Iterable iterable = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CacheKey it = (CacheKey)element$iv;
                boolean bl = false;
                this.internalDeleteRecord(it.getKey(), true);
            }
        }
        this.recordDatabase.delete(key);
        return this.recordDatabase.changes() > 0L;
    }

    private final Set<String> internalUpdateRecords(Collection<Record> records, RecordMerger recordMerger, Long date) {
        Ref.ObjectRef updatedRecordKeys = new Ref.ObjectRef();
        updatedRecordKeys.element = SetsKt.emptySet();
        RecordDatabase.transaction$default(this.recordDatabase, false, (Function0)new Function0<Unit>(this, records, (Ref.ObjectRef<Set<String>>)updatedRecordKeys, date, recordMerger){
            final /* synthetic */ SqlNormalizedCache this$0;
            final /* synthetic */ Collection<Record> $records;
            final /* synthetic */ Ref.ObjectRef<Set<String>> $updatedRecordKeys;
            final /* synthetic */ Long $date;
            final /* synthetic */ RecordMerger $recordMerger;
            {
                this.this$0 = $receiver;
                this.$records = $records;
                this.$updatedRecordKeys = $updatedRecordKeys;
                this.$date = $date;
                this.$recordMerger = $recordMerger;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                void $this$associateByTo$iv$iv;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = this.$records;
                Ref.ObjectRef<Set<String>> objectRef = this.this$0;
                boolean $i$f$map = false;
                void var4_5 = $this$map$iv;
                Iterable<E> destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Record record = (Record)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getKey());
                }
                Iterable $this$associateBy$iv = SqlNormalizedCache.access$internalGetRecords((SqlNormalizedCache)objectRef, (List)destination$iv$iv);
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                destination$iv$iv = $this$associateBy$iv;
                Map destination$iv$iv2 = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateByTo22 = false;
                for (E element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    Record bl = (Record)element$iv$iv;
                    objectRef = destination$iv$iv2;
                    boolean bl2 = false;
                    objectRef.put(it.getKey(), element$iv$iv);
                }
                Map oldRecords = destination$iv$iv2;
                $this$associateBy$iv = this.$records;
                SqlNormalizedCache sqlNormalizedCache = this.this$0;
                Long l = this.$date;
                RecordMerger recordMerger = this.$recordMerger;
                objectRef = this.$updatedRecordKeys;
                boolean $i$f$flatMap = false;
                void $i$f$associateByTo22 = $this$flatMap$iv;
                Collection destination$iv$iv3 = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    Set set;
                    Record record = (Record)element$iv$iv;
                    boolean bl = false;
                    Record oldRecord = (Record)oldRecords.get(record.getKey());
                    if (oldRecord == null) {
                        SqlNormalizedCache.access$getRecordDatabase$p(sqlNormalizedCache).insert(SqlNormalizedCache.access$withDate(sqlNormalizedCache, record, l));
                        set = record.fieldKeys();
                    } else {
                        Pair pair = recordMerger.merge(oldRecord, record, l);
                        Record mergedRecord = (Record)pair.component1();
                        Set changedKeys = (Set)pair.component2();
                        if (!((Map)mergedRecord).isEmpty()) {
                            SqlNormalizedCache.access$getRecordDatabase$p(sqlNormalizedCache).update(mergedRecord);
                        }
                        set = changedKeys;
                    }
                    Iterable list$iv$iv = set;
                    CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
                }
                objectRef.element = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
            }
        }, 1, null);
        return (Set)updatedRecordKeys.element;
    }

    /*
     * WARNING - void declaration
     */
    private final Record withDate(Record $this$withDate, Long date) {
        Map map;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        if (date == null) {
            return $this$withDate;
        }
        Map map2 = $this$withDate.getFields();
        UUID uUID = $this$withDate.getMutationId();
        Map map3 = $this$withDate.getFields();
        String string = $this$withDate.getKey();
        boolean $i$f$mapValues = false;
        void var5_8 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map4 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map = map4;
            boolean bl2 = false;
            Long l = (long)date;
            map.put(k, l);
        }
        map = destination$iv$iv;
        Map map5 = $this$withDate.getMetadata();
        Map map6 = map;
        UUID uUID2 = uUID;
        Map map7 = map3;
        String string2 = string;
        return new Record(string2, map7, uUID2, map6, map5);
    }

    private final Set<String> internalUpdateRecord(Record record, RecordMerger recordMerger, Long date) {
        return (Set)RecordDatabase.transaction$default(this.recordDatabase, false, (Function0)new Function0<Set<? extends String>>(this, record, date, recordMerger){
            final /* synthetic */ SqlNormalizedCache this$0;
            final /* synthetic */ Record $record;
            final /* synthetic */ Long $date;
            final /* synthetic */ RecordMerger $recordMerger;
            {
                this.this$0 = $receiver;
                this.$record = $record;
                this.$date = $date;
                this.$recordMerger = $recordMerger;
                super(0);
            }

            public final Set<String> invoke() {
                Set set;
                Record oldRecord = SqlNormalizedCache.access$getRecordDatabase$p(this.this$0).select(this.$record.getKey());
                if (oldRecord == null) {
                    SqlNormalizedCache.access$getRecordDatabase$p(this.this$0).insert(SqlNormalizedCache.access$withDate(this.this$0, this.$record, this.$date));
                    set = this.$record.fieldKeys();
                } else {
                    Pair pair = this.$recordMerger.merge(oldRecord, this.$record, this.$date);
                    Record mergedRecord = (Record)pair.component1();
                    Set changedKeys = (Set)pair.component2();
                    if (!((Map)mergedRecord).isEmpty()) {
                        SqlNormalizedCache.access$getRecordDatabase$p(this.this$0).update(mergedRecord);
                    }
                    set = changedKeys;
                }
                return set;
            }
        }, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Record> internalGetRecords(Collection<String> keys) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)keys, (int)999);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List chunkedKeys = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.recordDatabase.select(chunkedKeys);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ RecordDatabase access$getRecordDatabase$p(SqlNormalizedCache $this) {
        return $this.recordDatabase;
    }

    public static final /* synthetic */ List access$internalGetRecords(SqlNormalizedCache $this, Collection keys) {
        return $this.internalGetRecords(keys);
    }

    public static final /* synthetic */ boolean access$internalDeleteRecord(SqlNormalizedCache $this, String key, boolean cascade) {
        return $this.internalDeleteRecord(key, cascade);
    }

    public static final /* synthetic */ Record access$withDate(SqlNormalizedCache $this, Record $receiver, Long date) {
        return $this.withDate($receiver, date);
    }
}

