/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.normalized.sql.internal;

import com.squareup.sqldelight.db.SqlCursor;
import com.squareup.sqldelight.db.SqlDriver;
import com.squareup.sqldelight.sqlite.driver.JdbcSqliteDriver;
import java.io.Closeable;
import java.io.File;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a$\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a$\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0018\u0010\r\u001a\u00020\u0001*\u0004\u0018\u00010\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"versionPragma", "", "createDriver", "Lcom/squareup/sqldelight/db/SqlDriver;", "name", "baseDir", "schema", "Lcom/squareup/sqldelight/db/SqlDriver$Schema;", "properties", "Ljava/util/Properties;", "maybeCreateOrMigrateSchema", "", "driver", "toUrl", "apollo-normalized-cache-sqlite-incubating"})
public final class FactoryImplementationsKt {
    @NotNull
    private static final String versionPragma = "user_version";

    private static final String toUrl(String $this$toUrl, String baseDir) {
        String string;
        if ($this$toUrl == null) {
            string = "jdbc:sqlite:";
        } else {
            File file;
            String string2 = baseDir;
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                file = new File(it);
            } else {
                file = FilesKt.resolve((File)new File(System.getProperty("user.home")), (String)".apollo");
            }
            File dir = file;
            dir.mkdirs();
            string = "jdbc:sqlite:" + FilesKt.resolve((File)dir, (String)$this$toUrl).getAbsolutePath();
        }
        return string;
    }

    @NotNull
    public static final SqlDriver createDriver(@Nullable String name, @Nullable String baseDir, @NotNull Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        return (SqlDriver)new JdbcSqliteDriver(FactoryImplementationsKt.toUrl(name, baseDir), properties);
    }

    @NotNull
    public static final SqlDriver createDriver(@Nullable String name, @Nullable String baseDir, @NotNull SqlDriver.Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return FactoryImplementationsKt.createDriver(name, baseDir, new Properties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void maybeCreateOrMigrateSchema(@NotNull SqlDriver driver, @NotNull SqlDriver.Schema schema) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Closeable $this$use$iv = (Closeable)SqlDriver.DefaultImpls.executeQuery$default((SqlDriver)driver, null, (String)"PRAGMA user_version", (int)0, null, (int)8, null);
        boolean $i$f$use = false;
        Closeable closeable = $this$use$iv;
        Throwable throwable = null;
        try {
            Integer n2;
            SqlCursor cursor = (SqlCursor)closeable;
            boolean bl = false;
            if (cursor.next()) {
                Long l = cursor.getLong(0);
                n2 = l != null ? Integer.valueOf((int)l.longValue()) : null;
            } else {
                n2 = null;
            }
            Integer n3 = n2;
            n = n3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        int oldVersion = n != null ? n : 0;
        int newVersion = schema.getVersion();
        if (oldVersion == 0) {
            schema.create(driver);
            SqlDriver.DefaultImpls.execute$default((SqlDriver)driver, null, (String)("PRAGMA user_version=" + newVersion), (int)0, null, (int)8, null);
        } else if (oldVersion < newVersion) {
            schema.migrate(driver, oldVersion, newVersion);
            SqlDriver.DefaultImpls.execute$default((SqlDriver)driver, null, (String)("PRAGMA user_version=" + newVersion), (int)0, null, (int)8, null);
        }
    }
}

