/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.normalized.lru;

import com.apollographql.apollo3.cache.CacheHeaders;
import com.apollographql.apollo3.cache.normalized.CacheKey;
import com.apollographql.apollo3.cache.normalized.CacheReference;
import com.apollographql.apollo3.cache.normalized.NormalizedCache;
import com.apollographql.apollo3.cache.normalized.Record;
import com.apollographql.apollo3.cache.normalized.lru.EvictionPolicy;
import com.apollographql.apollo3.cache.normalized.lru.LruNormalizedCache;
import com.nytimes.android.external.cache.Cache;
import com.nytimes.android.external.cache.CacheBuilder;
import com.nytimes.android.external.cache.Weigher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="Will be removed soon", replaceWith=@ReplaceWith(imports={"com.apollographql.apollo3.cache.normalized.MemoryCache"}, expression="MemoryCache"))
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0002J$\u0010\f\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\r0\rH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00172\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001bH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/apollographql/apollo3/cache/normalized/lru/LruNormalizedCache;", "Lcom/apollographql/apollo3/cache/normalized/NormalizedCache;", "evictionPolicy", "Lcom/apollographql/apollo3/cache/normalized/lru/EvictionPolicy;", "(Lcom/apollographql/apollo3/cache/normalized/lru/EvictionPolicy;)V", "lruCache", "Lcom/nytimes/android/external/cache/Cache;", "", "Lcom/apollographql/apollo3/cache/normalized/Record;", "clearAll", "", "clearCurrentCache", "dump", "", "Lkotlin/reflect/KClass;", "loadRecord", "key", "cacheHeaders", "Lcom/apollographql/apollo3/cache/CacheHeaders;", "loadRecords", "", "keys", "merge", "", "record", "records", "remove", "", "cacheKey", "Lcom/apollographql/apollo3/cache/normalized/CacheKey;", "cascade", "apollo-normalized-cache"})
public final class LruNormalizedCache
extends NormalizedCache {
    private final Cache<String, Record> lruCache;

    @Nullable
    public Record loadRecord(@NotNull String key, @NotNull CacheHeaders cacheHeaders) {
        Record record;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        try {
            record = (Record)this.lruCache.get((Object)key, (Callable)new Callable<Record>(this, key, cacheHeaders){
                final /* synthetic */ LruNormalizedCache this$0;
                final /* synthetic */ String $key;
                final /* synthetic */ CacheHeaders $cacheHeaders;

                public final Record call() {
                    NormalizedCache normalizedCache = this.this$0.getNextCache();
                    return normalizedCache != null ? normalizedCache.loadRecord(this.$key, this.$cacheHeaders) : null;
                }
                {
                    this.this$0 = lruNormalizedCache;
                    this.$key = string;
                    this.$cacheHeaders = cacheHeaders;
                }
            });
        }
        catch (Exception ignored) {
            return null;
        }
        boolean bl = false;
        boolean bl2 = false;
        Record it = record;
        boolean bl3 = false;
        if (cacheHeaders.hasHeader("evict-after-read")) {
            this.lruCache.invalidate((Object)key);
        }
        return record;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<Record> loadRecords(@NotNull Collection<String> keys, @NotNull CacheHeaders cacheHeaders) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        Iterable $this$mapNotNull$iv = keys;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Record record;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String key = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.loadRecord(key, cacheHeaders) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Record it$iv$iv = record;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public void clearAll() {
        NormalizedCache normalizedCache = this.getNextCache();
        if (normalizedCache != null) {
            normalizedCache.clearAll();
        }
        this.clearCurrentCache();
    }

    public boolean remove(@NotNull CacheKey cacheKey, boolean cascade) {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        NormalizedCache normalizedCache = this.getNextCache();
        boolean result = normalizedCache != null ? normalizedCache.remove(cacheKey, cascade) : false;
        Record record = (Record)this.lruCache.getIfPresent((Object)cacheKey.getKey());
        if (record != null) {
            this.lruCache.invalidate((Object)cacheKey.getKey());
            result = true;
            if (cascade) {
                for (CacheReference cacheReference : record.referencedFields()) {
                    result = result && this.remove(new CacheKey(cacheReference.getKey()), true);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<String> merge(@NotNull Record record, @NotNull CacheHeaders cacheHeaders) {
        Object object;
        Set set;
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        if (cacheHeaders.hasHeader("do-not-store")) {
            return SetsKt.emptySet();
        }
        Record oldRecord = this.loadRecord(record.getKey(), cacheHeaders);
        if (oldRecord == null) {
            this.lruCache.put((Object)record.getKey(), (Object)record);
            set = record.fieldKeys();
        } else {
            void mergedRecord;
            Pair pair = oldRecord.mergeWith(record);
            object = (Record)pair.component1();
            Set changedKeys2 = (Set)pair.component2();
            this.lruCache.put((Object)record.getKey(), (Object)mergedRecord);
            set = changedKeys2;
        }
        Set changedKeys3 = set;
        NormalizedCache normalizedCache = this.getNextCache();
        object = normalizedCache != null ? normalizedCache.merge(record, cacheHeaders) : null;
        boolean bl = false;
        Object object2 = object;
        if (object2 == null) {
            object2 = SetsKt.emptySet();
        }
        return SetsKt.plus((Set)changedKeys3, (Iterable)((Iterable)object2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<String> merge(@NotNull Collection<Record> records, @NotNull CacheHeaders cacheHeaders) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        if (cacheHeaders.hasHeader("do-not-store")) {
            return SetsKt.emptySet();
        }
        Iterable $this$flatMap$iv = records;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Record record = (Record)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.merge(record, cacheHeaders);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final void clearCurrentCache() {
        this.lruCache.invalidateAll();
    }

    @NotNull
    public Map<KClass<?>, Map<String, Record>> dump() {
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        Map map = MapsKt.createMapBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        Map $this$buildMap = map;
        boolean bl5 = false;
        KClass kClass = Reflection.getOrCreateKotlinClass(((Object)((Object)this)).getClass());
        ConcurrentMap concurrentMap = this.lruCache.asMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"lruCache.asMap()");
        $this$buildMap.put(kClass, concurrentMap);
        NormalizedCache normalizedCache = this.getNextCache();
        Map map2 = normalizedCache != null ? normalizedCache.dump() : null;
        boolean bl6 = false;
        Map map3 = map2;
        if (map3 == null) {
            map3 = MapsKt.emptyMap();
        }
        $this$buildMap.putAll(map3);
        return MapsKt.build((Map)map);
    }

    /*
     * WARNING - void declaration
     */
    public LruNormalizedCache(@NotNull EvictionPolicy evictionPolicy) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)evictionPolicy, (String)"evictionPolicy");
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        boolean bl = false;
        boolean bl2 = false;
        CacheBuilder cacheBuilder2 = cacheBuilder;
        LruNormalizedCache lruNormalizedCache = this;
        boolean bl3 = false;
        if (evictionPolicy.getMaxSizeBytes() != null) {
            $this$apply.maximumWeight(evictionPolicy.getMaxSizeBytes().longValue()).weigher((Weigher)lruCache.1.1.INSTANCE);
        }
        if (evictionPolicy.getMaxEntries() != null) {
            $this$apply.maximumSize(evictionPolicy.getMaxEntries().longValue());
        }
        if (evictionPolicy.getExpireAfterAccess() != null) {
            long l = evictionPolicy.getExpireAfterAccess();
            TimeUnit timeUnit = evictionPolicy.getExpireAfterAccessTimeUnit();
            Intrinsics.checkNotNull((Object)((Object)timeUnit));
            $this$apply.expireAfterAccess(l, timeUnit);
        }
        if (evictionPolicy.getExpireAfterWrite() != null) {
            long l = evictionPolicy.getExpireAfterWrite();
            TimeUnit timeUnit = evictionPolicy.getExpireAfterWriteTimeUnit();
            Intrinsics.checkNotNull((Object)((Object)timeUnit));
            $this$apply.expireAfterWrite(l, timeUnit);
        }
        Unit unit = Unit.INSTANCE;
        Cache cache = cacheBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"CacheBuilder.newBuilder(\u2026Unit!!)\n    }\n  }.build()");
        lruNormalizedCache.lruCache = cache;
    }
}

