/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.normalized.api;

import com.apollographql.apollo3.annotations.ApolloExperimental;
import com.apollographql.apollo3.api.CompiledField;
import com.apollographql.apollo3.api.Executable;
import com.apollographql.apollo3.cache.normalized.api.CacheResolver;
import com.apollographql.apollo3.cache.normalized.api.Record;
import com.apollographql.apollo3.exception.CacheMissException;
import com.apollographql.apollo3.mpp.UtilsKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J=\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0019\u0010\n\u001a\u0015\u0012\u0004\u0012\u00020\f\u0012\u000b\u0012\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\r0\u000b2\u0006\u0010\u000e\u001a\u00020\fH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/apollographql/apollo3/cache/normalized/api/ExpireDateCacheResolver;", "Lcom/apollographql/apollo3/cache/normalized/api/CacheResolver;", "<init>", "()V", "resolveField", "", "field", "Lcom/apollographql/apollo3/api/CompiledField;", "variables", "Lcom/apollographql/apollo3/api/Executable$Variables;", "parent", "", "", "Lkotlin/jvm/JvmSuppressWildcards;", "parentId", "apollo-normalized-cache-api"})
@ApolloExperimental
public final class ExpireDateCacheResolver
implements CacheResolver {
    @Override
    @Nullable
    public Object resolveField(@NotNull CompiledField field, @NotNull Executable.Variables variables, @NotNull Map<String, Object> parent, @NotNull String parentId) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        String fieldKey = field.nameWithArguments(variables);
        if (!parent.containsKey(fieldKey)) {
            throw new CacheMissException(parentId, fieldKey);
        }
        if (parent instanceof Record) {
            Long expires;
            Map<String, Long> map = ((Record)parent).getDate();
            Long l = expires = map != null ? map.get(fieldKey) : null;
            if (expires != null && UtilsKt.currentTimeMillis() / (long)1000 - expires >= 0L) {
                throw new CacheMissException(parentId, fieldKey, true);
            }
        }
        return parent.get(fieldKey);
    }
}

