/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.normalized.api;

import com.apollographql.apollo3.cache.normalized.api.CacheHeaders;
import com.apollographql.apollo3.cache.normalized.api.CacheKey;
import com.apollographql.apollo3.cache.normalized.api.MemoryCache;
import com.apollographql.apollo3.cache.normalized.api.NormalizedCache;
import com.apollographql.apollo3.cache.normalized.api.Record;
import com.apollographql.apollo3.cache.normalized.api.internal.CacheLock;
import com.apollographql.apollo3.cache.normalized.api.internal.LruCache;
import com.apollographql.apollo3.mpp.UtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001)B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\r\u0010\u0012\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0013J$\u0010\u0014\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00170\u00150\u0015H\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J$\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0 2\u0006\u0010!\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J$\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00170\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020$H\u0016J\u0010\u0010#\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006*"}, d2={"Lcom/apollographql/apollo3/cache/normalized/api/MemoryCache;", "Lcom/apollographql/apollo3/cache/normalized/api/NormalizedCache;", "maxSizeBytes", "", "expireAfterMillis", "", "(IJ)V", "lock", "Lcom/apollographql/apollo3/cache/normalized/api/internal/CacheLock;", "lruCache", "Lcom/apollographql/apollo3/cache/normalized/api/internal/LruCache;", "", "Lcom/apollographql/apollo3/cache/normalized/api/MemoryCache$CacheEntry;", "size", "getSize", "()I", "clearAll", "", "clearCurrentCache", "clearCurrentCache$apollo_normalized_cache_api", "dump", "", "Lkotlin/reflect/KClass;", "Lcom/apollographql/apollo3/cache/normalized/api/Record;", "loadRecord", "key", "cacheHeaders", "Lcom/apollographql/apollo3/cache/normalized/api/CacheHeaders;", "loadRecords", "", "keys", "merge", "", "record", "records", "remove", "", "cacheKey", "Lcom/apollographql/apollo3/cache/normalized/api/CacheKey;", "cascade", "pattern", "CacheEntry", "apollo-normalized-cache-api"})
@SourceDebugExtension(value={"SMAP\nMemoryCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryCache.kt\ncom/apollographql/apollo3/cache/normalized/api/MemoryCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,164:1\n1603#2,9:165\n1855#2:174\n1856#2:176\n1612#2:177\n1855#2,2:178\n1360#2:180\n1446#2,5:181\n1238#2,4:188\n1#3:175\n453#4:186\n403#4:187\n*S KotlinDebug\n*F\n+ 1 MemoryCache.kt\ncom/apollographql/apollo3/cache/normalized/api/MemoryCache\n*L\n56#1:165,9\n56#1:174\n56#1:176\n56#1:177\n81#1:178,2\n120#1:180\n120#1:181,5\n125#1:188,4\n56#1:175\n125#1:186\n125#1:187\n*E\n"})
public final class MemoryCache
extends NormalizedCache {
    private final int maxSizeBytes;
    private final long expireAfterMillis;
    @NotNull
    private final CacheLock lock;
    @NotNull
    private final LruCache<String, CacheEntry> lruCache;

    public MemoryCache(int maxSizeBytes, long expireAfterMillis) {
        this.maxSizeBytes = maxSizeBytes;
        this.expireAfterMillis = expireAfterMillis;
        this.lock = new CacheLock();
        this.lruCache = new LruCache(this.maxSizeBytes, lruCache.1.INSTANCE);
    }

    public /* synthetic */ MemoryCache(int n, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n2 & 2) != 0) {
            l = -1L;
        }
        this(n, l);
    }

    public final int getSize() {
        return this.lruCache.size();
    }

    @Override
    @Nullable
    public Record loadRecord(@NotNull String key, @NotNull CacheHeaders cacheHeaders) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        return (Record)this.lock.lock((Function0)new Function0<Record>(this, key, cacheHeaders){
            final /* synthetic */ MemoryCache this$0;
            final /* synthetic */ String $key;
            final /* synthetic */ CacheHeaders $cacheHeaders;
            {
                this.this$0 = $receiver;
                this.$key = $key;
                this.$cacheHeaders = $cacheHeaders;
                super(0);
            }

            @Nullable
            public final Record invoke() {
                Object object;
                block9: {
                    Object object2;
                    Object object3;
                    block8: {
                        CacheEntry cacheEntry;
                        CacheEntry cacheEntry2;
                        CacheEntry cacheEntry3;
                        CacheEntry cacheEntry4 = (CacheEntry)MemoryCache.access$getLruCache$p(this.this$0).get(this.$key);
                        if (cacheEntry4 != null) {
                            cacheEntry3 = cacheEntry4;
                            CacheHeaders cacheHeaders = this.$cacheHeaders;
                            MemoryCache memoryCache = this.this$0;
                            object3 = this.$key;
                            CacheEntry cacheEntry5 = cacheEntry3;
                            boolean bl = false;
                            if (cacheEntry5.isExpired() || cacheHeaders.hasHeader("evict-after-read")) {
                                MemoryCache.access$getLruCache$p(memoryCache).remove(object3);
                            }
                            cacheEntry2 = cacheEntry3;
                        } else {
                            cacheEntry2 = null;
                        }
                        if ((object = (cacheEntry = cacheEntry2)) == null) break block8;
                        CacheEntry it = cacheEntry3 = object;
                        boolean bl = false;
                        object = !it.isExpired() ? cacheEntry3 : null;
                        if (object != null && (object = ((CacheEntry)object).getRecord()) != null) break block9;
                    }
                    if ((object2 = this.this$0.getNextCache()) != null && (object2 = object2.loadRecord(this.$key, this.$cacheHeaders)) != null) {
                        object3 = object2;
                        MemoryCache memoryCache = this.this$0;
                        String string = this.$key;
                        Object nextCachedRecord = object3;
                        boolean bl = false;
                        MemoryCache.access$getLruCache$p(memoryCache).set(string, new CacheEntry((Record)nextCachedRecord, MemoryCache.access$getExpireAfterMillis$p(memoryCache)));
                        object = object3;
                    } else {
                        object = null;
                    }
                }
                return object;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<Record> loadRecords(@NotNull Collection<String> keys, @NotNull CacheHeaders cacheHeaders) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        Iterable $this$mapNotNull$iv = keys;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Record it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String key = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.loadRecord(key, cacheHeaders) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void clearAll() {
        block0: {
            this.lruCache.clear();
            NormalizedCache normalizedCache = this.getNextCache();
            if (normalizedCache == null) break block0;
            normalizedCache.clearAll();
        }
    }

    @Override
    public boolean remove(@NotNull CacheKey cacheKey, boolean cascade) {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        CacheEntry cacheEntry = this.lruCache.remove(cacheKey.getKey());
        if (cascade && cacheEntry != null) {
            for (CacheKey cacheReference : cacheEntry.getRecord().referencedFields()) {
                this.remove(new CacheKey(cacheReference.getKey()), true);
            }
        }
        NormalizedCache normalizedCache = this.getNextCache();
        boolean chainRemoved = normalizedCache != null ? normalizedCache.remove(cacheKey, cascade) : false;
        return cacheEntry != null || chainRemoved;
    }

    @Override
    public int remove(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Regex regex = NormalizedCache.Companion.patternToRegex(pattern);
        int total = 0;
        HashSet keys = new HashSet(this.lruCache.keys());
        Iterable $this$forEach$iv = keys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!regex.matches((CharSequence)it)) continue;
            this.lruCache.remove(it);
            ++total;
        }
        NormalizedCache normalizedCache = this.getNextCache();
        int chainRemoved = normalizedCache != null ? normalizedCache.remove(pattern) : 0;
        return total + chainRemoved;
    }

    @Override
    @NotNull
    public Set<String> merge(@NotNull Record record, @NotNull CacheHeaders cacheHeaders) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        if (cacheHeaders.hasHeader("do-not-store")) {
            return SetsKt.emptySet();
        }
        Record oldRecord = this.loadRecord(record.getKey(), cacheHeaders);
        if (oldRecord == null) {
            this.lruCache.set(record.getKey(), new CacheEntry(record, this.expireAfterMillis));
            set = record.fieldKeys();
        } else {
            Pair<Record, Set<String>> pair = oldRecord.mergeWith(record);
            Record mergedRecord = (Record)pair.component1();
            Set changedKeys = (Set)pair.component2();
            this.lruCache.set(record.getKey(), new CacheEntry(mergedRecord, this.expireAfterMillis));
            set = changedKeys;
        }
        Set changedKeys = set;
        NormalizedCache normalizedCache = this.getNextCache();
        Set set2 = normalizedCache != null ? normalizedCache.merge(record, cacheHeaders) : null;
        if (set2 == null) {
            set2 = SetsKt.emptySet();
        }
        return SetsKt.plus((Set)changedKeys, (Iterable)set2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<String> merge(@NotNull Collection<Record> records, @NotNull CacheHeaders cacheHeaders) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        if (cacheHeaders.hasHeader("do-not-store")) {
            return SetsKt.emptySet();
        }
        Iterable $this$flatMap$iv = records;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Record record = (Record)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.merge(record, cacheHeaders);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<KClass<?>, Map<String, Record>> dump() {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Map<String, CacheEntry> map = this.lruCache.dump();
        KClass kClass = Reflection.getOrCreateKotlinClass(this.getClass());
        boolean $i$f$mapValues = false;
        void var3_4 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            CacheEntry entry3 = (CacheEntry)entry2.getValue();
            Record record = entry3.getRecord();
            map3.put(k, record);
        }
        Map map4 = MapsKt.mapOf((Pair)TuplesKt.to((Object)kClass, (Object)destination$iv$iv));
        NormalizedCache normalizedCache = this.getNextCache();
        Map map5 = normalizedCache != null ? normalizedCache.dump() : null;
        if (map5 == null) {
            map5 = MapsKt.emptyMap();
        }
        return MapsKt.plus((Map)map4, map5);
    }

    public final void clearCurrentCache$apollo_normalized_cache_api() {
        this.lruCache.clear();
    }

    public MemoryCache() {
        this(0, 0L, 3, null);
    }

    public static final /* synthetic */ LruCache access$getLruCache$p(MemoryCache $this) {
        return $this.lruCache;
    }

    public static final /* synthetic */ long access$getExpireAfterMillis$p(MemoryCache $this) {
        return $this.expireAfterMillis;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/apollographql/apollo3/cache/normalized/api/MemoryCache$CacheEntry;", "", "record", "Lcom/apollographql/apollo3/cache/normalized/api/Record;", "expireAfterMillis", "", "(Lcom/apollographql/apollo3/cache/normalized/api/Record;J)V", "cachedAtMillis", "getCachedAtMillis", "()J", "getExpireAfterMillis", "isExpired", "", "()Z", "getRecord", "()Lcom/apollographql/apollo3/cache/normalized/api/Record;", "sizeInBytes", "", "getSizeInBytes", "()I", "apollo-normalized-cache-api"})
    private static final class CacheEntry {
        @NotNull
        private final Record record;
        private final long expireAfterMillis;
        private final long cachedAtMillis;
        private final int sizeInBytes;

        public CacheEntry(@NotNull Record record, long expireAfterMillis) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            this.record = record;
            this.expireAfterMillis = expireAfterMillis;
            this.cachedAtMillis = UtilsKt.currentTimeMillis();
            this.sizeInBytes = this.record.getSizeInBytes() + 8;
        }

        @NotNull
        public final Record getRecord() {
            return this.record;
        }

        public final long getExpireAfterMillis() {
            return this.expireAfterMillis;
        }

        public final long getCachedAtMillis() {
            return this.cachedAtMillis;
        }

        public final int getSizeInBytes() {
            return this.sizeInBytes;
        }

        public final boolean isExpired() {
            return this.expireAfterMillis < 0L ? false : UtilsKt.currentTimeMillis() - this.cachedAtMillis >= this.expireAfterMillis;
        }
    }
}

