/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.normalized.api;

import com.apollographql.apollo3.annotations.ApolloExperimental;
import com.apollographql.apollo3.api.CompiledField;
import com.apollographql.apollo3.api.Executable;
import com.apollographql.apollo3.cache.normalized.api.CacheResolver;
import com.apollographql.apollo3.cache.normalized.api.Record;
import com.apollographql.apollo3.exception.CacheMissException;
import com.apollographql.apollo3.mpp.UtilsKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J=\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0019\u0010\u000b\u001a\u0015\u0012\u0004\u0012\u00020\r\u0012\u000b\u0012\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u000e0\f2\u0006\u0010\u000f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/apollographql/apollo3/cache/normalized/api/ReceiveDateCacheResolver;", "Lcom/apollographql/apollo3/cache/normalized/api/CacheResolver;", "maxAge", "", "(I)V", "resolveField", "", "field", "Lcom/apollographql/apollo3/api/CompiledField;", "variables", "Lcom/apollographql/apollo3/api/Executable$Variables;", "parent", "", "", "Lkotlin/jvm/JvmSuppressWildcards;", "parentId", "apollo-normalized-cache-api"})
@ApolloExperimental
public final class ReceiveDateCacheResolver
implements CacheResolver {
    private final int maxAge;

    public ReceiveDateCacheResolver(int maxAge) {
        this.maxAge = maxAge;
    }

    @Override
    @Nullable
    public Object resolveField(@NotNull CompiledField field, @NotNull Executable.Variables variables, @NotNull Map<String, Object> parent, @NotNull String parentId) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        String name = field.nameWithArguments(variables);
        if (!parent.containsKey(name)) {
            throw new CacheMissException(parentId, name);
        }
        if (parent instanceof Record) {
            long age;
            Long lastUpdated;
            Map<String, Long> map = ((Record)parent).getDate();
            Long l = lastUpdated = map != null ? map.get(name) : null;
            if (lastUpdated != null && (age = UtilsKt.currentTimeMillis() / (long)1000 - lastUpdated) > (long)this.maxAge) {
                throw new CacheMissException(parentId, name, true);
            }
        }
        return parent.get(name);
    }
}

