/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.normalized.api;

import com.apollographql.apollo3.annotations.ApolloExperimental;
import com.apollographql.apollo3.cache.normalized.api.ApolloResolver;
import com.apollographql.apollo3.cache.normalized.api.FieldKeyContext;
import com.apollographql.apollo3.cache.normalized.api.Record;
import com.apollographql.apollo3.cache.normalized.api.ResolverContext;
import com.apollographql.apollo3.exception.CacheMissException;
import com.apollographql.apollo3.mpp.UtilsKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/apollographql/apollo3/cache/normalized/api/ReceiveDateApolloResolver;", "Lcom/apollographql/apollo3/cache/normalized/api/ApolloResolver;", "maxAge", "", "<init>", "(I)V", "resolveField", "", "context", "Lcom/apollographql/apollo3/cache/normalized/api/ResolverContext;", "apollo-normalized-cache-api-incubating"})
@ApolloExperimental
public final class ReceiveDateApolloResolver
implements ApolloResolver {
    private final int maxAge;

    public ReceiveDateApolloResolver(int maxAge) {
        this.maxAge = maxAge;
    }

    @Override
    @Nullable
    public Object resolveField(@NotNull ResolverContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Map<String, Object> parent = context.getParent();
        String parentKey = context.getParentKey();
        String fieldKey = context.getFieldKeyGenerator().getFieldKey(new FieldKeyContext(context.getParentType(), context.getField(), context.getVariables()));
        if (!parent.containsKey(fieldKey)) {
            throw new CacheMissException(parentKey, fieldKey);
        }
        if (parent instanceof Record) {
            Long lastUpdated;
            Map<String, Long> map = ((Record)parent).getDates();
            Long l = lastUpdated = map != null ? map.get(fieldKey) : null;
            if (lastUpdated != null) {
                long age;
                long maxStale;
                Object object = context.getCacheHeaders().headerValue("apollo-max-stale");
                long l2 = object != null && (object = StringsKt.toLongOrNull((String)object)) != null ? (Long)object : (maxStale = 0L);
                if (maxStale < Long.MAX_VALUE && (long)this.maxAge + maxStale - (age = UtilsKt.currentTimeMillis() / (long)1000 - lastUpdated) < 0L) {
                    throw new CacheMissException(parentKey, fieldKey, true);
                }
            }
        }
        return parent.get(fieldKey);
    }
}

