/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.normalized.api;

import com.apollographql.apollo3.cache.normalized.api.CacheHeaders;
import com.apollographql.apollo3.cache.normalized.api.CacheKey;
import com.apollographql.apollo3.cache.normalized.api.MemoryCache;
import com.apollographql.apollo3.cache.normalized.api.NormalizedCache;
import com.apollographql.apollo3.cache.normalized.api.Record;
import com.apollographql.apollo3.cache.normalized.api.RecordMerger;
import com.apollographql.apollo3.cache.normalized.api.internal.Lock;
import com.apollographql.apollo3.cache.normalized.api.internal.LruCache;
import com.apollographql.apollo3.cache.normalized.api.internal.PatternToRegexKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\r\u0010\u0013\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0014J$\u0010\u0015\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0017\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u00160\u0016H\u0016J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u00192\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\r2\u0006\u0010 \u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J$\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0\"2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J!\u0010$\u001a\u0002H%\"\u0004\b\u0000\u0010%2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H%0'H\u0002\u00a2\u0006\u0002\u0010(J!\u0010)\u001a\u0002H%\"\u0004\b\u0000\u0010%2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H%0'H\u0002\u00a2\u0006\u0002\u0010(J&\u0010*\u001a\b\u0012\u0004\u0012\u00020\f0\u00192\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J,\u0010*\u001a\b\u0012\u0004\u0012\u00020\f0\u00192\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\r0\"2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020-H\u0016J\u0010\u0010,\u001a\u00020\u00042\u0006\u00101\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00062"}, d2={"Lcom/apollographql/apollo3/cache/normalized/api/MemoryCache;", "Lcom/apollographql/apollo3/cache/normalized/api/NormalizedCache;", "nextCache", "maxSizeBytes", "", "expireAfterMillis", "", "(Lcom/apollographql/apollo3/cache/normalized/api/NormalizedCache;IJ)V", "lock", "Lcom/apollographql/apollo3/cache/normalized/api/internal/Lock;", "lruCache", "Lcom/apollographql/apollo3/cache/normalized/api/internal/LruCache;", "", "Lcom/apollographql/apollo3/cache/normalized/api/Record;", "size", "getSize", "()I", "clearAll", "", "clearCurrentCache", "clearCurrentCache$apollo_normalized_cache_api_incubating", "dump", "", "Lkotlin/reflect/KClass;", "internalMerge", "", "record", "cacheHeaders", "Lcom/apollographql/apollo3/cache/normalized/api/CacheHeaders;", "recordMerger", "Lcom/apollographql/apollo3/cache/normalized/api/RecordMerger;", "loadRecord", "key", "loadRecords", "", "keys", "lockRead", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "lockWrite", "merge", "records", "remove", "", "cacheKey", "Lcom/apollographql/apollo3/cache/normalized/api/CacheKey;", "cascade", "pattern", "apollo-normalized-cache-api-incubating"})
@SourceDebugExtension(value={"SMAP\nMemoryCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryCache.kt\ncom/apollographql/apollo3/cache/normalized/api/MemoryCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,161:1\n1#2:162\n1#2:173\n1611#3,9:163\n1863#3:172\n1864#3:174\n1620#3:175\n*S KotlinDebug\n*F\n+ 1 MemoryCache.kt\ncom/apollographql/apollo3/cache/normalized/api/MemoryCache\n*L\n54#1:173\n54#1:163,9\n54#1:172\n54#1:174\n54#1:175\n*E\n"})
public final class MemoryCache
implements NormalizedCache {
    @Nullable
    private final NormalizedCache nextCache;
    private final int maxSizeBytes;
    private final long expireAfterMillis;
    @Nullable
    private final Lock lock;
    @NotNull
    private final LruCache<String, Record> lruCache;

    public MemoryCache(@Nullable NormalizedCache nextCache, int maxSizeBytes, long expireAfterMillis) {
        Lock lock;
        this.nextCache = nextCache;
        this.maxSizeBytes = maxSizeBytes;
        this.expireAfterMillis = expireAfterMillis;
        MemoryCache memoryCache = this;
        NormalizedCache normalizedCache = this.nextCache;
        if (normalizedCache != null) {
            NormalizedCache normalizedCache2 = normalizedCache;
            MemoryCache memoryCache2 = memoryCache;
            boolean bl = false;
            lock = new Lock();
            memoryCache = memoryCache2;
        } else {
            lock = null;
        }
        memoryCache.lock = lock;
        this.lruCache = new LruCache(this.maxSizeBytes, this.expireAfterMillis, lruCache.1.INSTANCE);
    }

    public /* synthetic */ MemoryCache(NormalizedCache normalizedCache, int n, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            normalizedCache = null;
        }
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n2 & 4) != 0) {
            l = -1L;
        }
        this(normalizedCache, n, l);
    }

    private final <T> T lockWrite(Function0<? extends T> block) {
        Object object = this.lock;
        if (object == null || (object = ((Lock)object).write((Function0)new Function0<T>(block){
            final /* synthetic */ Function0<T> $block;
            {
                this.$block = $block;
                super(0);
            }

            public final T invoke() {
                return (T)this.$block.invoke();
            }
        })) == null) {
            object = block.invoke();
        }
        return (T)object;
    }

    private final <T> T lockRead(Function0<? extends T> block) {
        Object object = this.lock;
        if (object == null || (object = ((Lock)object).read((Function0)new Function0<T>(block){
            final /* synthetic */ Function0<T> $block;
            {
                this.$block = $block;
                super(0);
            }

            public final T invoke() {
                return (T)this.$block.invoke();
            }
        })) == null) {
            object = block.invoke();
        }
        return (T)object;
    }

    public final int getSize() {
        return ((Number)this.lockRead((Function0)new Function0<Integer>(this){
            final /* synthetic */ MemoryCache this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Integer invoke() {
                return MemoryCache.access$getLruCache$p(this.this$0).weight();
            }
        })).intValue();
    }

    @Override
    @Nullable
    public Record loadRecord(@NotNull String key, @NotNull CacheHeaders cacheHeaders) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        return (Record)this.lockRead((Function0)new Function0<Record>(this, key, cacheHeaders){
            final /* synthetic */ MemoryCache this$0;
            final /* synthetic */ String $key;
            final /* synthetic */ CacheHeaders $cacheHeaders;
            {
                this.this$0 = $receiver;
                this.$key = $key;
                this.$cacheHeaders = $cacheHeaders;
                super(0);
            }

            public final Record invoke() {
                Record record;
                Object object;
                Record record2;
                String string;
                MemoryCache memoryCache;
                Object object2;
                Record record3 = (Record)MemoryCache.access$getLruCache$p(this.this$0).get(this.$key);
                if (record3 != null) {
                    Record record4 = record3;
                    object2 = this.$cacheHeaders;
                    memoryCache = this.this$0;
                    string = this.$key;
                    Record it = record4;
                    boolean bl = false;
                    if (((CacheHeaders)object2).hasHeader("evict-after-read")) {
                        MemoryCache.access$getLruCache$p(memoryCache).remove(string);
                    }
                    record2 = record4;
                } else {
                    record2 = null;
                }
                if ((object = (record = record2)) == null) {
                    Object object3 = MemoryCache.access$getNextCache$p(this.this$0);
                    if (object3 != null && (object3 = object3.loadRecord(this.$key, this.$cacheHeaders)) != null) {
                        object2 = object3;
                        memoryCache = this.this$0;
                        string = this.$key;
                        Object nextCachedRecord = object2;
                        boolean bl = false;
                        MemoryCache.access$getLruCache$p(memoryCache).set(string, nextCachedRecord);
                        object = object2;
                    } else {
                        object = null;
                    }
                }
                return object;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<Record> loadRecords(@NotNull Collection<String> keys2, @NotNull CacheHeaders cacheHeaders) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(keys2, (String)"keys");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        Iterable $this$mapNotNull$iv = keys2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Record it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String key = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.loadRecord(key, cacheHeaders) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void clearAll() {
        this.lockWrite((Function0)new Function0<Unit>(this){
            final /* synthetic */ MemoryCache this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Unit invoke() {
                Unit unit;
                MemoryCache.access$getLruCache$p(this.this$0).clear();
                NormalizedCache normalizedCache = MemoryCache.access$getNextCache$p(this.this$0);
                if (normalizedCache != null) {
                    normalizedCache.clearAll();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                return unit;
            }
        });
    }

    @Override
    public boolean remove(@NotNull CacheKey cacheKey, boolean cascade) {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        return (Boolean)this.lockWrite((Function0)new Function0<Boolean>(this, cacheKey, cascade){
            final /* synthetic */ MemoryCache this$0;
            final /* synthetic */ CacheKey $cacheKey;
            final /* synthetic */ boolean $cascade;
            {
                this.this$0 = $receiver;
                this.$cacheKey = $cacheKey;
                this.$cascade = $cascade;
                super(0);
            }

            public final Boolean invoke() {
                Record record = (Record)MemoryCache.access$getLruCache$p(this.this$0).remove(this.$cacheKey.getKey());
                if (this.$cascade && record != null) {
                    for (CacheKey cacheReference : record.referencedFields()) {
                        this.this$0.remove(new CacheKey(cacheReference.getKey()), true);
                    }
                }
                NormalizedCache normalizedCache = MemoryCache.access$getNextCache$p(this.this$0);
                boolean chainRemoved = normalizedCache != null ? normalizedCache.remove(this.$cacheKey, this.$cascade) : false;
                return record != null || chainRemoved;
            }
        });
    }

    @Override
    public int remove(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Regex regex = PatternToRegexKt.patternToRegex(pattern);
        return ((Number)this.lockWrite((Function0)new Function0<Integer>(this, pattern, regex){
            final /* synthetic */ MemoryCache this$0;
            final /* synthetic */ String $pattern;
            final /* synthetic */ Regex $regex;
            {
                this.this$0 = $receiver;
                this.$pattern = $pattern;
                this.$regex = $regex;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final Integer invoke() {
                void $this$forEach$iv;
                int total = 0;
                HashSet<E> keys2 = new HashSet<E>(MemoryCache.access$getLruCache$p(this.this$0).asMap().keySet());
                Iterable iterable = keys2;
                Regex regex = this.$regex;
                MemoryCache memoryCache = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!regex.matches((CharSequence)it)) continue;
                    MemoryCache.access$getLruCache$p(memoryCache).remove(it);
                    ++total;
                }
                NormalizedCache normalizedCache = MemoryCache.access$getNextCache$p(this.this$0);
                int chainRemoved = normalizedCache != null ? normalizedCache.remove(this.$pattern) : 0;
                return total + chainRemoved;
            }
        })).intValue();
    }

    @Override
    @NotNull
    public Set<String> merge(@NotNull Record record, @NotNull CacheHeaders cacheHeaders, @NotNull RecordMerger recordMerger) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        Intrinsics.checkNotNullParameter((Object)recordMerger, (String)"recordMerger");
        if (cacheHeaders.hasHeader("do-not-store")) {
            return SetsKt.emptySet();
        }
        return (Set)this.lockWrite((Function0)new Function0<Set<? extends String>>(this, record, cacheHeaders, recordMerger){
            final /* synthetic */ MemoryCache this$0;
            final /* synthetic */ Record $record;
            final /* synthetic */ CacheHeaders $cacheHeaders;
            final /* synthetic */ RecordMerger $recordMerger;
            {
                this.this$0 = $receiver;
                this.$record = $record;
                this.$cacheHeaders = $cacheHeaders;
                this.$recordMerger = $recordMerger;
                super(0);
            }

            public final Set<String> invoke() {
                Set changedKeys = MemoryCache.access$internalMerge(this.this$0, this.$record, this.$cacheHeaders, this.$recordMerger);
                NormalizedCache normalizedCache = MemoryCache.access$getNextCache$p(this.this$0);
                Set<String> set = normalizedCache != null ? normalizedCache.merge(this.$record, this.$cacheHeaders, this.$recordMerger) : null;
                if (set == null) {
                    set = SetsKt.emptySet();
                }
                return SetsKt.plus((Set)changedKeys, (Iterable)set);
            }
        });
    }

    @Override
    @NotNull
    public Set<String> merge(@NotNull Collection<Record> records, @NotNull CacheHeaders cacheHeaders, @NotNull RecordMerger recordMerger) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        Intrinsics.checkNotNullParameter((Object)recordMerger, (String)"recordMerger");
        if (cacheHeaders.hasHeader("do-not-store")) {
            return SetsKt.emptySet();
        }
        return (Set)this.lockWrite((Function0)new Function0<Set<? extends String>>(records, this, cacheHeaders, recordMerger){
            final /* synthetic */ Collection<Record> $records;
            final /* synthetic */ MemoryCache this$0;
            final /* synthetic */ CacheHeaders $cacheHeaders;
            final /* synthetic */ RecordMerger $recordMerger;
            {
                this.$records = $records;
                this.this$0 = $receiver;
                this.$cacheHeaders = $cacheHeaders;
                this.$recordMerger = $recordMerger;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final Set<String> invoke() {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                Iterable iterable = this.$records;
                MemoryCache memoryCache = this.this$0;
                CacheHeaders cacheHeaders = this.$cacheHeaders;
                RecordMerger recordMerger = this.$recordMerger;
                boolean $i$f$flatMap = false;
                void var7_6 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    Record record = (Record)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = MemoryCache.access$internalMerge(memoryCache, record, cacheHeaders, recordMerger);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                Set changedKeys = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                NormalizedCache normalizedCache = MemoryCache.access$getNextCache$p(this.this$0);
                Set<String> set = normalizedCache != null ? normalizedCache.merge(this.$records, this.$cacheHeaders, this.$recordMerger) : null;
                if (set == null) {
                    set = SetsKt.emptySet();
                }
                return SetsKt.plus((Set)changedKeys, (Iterable)set);
            }
        });
    }

    private final Set<String> internalMerge(Record record, CacheHeaders cacheHeaders, RecordMerger recordMerger) {
        Set set;
        Record oldRecord = this.loadRecord(record.getKey(), cacheHeaders);
        if (oldRecord == null) {
            this.lruCache.set(record.getKey(), record);
            set = record.fieldKeys();
        } else {
            Pair<Record, Set<String>> pair = recordMerger.merge(oldRecord, record, null);
            Record mergedRecord = (Record)pair.component1();
            Set changedKeys = (Set)pair.component2();
            this.lruCache.set(record.getKey(), mergedRecord);
            set = changedKeys;
        }
        Set changedKeys = set;
        return changedKeys;
    }

    @Override
    @NotNull
    public Map<KClass<?>, Map<String, Record>> dump() {
        return (Map)this.lockRead((Function0)new Function0<Map<KClass<?>, ? extends Map<String, ? extends Record>>>(this){
            final /* synthetic */ MemoryCache this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final Map<KClass<?>, Map<String, Record>> invoke() {
                void $this$mapValuesTo$iv$iv;
                void $this$mapValues$iv;
                Map<Key, Value> map = MemoryCache.access$getLruCache$p(this.this$0).asMap();
                KClass kClass = Reflection.getOrCreateKotlinClass(this.this$0.getClass());
                boolean $i$f$mapValues = false;
                void var3_4 = $this$mapValues$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    Record record;
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Map map2 = destination$iv$iv;
                    boolean bl = false;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    K k = it$iv$iv.getKey();
                    Map map3 = map2;
                    boolean bl2 = false;
                    Record record2 = record = (Record)entry2.getValue();
                    map3.put(k, record2);
                }
                Map map4 = MapsKt.mapOf((Pair)TuplesKt.to((Object)kClass, (Object)destination$iv$iv));
                NormalizedCache normalizedCache = MemoryCache.access$getNextCache$p(this.this$0);
                Map<K, V> map5 = normalizedCache != null ? normalizedCache.dump() : null;
                if (map5 == null) {
                    map5 = MapsKt.emptyMap();
                }
                return MapsKt.plus((Map)map4, map5);
            }
        });
    }

    public final void clearCurrentCache$apollo_normalized_cache_api_incubating() {
        this.lruCache.clear();
    }

    public MemoryCache() {
        this(null, 0, 0L, 7, null);
    }

    public static final /* synthetic */ LruCache access$getLruCache$p(MemoryCache $this) {
        return $this.lruCache;
    }

    public static final /* synthetic */ NormalizedCache access$getNextCache$p(MemoryCache $this) {
        return $this.nextCache;
    }

    public static final /* synthetic */ Set access$internalMerge(MemoryCache $this, Record record, CacheHeaders cacheHeaders, RecordMerger recordMerger) {
        return $this.internalMerge(record, cacheHeaders, recordMerger);
    }
}

