/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.normalized.api.internal;

import com.apollographql.apollo3.annotations.ApolloInternal;
import com.apollographql.apollo3.cache.normalized.api.CacheHeaders;
import com.apollographql.apollo3.cache.normalized.api.CacheKey;
import com.apollographql.apollo3.cache.normalized.api.NormalizedCache;
import com.apollographql.apollo3.cache.normalized.api.Record;
import com.apollographql.apollo3.cache.normalized.api.RecordMerger;
import com.apollographql.apollo3.cache.normalized.api.internal.ConcurrentMap_jvmKt;
import com.apollographql.apollo3.cache.normalized.api.internal.PatternToRegexKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0002*+B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J$\u0010\u0011\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0013\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\u00120\u0012H\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J$\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J&\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J,\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001fH\u0016J\u0010\u0010\u001e\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0006H\u0016J\u0018\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\n\u0010&\u001a\u00060'j\u0002`(J\u0018\u0010)\u001a\u0004\u0018\u00010\u000b*\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\u0006H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/apollographql/apollo3/cache/normalized/api/internal/OptimisticNormalizedCache;", "Lcom/apollographql/apollo3/cache/normalized/api/NormalizedCache;", "wrapped", "(Lcom/apollographql/apollo3/cache/normalized/api/NormalizedCache;)V", "recordJournals", "", "", "Lcom/apollographql/apollo3/cache/normalized/api/internal/OptimisticNormalizedCache$RecordJournal;", "addOptimisticUpdate", "", "record", "Lcom/apollographql/apollo3/cache/normalized/api/Record;", "addOptimisticUpdates", "recordSet", "", "clearAll", "", "dump", "", "Lkotlin/reflect/KClass;", "loadRecord", "key", "cacheHeaders", "Lcom/apollographql/apollo3/cache/normalized/api/CacheHeaders;", "loadRecords", "keys", "merge", "recordMerger", "Lcom/apollographql/apollo3/cache/normalized/api/RecordMerger;", "records", "remove", "", "cacheKey", "Lcom/apollographql/apollo3/cache/normalized/api/CacheKey;", "cascade", "", "pattern", "removeOptimisticUpdates", "mutationId", "Ljava/util/UUID;", "Lcom/benasher44/uuid/Uuid;", "mergeJournalRecord", "RecordJournal", "RemovalResult", "apollo-normalized-cache-api-incubating"})
@ApolloInternal
@SourceDebugExtension(value={"SMAP\nOptimisticNormalizedCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptimisticNormalizedCache.kt\ncom/apollographql/apollo3/cache/normalized/api/internal/OptimisticNormalizedCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,186:1\n1192#2,2:187\n1220#2,4:189\n1601#2,9:193\n1853#2:202\n1854#2:204\n1610#2:205\n1853#2,2:206\n1358#2:208\n1444#2,5:209\n1853#2,2:214\n1236#2,4:218\n1#3:203\n453#4:216\n403#4:217\n*S KotlinDebug\n*F\n+ 1 OptimisticNormalizedCache.kt\ncom/apollographql/apollo3/cache/normalized/api/internal/OptimisticNormalizedCache\n*L\n24#1:187,2\n24#1:189,4\n25#1:193,9\n25#1:202\n25#1:204\n25#1:205\n64#1:206,2\n75#1:208\n75#1:209,5\n93#1:214,2\n105#1:218,4\n25#1:203\n105#1:216\n105#1:217\n*E\n"})
public final class OptimisticNormalizedCache
implements NormalizedCache {
    @NotNull
    private final NormalizedCache wrapped;
    @NotNull
    private final Map<String, RecordJournal> recordJournals;

    public OptimisticNormalizedCache(@NotNull NormalizedCache wrapped) {
        Intrinsics.checkNotNullParameter((Object)wrapped, (String)"wrapped");
        this.wrapped = wrapped;
        this.recordJournals = ConcurrentMap_jvmKt.ConcurrentMap();
    }

    @Override
    @Nullable
    public Record loadRecord(@NotNull String key, @NotNull CacheHeaders cacheHeaders) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        Record nonOptimisticRecord = this.wrapped.loadRecord(key, cacheHeaders);
        return this.mergeJournalRecord(nonOptimisticRecord, key);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<Record> loadRecords(@NotNull Collection<String> keys2, @NotNull CacheHeaders cacheHeaders) {
        void $this$mapNotNullTo$iv$iv;
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(keys2, (String)"keys");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        Iterable $this$associateBy$iv = this.wrapped.loadRecords(keys2, cacheHeaders);
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Record record = (Record)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getKey(), element$iv$iv);
        }
        Map nonOptimisticRecords = destination$iv$iv;
        Iterable $this$mapNotNull$iv = keys2;
        boolean $i$f$mapNotNull = false;
        Iterable capacity$iv22 = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Record it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String key = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.mergeJournalRecord((Record)nonOptimisticRecords.get(key), key) == null) continue;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    @Override
    @NotNull
    public Set<String> merge(@NotNull Record record, @NotNull CacheHeaders cacheHeaders, @NotNull RecordMerger recordMerger) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        Intrinsics.checkNotNullParameter((Object)recordMerger, (String)"recordMerger");
        return this.wrapped.merge(record, cacheHeaders, recordMerger);
    }

    @Override
    @NotNull
    public Set<String> merge(@NotNull Collection<Record> records, @NotNull CacheHeaders cacheHeaders, @NotNull RecordMerger recordMerger) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        Intrinsics.checkNotNullParameter((Object)recordMerger, (String)"recordMerger");
        return this.wrapped.merge(records, cacheHeaders, recordMerger);
    }

    @Override
    public void clearAll() {
        this.wrapped.clearAll();
        this.recordJournals.clear();
    }

    @Override
    public boolean remove(@NotNull CacheKey cacheKey, boolean cascade) {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        boolean removed = this.wrapped.remove(cacheKey, cascade);
        RecordJournal recordJournal = this.recordJournals.get(cacheKey.getKey());
        if (recordJournal != null) {
            this.recordJournals.remove(cacheKey.getKey());
            removed = true;
            if (cascade) {
                for (CacheKey cacheReference : recordJournal.getCurrent().referencedFields()) {
                    this.remove(new CacheKey(cacheReference.getKey()), true);
                }
            }
        }
        return removed;
    }

    @Override
    public int remove(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        int removed = 0;
        removed = this.wrapped.remove(pattern);
        Regex regex = PatternToRegexKt.patternToRegex(pattern);
        HashSet keys2 = new HashSet(this.recordJournals.keySet());
        Iterable $this$forEach$iv = keys2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String key = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)key);
            if (!regex.matches((CharSequence)key)) continue;
            this.recordJournals.remove(key);
            ++removed;
        }
        return removed;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> addOptimisticUpdates(@NotNull Collection<Record> recordSet) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(recordSet, (String)"recordSet");
        Iterable $this$flatMap$iv = recordSet;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Record it = (Record)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.addOptimisticUpdate(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final Set<String> addOptimisticUpdate(@NotNull Record record) {
        Set<String> set;
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        RecordJournal journal = this.recordJournals.get(record.getKey());
        if (journal == null) {
            this.recordJournals.put(record.getKey(), new RecordJournal(record));
            set = record.fieldKeys();
        } else {
            set = journal.addPatch(record);
        }
        return set;
    }

    @NotNull
    public final Set<String> removeOptimisticUpdates(@NotNull UUID mutationId) {
        Intrinsics.checkNotNullParameter((Object)mutationId, (String)"mutationId");
        Set changedCacheKeys = new LinkedHashSet();
        HashSet keys2 = new HashSet(this.recordJournals.keySet());
        Iterable $this$forEach$iv = keys2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RecordJournal recordJournal;
            String it = (String)element$iv;
            boolean bl = false;
            if (this.recordJournals.get(it) == null) continue;
            RemovalResult result = recordJournal.removePatch(mutationId);
            changedCacheKeys.addAll((Collection)result.getChangedKeys());
            if (!result.isEmpty()) continue;
            this.recordJournals.remove(it);
        }
        return changedCacheKeys;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<KClass<?>, Map<String, Record>> dump() {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Map<String, RecordJournal> map = this.recordJournals;
        KClass kClass = Reflection.getOrCreateKotlinClass(this.getClass());
        boolean $i$f$mapValues = false;
        void var3_4 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            RecordJournal journal = (RecordJournal)entry2.getValue();
            Record record = journal.getCurrent();
            map3.put(k, record);
        }
        return MapsKt.plus((Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)kClass, (Object)destination$iv$iv)), this.wrapped.dump());
    }

    private final Record mergeJournalRecord(Record $this$mergeJournalRecord, String key) {
        Object object;
        RecordJournal journal = this.recordJournals.get(key);
        if (journal != null) {
            object = $this$mergeJournalRecord;
            if (object == null || (object = object.mergeWith(journal.getCurrent())) == null || (object = (Record)object.getFirst()) == null) {
                object = journal.getCurrent();
            }
        } else {
            object = $this$mergeJournalRecord;
        }
        return object;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0002\u001a\u00020\u0003J\u0012\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/apollographql/apollo3/cache/normalized/api/internal/OptimisticNormalizedCache$RecordJournal;", "", "record", "Lcom/apollographql/apollo3/cache/normalized/api/Record;", "(Lcom/apollographql/apollo3/cache/normalized/api/Record;)V", "current", "getCurrent", "()Lcom/apollographql/apollo3/cache/normalized/api/Record;", "setCurrent", "patches", "", "addPatch", "", "", "removePatch", "Lcom/apollographql/apollo3/cache/normalized/api/internal/OptimisticNormalizedCache$RemovalResult;", "mutationId", "Ljava/util/UUID;", "Lcom/benasher44/uuid/Uuid;", "apollo-normalized-cache-api-incubating"})
    @SourceDebugExtension(value={"SMAP\nOptimisticNormalizedCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptimisticNormalizedCache.kt\ncom/apollographql/apollo3/cache/normalized/api/internal/OptimisticNormalizedCache$RecordJournal\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n350#2,7:187\n*S KotlinDebug\n*F\n+ 1 OptimisticNormalizedCache.kt\ncom/apollographql/apollo3/cache/normalized/api/internal/OptimisticNormalizedCache$RecordJournal\n*L\n150#1:187,7\n*E\n"})
    private static final class RecordJournal {
        @NotNull
        private Record current;
        @NotNull
        private final List<Record> patches;

        public RecordJournal(@NotNull Record record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            this.current = record;
            Object[] objectArray = new Record[]{record};
            this.patches = CollectionsKt.mutableListOf((Object[])objectArray);
        }

        @NotNull
        public final Record getCurrent() {
            return this.current;
        }

        public final void setCurrent(@NotNull Record record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"<set-?>");
            this.current = record;
        }

        @NotNull
        public final Set<String> addPatch(@NotNull Record record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            Pair<Record, Set<String>> pair = this.current.mergeWith(record);
            Record mergedRecord = (Record)pair.component1();
            Set changedKeys = (Set)pair.component2();
            this.current = mergedRecord;
            this.patches.add(record);
            return changedKeys;
        }

        @NotNull
        public final RemovalResult removePatch(@NotNull UUID mutationId) {
            int start;
            int recordIndex;
            block5: {
                int n;
                Intrinsics.checkNotNullParameter((Object)mutationId, (String)"mutationId");
                List<Record> $this$indexOfFirst$iv = this.patches;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<Record> iterator2 = $this$indexOfFirst$iv.iterator();
                while (iterator2.hasNext()) {
                    Record item$iv;
                    Record it = item$iv = iterator2.next();
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)mutationId, (Object)it.getMutationId())) {
                        n = index$iv;
                        break block5;
                    }
                    ++index$iv;
                }
                n = recordIndex = -1;
            }
            if (recordIndex == -1) {
                return new RemovalResult(SetsKt.emptySet(), false);
            }
            if (this.patches.size() == 1) {
                return new RemovalResult(this.current.fieldKeys(), true);
            }
            Record oldRecord = this.current;
            this.patches.remove(recordIndex).getKey();
            Record cur = null;
            int n = this.patches.size();
            for (int i = start = Math.max(0, recordIndex - 1); i < n; ++i) {
                Record mergedRecord;
                Record record = this.patches.get(i);
                cur = cur == null ? record : (mergedRecord = (Record)cur.mergeWith(record).component1());
            }
            Record record = cur;
            Intrinsics.checkNotNull(record);
            this.current = record;
            return new RemovalResult(Record.Companion.changedKeys$apollo_normalized_cache_api_incubating(oldRecord, this.current), false);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/apollographql/apollo3/cache/normalized/api/internal/OptimisticNormalizedCache$RemovalResult;", "", "changedKeys", "", "", "isEmpty", "", "(Ljava/util/Set;Z)V", "getChangedKeys", "()Ljava/util/Set;", "()Z", "apollo-normalized-cache-api-incubating"})
    private static final class RemovalResult {
        @NotNull
        private final Set<String> changedKeys;
        private final boolean isEmpty;

        public RemovalResult(@NotNull Set<String> changedKeys, boolean isEmpty2) {
            Intrinsics.checkNotNullParameter(changedKeys, (String)"changedKeys");
            this.changedKeys = changedKeys;
            this.isEmpty = isEmpty2;
        }

        @NotNull
        public final Set<String> getChangedKeys() {
            return this.changedKeys;
        }

        public final boolean isEmpty() {
            return this.isEmpty;
        }
    }
}

