/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.normalized.api;

import com.apollographql.apollo3.annotations.ApolloExperimental;
import com.apollographql.apollo3.cache.normalized.api.CacheHeaders;
import com.apollographql.apollo3.cache.normalized.api.CacheKey;
import com.apollographql.apollo3.cache.normalized.api.ReadOnlyNormalizedCache;
import com.apollographql.apollo3.cache.normalized.api.Record;
import com.apollographql.apollo3.cache.normalized.api.RecordMerger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b&\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0000J\b\u0010\t\u001a\u00020\nH&J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&J&\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00152\u0006\u0010\u0010\u001a\u00020\u0011H&J,\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017H&J\u0010\u0010\u0016\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\rH&R\"\u0010\u0004\u001a\u0004\u0018\u00010\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0000@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001e"}, d2={"Lcom/apollographql/apollo3/cache/normalized/api/NormalizedCache;", "Lcom/apollographql/apollo3/cache/normalized/api/ReadOnlyNormalizedCache;", "()V", "<set-?>", "nextCache", "getNextCache", "()Lcom/apollographql/apollo3/cache/normalized/api/NormalizedCache;", "chain", "cache", "clearAll", "", "merge", "", "", "record", "Lcom/apollographql/apollo3/cache/normalized/api/Record;", "cacheHeaders", "Lcom/apollographql/apollo3/cache/normalized/api/CacheHeaders;", "recordMerger", "Lcom/apollographql/apollo3/cache/normalized/api/RecordMerger;", "records", "", "remove", "", "cacheKey", "Lcom/apollographql/apollo3/cache/normalized/api/CacheKey;", "cascade", "", "pattern", "Companion", "apollo-normalized-cache-api-incubating"})
public abstract class NormalizedCache
implements ReadOnlyNormalizedCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private NormalizedCache nextCache;
    @NotNull
    private static final String specialChars = "()^$.*?+{}";

    @Nullable
    public final NormalizedCache getNextCache() {
        return this.nextCache;
    }

    @NotNull
    public abstract Set<String> merge(@NotNull Record var1, @NotNull CacheHeaders var2);

    @NotNull
    public abstract Set<String> merge(@NotNull Collection<Record> var1, @NotNull CacheHeaders var2);

    @ApolloExperimental
    @NotNull
    public Set<String> merge(@NotNull Record record, @NotNull CacheHeaders cacheHeaders, @NotNull RecordMerger recordMerger) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        Intrinsics.checkNotNullParameter((Object)recordMerger, (String)"recordMerger");
        return this.merge(record, cacheHeaders);
    }

    @ApolloExperimental
    @NotNull
    public Set<String> merge(@NotNull Collection<Record> records, @NotNull CacheHeaders cacheHeaders, @NotNull RecordMerger recordMerger) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        Intrinsics.checkNotNullParameter((Object)recordMerger, (String)"recordMerger");
        return this.merge(records, cacheHeaders);
    }

    public abstract void clearAll();

    public abstract boolean remove(@NotNull CacheKey var1, boolean var2);

    public abstract int remove(@NotNull String var1);

    @NotNull
    public final NormalizedCache chain(@NotNull NormalizedCache cache) {
        NormalizedCache normalizedCache;
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        NormalizedCache $this$chain_u24lambda_u240 = normalizedCache = this;
        boolean bl = false;
        NormalizedCache leafCache = $this$chain_u24lambda_u240;
        while (leafCache.nextCache != null) {
            Intrinsics.checkNotNull((Object)leafCache.nextCache);
        }
        leafCache.nextCache = cache;
        return normalizedCache;
    }

    @JvmStatic
    @NotNull
    public static final String prettifyDump(@NotNull Map<KClass<?>, ? extends Map<String, Record>> dump) {
        return Companion.prettifyDump(dump);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J1\u0010\b\u001a\u00020\u00042'\u0010\t\u001a#\u0012\r\u0012\u000b\u0012\u0002\b\u00030\u000b\u00a2\u0006\u0002\b\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\n0\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/apollographql/apollo3/cache/normalized/api/NormalizedCache$Companion;", "", "()V", "specialChars", "", "patternToRegex", "Lkotlin/text/Regex;", "pattern", "prettifyDump", "dump", "", "Lkotlin/reflect/KClass;", "Lkotlin/jvm/JvmSuppressWildcards;", "Lcom/apollographql/apollo3/cache/normalized/api/Record;", "apollo-normalized-cache-api-incubating"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String prettifyDump(@NotNull Map<KClass<?>, ? extends Map<String, Record>> dump) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter(dump, (String)"dump");
            StringBuilder $this$prettifyDump_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            for (Map.Entry<KClass<?>, Map<String, Record>> entry : dump.entrySet()) {
                KClass<?> key = entry.getKey();
                Map<String, Record> value = entry.getValue();
                $this$prettifyDump_u24lambda_u240.append(key.getSimpleName()).append(" {");
                for (Map.Entry<String, Record> entry2 : value.entrySet()) {
                    String key1 = entry2.getKey();
                    Record value1 = entry2.getValue();
                    $this$prettifyDump_u24lambda_u240.append("\n  \"").append(key1).append("\" : {");
                    for (Map.Entry<String, Object> entry3 : value1.getFields().entrySet()) {
                        String key2 = entry3.getKey();
                        Object value2 = entry3.getValue();
                        $this$prettifyDump_u24lambda_u240.append("\n    \"").append(key2).append("\" : ");
                        Object object = value2;
                        if (object instanceof CacheKey) {
                            $this$prettifyDump_u24lambda_u240.append(value2);
                            continue;
                        }
                        if (object instanceof List) {
                            $this$prettifyDump_u24lambda_u240.append("[");
                            for (Object item : (List)value2) {
                                $this$prettifyDump_u24lambda_u240.append("\n      ").append(item);
                            }
                            $this$prettifyDump_u24lambda_u240.append("\n    ]");
                            continue;
                        }
                        $this$prettifyDump_u24lambda_u240.append(value2);
                    }
                    $this$prettifyDump_u24lambda_u240.append("\n  }\n");
                }
                $this$prettifyDump_u24lambda_u240.append("}\n");
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @NotNull
        public final Regex patternToRegex(@NotNull String pattern) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            StringBuilder $this$patternToRegex_u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl = false;
            boolean pendingEscape = false;
            int n = pattern.length();
            for (int i = 0; i < n; ++i) {
                char cur = pattern.charAt(i);
                if (pendingEscape) {
                    if (cur == '\\') {
                        $this$patternToRegex_u24lambda_u241.append("\\\\");
                        continue;
                    }
                    if (cur == '%') {
                        $this$patternToRegex_u24lambda_u241.append("%");
                        continue;
                    }
                    if (cur == '_') {
                        $this$patternToRegex_u24lambda_u241.append("_");
                        continue;
                    }
                    throw new IllegalStateException(("Invalid escape in pattern: " + pattern).toString());
                }
                if (cur == '\\') {
                    pendingEscape = true;
                    continue;
                }
                if (cur == '%') {
                    $this$patternToRegex_u24lambda_u241.append(".*");
                    continue;
                }
                if (cur == '_') {
                    $this$patternToRegex_u24lambda_u241.append(".");
                    continue;
                }
                if (StringsKt.contains$default((CharSequence)specialChars, (char)cur, (boolean)false, (int)2, null)) {
                    $this$patternToRegex_u24lambda_u241.append("\\");
                }
                $this$patternToRegex_u24lambda_u241.append(cur);
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String regex = string;
            return new Regex(regex, RegexOption.IGNORE_CASE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

