(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'apollo-kotlin-apollo-api-js-legacy', 'apollo-kotlin-apollo-mpp-utils-js-legacy', 'okio-parent-okio-js-legacy'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('apollo-kotlin-apollo-api-js-legacy'), require('apollo-kotlin-apollo-mpp-utils-js-legacy'), require('okio-parent-okio-js-legacy'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'apollo-kotlin-apollo-normalized-cache-api-incubating-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'apollo-kotlin-apollo-normalized-cache-api-incubating-js-legacy'.");
    }
    if (typeof this['apollo-kotlin-apollo-api-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'apollo-kotlin-apollo-normalized-cache-api-incubating-js-legacy'. Its dependency 'apollo-kotlin-apollo-api-js-legacy' was not found. Please, check whether 'apollo-kotlin-apollo-api-js-legacy' is loaded prior to 'apollo-kotlin-apollo-normalized-cache-api-incubating-js-legacy'.");
    }
    if (typeof this['apollo-kotlin-apollo-mpp-utils-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'apollo-kotlin-apollo-normalized-cache-api-incubating-js-legacy'. Its dependency 'apollo-kotlin-apollo-mpp-utils-js-legacy' was not found. Please, check whether 'apollo-kotlin-apollo-mpp-utils-js-legacy' is loaded prior to 'apollo-kotlin-apollo-normalized-cache-api-incubating-js-legacy'.");
    }
    if (typeof this['okio-parent-okio-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'apollo-kotlin-apollo-normalized-cache-api-incubating-js-legacy'. Its dependency 'okio-parent-okio-js-legacy' was not found. Please, check whether 'okio-parent-okio-js-legacy' is loaded prior to 'apollo-kotlin-apollo-normalized-cache-api-incubating-js-legacy'.");
    }
    root['apollo-kotlin-apollo-normalized-cache-api-incubating-js-legacy'] = factory(typeof this['apollo-kotlin-apollo-normalized-cache-api-incubating-js-legacy'] === 'undefined' ? {} : this['apollo-kotlin-apollo-normalized-cache-api-incubating-js-legacy'], kotlin, this['apollo-kotlin-apollo-api-js-legacy'], this['apollo-kotlin-apollo-mpp-utils-js-legacy'], this['okio-parent-okio-js-legacy']);
  }
}(this, function (_, Kotlin, $module$apollo_kotlin_apollo_api_js_legacy, $module$apollo_kotlin_apollo_mpp_utils_js_legacy, $module$okio_parent_okio_js_legacy) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var emptyMap = Kotlin.kotlin.collections.emptyMap_q3lmfv$;
  var LinkedHashMap_init = Kotlin.kotlin.collections.LinkedHashMap_init_q3lmfv$;
  var hashCode = Kotlin.hashCode;
  var equals = Kotlin.equals;
  var toList = Kotlin.kotlin.collections.toList_us0mfu$;
  var Regex_init = Kotlin.kotlin.text.Regex_init_61zpoe$;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  var StringBuilder_init = Kotlin.kotlin.text.StringBuilder_init;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var keyFields = $module$apollo_kotlin_apollo_api_js_legacy.com.apollographql.apollo3.api.keyFields_d50kdw$;
  var toString = Kotlin.toString;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var CompiledNotNullType = $module$apollo_kotlin_apollo_api_js_legacy.com.apollographql.apollo3.api.CompiledNotNullType;
  var CompiledNamedType = $module$apollo_kotlin_apollo_api_js_legacy.com.apollographql.apollo3.api.CompiledNamedType;
  var isComposite = $module$apollo_kotlin_apollo_api_js_legacy.com.apollographql.apollo3.api.isComposite_d50kdw$;
  var CompiledListType = $module$apollo_kotlin_apollo_api_js_legacy.com.apollographql.apollo3.api.CompiledListType;
  var CacheMissException_init = $module$apollo_kotlin_apollo_api_js_legacy.com.apollographql.apollo3.exception.CacheMissException_init_jyasbz$;
  var toLongOrNull = Kotlin.kotlin.text.toLongOrNull_pdl1vz$;
  var L0 = Kotlin.Long.ZERO;
  var Long$Companion$MAX_VALUE = Kotlin.Long.MAX_VALUE;
  var currentTimeMillis = $module$apollo_kotlin_apollo_mpp_utils_js_legacy.com.apollographql.apollo3.mpp.currentTimeMillis;
  var CacheMissException = $module$apollo_kotlin_apollo_api_js_legacy.com.apollographql.apollo3.exception.CacheMissException;
  var resolveVariables = $module$apollo_kotlin_apollo_api_js_legacy.com.apollographql.apollo3.api.resolveVariables_u8g08u$;
  var ArrayList_init_0 = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var Unit = Kotlin.kotlin.Unit;
  var HashSet_init = Kotlin.kotlin.collections.HashSet_init_mqih57$;
  var emptySet = Kotlin.kotlin.collections.emptySet_287e2$;
  var plus = Kotlin.kotlin.collections.plus_khz7k3$;
  var toSet = Kotlin.kotlin.collections.toSet_7wnvza$;
  var to = Kotlin.kotlin.to_ujzrz7$;
  var mapOf = Kotlin.kotlin.collections.mapOf_x2b85n$;
  var plus_0 = Kotlin.kotlin.collections.plus_iwxh38$;
  var L_1 = Kotlin.Long.NEG_ONE;
  var commonAsUtf8ToByteArray = $module$okio_parent_okio_js_legacy.okio.internal.commonAsUtf8ToByteArray_pdl1vz$;
  var addAll = Kotlin.kotlin.collections.addAll_ipc267$;
  var mapCapacity = Kotlin.kotlin.collections.mapCapacity_za3lpa$;
  var LinkedHashMap_init_0 = Kotlin.kotlin.collections.LinkedHashMap_init_bwtc7$;
  var Map = Kotlin.kotlin.collections.Map;
  var throwCCE = Kotlin.throwCCE;
  var List = Kotlin.kotlin.collections.List;
  var firstOrNull = Kotlin.kotlin.collections.firstOrNull_2p1efm$;
  var lastOrNull = Kotlin.kotlin.collections.lastOrNull_2p1efm$;
  var mapOf_0 = Kotlin.kotlin.collections.mapOf_qfcya0$;
  var coerceAtLeast = Kotlin.kotlin.ranges.coerceAtLeast_dqglrj$;
  var ensureNotNull = Kotlin.ensureNotNull;
  var get_indices = Kotlin.kotlin.text.get_indices_gw00vp$;
  var contains = Kotlin.kotlin.text.contains_sgbm27$;
  var RegexOption = Kotlin.kotlin.text.RegexOption;
  var Regex_init_0 = Kotlin.kotlin.text.Regex_init_sb3q2$;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var MapJsonWriter = $module$apollo_kotlin_apollo_api_js_legacy.com.apollographql.apollo3.api.json.MapJsonWriter;
  var variables = $module$apollo_kotlin_apollo_api_js_legacy.com.apollographql.apollo3.api.variables_x5dkxv$;
  var MapJsonReader = $module$apollo_kotlin_apollo_api_js_legacy.com.apollographql.apollo3.api.json.MapJsonReader;
  var toMutableList = Kotlin.kotlin.collections.toMutableList_4c7yge$;
  var intersect = Kotlin.kotlin.collections.intersect_q4559j$;
  var minus = Kotlin.kotlin.collections.minus_khz7k3$;
  var toMutableMap = Kotlin.kotlin.collections.toMutableMap_abgq59$;
  var plus_1 = Kotlin.kotlin.collections.plus_mydzjv$;
  var LinkedHashSet_init = Kotlin.kotlin.collections.LinkedHashSet_init_287e2$;
  var Buffer = $module$okio_parent_okio_js_legacy.okio.Buffer;
  var toDouble = Kotlin.kotlin.text.toDouble_pdl1vz$;
  var until = Kotlin.kotlin.ranges.until_dqglrj$;
  var CompiledField = $module$apollo_kotlin_apollo_api_js_legacy.com.apollographql.apollo3.api.CompiledField;
  var contains_0 = Kotlin.kotlin.collections.contains_2ws7j4$;
  var CompiledFragment = $module$apollo_kotlin_apollo_api_js_legacy.com.apollographql.apollo3.api.CompiledFragment;
  var first = Kotlin.kotlin.collections.first_2p1efm$;
  var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
  var toList_0 = Kotlin.kotlin.collections.toList_7wnvza$;
  var IllegalStateException_init_0 = Kotlin.kotlin.IllegalStateException_init;
  var plus_2 = Kotlin.kotlin.collections.plus_qloxvw$;
  var toMap = Kotlin.kotlin.collections.toMap_6hr0sd$;
  var checkIndexOverflow = Kotlin.kotlin.collections.checkIndexOverflow_za3lpa$;
  var BufferedSinkJsonWriter = $module$apollo_kotlin_apollo_api_js_legacy.com.apollographql.apollo3.api.json.BufferedSinkJsonWriter;
  var ByteString = $module$okio_parent_okio_js_legacy.okio.ByteString;
  var BufferedSourceJsonReader = $module$apollo_kotlin_apollo_api_js_legacy.com.apollographql.apollo3.api.json.BufferedSourceJsonReader;
  var readAny = $module$apollo_kotlin_apollo_api_js_legacy.com.apollographql.apollo3.api.json.readAny_ld4y5f$;
  var Throwable = Error;
  var addSuppressed = Kotlin.kotlin.addSuppressed_oh0dqn$;
  var Any = Object;
  var LinkedHashMap_init_1 = Kotlin.kotlin.collections.LinkedHashMap_init_xf5xz2$;
  var MutableMap = Kotlin.kotlin.collections.MutableMap;
  var RuntimeException_init = Kotlin.kotlin.RuntimeException_init_pdl1vj$;
  var ObjectType = $module$apollo_kotlin_apollo_api_js_legacy.com.apollographql.apollo3.api.ObjectType;
  var InterfaceType = $module$apollo_kotlin_apollo_api_js_legacy.com.apollographql.apollo3.api.InterfaceType;
  var Exception = Kotlin.kotlin.Exception;
  var mutableListOf = Kotlin.kotlin.collections.mutableListOf_i5x0yv$;
  var JsMath = Math;
  MemoryCache.prototype = Object.create(NormalizedCache.prototype);
  MemoryCache.prototype.constructor = MemoryCache;
  MemoryCacheFactory.prototype = Object.create(NormalizedCacheFactory.prototype);
  MemoryCacheFactory.prototype.constructor = MemoryCacheFactory;
  OptimisticCache.prototype = Object.create(NormalizedCache.prototype);
  OptimisticCache.prototype.constructor = OptimisticCache;
  function ApolloCacheHeaders() {
    ApolloCacheHeaders_instance = this;
    this.DO_NOT_STORE = 'do-not-store';
    this.EVICT_AFTER_READ = 'evict-after-read';
    this.DATE = 'apollo-date';
    this.MAX_STALE = 'apollo-max-stale';
    this.STORE_PARTIAL_RESPONSES = '';
  }
  ApolloCacheHeaders.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'ApolloCacheHeaders',
    interfaces: []
  };
  var ApolloCacheHeaders_instance = null;
  function ApolloCacheHeaders_getInstance() {
    if (ApolloCacheHeaders_instance === null) {
      new ApolloCacheHeaders();
    }
    return ApolloCacheHeaders_instance;
  }
  function CacheHeaders(headerMap) {
    CacheHeaders$Companion_getInstance();
    this.headerMap_0 = headerMap;
  }
  function CacheHeaders$Builder() {
    this.headerMap_0 = LinkedHashMap_init();
  }
  CacheHeaders$Builder.prototype.addHeader_puj7f4$ = function (headerName, headerValue) {
    this.headerMap_0.put_xwzc9p$(headerName, headerValue);
    return this;
  };
  CacheHeaders$Builder.prototype.addHeaders_y0zsll$ = function (headerMap) {
    this.headerMap_0.putAll_a2k3zr$(headerMap);
    return this;
  };
  CacheHeaders$Builder.prototype.build = function () {
    return new CacheHeaders(this.headerMap_0);
  };
  CacheHeaders$Builder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Builder',
    interfaces: []
  };
  CacheHeaders.prototype.toBuilder = function () {
    return this.newBuilder();
  };
  CacheHeaders.prototype.newBuilder = function () {
    return CacheHeaders$Companion_getInstance().builder().addHeaders_y0zsll$(this.headerMap_0);
  };
  CacheHeaders.prototype.headerValue_61zpoe$ = function (header) {
    return this.headerMap_0.get_11rb$(header);
  };
  CacheHeaders.prototype.hasHeader_61zpoe$ = function (headerName) {
    return this.headerMap_0.containsKey_11rb$(headerName);
  };
  function CacheHeaders$Companion() {
    CacheHeaders$Companion_instance = this;
    this.NONE = new CacheHeaders(emptyMap());
  }
  CacheHeaders$Companion.prototype.builder = function () {
    return new CacheHeaders$Builder();
  };
  CacheHeaders$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var CacheHeaders$Companion_instance = null;
  function CacheHeaders$Companion_getInstance() {
    if (CacheHeaders$Companion_instance === null) {
      new CacheHeaders$Companion();
    }
    return CacheHeaders$Companion_instance;
  }
  CacheHeaders.prototype.plus_f2tpx4$ = function (cacheHeaders) {
    return this.newBuilder().addHeaders_y0zsll$(cacheHeaders.headerMap_0).build();
  };
  CacheHeaders.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CacheHeaders',
    interfaces: []
  };
  function CacheKey(key) {
    CacheKey$Companion_getInstance();
    this.key = key;
  }
  CacheKey.prototype.hashCode = function () {
    return hashCode(this.key);
  };
  CacheKey.prototype.equals = function (other) {
    var tmp$, tmp$_0;
    return equals(this.key, (tmp$_0 = Kotlin.isType(tmp$ = other, CacheKey) ? tmp$ : null) != null ? tmp$_0.key : null);
  };
  CacheKey.prototype.toString = function () {
    return 'CacheKey(' + this.key + ')';
  };
  CacheKey.prototype.serialize = function () {
    return CacheKey$Companion_getInstance().SERIALIZATION_TEMPLATE_0 + '{' + this.key + '}';
  };
  function CacheKey$Companion() {
    CacheKey$Companion_instance = this;
    this.SERIALIZATION_REGEX_PATTERN_0 = Regex_init('ApolloCacheReference\\{(.*)\\}');
    this.SERIALIZATION_TEMPLATE_0 = 'ApolloCacheReference';
    this.ROOT_CACHE_KEY_0 = new CacheKey('QUERY_ROOT');
  }
  CacheKey$Companion.prototype.deserialize_61zpoe$ = function (serializedCacheKey) {
    var tmp$;
    var values = (tmp$ = this.SERIALIZATION_REGEX_PATTERN_0.matchEntire_6bul2c$(serializedCacheKey)) != null ? tmp$.groupValues : null;
    if (!(values != null && values.size > 1)) {
      var message = 'Not a cache reference: ' + serializedCacheKey + ' Must be of the form: ' + this.SERIALIZATION_TEMPLATE_0 + '{%s}';
      throw IllegalArgumentException_init(message.toString());
    }
    return new CacheKey(values.get_za3lpa$(1));
  };
  CacheKey$Companion.prototype.canDeserialize_61zpoe$ = function (value) {
    return this.SERIALIZATION_REGEX_PATTERN_0.matches_6bul2c$(value);
  };
  CacheKey$Companion.prototype.rootKey = function () {
    return this.ROOT_CACHE_KEY_0;
  };
  CacheKey$Companion.prototype.from_kwv3np$ = function (typename, values) {
    return CacheKey_init(typename, values);
  };
  CacheKey$Companion.prototype.from_60y5e1$ = function (typename, values) {
    return CacheKey_init(typename, toList(values));
  };
  CacheKey$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var CacheKey$Companion_instance = null;
  function CacheKey$Companion_getInstance() {
    if (CacheKey$Companion_instance === null) {
      new CacheKey$Companion();
    }
    return CacheKey$Companion_instance;
  }
  CacheKey.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CacheKey',
    interfaces: []
  };
  function CacheKey_init(typename, values, $this) {
    $this = $this || Object.create(CacheKey.prototype);
    var $receiver = StringBuilder_init();
    $receiver.append_pdl1vj$(typename);
    $receiver.append_pdl1vj$(':');
    var tmp$;
    tmp$ = values.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      $receiver.append_pdl1vj$(element);
    }
    CacheKey.call($this, $receiver.toString());
    return $this;
  }
  function CacheKey_init_0(typename, values, $this) {
    $this = $this || Object.create(CacheKey.prototype);
    CacheKey_init(typename, toList(values), $this);
    return $this;
  }
  function CacheKeyGenerator() {
  }
  CacheKeyGenerator.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'CacheKeyGenerator',
    interfaces: []
  };
  function CacheKeyGeneratorContext(field, variables) {
    this.field = field;
    this.variables = variables;
  }
  CacheKeyGeneratorContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CacheKeyGeneratorContext',
    interfaces: []
  };
  function TypePolicyCacheKeyGenerator() {
    TypePolicyCacheKeyGenerator_instance = this;
  }
  TypePolicyCacheKeyGenerator.prototype.cacheKeyForObject_bd1756$ = function (obj, context) {
    var tmp$;
    var keyFields_0 = keyFields(context.field.type.leafType());
    if (!keyFields_0.isEmpty()) {
      var tmp$_0 = toString(obj.get_11rb$('__typename'));
      var destination = ArrayList_init(collectionSizeOrDefault(keyFields_0, 10));
      var tmp$_1;
      tmp$_1 = keyFields_0.iterator();
      while (tmp$_1.hasNext()) {
        var item = tmp$_1.next();
        destination.add_11rb$(toString(obj.get_11rb$(item)));
      }
      tmp$ = CacheKey_init(tmp$_0, destination);
    } else {
      tmp$ = null;
    }
    return tmp$;
  };
  TypePolicyCacheKeyGenerator.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'TypePolicyCacheKeyGenerator',
    interfaces: [CacheKeyGenerator]
  };
  var TypePolicyCacheKeyGenerator_instance = null;
  function TypePolicyCacheKeyGenerator_getInstance() {
    if (TypePolicyCacheKeyGenerator_instance === null) {
      new TypePolicyCacheKeyGenerator();
    }
    return TypePolicyCacheKeyGenerator_instance;
  }
  function CacheKeyResolver() {
  }
  CacheKeyResolver.prototype.listOfCacheKeysForField_vzm0a4$ = function (field, variables) {
    return null;
  };
  CacheKeyResolver.prototype.resolveField_h2jtsx$ = function (field, variables, parent, parentId) {
    var type = field.type;
    if (Kotlin.isType(type, CompiledNotNullType)) {
      type = type.ofType;
    }
    if (Kotlin.isType(type, CompiledNamedType) && isComposite(type)) {
      var result = this.cacheKeyForField_vzm0a4$(field, variables);
      if (result != null) {
        return result;
      }
    }
    if (Kotlin.isType(type, CompiledListType)) {
      type = type.ofType;
      if (Kotlin.isType(type, CompiledNotNullType)) {
        type = type.ofType;
      }
      if (Kotlin.isType(type, CompiledNamedType) && isComposite(type)) {
        var result_0 = this.listOfCacheKeysForField_vzm0a4$(field, variables);
        if (result_0 != null) {
          return result_0;
        }
      }
    }
    return DefaultCacheResolver_getInstance().resolveField_h2jtsx$(field, variables, parent, parentId);
  };
  CacheKeyResolver.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CacheKeyResolver',
    interfaces: [CacheResolver]
  };
  function CacheResolver() {
  }
  CacheResolver.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'CacheResolver',
    interfaces: []
  };
  function ResolverContext(field, variables, parent, parentId, cacheHeaders) {
    this.field = field;
    this.variables = variables;
    this.parent = parent;
    this.parentId = parentId;
    this.cacheHeaders = cacheHeaders;
  }
  ResolverContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ResolverContext',
    interfaces: []
  };
  function ApolloResolver() {
  }
  ApolloResolver.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'ApolloResolver',
    interfaces: []
  };
  function DefaultCacheResolver() {
    DefaultCacheResolver_instance = this;
  }
  DefaultCacheResolver.prototype.resolveField_h2jtsx$ = function (field, variables, parent, parentId) {
    var name = field.nameWithArguments_mnmhg2$(variables);
    if (!parent.containsKey_11rb$(name)) {
      throw CacheMissException_init(parentId, name);
    }
    return parent.get_11rb$(name);
  };
  DefaultCacheResolver.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'DefaultCacheResolver',
    interfaces: [CacheResolver]
  };
  var DefaultCacheResolver_instance = null;
  function DefaultCacheResolver_getInstance() {
    if (DefaultCacheResolver_instance === null) {
      new DefaultCacheResolver();
    }
    return DefaultCacheResolver_instance;
  }
  function ReceiveDateApolloResolver(maxAge) {
    this.maxAge_0 = maxAge;
  }
  ReceiveDateApolloResolver.prototype.resolveField_5f759x$ = function (context) {
    var tmp$, tmp$_0, tmp$_1;
    var field = context.field;
    var parent = context.parent;
    var variables = context.variables;
    var parentId = context.parentId;
    var name = field.nameWithArguments_mnmhg2$(variables);
    if (!parent.containsKey_11rb$(name)) {
      throw CacheMissException_init(parentId, name);
    }
    if (Kotlin.isType(parent, Record)) {
      var lastUpdated = (tmp$ = parent.date) != null ? tmp$.get_11rb$(name) : null;
      if (lastUpdated != null) {
        var maxStale = (tmp$_1 = (tmp$_0 = context.cacheHeaders.headerValue_61zpoe$(ApolloCacheHeaders_getInstance().MAX_STALE)) != null ? toLongOrNull(tmp$_0) : null) != null ? tmp$_1 : L0;
        if (maxStale.compareTo_11rb$(Long$Companion$MAX_VALUE) < 0) {
          var age = currentTimeMillis().div(Kotlin.Long.fromInt(1000)).subtract(lastUpdated);
          if (Kotlin.Long.fromInt(this.maxAge_0).add(maxStale).subtract(age).toNumber() < 0) {
            throw new CacheMissException(parentId, name, true);
          }
        }
      }
    }
    return parent.get_11rb$(name);
  };
  ReceiveDateApolloResolver.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ReceiveDateApolloResolver',
    interfaces: [ApolloResolver]
  };
  function ExpireDateCacheResolver() {
  }
  ExpireDateCacheResolver.prototype.resolveField_h2jtsx$ = function (field, variables, parent, parentId) {
    var tmp$;
    var name = field.nameWithArguments_mnmhg2$(variables);
    if (!parent.containsKey_11rb$(name)) {
      throw CacheMissException_init(parentId, name);
    }
    if (Kotlin.isType(parent, Record)) {
      var expires = (tmp$ = parent.date) != null ? tmp$.get_11rb$(name) : null;
      if (expires != null) {
        if (currentTimeMillis().div(Kotlin.Long.fromInt(1000)).subtract(expires).toNumber() >= 0) {
          throw new CacheMissException(parentId, name, true);
        }
      }
    }
    return parent.get_11rb$(name);
  };
  ExpireDateCacheResolver.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ExpireDateCacheResolver',
    interfaces: [CacheResolver]
  };
  function FieldPolicyCacheResolver() {
    FieldPolicyCacheResolver_instance = this;
  }
  FieldPolicyCacheResolver.prototype.resolveField_h2jtsx$ = function (field, variables, parent, parentId) {
    var $receiver = field.arguments;
    var destination = ArrayList_init_0();
    var tmp$;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      if (element.isKey)
        destination.add_11rb$(element);
    }
    var destination_0 = ArrayList_init(collectionSizeOrDefault(destination, 10));
    var tmp$_0;
    tmp$_0 = destination.iterator();
    while (tmp$_0.hasNext()) {
      var item = tmp$_0.next();
      destination_0.add_11rb$(toString(resolveVariables(item.value, variables)));
    }
    var keyArgsValues = destination_0;
    if (!keyArgsValues.isEmpty()) {
      return CacheKey_init(field.type.leafType().name, keyArgsValues);
    }
    return DefaultCacheResolver_getInstance().resolveField_h2jtsx$(field, variables, parent, parentId);
  };
  FieldPolicyCacheResolver.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'FieldPolicyCacheResolver',
    interfaces: [CacheResolver]
  };
  var FieldPolicyCacheResolver_instance = null;
  function FieldPolicyCacheResolver_getInstance() {
    if (FieldPolicyCacheResolver_instance === null) {
      new FieldPolicyCacheResolver();
    }
    return FieldPolicyCacheResolver_instance;
  }
  function FieldPolicyApolloResolver() {
    FieldPolicyApolloResolver_instance = this;
  }
  FieldPolicyApolloResolver.prototype.resolveField_5f759x$ = function (context) {
    return FieldPolicyCacheResolver_getInstance().resolveField_h2jtsx$(context.field, context.variables, context.parent, context.parentId);
  };
  FieldPolicyApolloResolver.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'FieldPolicyApolloResolver',
    interfaces: [ApolloResolver]
  };
  var FieldPolicyApolloResolver_instance = null;
  function FieldPolicyApolloResolver_getInstance() {
    if (FieldPolicyApolloResolver_instance === null) {
      new FieldPolicyApolloResolver();
    }
    return FieldPolicyApolloResolver_instance;
  }
  function MemoryCache(maxSizeBytes, expireAfterMillis) {
    if (maxSizeBytes === void 0)
      maxSizeBytes = 2147483647;
    if (expireAfterMillis === void 0)
      expireAfterMillis = L_1;
    NormalizedCache.call(this);
    this.maxSizeBytes_0 = maxSizeBytes;
    this.expireAfterMillis_0 = expireAfterMillis;
    this.lock_0 = new CacheLock();
    this.lruCache_0 = new LruCache(this.maxSizeBytes_0, MemoryCache$lruCache$lambda);
  }
  Object.defineProperty(MemoryCache.prototype, 'size', {
    configurable: true,
    get: function () {
      return this.lruCache_0.size();
    }
  });
  function MemoryCache$loadRecord$lambda(this$MemoryCache, closure$key, closure$cacheHeaders) {
    return function () {
      var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3;
      var tmp$_4;
      if ((tmp$ = this$MemoryCache.lruCache_0.get_11rb$(closure$key)) != null) {
        var closure$cacheHeaders_0 = closure$cacheHeaders;
        var this$MemoryCache_0 = this$MemoryCache;
        var closure$key_0 = closure$key;
        if (tmp$.isExpired || closure$cacheHeaders_0.hasHeader_61zpoe$(ApolloCacheHeaders_getInstance().EVICT_AFTER_READ)) {
          this$MemoryCache_0.lruCache_0.remove_11rb$(closure$key_0);
        }
        tmp$_4 = tmp$;
      } else
        tmp$_4 = null;
      var cacheEntry = tmp$_4;
      var tmp$_5;
      if ((tmp$_3 = (tmp$_0 = cacheEntry != null ? !cacheEntry.isExpired ? cacheEntry : null : null) != null ? tmp$_0.record : null) != null)
        tmp$_5 = tmp$_3;
      else {
        var tmp$_6;
        if ((tmp$_2 = (tmp$_1 = this$MemoryCache.nextCache) != null ? tmp$_1.loadRecord_74n6a2$(closure$key, closure$cacheHeaders) : null) != null) {
          var this$MemoryCache_1 = this$MemoryCache;
          this$MemoryCache_1.lruCache_0.set_xwzc9p$(closure$key, new MemoryCache$CacheEntry(tmp$_2, this$MemoryCache_1.expireAfterMillis_0));
          tmp$_6 = tmp$_2;
        } else
          tmp$_6 = null;
        tmp$_5 = tmp$_6;
      }
      return tmp$_5;
    };
  }
  MemoryCache.prototype.loadRecord_74n6a2$ = function (key, cacheHeaders) {
    return this.lock_0.lock_klfg04$(MemoryCache$loadRecord$lambda(this, key, cacheHeaders));
  };
  MemoryCache.prototype.loadRecords_pa6ebj$ = function (keys, cacheHeaders) {
    var destination = ArrayList_init_0();
    var tmp$;
    tmp$ = keys.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var tmp$_0;
      if ((tmp$_0 = this.loadRecord_74n6a2$(element, cacheHeaders)) != null) {
        destination.add_11rb$(tmp$_0);
      }
    }
    return destination;
  };
  MemoryCache.prototype.clearAll = function () {
    var tmp$;
    this.lruCache_0.clear();
    (tmp$ = this.nextCache) != null ? (tmp$.clearAll(), Unit) : null;
  };
  MemoryCache.prototype.remove_gmcrai$ = function (cacheKey, cascade) {
    var tmp$, tmp$_0, tmp$_1;
    var cacheEntry = this.lruCache_0.remove_11rb$(cacheKey.key);
    if (cascade && cacheEntry != null) {
      tmp$ = cacheEntry.record.referencedFields().iterator();
      while (tmp$.hasNext()) {
        var cacheReference = tmp$.next();
        this.remove_gmcrai$(new CacheKey(cacheReference.key), true);
      }
    }
    var chainRemoved = (tmp$_1 = (tmp$_0 = this.nextCache) != null ? tmp$_0.remove_gmcrai$(cacheKey, cascade) : null) != null ? tmp$_1 : false;
    return cacheEntry != null || chainRemoved;
  };
  MemoryCache.prototype.remove_61zpoe$ = function (pattern) {
    var tmp$, tmp$_0;
    var regex = NormalizedCache$Companion_getInstance().patternToRegex_61zpoe$(pattern);
    var total = {v: 0};
    var keys = HashSet_init(this.lruCache_0.keys());
    var tmp$_1;
    tmp$_1 = keys.iterator();
    while (tmp$_1.hasNext()) {
      var element = tmp$_1.next();
      if (regex.matches_6bul2c$(element)) {
        this.lruCache_0.remove_11rb$(element);
        total.v = total.v + 1 | 0;
      }
    }
    var chainRemoved = (tmp$_0 = (tmp$ = this.nextCache) != null ? tmp$.remove_61zpoe$(pattern) : null) != null ? tmp$_0 : 0;
    return total.v + chainRemoved | 0;
  };
  MemoryCache.prototype.merge_3uj6of$ = function (record, cacheHeaders) {
    return this.merge_kw21vg$(record, cacheHeaders, DefaultRecordMerger_getInstance());
  };
  MemoryCache.prototype.merge_qfx2x4$ = function (records, cacheHeaders) {
    return this.merge_jot6vf$(records, cacheHeaders, DefaultRecordMerger_getInstance());
  };
  MemoryCache.prototype.merge_kw21vg$ = function (record, cacheHeaders, recordMerger) {
    var tmp$, tmp$_0;
    if (cacheHeaders.hasHeader_61zpoe$(ApolloCacheHeaders_getInstance().DO_NOT_STORE)) {
      return emptySet();
    }
    var oldRecord = this.loadRecord_74n6a2$(record.key, cacheHeaders);
    if (oldRecord == null) {
      this.lruCache_0.set_xwzc9p$(record.key, new MemoryCache$CacheEntry(record, this.expireAfterMillis_0));
      tmp$ = record.fieldKeys();
    } else {
      var tmp$_1 = recordMerger.merge_vutog4$(oldRecord, record, null);
      var mergedRecord = tmp$_1.component1()
      , changedKeys = tmp$_1.component2();
      this.lruCache_0.set_xwzc9p$(record.key, new MemoryCache$CacheEntry(mergedRecord, this.expireAfterMillis_0));
      tmp$ = changedKeys;
    }
    var changedKeys_0 = tmp$;
    var $receiver = (tmp$_0 = this.nextCache) != null ? tmp$_0.merge_kw21vg$(record, cacheHeaders, recordMerger) : null;
    return plus(changedKeys_0, $receiver != null ? $receiver : emptySet());
  };
  MemoryCache.prototype.merge_jot6vf$ = function (records, cacheHeaders, recordMerger) {
    if (cacheHeaders.hasHeader_61zpoe$(ApolloCacheHeaders_getInstance().DO_NOT_STORE)) {
      return emptySet();
    }
    var destination = ArrayList_init_0();
    var tmp$;
    tmp$ = records.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var list = this.merge_kw21vg$(element, cacheHeaders, recordMerger);
      addAll(destination, list);
    }
    return toSet(destination);
  };
  MemoryCache.prototype.dump = function () {
    var tmp$, tmp$_0;
    var tmp$_1 = Kotlin.getKClassFromExpression(this);
    var $receiver = this.lruCache_0.dump();
    var destination = LinkedHashMap_init_0(mapCapacity($receiver.size));
    var tmp$_2;
    tmp$_2 = $receiver.entries.iterator();
    while (tmp$_2.hasNext()) {
      var element = tmp$_2.next();
      var tmp$_3 = destination.put_xwzc9p$;
      var tmp$_4 = element.key;
      var entry = element.value;
      tmp$_3.call(destination, tmp$_4, entry.record);
    }
    tmp$_0 = mapOf(to(tmp$_1, destination));
    var $receiver_0 = (tmp$ = this.nextCache) != null ? tmp$.dump() : null;
    return plus_0(tmp$_0, $receiver_0 != null ? $receiver_0 : emptyMap());
  };
  MemoryCache.prototype.clearCurrentCache_8be2vx$ = function () {
    this.lruCache_0.clear();
  };
  function MemoryCache$CacheEntry(record, expireAfterMillis) {
    this.record = record;
    this.expireAfterMillis = expireAfterMillis;
    this.cachedAtMillis = currentTimeMillis();
    this.sizeInBytes = this.record.sizeInBytes + 8 | 0;
  }
  Object.defineProperty(MemoryCache$CacheEntry.prototype, 'isExpired', {
    configurable: true,
    get: function () {
      var tmp$;
      if (this.expireAfterMillis.toNumber() < 0) {
        tmp$ = false;
      } else {
        tmp$ = currentTimeMillis().subtract(this.cachedAtMillis).compareTo_11rb$(this.expireAfterMillis) >= 0;
      }
      return tmp$;
    }
  });
  MemoryCache$CacheEntry.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CacheEntry',
    interfaces: []
  };
  function MemoryCache$lruCache$lambda(key, cacheEntry) {
    var tmp$;
    return commonAsUtf8ToByteArray(key).length + ((tmp$ = cacheEntry != null ? cacheEntry.sizeInBytes : null) != null ? tmp$ : 0) | 0;
  }
  MemoryCache.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MemoryCache',
    interfaces: [NormalizedCache]
  };
  function MemoryCacheFactory(maxSizeBytes, expireAfterMillis) {
    if (maxSizeBytes === void 0)
      maxSizeBytes = 2147483647;
    if (expireAfterMillis === void 0)
      expireAfterMillis = L_1;
    NormalizedCacheFactory.call(this);
    this.maxSizeBytes_0 = maxSizeBytes;
    this.expireAfterMillis_0 = expireAfterMillis;
  }
  MemoryCacheFactory.prototype.create = function () {
    return new MemoryCache(this.maxSizeBytes_0, this.expireAfterMillis_0);
  };
  MemoryCacheFactory.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MemoryCacheFactory',
    interfaces: [NormalizedCacheFactory]
  };
  function MetadataGenerator() {
  }
  MetadataGenerator.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'MetadataGenerator',
    interfaces: []
  };
  function MetadataGeneratorContext(field, variables) {
    this.field = field;
    this.variables = variables;
  }
  MetadataGeneratorContext.prototype.argumentValue_61zpoe$ = function (argumentName) {
    return this.field.resolveArgument_9t1q4g$(argumentName, this.variables);
  };
  MetadataGeneratorContext.prototype.allArgumentValues = function () {
    var $receiver = this.field.arguments;
    var capacity = coerceAtLeast(mapCapacity(collectionSizeOrDefault($receiver, 10)), 16);
    var destination = LinkedHashMap_init_0(capacity);
    var tmp$;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var pair = to(element.name, this.argumentValue_61zpoe$(element.name));
      destination.put_xwzc9p$(pair.first, pair.second);
    }
    return destination;
  };
  MetadataGeneratorContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MetadataGeneratorContext',
    interfaces: []
  };
  function EmptyMetadataGenerator() {
    EmptyMetadataGenerator_instance = this;
  }
  EmptyMetadataGenerator.prototype.metadataForObject_wv82oj$ = function (obj, context) {
    return emptyMap();
  };
  EmptyMetadataGenerator.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'EmptyMetadataGenerator',
    interfaces: [MetadataGenerator]
  };
  var EmptyMetadataGenerator_instance = null;
  function EmptyMetadataGenerator_getInstance() {
    if (EmptyMetadataGenerator_instance === null) {
      new EmptyMetadataGenerator();
    }
    return EmptyMetadataGenerator_instance;
  }
  function ConnectionMetadataGenerator(connectionTypes) {
    this.connectionTypes_0 = connectionTypes;
  }
  ConnectionMetadataGenerator.prototype.metadataForObject_wv82oj$ = function (obj, context) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4;
    if (this.connectionTypes_0.contains_11rb$(context.field.type.leafType().name)) {
      Kotlin.isType(tmp$ = obj, Map) ? tmp$ : throwCCE();
      var edges = Kotlin.isType(tmp$_0 = obj.get_11rb$('edges'), List) ? tmp$_0 : throwCCE();
      var startCursor = (tmp$_2 = (tmp$_1 = firstOrNull(edges)) != null ? tmp$_1.get_11rb$('cursor') : null) == null || typeof tmp$_2 === 'string' ? tmp$_2 : throwCCE();
      var endCursor = (tmp$_4 = (tmp$_3 = lastOrNull(edges)) != null ? tmp$_3.get_11rb$('cursor') : null) == null || typeof tmp$_4 === 'string' ? tmp$_4 : throwCCE();
      return mapOf_0([to('startCursor', startCursor), to('endCursor', endCursor), to('before', context.argumentValue_61zpoe$('before')), to('after', context.argumentValue_61zpoe$('after'))]);
    }
    return emptyMap();
  };
  ConnectionMetadataGenerator.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ConnectionMetadataGenerator',
    interfaces: [MetadataGenerator]
  };
  function NormalizedCache() {
    NormalizedCache$Companion_getInstance();
    this.nextCache_i6iwym$_0 = null;
  }
  Object.defineProperty(NormalizedCache.prototype, 'nextCache', {
    configurable: true,
    get: function () {
      return this.nextCache_i6iwym$_0;
    },
    set: function (nextCache) {
      this.nextCache_i6iwym$_0 = nextCache;
    }
  });
  NormalizedCache.prototype.merge_kw21vg$ = function (record, cacheHeaders, recordMerger) {
    return this.merge_3uj6of$(record, cacheHeaders);
  };
  NormalizedCache.prototype.merge_jot6vf$ = function (records, cacheHeaders, recordMerger) {
    return this.merge_qfx2x4$(records, cacheHeaders);
  };
  NormalizedCache.prototype.chain_4wqkc7$ = function (cache) {
    var leafCache = this;
    while (leafCache.nextCache != null) {
      leafCache = ensureNotNull(leafCache.nextCache);
    }
    leafCache.nextCache = cache;
    return this;
  };
  function NormalizedCache$Companion() {
    NormalizedCache$Companion_instance = this;
    this.specialChars_0 = '()^$.*?+{}';
  }
  NormalizedCache$Companion.prototype.prettifyDump_e5fz4s$ = function (dump) {
    var $receiver = StringBuilder_init();
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    tmp$ = dump.entries.iterator();
    while (tmp$.hasNext()) {
      var tmp$_3 = tmp$.next();
      var key = tmp$_3.key;
      var value = tmp$_3.value;
      $receiver.append_pdl1vj$(key.simpleName).append_pdl1vj$(' {');
      tmp$_0 = value.entries.iterator();
      while (tmp$_0.hasNext()) {
        var tmp$_4 = tmp$_0.next();
        var key1 = tmp$_4.key;
        var value1 = tmp$_4.value;
        $receiver.append_pdl1vj$('\n  "').append_pdl1vj$(key1).append_pdl1vj$('" : {');
        tmp$_1 = value1.fields.entries.iterator();
        while (tmp$_1.hasNext()) {
          var tmp$_5 = tmp$_1.next();
          var key2 = tmp$_5.key;
          var value2 = tmp$_5.value;
          $receiver.append_pdl1vj$('\n    "').append_pdl1vj$(key2).append_pdl1vj$('" : ');
          if (Kotlin.isType(value2, CacheKey))
            $receiver.append_s8jyv4$(value2);
          else if (Kotlin.isType(value2, List)) {
            $receiver.append_pdl1vj$('[');
            tmp$_2 = value2.iterator();
            while (tmp$_2.hasNext()) {
              var item = tmp$_2.next();
              $receiver.append_pdl1vj$('\n      ').append_s8jyv4$(item);
            }
            $receiver.append_pdl1vj$('\n    ]');
          } else
            $receiver.append_s8jyv4$(value2);
        }
        $receiver.append_pdl1vj$('\n  }\n');
      }
      $receiver.append_pdl1vj$('}\n');
    }
    return $receiver.toString();
  };
  NormalizedCache$Companion.prototype.patternToRegex_61zpoe$ = function (pattern) {
    var $receiver = StringBuilder_init();
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    var pendingEscape = false;
    tmp$ = get_indices(pattern);
    tmp$_0 = tmp$.first;
    tmp$_1 = tmp$.last;
    tmp$_2 = tmp$.step;
    for (var i = tmp$_0; i <= tmp$_1; i += tmp$_2) {
      var cur = pattern.charCodeAt(i);
      if (pendingEscape)
        if (cur === 92)
          $receiver.append_pdl1vj$('\\\\');
        else if (cur === 37)
          $receiver.append_pdl1vj$('%');
        else if (cur === 95)
          $receiver.append_pdl1vj$('_');
        else {
          throw IllegalStateException_init(('Invalid escape in pattern: ' + pattern).toString());
        }
       else if (cur === 92)
        pendingEscape = true;
      else if (cur === 37)
        $receiver.append_pdl1vj$('.*');
      else if (cur === 95)
        $receiver.append_pdl1vj$('.');
      else {
        if (contains(this.specialChars_0, cur)) {
          $receiver.append_pdl1vj$('\\');
        }
        $receiver.append_s8itvh$(cur);
      }
    }
    var regex = $receiver.toString();
    return Regex_init_0(regex, RegexOption.IGNORE_CASE);
  };
  NormalizedCache$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var NormalizedCache$Companion_instance = null;
  function NormalizedCache$Companion_getInstance() {
    if (NormalizedCache$Companion_instance === null) {
      new NormalizedCache$Companion();
    }
    return NormalizedCache$Companion_instance;
  }
  NormalizedCache.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'NormalizedCache',
    interfaces: [ReadOnlyNormalizedCache]
  };
  function NormalizedCacheFactory() {
    this.nextFactory_jggc1u$_0 = null;
  }
  NormalizedCacheFactory.prototype.createChain = function () {
    var tmp$;
    var nextFactory = this.nextFactory_jggc1u$_0;
    if (nextFactory != null) {
      tmp$ = this.create().chain_4wqkc7$(nextFactory.createChain());
    } else {
      tmp$ = this.create();
    }
    return tmp$;
  };
  NormalizedCacheFactory.prototype.chain_bze2r1$ = function (factory) {
    var leafFactory = this;
    while (leafFactory.nextFactory_jggc1u$_0 != null) {
      leafFactory = ensureNotNull(leafFactory.nextFactory_jggc1u$_0);
    }
    leafFactory.nextFactory_jggc1u$_0 = factory;
    return this;
  };
  NormalizedCacheFactory.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'NormalizedCacheFactory',
    interfaces: []
  };
  function normalize($receiver, data, customScalarAdapters, cacheKeyGenerator) {
    return normalize_2($receiver, data, customScalarAdapters, cacheKeyGenerator, EmptyMetadataGenerator_getInstance(), CacheKey$Companion_getInstance().rootKey().key);
  }
  function normalize_0($receiver, data, customScalarAdapters, cacheKeyGenerator, metadataGenerator) {
    return normalize_2($receiver, data, customScalarAdapters, cacheKeyGenerator, metadataGenerator, CacheKey$Companion_getInstance().rootKey().key);
  }
  function normalize_1($receiver, data, customScalarAdapters, cacheKeyGenerator, rootKey) {
    var tmp$;
    var writer = new MapJsonWriter();
    $receiver.adapter().toJson_dotswr$(writer, customScalarAdapters, data);
    var variables_0 = variables($receiver, customScalarAdapters);
    return (new Normalizer(variables_0, rootKey, cacheKeyGenerator, EmptyMetadataGenerator_getInstance())).normalize_nacnkl$(Kotlin.isType(tmp$ = writer.root(), Map) ? tmp$ : throwCCE(), $receiver.rootField().selections, $receiver.rootField().type.leafType());
  }
  function normalize_2($receiver, data, customScalarAdapters, cacheKeyGenerator, metadataGenerator, rootKey) {
    var tmp$;
    var writer = new MapJsonWriter();
    $receiver.adapter().toJson_dotswr$(writer, customScalarAdapters, data);
    var variables_0 = variables($receiver, customScalarAdapters);
    return (new Normalizer(variables_0, rootKey, cacheKeyGenerator, metadataGenerator)).normalize_nacnkl$(Kotlin.isType(tmp$ = writer.root(), Map) ? tmp$ : throwCCE(), $receiver.rootField().selections, $receiver.rootField().type.leafType());
  }
  function readDataFromCache($receiver, customScalarAdapters, cache, cacheResolver, cacheHeaders) {
    return readInternal($receiver, CacheKey$Companion_getInstance().rootKey(), customScalarAdapters, cache, cacheResolver, cacheHeaders);
  }
  function readDataFromCache_0($receiver, cacheKey, customScalarAdapters, cache, cacheResolver, cacheHeaders) {
    return readInternal($receiver, cacheKey, customScalarAdapters, cache, cacheResolver, cacheHeaders);
  }
  function readDataFromCache_1($receiver, cacheKey, customScalarAdapters, cache, cacheResolver, cacheHeaders) {
    return readInternal($receiver, cacheKey, customScalarAdapters, cache, cacheResolver, cacheHeaders);
  }
  function readDataFromCache_2($receiver, cacheKey, customScalarAdapters, cache, cacheResolver, cacheHeaders) {
    return readInternal($receiver, cacheKey, customScalarAdapters, cache, cacheResolver, cacheHeaders);
  }
  function readInternal($receiver, cacheKey, customScalarAdapters, cache, cacheResolver, cacheHeaders) {
    var map = (new CacheBatchReader(cache, cacheKey.key, variables($receiver, customScalarAdapters), cacheResolver, cacheHeaders, $receiver.rootField().selections, $receiver.rootField().type.leafType().name)).toMap();
    var reader = new MapJsonReader(map);
    return $receiver.adapter().fromJson_p35aje$(reader, customScalarAdapters);
  }
  function dependentKeys($receiver) {
    var tmp$, tmp$_0;
    var tmp$_1;
    if ($receiver != null) {
      var destination = ArrayList_init_0();
      var tmp$_2;
      tmp$_2 = $receiver.iterator();
      while (tmp$_2.hasNext()) {
        var element = tmp$_2.next();
        var list = element.fieldKeys();
        addAll(destination, list);
      }
      tmp$_1 = destination;
    } else
      tmp$_1 = null;
    return (tmp$_0 = (tmp$ = tmp$_1) != null ? toSet(tmp$) : null) != null ? tmp$_0 : emptySet();
  }
  function ReadOnlyNormalizedCache() {
  }
  ReadOnlyNormalizedCache.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'ReadOnlyNormalizedCache',
    interfaces: []
  };
  function Record(key, fields, mutationId) {
    Record$Companion_getInstance();
    if (mutationId === void 0)
      mutationId = null;
    this.key = key;
    this.fields = fields;
    this.mutationId = mutationId;
    this.date_ik1epp$_0 = null;
    this.metadata_mtfmg2$_0 = emptyMap();
  }
  Object.defineProperty(Record.prototype, 'date', {
    configurable: true,
    get: function () {
      return this.date_ik1epp$_0;
    },
    set: function (date) {
      this.date_ik1epp$_0 = date;
    }
  });
  Object.defineProperty(Record.prototype, 'metadata', {
    configurable: true,
    get: function () {
      return this.metadata_mtfmg2$_0;
    },
    set: function (metadata) {
      this.metadata_mtfmg2$_0 = metadata;
    }
  });
  Object.defineProperty(Record.prototype, 'sizeInBytes', {
    configurable: true,
    get: function () {
      var tmp$, tmp$_0, tmp$_1;
      var datesSize = (tmp$_1 = (tmp$_0 = (tmp$ = this.date) != null ? tmp$.size : null) != null ? tmp$_0 * 8 | 0 : null) != null ? tmp$_1 : 0;
      return RecordWeigher_getInstance().calculateBytes_5ualzv$(this) + datesSize | 0;
    }
  });
  Record.prototype.mergeWith_5ualzv$ = function (newRecord) {
    return DefaultRecordMerger_getInstance().merge_vutog4$(this, newRecord, null);
  };
  Record.prototype.fieldKeys = function () {
    var $receiver = this.fields.keys;
    var destination = ArrayList_init(collectionSizeOrDefault($receiver, 10));
    var tmp$;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(this.key + '.' + item);
    }
    return toSet(destination);
  };
  Record.prototype.referencedFields = function () {
    var result = ArrayList_init_0();
    var stack = toMutableList(this.fields.values);
    while (!stack.isEmpty()) {
      var value = stack.removeAt_za3lpa$(stack.size - 1 | 0);
      if (Kotlin.isType(value, CacheKey))
        result.add_11rb$(value);
      else if (Kotlin.isType(value, Map))
        stack.addAll_brywnq$(value.values);
      else if (Kotlin.isType(value, List))
        stack.addAll_brywnq$(value);
    }
    return result;
  };
  function Record$Companion() {
    Record$Companion_instance = this;
  }
  Record$Companion.prototype.changedKeys_dz30kh$ = function (record1, record2) {
    if (!equals(record1.key, record2.key)) {
      var message = "Cannot compute changed keys on record with different keys: '" + record1.key + "' - '" + record2.key + "'";
      throw IllegalStateException_init(message.toString());
    }
    var keys1 = record1.fields.keys;
    var keys2 = record2.fields.keys;
    var intersection = intersect(keys1, keys2);
    var tmp$ = plus(minus(keys1, intersection), minus(keys2, intersection));
    var destination = ArrayList_init_0();
    var tmp$_0;
    tmp$_0 = intersection.iterator();
    while (tmp$_0.hasNext()) {
      var element = tmp$_0.next();
      if (!equals(record1.fields.get_11rb$(element), record2.fields.get_11rb$(element)))
        destination.add_11rb$(element);
    }
    var changed = plus(tmp$, destination);
    var destination_0 = ArrayList_init(collectionSizeOrDefault(changed, 10));
    var tmp$_1;
    tmp$_1 = changed.iterator();
    while (tmp$_1.hasNext()) {
      var item = tmp$_1.next();
      destination_0.add_11rb$(record1.key + '.' + item);
    }
    return toSet(destination_0);
  };
  Record$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Record$Companion_instance = null;
  function Record$Companion_getInstance() {
    if (Record$Companion_instance === null) {
      new Record$Companion();
    }
    return Record$Companion_instance;
  }
  Object.defineProperty(Record.prototype, 'entries', {
    configurable: true,
    get: function () {
      return this.fields.entries;
    }
  });
  Object.defineProperty(Record.prototype, 'keys', {
    configurable: true,
    get: function () {
      return this.fields.keys;
    }
  });
  Object.defineProperty(Record.prototype, 'size', {
    configurable: true,
    get: function () {
      return this.fields.size;
    }
  });
  Object.defineProperty(Record.prototype, 'values', {
    configurable: true,
    get: function () {
      return this.fields.values;
    }
  });
  Record.prototype.containsKey_11rb$ = function (key) {
    return this.fields.containsKey_11rb$(key);
  };
  Record.prototype.containsValue_11rc$ = function (value) {
    return this.fields.containsValue_11rc$(value);
  };
  Record.prototype.get_11rb$ = function (key) {
    return this.fields.get_11rb$(key);
  };
  Record.prototype.isEmpty = function () {
    return this.fields.isEmpty();
  };
  Record.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Record',
    interfaces: [Map]
  };
  function Record_init(key, fields, mutationId, date, metadata, $this) {
    $this = $this || Object.create(Record.prototype);
    Record.call($this, key, fields, mutationId);
    $this.date = date;
    $this.metadata = metadata;
    return $this;
  }
  function RecordFieldJsonAdapter() {
    RecordFieldJsonAdapter_instance = this;
  }
  RecordFieldJsonAdapter.prototype.fromJson_61zpoe$ = function (jsonFieldSource) {
    return JsonRecordSerializer_getInstance().deserialize_puj7f4$('', jsonFieldSource).fields;
  };
  RecordFieldJsonAdapter.prototype.toJson_zb9t9x$ = function (fields) {
    return JsonRecordSerializer_getInstance().serialize_5ualzv$(new Record('', fields));
  };
  RecordFieldJsonAdapter.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'RecordFieldJsonAdapter',
    interfaces: []
  };
  var RecordFieldJsonAdapter_instance = null;
  function RecordFieldJsonAdapter_getInstance() {
    if (RecordFieldJsonAdapter_instance === null) {
      new RecordFieldJsonAdapter();
    }
    return RecordFieldJsonAdapter_instance;
  }
  function RecordMerger() {
  }
  RecordMerger.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'RecordMerger',
    interfaces: []
  };
  function DefaultRecordMerger() {
    DefaultRecordMerger_instance = this;
  }
  DefaultRecordMerger.prototype.merge_vutog4$ = function (existing, incoming, newDate) {
    var tmp$, tmp$_0, tmp$_1;
    var changedKeys = LinkedHashSet_init();
    var mergedFields = toMutableMap(existing.fields);
    var date = (tmp$_0 = (tmp$ = existing.date) != null ? toMutableMap(tmp$) : null) != null ? tmp$_0 : LinkedHashMap_init();
    tmp$_1 = incoming.fields.entries.iterator();
    while (tmp$_1.hasNext()) {
      var tmp$_2 = tmp$_1.next();
      var fieldKey = tmp$_2.key;
      var incomingFieldValue = tmp$_2.value;
      var hasExistingFieldValue = existing.fields.containsKey_11rb$(fieldKey);
      var existingFieldValue = existing.fields.get_11rb$(fieldKey);
      if (!hasExistingFieldValue || !equals(existingFieldValue, incomingFieldValue)) {
        mergedFields.put_xwzc9p$(fieldKey, incomingFieldValue);
        changedKeys.add_11rb$(existing.key + '.' + fieldKey);
      }
      if (newDate != null) {
        date.put_xwzc9p$(fieldKey, newDate);
      }
    }
    return to(Record_init(existing.key, mergedFields, incoming.mutationId, date, plus_0(existing.metadata, incoming.metadata)), changedKeys);
  };
  DefaultRecordMerger.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'DefaultRecordMerger',
    interfaces: [RecordMerger]
  };
  var DefaultRecordMerger_instance = null;
  function DefaultRecordMerger_getInstance() {
    if (DefaultRecordMerger_instance === null) {
      new DefaultRecordMerger();
    }
    return DefaultRecordMerger_instance;
  }
  function FieldRecordMerger(fieldMerger) {
    this.fieldMerger_0 = fieldMerger;
  }
  function FieldRecordMerger$FieldMerger() {
  }
  FieldRecordMerger$FieldMerger.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'FieldMerger',
    interfaces: []
  };
  function FieldRecordMerger$FieldInfo(value, metadata) {
    this.value = value;
    this.metadata = metadata;
  }
  FieldRecordMerger$FieldInfo.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FieldInfo',
    interfaces: []
  };
  FieldRecordMerger$FieldInfo.prototype.component1 = function () {
    return this.value;
  };
  FieldRecordMerger$FieldInfo.prototype.component2 = function () {
    return this.metadata;
  };
  FieldRecordMerger$FieldInfo.prototype.copy_s50pwf$ = function (value, metadata) {
    return new FieldRecordMerger$FieldInfo(value === void 0 ? this.value : value, metadata === void 0 ? this.metadata : metadata);
  };
  FieldRecordMerger$FieldInfo.prototype.toString = function () {
    return 'FieldInfo(value=' + Kotlin.toString(this.value) + (', metadata=' + Kotlin.toString(this.metadata)) + ')';
  };
  FieldRecordMerger$FieldInfo.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    result = result * 31 + Kotlin.hashCode(this.metadata) | 0;
    return result;
  };
  FieldRecordMerger$FieldInfo.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.value, other.value) && Kotlin.equals(this.metadata, other.metadata)))));
  };
  FieldRecordMerger.prototype.merge_vutog4$ = function (existing, incoming, newDate) {
    var tmp$, tmp$_0, tmp$_1;
    var changedKeys = LinkedHashSet_init();
    var mergedFields = toMutableMap(existing.fields);
    var mergedMetadata = toMutableMap(existing.metadata);
    var date = (tmp$_0 = (tmp$ = existing.date) != null ? toMutableMap(tmp$) : null) != null ? tmp$_0 : LinkedHashMap_init();
    tmp$_1 = incoming.fields.entries.iterator();
    while (tmp$_1.hasNext()) {
      var tmp$_2 = tmp$_1.next();
      var fieldKey = tmp$_2.key;
      var incomingFieldValue = tmp$_2.value;
      var hasExistingFieldValue = existing.fields.containsKey_11rb$(fieldKey);
      var existingFieldValue = existing.fields.get_11rb$(fieldKey);
      if (!hasExistingFieldValue) {
        mergedFields.put_xwzc9p$(fieldKey, incomingFieldValue);
        var value = ensureNotNull(incoming.metadata.get_11rb$(fieldKey));
        mergedMetadata.put_xwzc9p$(fieldKey, value);
        changedKeys.add_11rb$(existing.key + '.' + fieldKey);
      } else if (!equals(existingFieldValue, incomingFieldValue)) {
        var existingFieldInfo = new FieldRecordMerger$FieldInfo(existingFieldValue, ensureNotNull(existing.metadata.get_11rb$(fieldKey)));
        var incomingFieldInfo = new FieldRecordMerger$FieldInfo(incomingFieldValue, ensureNotNull(incoming.metadata.get_11rb$(fieldKey)));
        var mergeResult = this.fieldMerger_0.mergeFields_4bhzd8$(existingFieldInfo, incomingFieldInfo);
        var value_0 = mergeResult.value;
        mergedFields.put_xwzc9p$(fieldKey, value_0);
        var value_1 = mergeResult.metadata;
        mergedMetadata.put_xwzc9p$(fieldKey, value_1);
        changedKeys.add_11rb$(existing.key + '.' + fieldKey);
      }
      if (newDate != null) {
        date.put_xwzc9p$(fieldKey, newDate);
      }
    }
    return to(Record_init(existing.key, mergedFields, incoming.mutationId, date, mergedMetadata), changedKeys);
  };
  FieldRecordMerger.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FieldRecordMerger',
    interfaces: [RecordMerger]
  };
  var ConnectionRecordMerger;
  function ConnectionFieldMerger() {
    ConnectionFieldMerger_instance = this;
  }
  ConnectionFieldMerger.prototype.mergeFields_4bhzd8$ = function (existing, incoming) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5, tmp$_6, tmp$_7, tmp$_8, tmp$_9;
    var existingStartCursor = typeof (tmp$ = existing.metadata.get_11rb$('startCursor')) === 'string' ? tmp$ : null;
    var existingEndCursor = typeof (tmp$_0 = existing.metadata.get_11rb$('endCursor')) === 'string' ? tmp$_0 : null;
    var incomingStartCursor = typeof (tmp$_1 = incoming.metadata.get_11rb$('startCursor')) === 'string' ? tmp$_1 : null;
    var incomingEndCursor = typeof (tmp$_2 = incoming.metadata.get_11rb$('endCursor')) === 'string' ? tmp$_2 : null;
    var incomingBeforeArgument = typeof (tmp$_3 = incoming.metadata.get_11rb$('before')) === 'string' ? tmp$_3 : null;
    var incomingAfterArgument = typeof (tmp$_4 = incoming.metadata.get_11rb$('after')) === 'string' ? tmp$_4 : null;
    if (incomingBeforeArgument == null && incomingAfterArgument == null) {
      tmp$_9 = incoming;
    } else if (existingStartCursor == null || existingEndCursor == null) {
      tmp$_9 = incoming;
    } else if (incomingStartCursor == null || incomingEndCursor == null) {
      tmp$_9 = existing;
    } else {
      var existingValue = Kotlin.isType(tmp$_5 = existing.value, Map) ? tmp$_5 : throwCCE();
      var existingList = Kotlin.isType(tmp$_6 = existingValue.get_11rb$('edges'), List) ? tmp$_6 : throwCCE();
      var incomingList = Kotlin.isType(tmp$_8 = (Kotlin.isType(tmp$_7 = incoming.value, Map) ? tmp$_7 : throwCCE()).get_11rb$('edges'), List) ? tmp$_8 : throwCCE();
      var mergedList;
      var newStartCursor;
      var newEndCursor;
      if (equals(incomingAfterArgument, existingEndCursor)) {
        mergedList = plus_1(existingList, incomingList);
        newStartCursor = existingStartCursor;
        newEndCursor = incomingEndCursor;
      } else if (equals(incomingBeforeArgument, existingStartCursor)) {
        mergedList = plus_1(incomingList, existingList);
        newStartCursor = incomingStartCursor;
        newEndCursor = existingEndCursor;
      } else {
        mergedList = incomingList;
        newStartCursor = incomingStartCursor;
        newEndCursor = incomingEndCursor;
      }
      var mergedFieldValue = toMutableMap(existingValue);
      var value = mergedList;
      mergedFieldValue.put_xwzc9p$('edges', value);
      tmp$_9 = new FieldRecordMerger$FieldInfo(mergedFieldValue, mapOf_0([to('startCursor', newStartCursor), to('endCursor', newEndCursor)]));
    }
    return tmp$_9;
  };
  ConnectionFieldMerger.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'ConnectionFieldMerger',
    interfaces: [FieldRecordMerger$FieldMerger]
  };
  var ConnectionFieldMerger_instance = null;
  function ConnectionFieldMerger_getInstance() {
    if (ConnectionFieldMerger_instance === null) {
      new ConnectionFieldMerger();
    }
    return ConnectionFieldMerger_instance;
  }
  function BlobRecordSerializer() {
    BlobRecordSerializer_instance = this;
    this.STRING_0 = 0;
    this.INT_0 = 1;
    this.LONG_0 = 2;
    this.BOOLEAN_0 = 3;
    this.DOUBLE_0 = 4;
    this.LIST_0 = 5;
    this.MAP_0 = 6;
    this.CACHE_KEY_0 = 7;
    this.NULL_0 = 8;
  }
  BlobRecordSerializer.prototype.serialize_5ualzv$ = function (record) {
    var tmp$, tmp$_0;
    var buffer = new Buffer();
    this.writeAny_0(buffer, record.metadata);
    var keys = record.fields.keys;
    buffer.writeInt_za3lpa$(keys.size);
    tmp$ = keys.iterator();
    while (tmp$.hasNext()) {
      var key = tmp$.next();
      this.writeString_0(buffer, key);
      this.writeAny_0(buffer, (tmp$_0 = record.date) != null ? tmp$_0.get_11rb$(key) : null);
      this.writeAny_0(buffer, record.fields.get_11rb$(key));
    }
    return buffer.readByteArray();
  };
  BlobRecordSerializer.prototype.deserialize_yzgtim$ = function (key, bytes) {
    var tmp$, tmp$_0;
    var buffer = (new Buffer()).write_fqrh44$(bytes);
    var metadata = Kotlin.isType(tmp$ = this.readAny_0(buffer), Map) ? tmp$ : throwCCE();
    var fields = LinkedHashMap_init();
    var dates = LinkedHashMap_init();
    var size = buffer.readInt();
    for (var i = 0; i < size; i++) {
      var name = this.readString_0(buffer);
      var value = (tmp$_0 = this.readAny_0(buffer)) == null || Kotlin.isType(tmp$_0, Kotlin.Long) ? tmp$_0 : throwCCE();
      dates.put_xwzc9p$(name, value);
      var value_0 = this.readAny_0(buffer);
      fields.put_xwzc9p$(name, value_0);
    }
    return Record_init(key, fields, null, dates, metadata);
  };
  BlobRecordSerializer.prototype.writeString_0 = function ($receiver, value) {
    $receiver.writeInt_za3lpa$(value.length);
    $receiver.writeUtf8_61zpoe$(value);
  };
  BlobRecordSerializer.prototype.readString_0 = function ($receiver) {
    return $receiver.readUtf8_s8cxhz$(Kotlin.Long.fromInt($receiver.readInt()));
  };
  BlobRecordSerializer.prototype.writeAny_0 = function ($receiver, value) {
    var tmp$;
    if (typeof value === 'string') {
      $receiver.buffer.writeByte_za3lpa$(0);
      this.writeString_0($receiver.buffer, value);
    } else if (typeof value === 'number') {
      $receiver.buffer.writeByte_za3lpa$(1);
      $receiver.buffer.writeInt_za3lpa$(value);
    } else if (Kotlin.isType(value, Kotlin.Long)) {
      $receiver.buffer.writeByte_za3lpa$(2);
      $receiver.buffer.writeLong_s8cxhz$(value);
    } else if (typeof value === 'number') {
      $receiver.buffer.writeByte_za3lpa$(4);
      this.writeString_0($receiver.buffer, value.toString());
    } else if (typeof value === 'boolean') {
      $receiver.buffer.writeByte_za3lpa$(3);
      $receiver.buffer.writeByte_za3lpa$(value ? 1 : 0);
    } else if (Kotlin.isType(value, CacheKey)) {
      $receiver.buffer.writeByte_za3lpa$(7);
      this.writeString_0($receiver.buffer, value.key);
    } else if (Kotlin.isType(value, List)) {
      $receiver.buffer.writeByte_za3lpa$(5);
      $receiver.buffer.writeInt_za3lpa$(value.size);
      var tmp$_0;
      tmp$_0 = value.iterator();
      while (tmp$_0.hasNext()) {
        var element = tmp$_0.next();
        this.writeAny_0($receiver.buffer, element);
      }
    } else if (Kotlin.isType(value, Map)) {
      $receiver.buffer.writeByte_za3lpa$(6);
      $receiver.buffer.writeInt_za3lpa$(value.size);
      Kotlin.isType(tmp$ = value, Map) ? tmp$ : throwCCE();
      var tmp$_1;
      tmp$_1 = value.entries.iterator();
      while (tmp$_1.hasNext()) {
        var element_0 = tmp$_1.next();
        this.writeString_0($receiver.buffer, element_0.key);
        this.writeAny_0($receiver.buffer, element_0.value);
      }
    } else if (value == null)
      $receiver.buffer.writeByte_za3lpa$(8);
    else {
      throw IllegalStateException_init(('Trying to write unsupported Record value: ' + toString(value)).toString());
    }
  };
  BlobRecordSerializer.prototype.readAny_0 = function ($receiver) {
    var tmp$;
    var what = $receiver.readByte();
    switch (what) {
      case 0:
        tmp$ = this.readString_0($receiver);
        break;
      case 1:
        tmp$ = $receiver.readInt();
        break;
      case 2:
        tmp$ = $receiver.readLong();
        break;
      case 4:
        tmp$ = toDouble(this.readString_0($receiver));
        break;
      case 3:
        tmp$ = $receiver.readByte() > 0;
        break;
      case 7:
        tmp$ = new CacheKey(this.readString_0($receiver));
        break;
      case 5:
        var size = $receiver.readInt();
        var $receiver_0 = until(0, size);
        var destination = ArrayList_init(collectionSizeOrDefault($receiver_0, 10));
        var tmp$_0;
        tmp$_0 = $receiver_0.iterator();
        while (tmp$_0.hasNext()) {
          var item = tmp$_0.next();
          destination.add_11rb$(this.readAny_0($receiver));
        }

        tmp$ = destination;
        break;
      case 6:
        var size_0 = $receiver.readInt();
        var $receiver_1 = until(0, size_0);
        var capacity = coerceAtLeast(mapCapacity(collectionSizeOrDefault($receiver_1, 10)), 16);
        var destination_0 = LinkedHashMap_init_0(capacity);
        var tmp$_1;
        tmp$_1 = $receiver_1.iterator();
        while (tmp$_1.hasNext()) {
          var element = tmp$_1.next();
          var pair = to(this.readString_0($receiver), this.readAny_0($receiver));
          destination_0.put_xwzc9p$(pair.first, pair.second);
        }

        tmp$ = destination_0;
        break;
      case 8:
        tmp$ = null;
        break;
      default:
        throw IllegalStateException_init(('Trying to read unsupported Record value: ' + what).toString());
    }
    return tmp$;
  };
  BlobRecordSerializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'BlobRecordSerializer',
    interfaces: []
  };
  var BlobRecordSerializer_instance = null;
  function BlobRecordSerializer_getInstance() {
    if (BlobRecordSerializer_instance === null) {
      new BlobRecordSerializer();
    }
    return BlobRecordSerializer_instance;
  }
  function CacheBatchReader(cache, rootKey, variables, cacheResolver, cacheHeaders, rootSelections, rootTypename) {
    this.cache_0 = cache;
    this.rootKey_0 = rootKey;
    this.variables_0 = variables;
    this.cacheResolver_0 = cacheResolver;
    this.cacheHeaders_0 = cacheHeaders;
    this.rootSelections_0 = rootSelections;
    this.rootTypename_0 = rootTypename;
    this.data_0 = LinkedHashMap_init();
    this.pendingReferences_0 = ArrayList_init_0();
  }
  function CacheBatchReader$PendingReference(key, path, selections, typeInScope) {
    this.key = key;
    this.path = path;
    this.selections = selections;
    this.typeInScope = typeInScope;
  }
  CacheBatchReader$PendingReference.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PendingReference',
    interfaces: []
  };
  function CacheBatchReader$CollectState() {
    this.fields = ArrayList_init_0();
  }
  CacheBatchReader$CollectState.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CollectState',
    interfaces: []
  };
  CacheBatchReader.prototype.collect_0 = function (selections, typeInScope, typename, state) {
    var tmp$;
    tmp$ = selections.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      if (Kotlin.isType(element, CompiledField))
        state.fields.add_11rb$(element);
      else if (Kotlin.isType(element, CompiledFragment)) {
        if (contains_0(element.possibleTypes, typename) || equals(element.typeCondition, typeInScope)) {
          this.collect_0(element.selections, typeInScope, typename, state);
        }
      } else
        Kotlin.noWhenBranchMatched();
    }
  };
  CacheBatchReader.prototype.collectAndMergeSameDirectives_0 = function (selections, typeInScope, typename) {
    var state = new CacheBatchReader$CollectState();
    this.collect_0(selections, typeInScope, typename, state);
    var $receiver = state.fields;
    var destination = LinkedHashMap_init();
    var tmp$;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var key = to(element.responseName, element.condition);
      var tmp$_0;
      var value = destination.get_11rb$(key);
      if (value == null) {
        var answer = ArrayList_init_0();
        destination.put_xwzc9p$(key, answer);
        tmp$_0 = answer;
      } else {
        tmp$_0 = value;
      }
      var list = tmp$_0;
      list.add_11rb$(element);
    }
    var $receiver_0 = destination.values;
    var destination_0 = ArrayList_init(collectionSizeOrDefault($receiver_0, 10));
    var tmp$_1;
    tmp$_1 = $receiver_0.iterator();
    while (tmp$_1.hasNext()) {
      var item = tmp$_1.next();
      var tmp$_2 = destination_0.add_11rb$;
      var tmp$_3 = first(item).newBuilder();
      var destination_1 = ArrayList_init_0();
      var tmp$_4;
      tmp$_4 = item.iterator();
      while (tmp$_4.hasNext()) {
        var element_0 = tmp$_4.next();
        var list_0 = element_0.selections;
        addAll(destination_1, list_0);
      }
      tmp$_2.call(destination_0, tmp$_3.selections_xxmmyd$(destination_1).build());
    }
    return destination_0;
  };
  CacheBatchReader.prototype.toMap = function () {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3;
    tmp$_2 = this.pendingReferences_0;
    tmp$ = this.rootKey_0;
    tmp$_0 = this.rootSelections_0;
    tmp$_1 = this.rootTypename_0;
    tmp$_2.add_11rb$(new CacheBatchReader$PendingReference(tmp$, emptyList(), tmp$_0, tmp$_1));
    while (!this.pendingReferences_0.isEmpty()) {
      var tmp$_4 = this.cache_0;
      var $receiver = this.pendingReferences_0;
      var destination = ArrayList_init(collectionSizeOrDefault($receiver, 10));
      var tmp$_5;
      tmp$_5 = $receiver.iterator();
      while (tmp$_5.hasNext()) {
        var item = tmp$_5.next();
        destination.add_11rb$(item.key);
      }
      var $receiver_0 = tmp$_4.loadRecords_pa6ebj$(destination, this.cacheHeaders_0);
      var capacity = coerceAtLeast(mapCapacity(collectionSizeOrDefault($receiver_0, 10)), 16);
      var destination_0 = LinkedHashMap_init_0(capacity);
      var tmp$_6;
      tmp$_6 = $receiver_0.iterator();
      while (tmp$_6.hasNext()) {
        var element = tmp$_6.next();
        destination_0.put_xwzc9p$(element.key, element);
      }
      var records = destination_0;
      var copy = toList_0(this.pendingReferences_0);
      this.pendingReferences_0.clear();
      var tmp$_7;
      tmp$_7 = copy.iterator();
      while (tmp$_7.hasNext()) {
        var element_0 = tmp$_7.next();
        var tmp$_8;
        var record = {v: records.get_11rb$(element_0.key)};
        if (record.v == null) {
          if (equals(element_0.key, CacheKey$Companion_getInstance().rootKey().key)) {
            record.v = new Record(element_0.key, emptyMap());
          } else {
            throw new CacheMissException(element_0.key);
          }
        }
        var collectedFields = this.collectAndMergeSameDirectives_0(element_0.selections, element_0.typeInScope, typeof (tmp$_8 = record.v.get_11rb$('__typename')) === 'string' ? tmp$_8 : null);
        var destination_1 = ArrayList_init_0();
        var tmp$_9;
        tmp$_9 = collectedFields.iterator();
        loop_label: while (tmp$_9.hasNext()) {
          var element_1 = tmp$_9.next();
          var tmp$_0_0;
          var transform$result;
          transform$break: do {
            var tmp$_10, tmp$_11;
            if (shouldSkip(element_1, this.variables_0.valueMap)) {
              transform$result = null;
              break transform$break;
            }
            tmp$_10 = this.cacheResolver_0;
            if (Kotlin.isType(tmp$_10, CacheResolver))
              tmp$_11 = this.cacheResolver_0.resolveField_h2jtsx$(element_1, this.variables_0, record.v, record.v.key);
            else if (Kotlin.isType(tmp$_10, ApolloResolver))
              tmp$_11 = this.cacheResolver_0.resolveField_5f759x$(new ResolverContext(element_1, this.variables_0, record.v, record.v.key, this.cacheHeaders_0));
            else
              throw IllegalStateException_init_0();
            var value = tmp$_11;
            this.registerCacheKeys_0(value, plus_2(element_0.path, element_1.responseName), element_1.selections, element_1.type.leafType().name);
            transform$result = to(element_1.responseName, value);
          }
           while (false);
          if ((tmp$_0_0 = transform$result) != null) {
            destination_1.add_11rb$(tmp$_0_0);
          }
        }
        var map = toMap(destination_1);
        var $receiver_1 = this.data_0;
        var key = element_0.path;
        $receiver_1.put_xwzc9p$(key, map);
      }
    }
    return Kotlin.isType(tmp$_3 = this.replaceCacheKeys_0(this.data_0.get_11rb$(emptyList()), emptyList()), Map) ? tmp$_3 : throwCCE();
  };
  CacheBatchReader.prototype.registerCacheKeys_0 = function ($receiver, path, selections, typeInScope) {
    var tmp$, tmp$_0;
    if (Kotlin.isType($receiver, CacheKey)) {
      this.pendingReferences_0.add_11rb$(new CacheBatchReader$PendingReference($receiver.key, path, selections, typeInScope));
    } else if (Kotlin.isType($receiver, List)) {
      var tmp$_1, tmp$_0_0;
      var index = 0;
      tmp$_1 = $receiver.iterator();
      while (tmp$_1.hasNext()) {
        var item = tmp$_1.next();
        this.registerCacheKeys_0(item, plus_2(path, checkIndexOverflow((tmp$_0_0 = index, index = tmp$_0_0 + 1 | 0, tmp$_0_0))), selections, typeInScope);
      }
    } else if (Kotlin.isType($receiver, Map)) {
      Kotlin.isType(tmp$ = $receiver, Map) ? tmp$ : throwCCE();
      var collectedFields = this.collectAndMergeSameDirectives_0(selections, typeInScope, typeof (tmp$_0 = $receiver.get_11rb$('__typename')) === 'string' ? tmp$_0 : null);
      var destination = ArrayList_init_0();
      var tmp$_2;
      tmp$_2 = collectedFields.iterator();
      loop_label: while (tmp$_2.hasNext()) {
        var element = tmp$_2.next();
        var tmp$_0_1;
        var transform$result;
        transform$break: do {
          var tmp$_3, tmp$_4;
          if (shouldSkip(element, this.variables_0.valueMap)) {
            transform$result = null;
            break transform$break;
          }
          tmp$_3 = this.cacheResolver_0;
          if (Kotlin.isType(tmp$_3, CacheResolver))
            tmp$_4 = this.cacheResolver_0.resolveField_h2jtsx$(element, this.variables_0, $receiver, '');
          else if (Kotlin.isType(tmp$_3, ApolloResolver))
            tmp$_4 = this.cacheResolver_0.resolveField_5f759x$(new ResolverContext(element, this.variables_0, $receiver, '', this.cacheHeaders_0));
          else
            throw IllegalStateException_init_0();
          var value = tmp$_4;
          this.registerCacheKeys_0(value, plus_2(path, element.responseName), element.selections, element.type.leafType().name);
          transform$result = to(element.responseName, value);
        }
         while (false);
        if ((tmp$_0_1 = transform$result) != null) {
          destination.add_11rb$(tmp$_0_1);
        }
      }
      toMap(destination);
    }
  };
  CacheBatchReader.prototype.replaceCacheKeys_0 = function ($receiver, path) {
    var tmp$;
    if (Kotlin.isType($receiver, CacheKey))
      tmp$ = this.replaceCacheKeys_0(this.data_0.get_11rb$(path), path);
    else if (Kotlin.isType($receiver, List)) {
      var destination = ArrayList_init(collectionSizeOrDefault($receiver, 10));
      var tmp$_0, tmp$_0_0;
      var index = 0;
      tmp$_0 = $receiver.iterator();
      while (tmp$_0.hasNext()) {
        var item = tmp$_0.next();
        destination.add_11rb$(this.replaceCacheKeys_0(item, plus_2(path, checkIndexOverflow((tmp$_0_0 = index, index = tmp$_0_0 + 1 | 0, tmp$_0_0)))));
      }
      tmp$ = destination;
    } else if (Kotlin.isType($receiver, Map)) {
      var destination_0 = LinkedHashMap_init_0(mapCapacity($receiver.size));
      var tmp$_1;
      tmp$_1 = $receiver.entries.iterator();
      while (tmp$_1.hasNext()) {
        var element = tmp$_1.next();
        var tmp$_2;
        destination_0.put_xwzc9p$(element.key, this.replaceCacheKeys_0(element.value, plus_2(path, typeof (tmp$_2 = element.key) === 'string' ? tmp$_2 : throwCCE())));
      }
      tmp$ = destination_0;
    } else {
      tmp$ = $receiver;
    }
    return tmp$;
  };
  CacheBatchReader.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CacheBatchReader',
    interfaces: []
  };
  function JsonRecordSerializer() {
    JsonRecordSerializer_instance = this;
    this.KEY_METADATA_0 = '__apm';
  }
  JsonRecordSerializer.prototype.serialize_5ualzv$ = function (record) {
    return this.toJson_0(record);
  };
  JsonRecordSerializer.prototype.toJson_0 = function (record) {
    var buffer = new Buffer();
    var $receiver = new BufferedSinkJsonWriter(buffer);
    var result = null;
    var thrown = null;
    try {
      var tmp$;
      $receiver.beginObject();
      tmp$ = record.fields.entries.iterator();
      while (tmp$.hasNext()) {
        var tmp$_0 = tmp$.next();
        var key = tmp$_0.key;
        var value = tmp$_0.value;
        this.writeJsonValue_0($receiver.name_61zpoe$(key), value);
      }
      $receiver.name_61zpoe$(this.KEY_METADATA_0);
      this.writeJsonValue_0($receiver, record.metadata);
      result = $receiver.endObject();
    } catch (t) {
      if (Kotlin.isType(t, Throwable)) {
        thrown = t;
      } else
        throw t;
    }
    try {
      $receiver != null ? ($receiver.close(), Unit) : null;
    } catch (t_0) {
      if (Kotlin.isType(t_0, Throwable)) {
        if (thrown == null)
          thrown = t_0;
        else
          addSuppressed(thrown, t_0);
      } else
        throw t_0;
    }
    if (thrown != null)
      throw thrown;
    ensureNotNull(result);
    return buffer.readUtf8();
  };
  JsonRecordSerializer.prototype.deserializeCacheKeys_0 = function ($receiver) {
    var tmp$;
    if (typeof $receiver === 'string')
      if (CacheKey$Companion_getInstance().canDeserialize_61zpoe$($receiver)) {
        tmp$ = CacheKey$Companion_getInstance().deserialize_61zpoe$($receiver);
      } else {
        tmp$ = $receiver;
      }
     else if (Kotlin.isType($receiver, Map)) {
      var destination = LinkedHashMap_init_0(mapCapacity($receiver.size));
      var tmp$_0;
      tmp$_0 = $receiver.entries.iterator();
      while (tmp$_0.hasNext()) {
        var element = tmp$_0.next();
        destination.put_xwzc9p$(element.key, this.deserializeCacheKeys_0(element.value));
      }
      tmp$ = destination;
    } else if (Kotlin.isType($receiver, List)) {
      var destination_0 = ArrayList_init(collectionSizeOrDefault($receiver, 10));
      var tmp$_1;
      tmp$_1 = $receiver.iterator();
      while (tmp$_1.hasNext()) {
        var item = tmp$_1.next();
        destination_0.add_11rb$(this.deserializeCacheKeys_0(item));
      }
      tmp$ = destination_0;
    } else
      tmp$ = $receiver;
    return tmp$;
  };
  JsonRecordSerializer.prototype.deserialize_puj7f4$ = function (key, jsonFieldSource) {
    var tmp$, tmp$_0, tmp$_1;
    var buffer = (new Buffer()).write_9ovubf$(ByteString.Companion.encodeUtf8_pdl1vz$(jsonFieldSource));
    var allFields = Kotlin.isType(tmp$ = readAny(new BufferedSourceJsonReader(buffer)), Map) ? tmp$ : throwCCE();
    var tmp$_2;
    var result = LinkedHashMap_init();
    tmp$_2 = allFields.entries.iterator();
    while (tmp$_2.hasNext()) {
      var entry = tmp$_2.next();
      if (!equals(entry.key, this.KEY_METADATA_0)) {
        result.put_xwzc9p$(entry.key, entry.value);
      }
    }
    var fields = Kotlin.isType(tmp$_0 = this.deserializeCacheKeys_0(result), Map) ? tmp$_0 : null;
    if (!(fields != null)) {
      var message = 'error deserializing: ' + jsonFieldSource;
      throw IllegalStateException_init(message.toString());
    }
    return Record_init(key, fields, null, emptyMap(), Kotlin.isType(tmp$_1 = allFields.get_11rb$(this.KEY_METADATA_0), Map) ? tmp$_1 : throwCCE());
  };
  JsonRecordSerializer.prototype.writeJsonValue_0 = function ($receiver, value) {
    var tmp$, tmp$_0;
    if (value == null)
      $receiver.nullValue();
    else if (typeof value === 'string')
      $receiver.value_61zpoe$(value);
    else if (typeof value === 'boolean')
      $receiver.value_6taknv$(value);
    else if (typeof value === 'number')
      $receiver.value_za3lpa$(value);
    else if (Kotlin.isType(value, Kotlin.Long))
      $receiver.value_s8cxhz$(value);
    else if (typeof value === 'number')
      $receiver.value_14dthe$(value);
    else if (Kotlin.isType(value, CacheKey))
      $receiver.value_61zpoe$(value.serialize());
    else if (Kotlin.isType(value, List)) {
      $receiver.beginArray();
      var tmp$_1;
      tmp$_1 = value.iterator();
      while (tmp$_1.hasNext()) {
        var element = tmp$_1.next();
        this.writeJsonValue_0($receiver, element);
      }
      $receiver.endArray();
    } else if (Kotlin.isType(value, Map)) {
      $receiver.beginObject();
      tmp$_0 = (Kotlin.isType(tmp$ = value, Map) ? tmp$ : throwCCE()).entries.iterator();
      while (tmp$_0.hasNext()) {
        var entry = tmp$_0.next();
        this.writeJsonValue_0($receiver.name_61zpoe$(entry.key), entry.value);
      }
      $receiver.endObject();
    } else {
      throw IllegalStateException_init(("Unsupported record value type: '" + toString(value) + "'").toString());
    }
  };
  JsonRecordSerializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'JsonRecordSerializer',
    interfaces: []
  };
  var JsonRecordSerializer_instance = null;
  function JsonRecordSerializer_getInstance() {
    if (JsonRecordSerializer_instance === null) {
      new JsonRecordSerializer();
    }
    return JsonRecordSerializer_instance;
  }
  function LruCache(maxSize, weigher) {
    if (weigher === void 0)
      weigher = LruCache_init$lambda;
    this.maxSize_0 = maxSize;
    this.weigher_0 = weigher;
    this.cache_0 = LinkedHashMap_init_1(0, 0.75);
    this.headNode_0 = null;
    this.tailNode_0 = null;
    this.size_0 = 0;
  }
  LruCache.prototype.get_11rb$ = function (key) {
    var node = this.cache_0.get_11rb$(key);
    if (node != null) {
      this.moveNodeToHead_0(node);
    }
    return node != null ? node.value : null;
  };
  LruCache.prototype.set_xwzc9p$ = function (key, value) {
    var node = this.cache_0.get_11rb$(key);
    if (node == null) {
      var $receiver = this.cache_0;
      var value_0 = this.addNode_0(key, value);
      $receiver.put_xwzc9p$(key, value_0);
    } else {
      node.value = value;
      this.moveNodeToHead_0(node);
    }
    this.trim_0();
  };
  LruCache.prototype.remove_11rb$ = function (key) {
    return this.removeUnsafe_0(key);
  };
  LruCache.prototype.keys = function () {
    return this.cache_0.keys;
  };
  LruCache.prototype.removeUnsafe_0 = function (key) {
    var nodeToRemove = this.cache_0.remove_11rb$(key);
    var value = nodeToRemove != null ? nodeToRemove.value : null;
    if (nodeToRemove != null) {
      this.unlinkNode_0(nodeToRemove);
    }
    return value;
  };
  LruCache.prototype.remove_brywnq$ = function (keys) {
    var tmp$;
    tmp$ = keys.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      this.removeUnsafe_0(element);
    }
  };
  LruCache.prototype.clear = function () {
    this.cache_0.clear();
    this.headNode_0 = null;
    this.tailNode_0 = null;
    this.size_0 = 0;
  };
  LruCache.prototype.size = function () {
    return this.size_0;
  };
  LruCache.prototype.dump = function () {
    var $receiver = this.cache_0;
    var destination = LinkedHashMap_init_0(mapCapacity($receiver.size));
    var tmp$;
    tmp$ = $receiver.entries.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var tmp$_0 = destination.put_xwzc9p$;
      var tmp$_1 = element.key;
      var value = element.value;
      var tmp$_2;
      tmp$_0.call(destination, tmp$_1, (tmp$_2 = value.value) == null || Kotlin.isType(tmp$_2, Any) ? tmp$_2 : throwCCE());
    }
    return destination;
  };
  LruCache.prototype.trim_0 = function () {
    var nodeToRemove = this.tailNode_0;
    while (nodeToRemove != null && this.size_0 > this.maxSize_0) {
      var $receiver = this.cache_0;
      var key = nodeToRemove.key;
      var tmp$;
      (Kotlin.isType(tmp$ = $receiver, MutableMap) ? tmp$ : throwCCE()).remove_11rb$(key);
      this.unlinkNode_0(nodeToRemove);
      nodeToRemove = this.tailNode_0;
    }
  };
  LruCache.prototype.addNode_0 = function (key, value) {
    var tmp$;
    var node = new LruCache$Node(key, value, this.headNode_0, null);
    this.headNode_0 = node;
    if (node.next == null) {
      this.tailNode_0 = this.headNode_0;
    } else {
      (tmp$ = node.next) != null ? (tmp$.prev = this.headNode_0) : null;
    }
    this.size_0 = this.size_0 + this.weigher_0(key, value) | 0;
    return node;
  };
  LruCache.prototype.moveNodeToHead_0 = function (node) {
    var tmp$, tmp$_0, tmp$_1;
    if (node.prev == null) {
      return;
    }
    (tmp$ = node.prev) != null ? (tmp$.next = node.next) : null;
    if (node.next == null) {
      this.tailNode_0 = node.prev;
    } else {
      (tmp$_0 = node.next) != null ? (tmp$_0.prev = node.prev) : null;
    }
    node.next = this.headNode_0;
    node.prev = null;
    (tmp$_1 = this.headNode_0) != null ? (tmp$_1.prev = node) : null;
    this.headNode_0 = node;
  };
  LruCache.prototype.unlinkNode_0 = function (node) {
    var tmp$, tmp$_0;
    if (node.prev == null) {
      this.headNode_0 = node.next;
    } else {
      (tmp$ = node.prev) != null ? (tmp$.next = node.next) : null;
    }
    if (node.next == null) {
      this.tailNode_0 = node.prev;
    } else {
      (tmp$_0 = node.next) != null ? (tmp$_0.prev = node.prev) : null;
    }
    this.size_0 = this.size_0 - this.weigher_0(ensureNotNull(node.key), node.value) | 0;
    node.key = null;
    node.value = null;
    node.next = null;
    node.prev = null;
  };
  function LruCache$Node(key, value, next, prev) {
    this.key = key;
    this.value = value;
    this.next = next;
    this.prev = prev;
  }
  LruCache$Node.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Node',
    interfaces: []
  };
  function LruCache_init$lambda(f, f_0) {
    return 1;
  }
  LruCache.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LruCache',
    interfaces: []
  };
  function Normalizer(variables, rootKey, cacheKeyGenerator, metadataGenerator) {
    this.variables_0 = variables;
    this.rootKey_0 = rootKey;
    this.cacheKeyGenerator_0 = cacheKeyGenerator;
    this.metadataGenerator_0 = metadataGenerator;
    this.records_0 = LinkedHashMap_init();
  }
  Normalizer.prototype.normalize_nacnkl$ = function (map, selections, typeInScope) {
    this.buildRecord_0(map, this.rootKey_0, selections, typeInScope.name, this.get_embeddedFields_0(typeInScope));
    return this.records_0;
  };
  function Normalizer$FieldInfo(fieldValue, metadata) {
    this.fieldValue = fieldValue;
    this.metadata = metadata;
  }
  Normalizer$FieldInfo.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FieldInfo',
    interfaces: []
  };
  Normalizer.prototype.buildFields_0 = function (obj, key, selections, typeInScope, embeddedFields) {
    var tmp$;
    var typename = typeof (tmp$ = obj.get_11rb$('__typename')) === 'string' ? tmp$ : null;
    var allFields = this.collectFields_0(selections, typeInScope, typename);
    var $receiver = obj.entries;
    var destination = ArrayList_init_0();
    var tmp$_0;
    tmp$_0 = $receiver.iterator();
    loop_label: while (tmp$_0.hasNext()) {
      var element = tmp$_0.next();
      var tmp$_0_0;
      var transform$result;
      transform$break: do {
        var tmp$_1;
        var destination_0 = ArrayList_init_0();
        var tmp$_2;
        tmp$_2 = allFields.iterator();
        while (tmp$_2.hasNext()) {
          var element_0 = tmp$_2.next();
          if (equals(element_0.responseName, element.key))
            destination_0.add_11rb$(element_0);
        }
        var compiledFields = destination_0;
        if (compiledFields.isEmpty()) {
          throw RuntimeException_init('Cannot find a CompiledField for entry: {' + element.key + ': ' + toString(element.value) + '}, __typename = ' + toString(typename) + ', key = ' + key);
        }
        var destination_1 = ArrayList_init_0();
        var tmp$_3;
        tmp$_3 = compiledFields.iterator();
        while (tmp$_3.hasNext()) {
          var element_1 = tmp$_3.next();
          if (!shouldSkip(element_1, this.variables_0.valueMap))
            destination_1.add_11rb$(element_1);
        }
        var includedFields = destination_1;
        if (includedFields.isEmpty()) {
          transform$result = null;
          break transform$break;
        }
        var tmp$_4 = first(includedFields).newBuilder();
        var destination_2 = ArrayList_init_0();
        var tmp$_5;
        tmp$_5 = includedFields.iterator();
        while (tmp$_5.hasNext()) {
          var element_2 = tmp$_5.next();
          var list = element_2.selections;
          addAll(destination_2, list);
        }
        var mergedField = tmp$_4.selections_xxmmyd$(destination_2).condition_p45m2i$(emptyList()).build();
        var fieldKey = mergedField.nameWithArguments_mnmhg2$(this.variables_0);
        if (equals(key, CacheKey$Companion_getInstance().rootKey().key)) {
          tmp$_1 = null;
        } else {
          tmp$_1 = key;
        }
        var base = tmp$_1;
        var value = this.replaceObjects_0(element.value, mergedField, mergedField.type, this.append_0(base, fieldKey), embeddedFields);
        var metadata = this.metadataGenerator_0.metadataForObject_wv82oj$(element.value, new MetadataGeneratorContext(mergedField, this.variables_0));
        transform$result = to(fieldKey, new Normalizer$FieldInfo(value, metadata));
      }
       while (false);
      if ((tmp$_0_0 = transform$result) != null) {
        destination.add_11rb$(tmp$_0_0);
      }
    }
    var fields = toMap(destination);
    return fields;
  };
  Normalizer.prototype.buildRecord_0 = function (obj, key, selections, typeInScope, embeddedFields) {
    var tmp$;
    var fields = this.buildFields_0(obj, key, selections, typeInScope, embeddedFields);
    var destination = LinkedHashMap_init_0(mapCapacity(fields.size));
    var tmp$_0;
    tmp$_0 = fields.entries.iterator();
    while (tmp$_0.hasNext()) {
      var element = tmp$_0.next();
      destination.put_xwzc9p$(element.key, element.value.fieldValue);
    }
    var fieldValues = destination;
    var destination_0 = LinkedHashMap_init_0(mapCapacity(fields.size));
    var tmp$_1;
    tmp$_1 = fields.entries.iterator();
    while (tmp$_1.hasNext()) {
      var element_0 = tmp$_1.next();
      destination_0.put_xwzc9p$(element_0.key, element_0.value.metadata);
    }
    var metadata = destination_0;
    var record = Record_init(key, fieldValues, null, emptyMap(), metadata);
    var existingRecord = this.records_0.get_11rb$(key);
    if (existingRecord != null) {
      tmp$ = existingRecord.mergeWith_5ualzv$(record).first;
    } else {
      tmp$ = record;
    }
    var mergedRecord = tmp$;
    this.records_0.put_xwzc9p$(key, mergedRecord);
    return new CacheKey(key);
  };
  Normalizer.prototype.replaceObjects_0 = function (value, field, type_, path, embeddedFields) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    if (Kotlin.isType(type_, CompiledNotNullType)) {
      if (!(value != null)) {
        var message = 'Check failed.';
        throw IllegalStateException_init(message.toString());
      }
      tmp$ = type_.ofType;
    } else {
      if (value == null) {
        return null;
      }
      tmp$ = type_;
    }
    var type = tmp$;
    if (Kotlin.isType(type, CompiledListType)) {
      if (!Kotlin.isType(value, List)) {
        var message_0 = 'Check failed.';
        throw IllegalStateException_init(message_0.toString());
      }
      var destination = ArrayList_init(collectionSizeOrDefault(value, 10));
      var tmp$_3, tmp$_0_0;
      var index = 0;
      tmp$_3 = value.iterator();
      while (tmp$_3.hasNext()) {
        var item = tmp$_3.next();
        destination.add_11rb$(this.replaceObjects_0(item, field, type.ofType, this.append_0(path, checkIndexOverflow((tmp$_0_0 = index, index = tmp$_0_0 + 1 | 0, tmp$_0_0)).toString()), embeddedFields));
      }
      tmp$_2 = destination;
    } else if (Kotlin.isType(type, CompiledNamedType) && isComposite(type)) {
      if (!Kotlin.isType(value, Map)) {
        var message_1 = 'Check failed.';
        throw IllegalStateException_init(message_1.toString());
      }
      var key = (tmp$_1 = this.cacheKeyGenerator_0.cacheKeyForObject_bd1756$(Kotlin.isType(tmp$_0 = value, Map) ? tmp$_0 : throwCCE(), new CacheKeyGeneratorContext(field, this.variables_0))) != null ? tmp$_1.key : null;
      if (key == null) {
        key = path;
      }
      if (embeddedFields.contains_11rb$(field.name)) {
        var $receiver = this.buildFields_0(value, key, field.selections, field.type.leafType().name, this.get_embeddedFields_0(field.type.leafType()));
        var destination_0 = LinkedHashMap_init_0(mapCapacity($receiver.size));
        var tmp$_4;
        tmp$_4 = $receiver.entries.iterator();
        while (tmp$_4.hasNext()) {
          var element = tmp$_4.next();
          destination_0.put_xwzc9p$(element.key, element.value.fieldValue);
        }
        tmp$_2 = destination_0;
      } else {
        tmp$_2 = this.buildRecord_0(value, key, field.selections, field.type.leafType().name, this.get_embeddedFields_0(field.type.leafType()));
      }
    } else {
      tmp$_2 = value;
    }
    return tmp$_2;
  };
  Normalizer.prototype.get_embeddedFields_0 = function ($receiver) {
    if (Kotlin.isType($receiver, ObjectType))
      return $receiver.embeddedFields;
    else if (Kotlin.isType($receiver, InterfaceType))
      return $receiver.embeddedFields;
    else
      return emptyList();
  };
  function Normalizer$CollectState() {
    this.fields = ArrayList_init_0();
  }
  Normalizer$CollectState.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CollectState',
    interfaces: []
  };
  Normalizer.prototype.collectFields_1 = function (selections, typeInScope, typename, state) {
    var tmp$;
    tmp$ = selections.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      if (Kotlin.isType(element, CompiledField))
        state.fields.add_11rb$(element);
      else if (Kotlin.isType(element, CompiledFragment)) {
        if (contains_0(element.possibleTypes, typename) || equals(element.typeCondition, typeInScope)) {
          this.collectFields_1(element.selections, typeInScope, typename, state);
        }
      } else
        Kotlin.noWhenBranchMatched();
    }
  };
  Normalizer.prototype.collectFields_0 = function (selections, typeInScope, typename) {
    var state = new Normalizer$CollectState();
    this.collectFields_1(selections, typeInScope, typename, state);
    return state.fields;
  };
  Normalizer.prototype.append_0 = function ($receiver, next) {
    return $receiver == null ? next : toString($receiver) + '.' + next;
  };
  Normalizer.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Normalizer',
    interfaces: []
  };
  function OptimisticCache() {
    NormalizedCache.call(this);
    this.recordJournals_0 = LinkedHashMap_init();
  }
  OptimisticCache.prototype.loadRecord_74n6a2$ = function (key, cacheHeaders) {
    var tmp$, tmp$_0;
    try {
      var nonOptimisticRecord = (tmp$ = this.nextCache) != null ? tmp$.loadRecord_74n6a2$(key, cacheHeaders) : null;
      tmp$_0 = this.mergeJournalRecord_0(nonOptimisticRecord, key);
    } catch (ignore) {
      if (Kotlin.isType(ignore, Exception)) {
        tmp$_0 = null;
      } else
        throw ignore;
    }
    return tmp$_0;
  };
  OptimisticCache.prototype.loadRecords_pa6ebj$ = function (keys, cacheHeaders) {
    var tmp$, tmp$_0, tmp$_1;
    var tmp$_2;
    if ((tmp$_0 = (tmp$ = this.nextCache) != null ? tmp$.loadRecords_pa6ebj$(keys, cacheHeaders) : null) != null) {
      var capacity = coerceAtLeast(mapCapacity(collectionSizeOrDefault(tmp$_0, 10)), 16);
      var destination = LinkedHashMap_init_0(capacity);
      var tmp$_3;
      tmp$_3 = tmp$_0.iterator();
      while (tmp$_3.hasNext()) {
        var element = tmp$_3.next();
        destination.put_xwzc9p$(element.key, element);
      }
      tmp$_2 = destination;
    } else
      tmp$_2 = null;
    var nonOptimisticRecords = (tmp$_1 = tmp$_2) != null ? tmp$_1 : emptyMap();
    var destination_0 = ArrayList_init_0();
    var tmp$_4;
    tmp$_4 = keys.iterator();
    while (tmp$_4.hasNext()) {
      var element_0 = tmp$_4.next();
      var tmp$_0_0;
      if ((tmp$_0_0 = this.mergeJournalRecord_0(nonOptimisticRecords.get_11rb$(element_0), element_0)) != null) {
        destination_0.add_11rb$(tmp$_0_0);
      }
    }
    return destination_0;
  };
  OptimisticCache.prototype.merge_3uj6of$ = function (record, cacheHeaders) {
    var tmp$, tmp$_0;
    return (tmp$_0 = (tmp$ = this.nextCache) != null ? tmp$.merge_3uj6of$(record, cacheHeaders) : null) != null ? tmp$_0 : emptySet();
  };
  OptimisticCache.prototype.merge_qfx2x4$ = function (records, cacheHeaders) {
    var tmp$, tmp$_0;
    return (tmp$_0 = (tmp$ = this.nextCache) != null ? tmp$.merge_qfx2x4$(records, cacheHeaders) : null) != null ? tmp$_0 : emptySet();
  };
  OptimisticCache.prototype.merge_kw21vg$ = function (record, cacheHeaders, recordMerger) {
    var tmp$, tmp$_0;
    return (tmp$_0 = (tmp$ = this.nextCache) != null ? tmp$.merge_kw21vg$(record, cacheHeaders, recordMerger) : null) != null ? tmp$_0 : emptySet();
  };
  OptimisticCache.prototype.merge_jot6vf$ = function (records, cacheHeaders, recordMerger) {
    var tmp$, tmp$_0;
    return (tmp$_0 = (tmp$ = this.nextCache) != null ? tmp$.merge_jot6vf$(records, cacheHeaders, recordMerger) : null) != null ? tmp$_0 : emptySet();
  };
  OptimisticCache.prototype.clearAll = function () {
    var tmp$;
    this.recordJournals_0.clear();
    (tmp$ = this.nextCache) != null ? (tmp$.clearAll(), Unit) : null;
  };
  OptimisticCache.prototype.remove_gmcrai$ = function (cacheKey, cascade) {
    var tmp$, tmp$_0, tmp$_1;
    var result = (tmp$_0 = (tmp$ = this.nextCache) != null ? tmp$.remove_gmcrai$(cacheKey, cascade) : null) != null ? tmp$_0 : false;
    var recordJournal = this.recordJournals_0.get_11rb$(cacheKey.key);
    if (recordJournal != null) {
      this.recordJournals_0.remove_11rb$(cacheKey.key);
      result = true;
      if (cascade) {
        tmp$_1 = recordJournal.current.referencedFields().iterator();
        while (tmp$_1.hasNext()) {
          var cacheReference = tmp$_1.next();
          result = (result && this.remove_gmcrai$(new CacheKey(cacheReference.key), true));
        }
      }
    }
    return result;
  };
  OptimisticCache.prototype.remove_61zpoe$ = function (pattern) {
    var tmp$, tmp$_0;
    var regex = NormalizedCache$Companion_getInstance().patternToRegex_61zpoe$(pattern);
    var total = 0;
    var iterator = this.recordJournals_0.entries.iterator();
    while (iterator.hasNext()) {
      var entry = iterator.next();
      if (regex.matches_6bul2c$(entry.key)) {
        iterator.remove();
        total = total + 1 | 0;
      }
    }
    var chainRemoved = (tmp$_0 = (tmp$ = this.nextCache) != null ? tmp$.remove_61zpoe$(pattern) : null) != null ? tmp$_0 : 0;
    return total + chainRemoved | 0;
  };
  OptimisticCache.prototype.addOptimisticUpdates_yexvpw$ = function (recordSet) {
    var destination = ArrayList_init_0();
    var tmp$;
    tmp$ = recordSet.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var list = this.addOptimisticUpdate_5ualzv$(element);
      addAll(destination, list);
    }
    return toSet(destination);
  };
  OptimisticCache.prototype.addOptimisticUpdate_5ualzv$ = function (record) {
    var tmp$;
    var journal = this.recordJournals_0.get_11rb$(record.key);
    if (journal == null) {
      var $receiver = this.recordJournals_0;
      var key = record.key;
      var value = new OptimisticCache$RecordJournal(record);
      $receiver.put_xwzc9p$(key, value);
      tmp$ = record.fieldKeys();
    } else {
      tmp$ = journal.addPatch_5ualzv$(record);
    }
    return tmp$;
  };
  OptimisticCache.prototype.removeOptimisticUpdates_y45vgl$ = function (mutationId) {
    var changedCacheKeys = LinkedHashSet_init();
    var iterator = this.recordJournals_0.entries.iterator();
    while (iterator.hasNext()) {
      var entry = iterator.next();
      var result = entry.value.removePatch_y45vgl$(mutationId);
      changedCacheKeys.addAll_brywnq$(result.changedKeys);
      if (result.isEmpty) {
        iterator.remove();
      }
    }
    return changedCacheKeys;
  };
  OptimisticCache.prototype.dump = function () {
    var tmp$, tmp$_0;
    var tmp$_1 = Kotlin.getKClassFromExpression(this);
    var $receiver = this.recordJournals_0;
    var destination = LinkedHashMap_init_0(mapCapacity($receiver.size));
    var tmp$_2;
    tmp$_2 = $receiver.entries.iterator();
    while (tmp$_2.hasNext()) {
      var element = tmp$_2.next();
      var tmp$_3 = destination.put_xwzc9p$;
      var tmp$_4 = element.key;
      var journal = element.value;
      tmp$_3.call(destination, tmp$_4, journal.current);
    }
    tmp$_0 = mapOf(to(tmp$_1, destination));
    var $receiver_0 = (tmp$ = this.nextCache) != null ? tmp$.dump() : null;
    return plus_0(tmp$_0, $receiver_0 != null ? $receiver_0 : emptyMap());
  };
  OptimisticCache.prototype.mergeJournalRecord_0 = function ($receiver, key) {
    var tmp$, tmp$_0, tmp$_1;
    var journal = this.recordJournals_0.get_11rb$(key);
    if (journal != null) {
      tmp$_1 = (tmp$_0 = (tmp$ = $receiver != null ? $receiver.mergeWith_5ualzv$(journal.current) : null) != null ? tmp$.first : null) != null ? tmp$_0 : journal.current;
    } else {
      tmp$_1 = $receiver;
    }
    return tmp$_1;
  };
  function OptimisticCache$RemovalResult(changedKeys, isEmpty) {
    this.changedKeys = changedKeys;
    this.isEmpty = isEmpty;
  }
  OptimisticCache$RemovalResult.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RemovalResult',
    interfaces: []
  };
  function OptimisticCache$RecordJournal(record) {
    this.current = record;
    this.patches_0 = mutableListOf([record]);
  }
  OptimisticCache$RecordJournal.prototype.addPatch_5ualzv$ = function (record) {
    var tmp$ = this.current.mergeWith_5ualzv$(record);
    var mergedRecord = tmp$.component1()
    , changedKeys = tmp$.component2();
    this.current = mergedRecord;
    this.patches_0.add_11rb$(record);
    return changedKeys;
  };
  OptimisticCache$RecordJournal.prototype.removePatch_y45vgl$ = function (mutationId) {
    var tmp$;
    var $receiver = this.patches_0;
    var indexOfFirst$result;
    indexOfFirst$break: do {
      var tmp$_0;
      var index = 0;
      tmp$_0 = $receiver.iterator();
      while (tmp$_0.hasNext()) {
        var item = tmp$_0.next();
        if (equals(mutationId, item.mutationId)) {
          indexOfFirst$result = index;
          break indexOfFirst$break;
        }
        index = index + 1 | 0;
      }
      indexOfFirst$result = -1;
    }
     while (false);
    var recordIndex = indexOfFirst$result;
    if (recordIndex === -1) {
      return new OptimisticCache$RemovalResult(emptySet(), false);
    }
    if (this.patches_0.size === 1) {
      return new OptimisticCache$RemovalResult(this.current.fieldKeys(), true);
    }
    var oldRecord = this.current;
    this.patches_0.removeAt_za3lpa$(recordIndex).key;
    var cur = null;
    var b = recordIndex - 1 | 0;
    var start = JsMath.max(0, b);
    tmp$ = this.patches_0.size;
    for (var i = start; i < tmp$; i++) {
      var record = this.patches_0.get_za3lpa$(i);
      if (cur == null) {
        cur = record;
      } else {
        var mergedRecord = cur.mergeWith_5ualzv$(record).component1();
        cur = mergedRecord;
      }
    }
    this.current = ensureNotNull(cur);
    return new OptimisticCache$RemovalResult(Record$Companion_getInstance().changedKeys_dz30kh$(oldRecord, this.current), false);
  };
  OptimisticCache$RecordJournal.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RecordJournal',
    interfaces: []
  };
  OptimisticCache.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'OptimisticCache',
    interfaces: [NormalizedCache]
  };
  function RecordWeigher() {
    RecordWeigher_instance = this;
    this.SIZE_OF_BOOLEAN_0 = 16;
    this.SIZE_OF_INT_0 = 4;
    this.SIZE_OF_LONG_0 = 8;
    this.SIZE_OF_DOUBLE_0 = 8;
    this.SIZE_OF_ARRAY_OVERHEAD_0 = 16;
    this.SIZE_OF_MAP_OVERHEAD_0 = 16;
    this.SIZE_OF_RECORD_OVERHEAD_0 = 16;
    this.SIZE_OF_CACHE_KEY_OVERHEAD_0 = 16;
    this.SIZE_OF_NULL_0 = 4;
  }
  RecordWeigher.prototype.byteChange_oaftn8$ = function (newValue, oldValue) {
    return this.weighField_0(newValue) - this.weighField_0(oldValue) | 0;
  };
  RecordWeigher.prototype.calculateBytes_5ualzv$ = function (record) {
    var tmp$;
    var size = 16 + commonAsUtf8ToByteArray(record.key).length | 0;
    tmp$ = record.fields.entries.iterator();
    while (tmp$.hasNext()) {
      var tmp$_0 = tmp$.next();
      var key = tmp$_0.key;
      var value = tmp$_0.value;
      size = size + (commonAsUtf8ToByteArray(key).length + this.weighField_0(value)) | 0;
    }
    return size;
  };
  RecordWeigher.prototype.weighField_0 = function (field) {
    var tmp$;
    if (field == null)
      tmp$ = 4;
    else if (typeof field === 'string')
      tmp$ = commonAsUtf8ToByteArray(field).length;
    else if (typeof field === 'boolean')
      tmp$ = 16;
    else if (typeof field === 'number')
      tmp$ = 4;
    else if (Kotlin.isType(field, Kotlin.Long))
      tmp$ = 8;
    else if (typeof field === 'number')
      tmp$ = 8;
    else if (Kotlin.isType(field, List)) {
      var tmp$_0;
      var sum = 0;
      tmp$_0 = field.iterator();
      while (tmp$_0.hasNext()) {
        var element = tmp$_0.next();
        sum = sum + this.weighField_0(element) | 0;
      }
      tmp$ = 16 + sum | 0;
    } else if (Kotlin.isType(field, CacheKey))
      tmp$ = 16 + commonAsUtf8ToByteArray(field.key).length | 0;
    else if (Kotlin.isType(field, Map)) {
      var tmp$_1;
      var sum_0 = 0;
      tmp$_1 = field.keys.iterator();
      while (tmp$_1.hasNext()) {
        var element_0 = tmp$_1.next();
        sum_0 = sum_0 + this.weighField_0(element_0) | 0;
      }
      var tmp$_2 = 16 + sum_0;
      var tmp$_3;
      var sum_1 = 0;
      tmp$_3 = field.values.iterator();
      while (tmp$_3.hasNext()) {
        var element_1 = tmp$_3.next();
        sum_1 = sum_1 + this.weighField_0(element_1) | 0;
      }
      tmp$ = tmp$_2 + sum_1 | 0;
    } else {
      throw IllegalStateException_init(("Unknown field type in Record: '" + toString(field) + "'").toString());
    }
    return tmp$;
  };
  RecordWeigher.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'RecordWeigher',
    interfaces: []
  };
  var RecordWeigher_instance = null;
  function RecordWeigher_getInstance() {
    if (RecordWeigher_instance === null) {
      new RecordWeigher();
    }
    return RecordWeigher_instance;
  }
  function shouldSkip($receiver, variableValues) {
    var tmp$;
    tmp$ = $receiver.condition.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var tmp$_0, tmp$_1;
      var value = (tmp$_1 = typeof (tmp$_0 = variableValues.get_11rb$(element.name)) === 'boolean' ? tmp$_0 : null) != null ? tmp$_1 : false;
      if (element.inverted) {
        value = !value;
      }
      if (!value) {
        return true;
      }
    }
    return false;
  }
  function CacheLock() {
  }
  CacheLock.prototype.lock_klfg04$ = function (block) {
    return block();
  };
  CacheLock.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CacheLock',
    interfaces: []
  };
  var package$com = _.com || (_.com = {});
  var package$apollographql = package$com.apollographql || (package$com.apollographql = {});
  var package$apollo3 = package$apollographql.apollo3 || (package$apollographql.apollo3 = {});
  var package$cache = package$apollo3.cache || (package$apollo3.cache = {});
  var package$normalized = package$cache.normalized || (package$cache.normalized = {});
  var package$api = package$normalized.api || (package$normalized.api = {});
  Object.defineProperty(package$api, 'ApolloCacheHeaders', {
    get: ApolloCacheHeaders_getInstance
  });
  CacheHeaders.Builder = CacheHeaders$Builder;
  Object.defineProperty(CacheHeaders, 'Companion', {
    get: CacheHeaders$Companion_getInstance
  });
  package$api.CacheHeaders = CacheHeaders;
  Object.defineProperty(CacheKey, 'Companion', {
    get: CacheKey$Companion_getInstance
  });
  package$api.CacheKey_init_kwv3np$ = CacheKey_init;
  package$api.CacheKey_init_60y5e1$ = CacheKey_init_0;
  package$api.CacheKey = CacheKey;
  package$api.CacheKeyGenerator = CacheKeyGenerator;
  package$api.CacheKeyGeneratorContext = CacheKeyGeneratorContext;
  Object.defineProperty(package$api, 'TypePolicyCacheKeyGenerator', {
    get: TypePolicyCacheKeyGenerator_getInstance
  });
  package$api.CacheKeyResolver = CacheKeyResolver;
  package$api.CacheResolver = CacheResolver;
  package$api.ResolverContext = ResolverContext;
  package$api.ApolloResolver = ApolloResolver;
  Object.defineProperty(package$api, 'DefaultCacheResolver', {
    get: DefaultCacheResolver_getInstance
  });
  package$api.ReceiveDateApolloResolver = ReceiveDateApolloResolver;
  package$api.ExpireDateCacheResolver = ExpireDateCacheResolver;
  Object.defineProperty(package$api, 'FieldPolicyCacheResolver', {
    get: FieldPolicyCacheResolver_getInstance
  });
  Object.defineProperty(package$api, 'FieldPolicyApolloResolver', {
    get: FieldPolicyApolloResolver_getInstance
  });
  package$api.MemoryCache = MemoryCache;
  package$api.MemoryCacheFactory = MemoryCacheFactory;
  package$api.MetadataGenerator = MetadataGenerator;
  package$api.MetadataGeneratorContext = MetadataGeneratorContext;
  Object.defineProperty(package$api, 'EmptyMetadataGenerator', {
    get: EmptyMetadataGenerator_getInstance
  });
  package$api.ConnectionMetadataGenerator = ConnectionMetadataGenerator;
  Object.defineProperty(NormalizedCache, 'Companion', {
    get: NormalizedCache$Companion_getInstance
  });
  package$api.NormalizedCache = NormalizedCache;
  package$api.NormalizedCacheFactory = NormalizedCacheFactory;
  package$api.normalize_fx9czh$ = normalize;
  package$api.normalize_v7ww4x$ = normalize_0;
  package$api.normalize_mugrdd$ = normalize_1;
  package$api.normalize_kk86eb$ = normalize_2;
  package$api.readDataFromCache_e8dx3s$ = readDataFromCache;
  package$api.readDataFromCache_6vtvzl$ = readDataFromCache_0;
  package$api.readDataFromCache_t3jnsz$ = readDataFromCache_1;
  package$api.readDataFromCache_ohiuv0$ = readDataFromCache_2;
  package$api.dependentKeys_rk1vy4$ = dependentKeys;
  package$api.ReadOnlyNormalizedCache = ReadOnlyNormalizedCache;
  Object.defineProperty(Record, 'Companion', {
    get: Record$Companion_getInstance
  });
  package$api.Record_init_16agn8$ = Record_init;
  package$api.Record = Record;
  Object.defineProperty(package$api, 'RecordFieldJsonAdapter', {
    get: RecordFieldJsonAdapter_getInstance
  });
  package$api.RecordMerger = RecordMerger;
  Object.defineProperty(package$api, 'DefaultRecordMerger', {
    get: DefaultRecordMerger_getInstance
  });
  FieldRecordMerger.FieldMerger = FieldRecordMerger$FieldMerger;
  FieldRecordMerger.FieldInfo = FieldRecordMerger$FieldInfo;
  package$api.FieldRecordMerger = FieldRecordMerger;
  Object.defineProperty(package$api, 'ConnectionRecordMerger', {
    get: function () {
      return ConnectionRecordMerger;
    }
  });
  var package$internal = package$api.internal || (package$api.internal = {});
  Object.defineProperty(package$internal, 'BlobRecordSerializer', {
    get: BlobRecordSerializer_getInstance
  });
  CacheBatchReader.PendingReference = CacheBatchReader$PendingReference;
  package$internal.CacheBatchReader = CacheBatchReader;
  $$importsForInline$$['okio-parent-okio-js-legacy'] = $module$okio_parent_okio_js_legacy;
  Object.defineProperty(package$internal, 'JsonRecordSerializer', {
    get: JsonRecordSerializer_getInstance
  });
  package$internal.LruCache = LruCache;
  package$internal.Normalizer = Normalizer;
  package$internal.OptimisticCache = OptimisticCache;
  Object.defineProperty(package$internal, 'RecordWeigher', {
    get: RecordWeigher_getInstance
  });
  package$internal.shouldSkip_rwu2sp$ = shouldSkip;
  package$internal.CacheLock = CacheLock;
  ConnectionRecordMerger = new FieldRecordMerger(ConnectionFieldMerger_getInstance());
  Kotlin.defineModule('apollo-kotlin-apollo-normalized-cache-api-incubating-js-legacy', _);
  return _;
}));

//# sourceMappingURL=apollo-kotlin-apollo-normalized-cache-api-incubating-js-legacy.js.map
