/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.http.internal;

import com.apollographql.apollo3.cache.http.internal.DiskLruCacheKt;
import com.apollographql.apollo3.cache.http.internal.FaultHidingSink;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010)\n\u0002\b\u0007\b\u0000\u0018\u0000 \\2\u00020\u00012\u00020\u0002:\u0004\\]^_B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010:\u001a\u00020;H\u0002J\b\u0010<\u001a\u00020;H\u0016J\u001a\u0010=\u001a\u00020;2\b\u0010>\u001a\u0004\u0018\u00010\u00012\b\u0010?\u001a\u0004\u0018\u00010'J\u001a\u0010@\u001a\u00020;2\n\u0010A\u001a\u00060BR\u00020\u00002\u0006\u0010C\u001a\u00020\u0012J\u0006\u0010D\u001a\u00020;J\u0014\u0010E\u001a\b\u0018\u00010BR\u00020\u00002\u0006\u0010F\u001a\u00020'J\u001c\u0010E\u001a\b\u0018\u00010BR\u00020\u00002\u0006\u0010F\u001a\u00020'2\u0006\u0010G\u001a\u00020\u000bJ\u0006\u0010H\u001a\u00020;J\b\u0010I\u001a\u00020;H\u0016J\u0017\u0010J\u001a\b\u0018\u00010KR\u00020\u00002\u0006\u0010F\u001a\u00020'H\u0086\u0002J\u0006\u0010L\u001a\u00020;J\u0006\u0010M\u001a\u00020\u0012J\b\u0010N\u001a\u00020 H\u0002J\b\u0010O\u001a\u00020;H\u0002J\b\u0010P\u001a\u00020;H\u0002J\u0010\u0010Q\u001a\u00020;2\u0006\u0010R\u001a\u00020'H\u0002J\u0006\u0010S\u001a\u00020;J\u000e\u0010T\u001a\u00020\u00122\u0006\u0010F\u001a\u00020'J\u0014\u0010U\u001a\u00020\u00122\f\u0010V\u001a\b\u0018\u00010(R\u00020\u0000J\u000e\u0010W\u001a\u00020;2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u00108\u001a\u00020\u000bJ\u0010\u0010X\u001a\f\u0012\b\u0012\u00060KR\u00020\u00000YJ\u0006\u0010Z\u001a\u00020;J\u0010\u0010[\u001a\u00020;2\u0006\u0010F\u001a\u00020'H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u001c\u0010\u001a\u001a\u00020\u00128FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0014\"\u0004\b\u001b\u0010\u0016R\u000e\u0010\u001c\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R9\u0010%\u001a*\u0012\u0004\u0012\u00020'\u0012\n\u0012\b\u0018\u00010(R\u00020\u00000&j\u0014\u0012\u0004\u0012\u00020'\u0012\n\u0012\b\u0018\u00010(R\u00020\u0000`)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010,\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0014\"\u0004\b.\u0010\u0016R\u001a\u0010/\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0014\"\u0004\b1\u0010\u0016R\u000e\u00102\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00103\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u000e\u00108\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u00105\u00a8\u0006`"}, d2={"Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache;", "Ljava/io/Closeable;", "Ljava/io/Flushable;", "fileSystem", "Lokio/FileSystem;", "directory", "Ljava/io/File;", "appVersion", "", "valueCount", "maxSize", "", "executor", "Ljava/util/concurrent/Executor;", "(Lokio/FileSystem;Ljava/io/File;IIJLjava/util/concurrent/Executor;)V", "cleanupRunnable", "Ljava/lang/Runnable;", "hasJournalErrors", "", "getHasJournalErrors", "()Z", "setHasJournalErrors", "(Z)V", "initialized", "getInitialized", "setInitialized", "isClosed", "setClosed", "journalFile", "journalFileBackup", "journalFileTmp", "journalWriter", "Lokio/BufferedSink;", "getJournalWriter", "()Lokio/BufferedSink;", "setJournalWriter", "(Lokio/BufferedSink;)V", "lruEntries", "Ljava/util/LinkedHashMap;", "", "Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Entry;", "Lkotlin/collections/LinkedHashMap;", "getLruEntries", "()Ljava/util/LinkedHashMap;", "mostRecentRebuildFailed", "getMostRecentRebuildFailed", "setMostRecentRebuildFailed", "mostRecentTrimFailed", "getMostRecentTrimFailed", "setMostRecentTrimFailed", "nextSequenceNumber", "redundantOpCount", "getRedundantOpCount", "()I", "setRedundantOpCount", "(I)V", "size", "getValueCount", "checkNotClosed", "", "close", "closeQuietly", "closeable", "name", "completeEdit", "editor", "Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Editor;", "success", "delete", "edit", "key", "expectedSequenceNumber", "evictAll", "flush", "get", "Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Snapshot;", "initialize", "journalRebuildRequired", "newJournalWriter", "processJournal", "readJournal", "readJournalLine", "line", "rebuildJournal", "remove", "removeEntry", "entry", "setMaxSize", "snapshots", "", "trimToSize", "validateKey", "Companion", "Editor", "Entry", "Snapshot", "apollo-http-cache"})
public final class DiskLruCache
implements Closeable,
Flushable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final File directory;
    private final int appVersion;
    @NotNull
    private final File journalFile;
    @NotNull
    private final File journalFileTmp;
    @NotNull
    private final File journalFileBackup;
    private long maxSize;
    private final int valueCount;
    private long size;
    @Nullable
    private BufferedSink journalWriter;
    @NotNull
    private final LinkedHashMap<String, Entry> lruEntries;
    private int redundantOpCount;
    private boolean hasJournalErrors;
    private boolean initialized;
    private boolean isClosed;
    private boolean mostRecentTrimFailed;
    private boolean mostRecentRebuildFailed;
    private long nextSequenceNumber;
    @NotNull
    private final Executor executor;
    @NotNull
    private final Runnable cleanupRunnable;
    @NotNull
    public static final String JOURNAL_FILE = "journal";
    @NotNull
    public static final String JOURNAL_FILE_TEMP = "journal.tmp";
    @NotNull
    public static final String JOURNAL_FILE_BACKUP = "journal.bkp";
    @NotNull
    public static final String MAGIC = "libcore.io.DiskLruCache";
    @NotNull
    public static final String VERSION_1 = "1";
    public static final long ANY_SEQUENCE_NUMBER = -1L;
    private static final Pattern LEGAL_KEY_PATTERN = Pattern.compile("[a-z0-9_-]{1,120}");
    @NotNull
    private static final String CLEAN = "CLEAN";
    @NotNull
    private static final String DIRTY = "DIRTY";
    @NotNull
    private static final String REMOVE = "REMOVE";
    @NotNull
    private static final String READ = "READ";

    public DiskLruCache(@NotNull FileSystem fileSystem, @NotNull File directory, int appVersion, int valueCount, long maxSize, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.fileSystem = fileSystem;
        this.directory = directory;
        this.appVersion = appVersion;
        this.journalFile = new File(this.directory, JOURNAL_FILE);
        this.lruEntries = new LinkedHashMap(0, 0.75f, true);
        this.cleanupRunnable = new Runnable(this){
            final /* synthetic */ DiskLruCache this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DiskLruCache diskLruCache = this.this$0;
                DiskLruCache diskLruCache2 = this.this$0;
                DiskLruCache diskLruCache3 = diskLruCache;
                synchronized (diskLruCache3) {
                    block13: {
                        block12: {
                            boolean bl = false;
                            if (!diskLruCache2.getInitialized()) break block12;
                            if (!diskLruCache2.isClosed()) break block13;
                        }
                        return;
                    }
                    try {
                        diskLruCache2.trimToSize();
                    }
                    catch (IOException ignored) {
                        diskLruCache2.setMostRecentTrimFailed(true);
                    }
                    try {
                        if (diskLruCache2.journalRebuildRequired()) {
                            diskLruCache2.rebuildJournal();
                            diskLruCache2.setRedundantOpCount(0);
                        }
                    }
                    catch (IOException e) {
                        diskLruCache2.setMostRecentRebuildFailed(true);
                        diskLruCache2.setJournalWriter(Okio.buffer((Sink)Okio.blackhole()));
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        };
        this.journalFileTmp = new File(this.directory, JOURNAL_FILE_TEMP);
        this.journalFileBackup = new File(this.directory, JOURNAL_FILE_BACKUP);
        this.valueCount = valueCount;
        this.maxSize = maxSize;
        this.executor = executor;
    }

    public final int getValueCount() {
        return this.valueCount;
    }

    @Nullable
    public final BufferedSink getJournalWriter() {
        return this.journalWriter;
    }

    public final void setJournalWriter(@Nullable BufferedSink bufferedSink) {
        this.journalWriter = bufferedSink;
    }

    @NotNull
    public final LinkedHashMap<String, Entry> getLruEntries() {
        return this.lruEntries;
    }

    public final int getRedundantOpCount() {
        return this.redundantOpCount;
    }

    public final void setRedundantOpCount(int n) {
        this.redundantOpCount = n;
    }

    public final boolean getHasJournalErrors() {
        return this.hasJournalErrors;
    }

    public final void setHasJournalErrors(boolean bl) {
        this.hasJournalErrors = bl;
    }

    public final boolean getInitialized() {
        return this.initialized;
    }

    public final void setInitialized(boolean bl) {
        this.initialized = bl;
    }

    public final synchronized boolean isClosed() {
        return this.isClosed;
    }

    public final void setClosed(boolean bl) {
        this.isClosed = bl;
    }

    public final boolean getMostRecentTrimFailed() {
        return this.mostRecentTrimFailed;
    }

    public final void setMostRecentTrimFailed(boolean bl) {
        this.mostRecentTrimFailed = bl;
    }

    public final boolean getMostRecentRebuildFailed() {
        return this.mostRecentRebuildFailed;
    }

    public final void setMostRecentRebuildFailed(boolean bl) {
        this.mostRecentRebuildFailed = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void initialize() throws IOException {
        boolean bl = Thread.holdsLock(this);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (this.initialized) {
            return;
        }
        if (DiskLruCacheKt.access$exists(this.fileSystem, this.journalFileBackup)) {
            if (DiskLruCacheKt.access$exists(this.fileSystem, this.journalFile)) {
                DiskLruCacheKt.access$delete(this.fileSystem, this.journalFileBackup);
            } else {
                DiskLruCacheKt.access$rename(this.fileSystem, this.journalFileBackup, this.journalFile);
            }
        }
        if (DiskLruCacheKt.access$exists(this.fileSystem, this.journalFile)) {
            try {
                this.readJournal();
                this.processJournal();
                this.initialized = true;
                return;
            }
            catch (IOException iOException) {
                try {
                    this.delete();
                }
                finally {
                    this.isClosed = false;
                }
            }
        }
        this.rebuildJournal();
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readJournal() throws IOException {
        Closeable closeable = (Closeable)Okio.buffer((Source)DiskLruCacheKt.access$source(this.fileSystem, this.journalFile));
        Throwable throwable = null;
        try {
            BufferedSource source = (BufferedSource)closeable;
            boolean bl = false;
            String magic = source.readUtf8LineStrict();
            String version = source.readUtf8LineStrict();
            String appVersionString = source.readUtf8LineStrict();
            String valueCountString = source.readUtf8LineStrict();
            String blank = source.readUtf8LineStrict();
            if (!Intrinsics.areEqual((Object)MAGIC, (Object)magic)) throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + valueCountString + ", " + blank + ']');
            if (!Intrinsics.areEqual((Object)VERSION_1, (Object)version)) throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + valueCountString + ", " + blank + ']');
            if (!Intrinsics.areEqual((Object)String.valueOf(this.appVersion), (Object)appVersionString)) throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + valueCountString + ", " + blank + ']');
            if (!Intrinsics.areEqual((Object)String.valueOf(this.valueCount), (Object)valueCountString)) throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + valueCountString + ", " + blank + ']');
            if (!Intrinsics.areEqual((Object)"", (Object)blank)) {
                throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + valueCountString + ", " + blank + ']');
            }
            int lineCount = 0;
            try {
                while (true) {
                    this.readJournalLine(source.readUtf8LineStrict());
                    ++lineCount;
                }
            }
            catch (EOFException endOfJournal) {
                this.redundantOpCount = lineCount - this.lruEntries.size();
                if (!source.exhausted()) {
                    this.rebuildJournal();
                } else {
                    this.journalWriter = this.newJournalWriter();
                }
                Unit unit = Unit.INSTANCE;
                return;
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final BufferedSink newJournalWriter() throws FileNotFoundException {
        Sink fileSink = DiskLruCacheKt.access$appendingSink(this.fileSystem, this.journalFile);
        Sink faultHidingSink2 = (Sink)new FaultHidingSink(fileSink, this){
            final /* synthetic */ DiskLruCache this$0;
            {
                this.this$0 = $receiver;
                super($fileSink);
            }

            protected void onException(@Nullable IOException e) {
                boolean bl = Thread.holdsLock(this.this$0);
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                this.this$0.setHasJournalErrors(true);
            }
        };
        return Okio.buffer((Sink)faultHidingSink2);
    }

    private final void readJournalLine(String line) throws IOException {
        Entry entry;
        int firstSpace = StringsKt.indexOf$default((CharSequence)line, (char)' ', (int)0, (boolean)false, (int)6, null);
        if (firstSpace == -1) {
            throw new IOException("unexpected journal line: " + line);
        }
        int keyBegin = firstSpace + 1;
        int secondSpace = StringsKt.indexOf$default((CharSequence)line, (char)' ', (int)keyBegin, (boolean)false, (int)4, null);
        String key = null;
        if (secondSpace == -1) {
            String string = line.substring(keyBegin);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            key = string;
            if (firstSpace == REMOVE.length() && StringsKt.startsWith$default((String)line, (String)REMOVE, (boolean)false, (int)2, null)) {
                this.lruEntries.remove(key);
                return;
            }
        } else {
            String string = line.substring(keyBegin, secondSpace);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            key = string;
        }
        if ((entry = this.lruEntries.get(key)) == null) {
            entry = new Entry(key);
            ((Map)this.lruEntries).put(key, entry);
        }
        if (secondSpace != -1 && firstSpace == CLEAN.length() && StringsKt.startsWith$default((String)line, (String)CLEAN, (boolean)false, (int)2, null)) {
            String string = line.substring(secondSpace + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            String[] stringArray = new String[]{" "};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            Intrinsics.checkNotNull((Object)stringArray2, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            String[] parts = stringArray2;
            entry.setReadable(true);
            entry.setCurrentEditor(null);
            entry.setLengths(parts);
        } else if (secondSpace == -1 && firstSpace == DIRTY.length() && StringsKt.startsWith$default((String)line, (String)DIRTY, (boolean)false, (int)2, null)) {
            entry.setCurrentEditor(new Editor(entry));
        } else if (secondSpace != -1 || firstSpace != READ.length() || !StringsKt.startsWith$default((String)line, (String)READ, (boolean)false, (int)2, null)) {
            throw new IOException("unexpected journal line: " + line);
        }
    }

    private final void processJournal() throws IOException {
        DiskLruCacheKt.access$delete(this.fileSystem, this.journalFileTmp);
        Iterator<Entry> i = this.lruEntries.values().iterator();
        while (i.hasNext()) {
            int t;
            int n;
            Entry entry;
            Entry entry2 = entry = i.next();
            Intrinsics.checkNotNull((Object)entry2);
            if (entry2.getCurrentEditor() == null) {
                n = this.valueCount;
                for (t = 0; t < n; ++t) {
                    this.size += entry.getLengths()[t];
                }
                continue;
            }
            entry.setCurrentEditor(null);
            n = this.valueCount;
            for (t = 0; t < n; ++t) {
                DiskLruCacheKt.access$delete(this.fileSystem, entry.getCleanFiles()[t]);
                DiskLruCacheKt.access$delete(this.fileSystem, entry.getDirtyFiles()[t]);
            }
            i.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void rebuildJournal() throws IOException {
        if (this.journalWriter != null) {
            BufferedSink bufferedSink = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink);
            bufferedSink.close();
        }
        Closeable closeable = (Closeable)Okio.buffer((Sink)DiskLruCacheKt.access$sink(this.fileSystem, this.journalFileTmp));
        Throwable throwable = null;
        try {
            BufferedSink writer = (BufferedSink)closeable;
            boolean bl = false;
            writer.writeUtf8(MAGIC).writeByte(10);
            writer.writeUtf8(VERSION_1).writeByte(10);
            writer.writeDecimalLong((long)this.appVersion).writeByte(10);
            writer.writeDecimalLong((long)this.valueCount).writeByte(10);
            writer.writeByte(10);
            Iterator<Entry> iterator = this.lruEntries.values().iterator();
            while (iterator.hasNext()) {
                Entry entry;
                Entry entry2 = entry = iterator.next();
                Intrinsics.checkNotNull((Object)entry2);
                if (entry2.getCurrentEditor() != null) {
                    writer.writeUtf8(DIRTY).writeByte(32);
                    writer.writeUtf8(entry.getKey());
                    writer.writeByte(10);
                    continue;
                }
                writer.writeUtf8(CLEAN).writeByte(32);
                writer.writeUtf8(entry.getKey());
                entry.writeLengths(writer);
                writer.writeByte(10);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        if (DiskLruCacheKt.access$exists(this.fileSystem, this.journalFile)) {
            DiskLruCacheKt.access$rename(this.fileSystem, this.journalFile, this.journalFileBackup);
        }
        DiskLruCacheKt.access$rename(this.fileSystem, this.journalFileTmp, this.journalFile);
        DiskLruCacheKt.access$delete(this.fileSystem, this.journalFileBackup);
        this.journalWriter = this.newJournalWriter();
        this.hasJournalErrors = false;
        this.mostRecentRebuildFailed = false;
    }

    @Nullable
    public final synchronized Snapshot get(@NotNull String key) throws IOException {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.initialize();
        this.checkNotClosed();
        this.validateKey(key);
        Entry entry = this.lruEntries.get(key);
        if (entry == null || !entry.getReadable()) {
            return null;
        }
        Snapshot snapshot = entry.snapshot();
        if (snapshot == null) {
            return null;
        }
        Snapshot snapshot2 = snapshot;
        int n = this.redundantOpCount;
        this.redundantOpCount = n + 1;
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink);
        bufferedSink.writeUtf8(READ).writeByte(32).writeUtf8(key).writeByte(10);
        if (this.journalRebuildRequired()) {
            this.executor.execute(this.cleanupRunnable);
        }
        return snapshot2;
    }

    @Nullable
    public final Editor edit(@NotNull String key) throws IOException {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.edit(key, -1L);
    }

    @Nullable
    public final synchronized Editor edit(@NotNull String key, long expectedSequenceNumber) throws IOException {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.initialize();
        this.checkNotClosed();
        this.validateKey(key);
        Entry entry = this.lruEntries.get(key);
        if (expectedSequenceNumber != -1L && (entry == null || entry.getSequenceNumber() != expectedSequenceNumber)) {
            return null;
        }
        if (entry != null && entry.getCurrentEditor() != null) {
            return null;
        }
        if (this.mostRecentTrimFailed || this.mostRecentRebuildFailed) {
            this.executor.execute(this.cleanupRunnable);
            return null;
        }
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink);
        bufferedSink.writeUtf8(DIRTY).writeByte(32).writeUtf8(key).writeByte(10);
        BufferedSink bufferedSink2 = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink2);
        bufferedSink2.flush();
        if (this.hasJournalErrors) {
            return null;
        }
        if (entry == null) {
            entry = new Entry(key);
            ((Map)this.lruEntries).put(key, entry);
        }
        Editor editor = new Editor(entry);
        entry.setCurrentEditor(editor);
        return editor;
    }

    public final synchronized void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
        if (this.initialized) {
            this.executor.execute(this.cleanupRunnable);
        }
    }

    public final synchronized long size() throws IOException {
        this.initialize();
        return this.size;
    }

    public final synchronized void completeEdit(@NotNull Editor editor, boolean success) throws IOException {
        int i;
        int n;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Entry entry = editor.getEntry();
        if (!Intrinsics.areEqual((Object)entry.getCurrentEditor(), (Object)editor)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (success && !entry.getReadable()) {
            n = this.valueCount;
            for (i = 0; i < n; ++i) {
                boolean[] blArray = editor.getWritten();
                Intrinsics.checkNotNull((Object)blArray);
                if (!blArray[i]) {
                    editor.abort();
                    throw new IllegalStateException("Newly created entry didn't create value for index " + i);
                }
                if (DiskLruCacheKt.access$exists(this.fileSystem, entry.getDirtyFiles()[i])) continue;
                editor.abort();
                return;
            }
        }
        n = this.valueCount;
        for (i = 0; i < n; ++i) {
            File dirty = entry.getDirtyFiles()[i];
            if (success) {
                long newLength;
                if (!DiskLruCacheKt.access$exists(this.fileSystem, dirty)) continue;
                File clean = entry.getCleanFiles()[i];
                DiskLruCacheKt.access$rename(this.fileSystem, dirty, clean);
                long oldLength = entry.getLengths()[i];
                entry.getLengths()[i] = newLength = DiskLruCacheKt.access$size(this.fileSystem, clean);
                this.size = this.size - oldLength + newLength;
                continue;
            }
            DiskLruCacheKt.access$delete(this.fileSystem, dirty);
        }
        int n2 = this.redundantOpCount;
        this.redundantOpCount = n2 + 1;
        entry.setCurrentEditor(null);
        if (entry.getReadable() || success) {
            entry.setReadable(true);
            BufferedSink bufferedSink = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink);
            bufferedSink.writeUtf8(CLEAN).writeByte(32);
            BufferedSink bufferedSink2 = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink2);
            bufferedSink2.writeUtf8(entry.getKey());
            entry.writeLengths(this.journalWriter);
            BufferedSink bufferedSink3 = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink3);
            bufferedSink3.writeByte(10);
            if (success) {
                long l = this.nextSequenceNumber;
                this.nextSequenceNumber = l + 1L;
                entry.setSequenceNumber(l);
            }
        } else {
            this.lruEntries.remove(entry.getKey());
            BufferedSink bufferedSink = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink);
            bufferedSink.writeUtf8(REMOVE).writeByte(32);
            BufferedSink bufferedSink4 = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink4);
            bufferedSink4.writeUtf8(entry.getKey());
            BufferedSink bufferedSink5 = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink5);
            bufferedSink5.writeByte(10);
        }
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink);
        bufferedSink.flush();
        if (this.size > this.maxSize || this.journalRebuildRequired()) {
            this.executor.execute(this.cleanupRunnable);
        }
    }

    public final boolean journalRebuildRequired() {
        int redundantOpCompactThreshold = 2000;
        return this.redundantOpCount >= redundantOpCompactThreshold && this.redundantOpCount >= this.lruEntries.size();
    }

    public final synchronized boolean remove(@NotNull String key) throws IOException {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.initialize();
        this.checkNotClosed();
        this.validateKey(key);
        Entry entry = this.lruEntries.get(key);
        if (entry == null) {
            return false;
        }
        Entry entry2 = entry;
        boolean removed = this.removeEntry(entry2);
        if (removed && this.size <= this.maxSize) {
            this.mostRecentTrimFailed = false;
        }
        return removed;
    }

    public final boolean removeEntry(@Nullable Entry entry) throws IOException {
        Entry entry2 = entry;
        Intrinsics.checkNotNull((Object)entry2);
        if (entry2.getCurrentEditor() != null) {
            Editor editor = entry.getCurrentEditor();
            Intrinsics.checkNotNull((Object)editor);
            editor.detach();
        }
        int n = this.valueCount;
        for (int i = 0; i < n; ++i) {
            DiskLruCacheKt.access$delete(this.fileSystem, entry.getCleanFiles()[i]);
            this.size -= entry.getLengths()[i];
            entry.getLengths()[i] = 0L;
        }
        int n2 = this.redundantOpCount;
        this.redundantOpCount = n2 + 1;
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink);
        bufferedSink.writeUtf8(REMOVE).writeByte(32).writeUtf8(entry.getKey()).writeByte(10);
        this.lruEntries.remove(entry.getKey());
        if (this.journalRebuildRequired()) {
            this.executor.execute(this.cleanupRunnable);
        }
        return true;
    }

    private final synchronized void checkNotClosed() {
        if (!(!this.isClosed)) {
            boolean bl = false;
            String string = "cache is closed";
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (!this.initialized) {
            return;
        }
        this.checkNotClosed();
        this.trimToSize();
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink);
        bufferedSink.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.initialized || this.isClosed) {
            this.isClosed = true;
            return;
        }
        Collection<Entry> collection = this.lruEntries.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"lruEntries.values");
        Collection<Entry> $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection<Entry> thisCollection$iv = $this$toTypedArray$iv;
        Entry[] entryArray = thisCollection$iv.toArray(new Entry[0]);
        Intrinsics.checkNotNull((Object)entryArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        Entry[] entryArray2 = entryArray;
        int n = entryArray2.length;
        for (int i = 0; i < n; ++i) {
            Entry entry;
            Entry entry2 = entry = entryArray2[i];
            if ((entry2 != null ? entry2.getCurrentEditor() : null) == null) continue;
            Editor editor = entry.getCurrentEditor();
            Intrinsics.checkNotNull((Object)editor);
            editor.abort();
        }
        this.trimToSize();
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink);
        bufferedSink.close();
        this.journalWriter = null;
        this.isClosed = true;
    }

    public final void trimToSize() throws IOException {
        while (this.size > this.maxSize) {
            Entry toEvict = this.lruEntries.values().iterator().next();
            this.removeEntry(toEvict);
        }
        this.mostRecentTrimFailed = false;
    }

    public final void delete() throws IOException {
        this.close();
        DiskLruCacheKt.access$deleteRecursively(this.fileSystem, this.directory);
    }

    public final synchronized void evictAll() throws IOException {
        this.initialize();
        Collection<Entry> collection = this.lruEntries.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"lruEntries.values");
        Collection<Entry> $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection<Entry> thisCollection$iv = $this$toTypedArray$iv;
        Entry[] entryArray = thisCollection$iv.toArray(new Entry[0]);
        Intrinsics.checkNotNull((Object)entryArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        for (Entry entry : entryArray) {
            this.removeEntry(entry);
        }
        this.mostRecentTrimFailed = false;
    }

    private final void validateKey(String key) {
        Matcher matcher = LEGAL_KEY_PATTERN.matcher(key);
        if (!matcher.matches()) {
            boolean bl = false;
            String string = "keys must match regex [a-z0-9_-]{1,120}: \"" + key + '\"';
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final synchronized Iterator<Snapshot> snapshots() throws IOException {
        this.initialize();
        return new Iterator<Snapshot>(this){
            @NotNull
            private final Iterator<Entry> delegate;
            @Nullable
            private Snapshot nextSnapshot;
            @Nullable
            private Snapshot removeSnapshot;
            final /* synthetic */ DiskLruCache this$0;
            {
                this.this$0 = $receiver;
                Iterator<Entry> iterator = new ArrayList<Entry>($receiver.getLruEntries().values()).iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"ArrayList(lruEntries.values).iterator()");
                this.delegate = iterator;
            }

            @NotNull
            public final Iterator<Entry> getDelegate() {
                return this.delegate;
            }

            @Nullable
            public final Snapshot getNextSnapshot() {
                return this.nextSnapshot;
            }

            public final void setNextSnapshot(@Nullable Snapshot snapshot) {
                this.nextSnapshot = snapshot;
            }

            @Nullable
            public final Snapshot getRemoveSnapshot() {
                return this.removeSnapshot;
            }

            public final void setRemoveSnapshot(@Nullable Snapshot snapshot) {
                this.removeSnapshot = snapshot;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasNext() {
                if (this.nextSnapshot != null) {
                    return true;
                }
                DiskLruCache diskLruCache = this.this$0;
                DiskLruCache diskLruCache2 = this.this$0;
                DiskLruCache diskLruCache3 = diskLruCache;
                synchronized (diskLruCache3) {
                    block7: {
                        boolean bl = false;
                        if (!diskLruCache2.isClosed()) break block7;
                        boolean bl2 = false;
                        return bl2;
                    }
                    while (this.delegate.hasNext()) {
                        Snapshot snapshot;
                        Entry entry;
                        Entry entry2 = entry = this.delegate.next();
                        Intrinsics.checkNotNull((Object)entry2);
                        Snapshot snapshot2 = entry2.snapshot();
                        if (snapshot2 == null) continue;
                        this.nextSnapshot = snapshot = snapshot2;
                        boolean bl = true;
                        return bl;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                return false;
            }

            @NotNull
            public Snapshot next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.removeSnapshot = this.nextSnapshot;
                this.nextSnapshot = null;
                Snapshot snapshot = this.removeSnapshot;
                Intrinsics.checkNotNull((Object)snapshot);
                return snapshot;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void remove() {
                if (this.removeSnapshot == null) {
                    boolean bl = false;
                    String string = "remove() before next()";
                    throw new IllegalStateException(string.toString());
                }
                try {
                    Snapshot snapshot = this.removeSnapshot;
                    Intrinsics.checkNotNull((Object)snapshot);
                    this.this$0.remove(snapshot.getKey());
                }
                catch (IOException iOException) {
                }
                finally {
                    this.removeSnapshot = null;
                }
            }
        };
    }

    public final void closeQuietly(@Nullable Closeable closeable, @Nullable String name) {
        try {
            Closeable closeable2 = closeable;
            if (closeable2 != null) {
                closeable2.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @JvmStatic
    @NotNull
    public static final DiskLruCache create(@NotNull FileSystem fileSystem, @NotNull File directory, int appVersion, int valueCount, long maxSize) {
        return Companion.create(fileSystem, directory, appVersion, valueCount, maxSize);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B-\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\f\u0010\u0011\u001a\b\u0018\u00010\u0012R\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0002\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Snapshot;", "Ljava/io/Closeable;", "key", "", "sequenceNumber", "", "sources", "", "Lokio/Source;", "lengths", "", "(Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache;Ljava/lang/String;J[Lokio/Source;[J)V", "getKey", "()Ljava/lang/String;", "[Lokio/Source;", "close", "", "edit", "Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Editor;", "Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache;", "getLength", "index", "", "getSource", "apollo-http-cache"})
    public final class Snapshot
    implements Closeable {
        @NotNull
        private final String key;
        private final long sequenceNumber;
        @NotNull
        private final Source[] sources;
        @NotNull
        private final long[] lengths;

        public Snapshot(String key, @NotNull long sequenceNumber, @NotNull Source[] sources, long[] lengths) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)sources, (String)"sources");
            Intrinsics.checkNotNullParameter((Object)lengths, (String)"lengths");
            this.key = key;
            this.sequenceNumber = sequenceNumber;
            this.sources = sources;
            this.lengths = lengths;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final String key() {
            return this.key;
        }

        @Nullable
        public final Editor edit() throws IOException {
            return DiskLruCache.this.edit(this.key, this.sequenceNumber);
        }

        @NotNull
        public final Source getSource(int index) {
            return this.sources[index];
        }

        public final long getLength(int index) {
            return this.lengths[index];
        }

        @Override
        public void close() {
            for (Source in : this.sources) {
                DiskLruCache.this.closeQuietly((Closeable)in, "source");
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0018\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0013\b\u0000\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\u0006\u0010\u0011\u001a\u00020\u000fJ\u0006\u0010\u0012\u001a\u00020\u000fJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Editor;", "", "entry", "Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Entry;", "Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache;", "(Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache;Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Entry;)V", "done", "", "getEntry", "()Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Entry;", "written", "", "getWritten", "()[Z", "abort", "", "abortUnlessCommitted", "commit", "detach", "newSink", "Lokio/Sink;", "index", "", "newSource", "Lokio/Source;", "apollo-http-cache"})
    public final class Editor {
        @NotNull
        private final Entry entry;
        @Nullable
        private final boolean[] written;
        private boolean done;

        public Editor(Entry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            this.entry = entry;
            this.written = this.entry.getReadable() ? null : new boolean[DiskLruCache.this.getValueCount()];
        }

        @NotNull
        public final Entry getEntry() {
            return this.entry;
        }

        @Nullable
        public final boolean[] getWritten() {
            return this.written;
        }

        public final void detach() {
            if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor(), (Object)this)) {
                int n = DiskLruCache.this.getValueCount();
                for (int i = 0; i < n; ++i) {
                    try {
                        DiskLruCacheKt.access$delete(DiskLruCache.this.fileSystem, this.entry.getDirtyFiles()[i]);
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.entry.setCurrentEditor(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final Source newSource(int index) {
            DiskLruCache diskLruCache = DiskLruCache.this;
            DiskLruCache diskLruCache2 = DiskLruCache.this;
            DiskLruCache diskLruCache3 = diskLruCache;
            synchronized (diskLruCache3) {
                Source source;
                boolean bl = false;
                if (!(!this.done)) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                if (!this.entry.getReadable() || !Intrinsics.areEqual((Object)this.entry.getCurrentEditor(), (Object)this)) {
                    source = null;
                } else {
                    Source source2;
                    try {
                        source2 = DiskLruCacheKt.access$source(diskLruCache2.fileSystem, this.entry.getCleanFiles()[index]);
                    }
                    catch (FileNotFoundException e) {
                        source2 = null;
                    }
                    source = source2;
                }
                Source source3 = source;
                return source3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Sink newSink(int index) {
            DiskLruCache diskLruCache = DiskLruCache.this;
            DiskLruCache diskLruCache2 = DiskLruCache.this;
            DiskLruCache diskLruCache3 = diskLruCache;
            synchronized (diskLruCache3) {
                Sink sink;
                block9: {
                    boolean bl = false;
                    if (!(!this.done)) {
                        String string = "Check failed.";
                        throw new IllegalStateException(string.toString());
                    }
                    if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor(), (Object)this)) break block9;
                    Sink sink2 = Okio.blackhole();
                    return sink2;
                }
                if (!this.entry.getReadable()) {
                    Intrinsics.checkNotNull((Object)this.written);
                    this.written[index] = true;
                }
                File dirtyFile = this.entry.getDirtyFiles()[index];
                try {
                    sink = DiskLruCacheKt.access$sink(diskLruCache2.fileSystem, dirtyFile);
                }
                catch (FileNotFoundException e) {
                    Sink sink3 = Okio.blackhole();
                    return sink3;
                }
                Sink sink4 = sink;
                Sink sink5 = (Sink)new FaultHidingSink(sink4, diskLruCache2, this){
                    final /* synthetic */ DiskLruCache this$0;
                    final /* synthetic */ Editor this$1;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        super($sink);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void onException(@Nullable IOException e) {
                        DiskLruCache diskLruCache = this.this$0;
                        Editor editor = this.this$1;
                        DiskLruCache diskLruCache2 = diskLruCache;
                        synchronized (diskLruCache2) {
                            boolean bl = false;
                            editor.detach();
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                };
                return sink5;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void commit() throws IOException {
            DiskLruCache diskLruCache = DiskLruCache.this;
            DiskLruCache diskLruCache2 = DiskLruCache.this;
            DiskLruCache diskLruCache3 = diskLruCache;
            synchronized (diskLruCache3) {
                boolean bl = false;
                if (!(!this.done)) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor(), (Object)this)) {
                    diskLruCache2.completeEdit(this, true);
                }
                this.done = true;
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void abort() throws IOException {
            DiskLruCache diskLruCache = DiskLruCache.this;
            DiskLruCache diskLruCache2 = DiskLruCache.this;
            DiskLruCache diskLruCache3 = diskLruCache;
            synchronized (diskLruCache3) {
                boolean bl = false;
                if (!(!this.done)) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor(), (Object)this)) {
                    diskLruCache2.completeEdit(this, false);
                }
                this.done = true;
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void abortUnlessCommitted() {
            DiskLruCache diskLruCache = DiskLruCache.this;
            DiskLruCache diskLruCache2 = DiskLruCache.this;
            DiskLruCache diskLruCache3 = diskLruCache;
            synchronized (diskLruCache3) {
                boolean bl = false;
                if (!this.done && Intrinsics.areEqual((Object)this.entry.getCurrentEditor(), (Object)this)) {
                    try {
                        diskLruCache2.completeEdit(this, false);
                    }
                    catch (IOException iOException) {
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u0002\u00a2\u0006\u0002\u0010)J\u0019\u0010*\u001a\u00020+2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010,J\f\u0010-\u001a\b\u0018\u00010.R\u00020\rJ\u0010\u0010/\u001a\u00020+2\b\u00100\u001a\u0004\u0018\u000101R\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR \u0010\u000b\u001a\b\u0018\u00010\fR\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u0013\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u00062"}, d2={"Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Entry;", "", "key", "", "(Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache;Ljava/lang/String;)V", "cleanFiles", "", "Ljava/io/File;", "getCleanFiles", "()[Ljava/io/File;", "[Ljava/io/File;", "currentEditor", "Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Editor;", "Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache;", "getCurrentEditor", "()Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Editor;", "setCurrentEditor", "(Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Editor;)V", "dirtyFiles", "getDirtyFiles", "getKey", "()Ljava/lang/String;", "lengths", "", "getLengths", "()[J", "readable", "", "getReadable", "()Z", "setReadable", "(Z)V", "sequenceNumber", "", "getSequenceNumber", "()J", "setSequenceNumber", "(J)V", "invalidLengths", "Ljava/io/IOException;", "strings", "([Ljava/lang/String;)Ljava/io/IOException;", "setLengths", "", "([Ljava/lang/String;)V", "snapshot", "Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Snapshot;", "writeLengths", "writer", "Lokio/BufferedSink;", "apollo-http-cache"})
    public final class Entry {
        @NotNull
        private final String key;
        @NotNull
        private final long[] lengths;
        @NotNull
        private final File[] cleanFiles;
        @NotNull
        private final File[] dirtyFiles;
        private boolean readable;
        @Nullable
        private Editor currentEditor;
        private long sequenceNumber;

        public Entry(String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.key = key;
            this.lengths = new long[DiskLruCache.this.getValueCount()];
            List tmpCleanFiles = new ArrayList();
            List tmpDirtyFiles = new ArrayList();
            StringBuilder fileBuilder = new StringBuilder(this.key).append('.');
            int truncateTo = fileBuilder.length();
            int n = DiskLruCache.this.getValueCount();
            for (int i = 0; i < n; ++i) {
                fileBuilder.append(i);
                tmpCleanFiles.add(new File(DiskLruCache.this.directory, fileBuilder.toString()));
                fileBuilder.append(".tmp");
                tmpDirtyFiles.add(new File(DiskLruCache.this.directory, fileBuilder.toString()));
                fileBuilder.setLength(truncateTo);
            }
            Collection $this$toTypedArray$iv = tmpCleanFiles;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            File[] fileArray = thisCollection$iv.toArray(new File[0]);
            Intrinsics.checkNotNull((Object)fileArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            this.cleanFiles = fileArray;
            $this$toTypedArray$iv = tmpDirtyFiles;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            File[] fileArray2 = thisCollection$iv.toArray(new File[0]);
            Intrinsics.checkNotNull((Object)fileArray2, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            this.dirtyFiles = fileArray2;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final long[] getLengths() {
            return this.lengths;
        }

        @NotNull
        public final File[] getCleanFiles() {
            return this.cleanFiles;
        }

        @NotNull
        public final File[] getDirtyFiles() {
            return this.dirtyFiles;
        }

        public final boolean getReadable() {
            return this.readable;
        }

        public final void setReadable(boolean bl) {
            this.readable = bl;
        }

        @Nullable
        public final Editor getCurrentEditor() {
            return this.currentEditor;
        }

        public final void setCurrentEditor(@Nullable Editor editor) {
            this.currentEditor = editor;
        }

        public final long getSequenceNumber() {
            return this.sequenceNumber;
        }

        public final void setSequenceNumber(long l) {
            this.sequenceNumber = l;
        }

        public final void setLengths(@NotNull String[] strings) throws IOException {
            Intrinsics.checkNotNullParameter((Object)strings, (String)"strings");
            if (strings.length != DiskLruCache.this.getValueCount()) {
                throw this.invalidLengths(strings);
            }
            try {
                int n = strings.length;
                for (int i = 0; i < n; ++i) {
                    this.lengths[i] = Long.parseLong(strings[i]);
                }
            }
            catch (NumberFormatException e) {
                throw this.invalidLengths(strings);
            }
        }

        public final void writeLengths(@Nullable BufferedSink writer) throws IOException {
            for (long length : this.lengths) {
                BufferedSink bufferedSink = writer;
                Intrinsics.checkNotNull((Object)bufferedSink);
                bufferedSink.writeByte(32).writeDecimalLong(length);
            }
        }

        private final IOException invalidLengths(String[] strings) throws IOException {
            StringBuilder stringBuilder = new StringBuilder().append("unexpected journal line: ");
            String string = Arrays.toString(strings);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
            throw new IOException(stringBuilder.append(string).toString());
        }

        @Nullable
        public final Snapshot snapshot() {
            Snapshot snapshot;
            if (!Thread.holdsLock(DiskLruCache.this)) {
                throw new AssertionError();
            }
            Source[] sources = new Source[DiskLruCache.this.getValueCount()];
            long[] lengths = (long[])this.lengths.clone();
            try {
                int n = DiskLruCache.this.getValueCount();
                for (int i = 0; i < n; ++i) {
                    sources[i] = DiskLruCacheKt.access$source(DiskLruCache.this.fileSystem, this.cleanFiles[i]);
                }
                snapshot = new Snapshot(this.key, this.sequenceNumber, sources, lengths);
            }
            catch (FileNotFoundException e) {
                for (int i = 0; i < DiskLruCache.this.getValueCount() && sources[i] != null; ++i) {
                    DiskLruCache.this.closeQuietly((Closeable)sources[i], "file");
                }
                try {
                    DiskLruCache.this.removeEntry(this);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                snapshot = null;
            }
            return snapshot;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Companion;", "", "()V", "ANY_SEQUENCE_NUMBER", "", "CLEAN", "", "DIRTY", "JOURNAL_FILE", "JOURNAL_FILE_BACKUP", "JOURNAL_FILE_TEMP", "LEGAL_KEY_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getLEGAL_KEY_PATTERN", "()Ljava/util/regex/Pattern;", "MAGIC", "READ", "REMOVE", "VERSION_1", "create", "Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache;", "fileSystem", "Lokio/FileSystem;", "directory", "Ljava/io/File;", "appVersion", "", "valueCount", "maxSize", "apollo-http-cache"})
    public static final class Companion {
        private Companion() {
        }

        public final Pattern getLEGAL_KEY_PATTERN() {
            return LEGAL_KEY_PATTERN;
        }

        @JvmStatic
        @NotNull
        public final DiskLruCache create(@NotNull FileSystem fileSystem, @NotNull File directory, int appVersion, int valueCount, long maxSize) {
            Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            if (!(maxSize > 0L)) {
                boolean $i$a$-require-DiskLruCache$Companion$create$32 = false;
                String $i$a$-require-DiskLruCache$Companion$create$32 = "maxSize <= 0";
                throw new IllegalArgumentException($i$a$-require-DiskLruCache$Companion$create$32.toString());
            }
            if (!(valueCount > 0)) {
                boolean bl = false;
                String string = "valueCount <= 0";
                throw new IllegalArgumentException(string.toString());
            }
            Executor executor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new LinkedBlockingQueue(), Companion::create$lambda$2);
            return new DiskLruCache(fileSystem, directory, appVersion, valueCount, maxSize, executor);
        }

        private static final Thread create$lambda$2(Runnable runnable) {
            Thread result = new Thread(runnable, "OkHttp DiskLruCache");
            result.setDaemon(true);
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

