/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.http;

import com.apollographql.apollo3.api.cache.http.HttpCacheRecordEditor;
import com.apollographql.apollo3.api.internal.ApolloLogger;
import com.apollographql.apollo3.cache.http.ResponseBodyCacheSink;
import com.apollographql.apollo3.cache.http.Utils;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0011B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\u000eH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/apollographql/apollo3/cache/http/ResponseBodyProxy;", "Lokhttp3/ResponseBody;", "cacheRecordEditor", "Lcom/apollographql/apollo3/api/cache/http/HttpCacheRecordEditor;", "sourceResponse", "Lokhttp3/Response;", "logger", "Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "(Lcom/apollographql/apollo3/api/cache/http/HttpCacheRecordEditor;Lokhttp3/Response;Lcom/apollographql/apollo3/api/internal/ApolloLogger;)V", "contentLength", "", "contentType", "responseBodySource", "Lokio/BufferedSource;", "", "Lokhttp3/MediaType;", "source", "ProxySource", "apollo-http-cache"})
public final class ResponseBodyProxy
extends ResponseBody {
    private final String contentType;
    private final String contentLength;
    private final BufferedSource responseBodySource;

    @Nullable
    public MediaType contentType() {
        return this.contentType != null ? MediaType.parse((String)this.contentType) : null;
    }

    public long contentLength() {
        long l;
        try {
            long l2;
            String string = this.contentLength;
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                l2 = Long.parseLong(string2);
            } else {
                l2 = -1L;
            }
            l = l2;
        }
        catch (NumberFormatException e) {
            l = -1L;
        }
        return l;
    }

    @NotNull
    public BufferedSource source() {
        return this.responseBodySource;
    }

    public ResponseBodyProxy(@NotNull HttpCacheRecordEditor cacheRecordEditor2, @NotNull Response sourceResponse, @NotNull ApolloLogger logger) {
        Intrinsics.checkNotNullParameter((Object)cacheRecordEditor2, (String)"cacheRecordEditor");
        Intrinsics.checkNotNullParameter((Object)sourceResponse, (String)"sourceResponse");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        com.apollographql.apollo3.api.internal.Utils.checkNotNull((Object)cacheRecordEditor2, (Object)"cacheRecordEditor == null");
        com.apollographql.apollo3.api.internal.Utils.checkNotNull((Object)sourceResponse, (Object)"sourceResponse == null");
        com.apollographql.apollo3.api.internal.Utils.checkNotNull((Object)logger, (Object)"logger == null");
        this.contentType = sourceResponse.header("Content-Type");
        this.contentLength = sourceResponse.header("Content-Length");
        ResponseBody responseBody = sourceResponse.body();
        Intrinsics.checkNotNull((Object)responseBody);
        BufferedSource bufferedSource = responseBody.source();
        Intrinsics.checkNotNullExpressionValue((Object)bufferedSource, (String)"sourceResponse.body()!!.source()");
        this.responseBodySource = Okio.buffer((Source)new ProxySource(cacheRecordEditor2, bufferedSource, logger));
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/apollographql/apollo3/cache/http/ResponseBodyProxy$ProxySource;", "Lokio/Source;", "cacheRecordEditor", "Lcom/apollographql/apollo3/api/cache/http/HttpCacheRecordEditor;", "responseBodySource", "Lokio/BufferedSource;", "logger", "Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "(Lcom/apollographql/apollo3/api/cache/http/HttpCacheRecordEditor;Lokio/BufferedSource;Lcom/apollographql/apollo3/api/internal/ApolloLogger;)V", "closed", "", "responseBodyCacheSink", "Lcom/apollographql/apollo3/cache/http/ResponseBodyCacheSink;", "abortCacheQuietly", "", "close", "commitCache", "read", "", "sink", "Lokio/Buffer;", "byteCount", "timeout", "Lokio/Timeout;", "apollo-http-cache"})
    private static final class ProxySource
    implements Source {
        private final ResponseBodyCacheSink responseBodyCacheSink;
        private boolean closed;
        private final HttpCacheRecordEditor cacheRecordEditor;
        private final BufferedSource responseBodySource;
        private final ApolloLogger logger;

        public long read(@NotNull Buffer sink, long byteCount) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            long bytesRead = 0L;
            try {
                bytesRead = this.responseBodySource.read(sink, byteCount);
            }
            catch (IOException e) {
                if (!this.closed) {
                    this.closed = true;
                    this.abortCacheQuietly();
                }
                throw (Throwable)e;
            }
            if (bytesRead == -1L) {
                if (!this.closed) {
                    this.closed = true;
                    this.commitCache();
                }
                return -1L;
            }
            this.responseBodyCacheSink.copyFrom(sink, sink.size() - bytesRead, bytesRead);
            return bytesRead;
        }

        @NotNull
        public Timeout timeout() {
            return this.responseBodySource.timeout();
        }

        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (Utils.INSTANCE.discard(this, 100, TimeUnit.MILLISECONDS)) {
                this.commitCache();
            } else {
                this.abortCacheQuietly();
            }
        }

        private final void commitCache() {
            Utils.INSTANCE.closeQuietly((Closeable)this.responseBodySource);
            try {
                this.responseBodyCacheSink.close();
                this.cacheRecordEditor.commit();
            }
            catch (Exception e) {
                Utils.INSTANCE.closeQuietly((Closeable)((Object)this.responseBodyCacheSink));
                this.abortCacheQuietly();
                this.logger.e((Throwable)e, "Failed to commit cache changes", new Object[0]);
            }
        }

        public final void abortCacheQuietly() {
            Utils.INSTANCE.closeQuietly((Closeable)this.responseBodySource);
            Utils.INSTANCE.closeQuietly((Closeable)((Object)this.responseBodyCacheSink));
            try {
                this.cacheRecordEditor.abort();
            }
            catch (Exception e) {
                this.logger.w((Throwable)e, "Failed to abort cache edit", new Object[0]);
            }
        }

        public ProxySource(@NotNull HttpCacheRecordEditor cacheRecordEditor2, @NotNull BufferedSource responseBodySource, @NotNull ApolloLogger logger) {
            Intrinsics.checkNotNullParameter((Object)cacheRecordEditor2, (String)"cacheRecordEditor");
            Intrinsics.checkNotNullParameter((Object)responseBodySource, (String)"responseBodySource");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            this.cacheRecordEditor = cacheRecordEditor2;
            this.responseBodySource = responseBodySource;
            this.logger = logger;
            this.responseBodyCacheSink = new ResponseBodyCacheSink(Okio.buffer((Sink)this.cacheRecordEditor.bodySink())){

                @Override
                public void onException(@Nullable Exception e) {
                    this.abortCacheQuietly();
                    logger.w((Throwable)e, "Operation failed", new Object[0]);
                }
            };
        }
    }
}

