/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.http;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\b\u0010\u000f\u001a\u00020\bH\u0016J\u0018\u0010\u0010\u001a\u00020\b2\u000e\u0010\u0011\u001a\n\u0018\u00010\u0012j\u0004\u0018\u0001`\u0013H&J\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/apollographql/apollo3/cache/http/ResponseBodyCacheSink;", "Lokio/ForwardingSink;", "delegate", "Lokio/BufferedSink;", "(Lokio/BufferedSink;)V", "failed", "", "close", "", "copyFrom", "buffer", "Lokio/Buffer;", "offset", "", "bytesCount", "flush", "onException", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "write", "source", "byteCount", "apollo-http-cache"})
public abstract class ResponseBodyCacheSink
extends ForwardingSink {
    private boolean failed;

    public ResponseBodyCacheSink(@Nullable BufferedSink delegate) {
        Intrinsics.checkNotNull((Object)delegate);
        super((Sink)delegate);
    }

    public void write(@NotNull Buffer source, long byteCount) throws IOException {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (this.failed) {
            return;
        }
        try {
            super.write(source, byteCount);
        }
        catch (Exception e) {
            this.failed = true;
            this.onException(e);
        }
    }

    public void flush() throws IOException {
        if (this.failed) {
            return;
        }
        try {
            super.flush();
        }
        catch (Exception e) {
            this.failed = true;
            this.onException(e);
        }
    }

    public void close() throws IOException {
        if (this.failed) {
            return;
        }
        try {
            super.close();
        }
        catch (Exception e) {
            this.failed = true;
            this.onException(e);
        }
    }

    public final void copyFrom(@NotNull Buffer buffer, long offset, long bytesCount) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (this.failed) {
            return;
        }
        try {
            BufferedSink outSink = (BufferedSink)this.delegate();
            buffer.copyTo(outSink.buffer(), offset, bytesCount);
            outSink.emitCompleteSegments();
        }
        catch (Exception e) {
            this.failed = true;
            this.onException(e);
        }
    }

    public abstract void onException(@Nullable Exception var1);
}

