/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.http;

import com.apollographql.apollo3.api.internal.ApolloLogger;
import com.apollographql.apollo3.cache.http.ApolloHttpCache;
import com.apollographql.apollo3.cache.http.Utils;
import java.io.Closeable;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\u0015\u001a\u0004\u0018\u00010\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/apollographql/apollo3/cache/http/HttpCacheInterceptor;", "Lokhttp3/Interceptor;", "cache", "Lcom/apollographql/apollo3/cache/http/ApolloHttpCache;", "logger", "Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "(Lcom/apollographql/apollo3/cache/http/ApolloHttpCache;Lcom/apollographql/apollo3/api/internal/ApolloLogger;)V", "cacheFirst", "Lokhttp3/Response;", "request", "Lokhttp3/Request;", "chain", "Lokhttp3/Interceptor$Chain;", "cacheOnlyResponse", "cachedResponse", "intercept", "logCacheHit", "", "logCacheMiss", "networkFirst", "networkOnly", "prefetch", "networkResponse", "cacheKey", "", "apollo-http-cache"})
public final class HttpCacheInterceptor
implements Interceptor {
    @NotNull
    private final ApolloHttpCache cache;
    @NotNull
    private final ApolloLogger logger;

    public HttpCacheInterceptor(@Nullable ApolloHttpCache cache, @Nullable ApolloLogger logger) {
        this.cache = (ApolloHttpCache)com.apollographql.apollo3.api.internal.Utils.checkNotNull((Object)cache, (Object)"cache == null");
        this.logger = (ApolloLogger)com.apollographql.apollo3.api.internal.Utils.checkNotNull((Object)logger, (Object)"logger == null");
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request = chain.request();
        Intrinsics.checkNotNullExpressionValue((Object)request, (String)"request");
        if (Utils.INSTANCE.shouldSkipCache(request)) {
            Object[] objectArray2 = new Object[]{request};
            this.logger.d("Skip http cache for request: %s", objectArray2);
            objectArray2 = chain.proceed(request);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"chain.proceed(request)");
            return objectArray2;
        }
        if (Utils.INSTANCE.shouldSkipNetwork(request)) {
            Object[] objectArray3 = new Object[]{request};
            this.logger.d("Read http cache only for request: %s", objectArray3);
            objectArray3 = this.cacheOnlyResponse(request);
            Intrinsics.checkNotNull((Object)objectArray3);
            return objectArray3;
        }
        if (Utils.INSTANCE.isNetworkOnly(request)) {
            Object[] objectArray4 = new Object[]{request};
            this.logger.d("Skip http cache network only request: %s", objectArray4);
            objectArray4 = this.networkOnly(request, chain);
            Intrinsics.checkNotNull((Object)objectArray4);
            return objectArray4;
        }
        if (Utils.INSTANCE.isNetworkFirst(request)) {
            Object[] objectArray5 = new Object[]{request};
            this.logger.d("Network first for request: %s", objectArray5);
            objectArray5 = this.networkFirst(request, chain);
            Intrinsics.checkNotNull((Object)objectArray5);
            objectArray = objectArray5;
        } else {
            Object[] objectArray6 = new Object[]{request};
            this.logger.d("Cache first for request: %s", objectArray6);
            objectArray6 = this.cacheFirst(request, chain);
            Intrinsics.checkNotNull((Object)objectArray6);
            objectArray = objectArray6;
        }
        return objectArray;
    }

    private final Response cacheOnlyResponse(Request request) throws IOException {
        Response cacheResponse = this.cachedResponse(request);
        if (cacheResponse == null) {
            this.logCacheMiss(request);
            return Utils.INSTANCE.unsatisfiableCacheRequest(request);
        }
        this.logCacheHit(request);
        return cacheResponse.newBuilder().cacheResponse(Utils.INSTANCE.strip(cacheResponse)).build();
    }

    private final Response networkOnly(Request request, Interceptor.Chain chain) throws IOException {
        Response response;
        String cacheKey = request.header("X-APOLLO-CACHE-KEY");
        Object[] objectArray = chain.proceed(request);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"chain.proceed(request)");
        Response networkResponse = Utils.INSTANCE.withServedDateHeader((Response)objectArray);
        if (Utils.INSTANCE.isPrefetchResponse(request)) {
            response = this.prefetch(networkResponse, cacheKey);
        } else {
            Intrinsics.checkNotNull((Object)networkResponse);
            if (networkResponse.isSuccessful()) {
                objectArray = new Object[2];
                objectArray[0] = request;
                Intrinsics.checkNotNull((Object)cacheKey);
                objectArray[1] = cacheKey;
                this.logger.d("Network success, skip http cache for request: %s, with cache key: %s", objectArray);
                response = this.cache.cacheProxy(networkResponse, cacheKey);
            } else {
                response = networkResponse;
            }
        }
        return response;
    }

    private final Response networkFirst(Request request, Interceptor.Chain chain) throws IOException {
        String cacheKey = request.header("X-APOLLO-CACHE-KEY");
        IOException rethrowException = null;
        Response networkResponse = null;
        try {
            Object[] objectArray = chain.proceed(request);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"chain.proceed(request)");
            networkResponse = Utils.INSTANCE.withServedDateHeader((Response)objectArray);
            if (networkResponse.isSuccessful()) {
                objectArray = new Object[2];
                objectArray[0] = request;
                Intrinsics.checkNotNull((Object)cacheKey);
                objectArray[1] = cacheKey;
                this.logger.d("Network success, skip http cache for request: %s, with cache key: %s", objectArray);
                return this.cache.cacheProxy(networkResponse, cacheKey);
            }
            rethrowException = null;
        }
        catch (IOException e) {
            rethrowException = e;
        }
        Response cachedResponse = this.cachedResponse(request);
        if (cachedResponse == null) {
            this.logCacheMiss(request);
            if (rethrowException != null) {
                throw rethrowException;
            }
            return networkResponse;
        }
        this.logCacheHit(request);
        return cachedResponse.newBuilder().cacheResponse(Utils.INSTANCE.strip(cachedResponse)).networkResponse(Utils.INSTANCE.strip(networkResponse)).request(request).build();
    }

    private final Response cacheFirst(Request request, Interceptor.Chain chain) throws IOException {
        Response cachedResponse = this.cachedResponse(request);
        if (cachedResponse != null) {
            this.logCacheHit(request);
            return cachedResponse.newBuilder().cacheResponse(Utils.INSTANCE.strip(cachedResponse)).request(request).build();
        }
        this.logCacheMiss(request);
        String cacheKey = request.header("X-APOLLO-CACHE-KEY");
        Response response = chain.proceed(request);
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"chain.proceed(request)");
        Response networkResponse = Utils.INSTANCE.withServedDateHeader(response);
        if (Utils.INSTANCE.isPrefetchResponse(request)) {
            return this.prefetch(networkResponse, cacheKey);
        }
        Intrinsics.checkNotNull((Object)networkResponse);
        if (networkResponse.isSuccessful()) {
            Intrinsics.checkNotNull((Object)cacheKey);
            return this.cache.cacheProxy(networkResponse, cacheKey);
        }
        return networkResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response prefetch(Response networkResponse, String cacheKey) throws IOException {
        Intrinsics.checkNotNull((Object)networkResponse);
        if (!networkResponse.isSuccessful()) {
            return networkResponse;
        }
        try {
            Intrinsics.checkNotNull((Object)cacheKey);
            this.cache.write(networkResponse, cacheKey);
        }
        finally {
            networkResponse.close();
        }
        Response response = this.cache.read(cacheKey);
        if (response == null) {
            throw new IOException("failed to read prefetch cache response");
        }
        Response cachedResponse = response;
        return cachedResponse.newBuilder().networkResponse(Utils.INSTANCE.strip(networkResponse)).build();
    }

    private final Response cachedResponse(Request request) {
        String cacheKey = request.header("X-APOLLO-CACHE-KEY");
        Intrinsics.checkNotNull((Object)cacheKey);
        Response response = this.cache.read(cacheKey, Utils.INSTANCE.shouldExpireAfterRead(request));
        if (response == null) {
            return null;
        }
        Response cachedResponse = response;
        if (Utils.INSTANCE.isStale(request, cachedResponse)) {
            Utils.INSTANCE.closeQuietly((Closeable)cachedResponse);
            return null;
        }
        return cachedResponse;
    }

    private final void logCacheHit(Request request) {
        String cacheKey = request.header("X-APOLLO-CACHE-KEY");
        Object[] objectArray = new Object[2];
        objectArray[0] = request;
        Intrinsics.checkNotNull((Object)cacheKey);
        objectArray[1] = cacheKey;
        this.logger.d("Cache HIT for request: %s, with cache key: %s", objectArray);
    }

    private final void logCacheMiss(Request request) {
        String cacheKey = request.header("X-APOLLO-CACHE-KEY");
        Object[] objectArray = new Object[2];
        objectArray[0] = request;
        Intrinsics.checkNotNull((Object)cacheKey);
        objectArray[1] = cacheKey;
        this.logger.d("Cache MISS for request: %s, with cache key: %s", objectArray);
    }
}

