/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.api.http;

import com.apollographql.apollo3.api.AnyResponseAdapter;
import com.apollographql.apollo3.api.ApolloRequest;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.ResponseAdapterCache;
import com.apollographql.apollo3.api.Upload;
import com.apollographql.apollo3.api.http.DefaultHttpRequestComposer$WhenMappings;
import com.apollographql.apollo3.api.http.HttpBody;
import com.apollographql.apollo3.api.http.HttpMethod;
import com.apollographql.apollo3.api.http.HttpRequest;
import com.apollographql.apollo3.api.http.HttpRequestComposer;
import com.apollographql.apollo3.api.http.HttpRequestComposerParams;
import com.apollographql.apollo3.api.http.UrlEncodeKt;
import com.apollographql.apollo3.api.internal.json.BufferedSinkJsonWriter;
import com.apollographql.apollo3.api.internal.json.FileUploadAwareJsonWriter;
import com.apollographql.apollo3.api.json.JsonWriter;
import com.apollographql.relocated.okio.Buffer;
import com.apollographql.relocated.okio.BufferedSink;
import com.apollographql.relocated.okio.ByteString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\fH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/apollographql/apollo3/api/http/DefaultHttpRequestComposer;", "Lcom/apollographql/apollo3/api/http/HttpRequestComposer;", "serverUrl", "", "defaultHeaders", "", "(Ljava/lang/String;Ljava/util/Map;)V", "compose", "Lcom/apollographql/apollo3/api/http/HttpRequest;", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "apolloRequest", "Lcom/apollographql/apollo3/api/ApolloRequest;", "Companion", "apollo-api"})
public final class DefaultHttpRequestComposer
implements HttpRequestComposer {
    private final String serverUrl;
    private final Map<String, String> defaultHeaders;
    @NotNull
    public static final String HEADER_APOLLO_OPERATION_ID = "X-APOLLO-OPERATION-ID";
    @NotNull
    public static final String HEADER_APOLLO_OPERATION_NAME = "X-APOLLO-OPERATION-NAME";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public <D extends Operation.Data> HttpRequest compose(@NotNull ApolloRequest<D> apolloRequest) {
        HttpRequest httpRequest;
        Intrinsics.checkNotNullParameter(apolloRequest, (String)"apolloRequest");
        HttpRequestComposerParams params = (HttpRequestComposerParams)apolloRequest.getExecutionContext().get(HttpRequestComposerParams.Key);
        Operation<D> operation = apolloRequest.getOperation();
        Object object = params;
        if (object == null || (object = ((HttpRequestComposerParams)object).getMethod()) == null) {
            object = HttpMethod.Post;
        }
        Object method = object;
        HttpRequestComposerParams httpRequestComposerParams = params;
        boolean autoPersistQueries = httpRequestComposerParams != null ? httpRequestComposerParams.getAutoPersistQueries() : false;
        HttpRequestComposerParams httpRequestComposerParams2 = params;
        boolean sendDocument = httpRequestComposerParams2 != null ? httpRequestComposerParams2.getSendDocument() : true;
        ResponseAdapterCache responseAdapterCache = (ResponseAdapterCache)apolloRequest.getExecutionContext().get(ResponseAdapterCache.Key);
        if (responseAdapterCache == null) {
            String string = "Cannot find a ResponseAdapterCache";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ResponseAdapterCache responseAdapterCache2 = responseAdapterCache;
        Map headers = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)HEADER_APOLLO_OPERATION_ID, (Object)operation.id()), TuplesKt.to((Object)HEADER_APOLLO_OPERATION_NAME, (Object)operation.name())});
        Object $this$forEach$iv = this.defaultHeaders;
        boolean $i$f$forEach = false;
        Object object2 = $this$forEach$iv;
        boolean bl = false;
        Object object3 = object2.entrySet().iterator();
        while (object3.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> it = element$iv = object3.next();
            boolean bl2 = false;
            headers.put(it.getKey(), it.getValue());
        }
        Object object4 = params;
        if (object4 != null && (object4 = ((HttpRequestComposerParams)object4).getExtraHeaders()) != null && (object4 = object4.entrySet()) != null) {
            $this$forEach$iv = (Iterable)object4;
            $i$f$forEach = false;
            object2 = $this$forEach$iv.iterator();
            while (object2.hasNext()) {
                Object element$iv = object2.next();
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl3 = false;
                headers.put(it.getKey(), it.getValue());
            }
        }
        switch (DefaultHttpRequestComposer$WhenMappings.$EnumSwitchMapping$0[((Enum)method).ordinal()]) {
            case 1: {
                $this$forEach$iv = null;
                Map map = headers;
                object2 = DefaultHttpRequestComposer.Companion.buildGetUrl(this.serverUrl, operation, responseAdapterCache2, autoPersistQueries, sendDocument);
                HttpMethod httpMethod = HttpMethod.Get;
                HttpRequest httpRequest2 = new HttpRequest((String)object2, map, httpMethod, (HttpBody)$this$forEach$iv);
                httpRequest = httpRequest2;
                break;
            }
            case 2: {
                String query = sendDocument ? operation.document() : null;
                HttpBody httpBody = Companion.buildPostBody(operation, responseAdapterCache2, autoPersistQueries, query);
                object2 = headers;
                String string = this.serverUrl;
                object3 = HttpMethod.Post;
                HttpRequest httpRequest3 = new HttpRequest(string, (Map<String, String>)object2, (HttpMethod)((Object)object3), httpBody);
                httpRequest = httpRequest3;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return httpRequest;
    }

    public DefaultHttpRequestComposer(@NotNull String serverUrl, @NotNull Map<String, String> defaultHeaders) {
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        Intrinsics.checkNotNullParameter(defaultHeaders, (String)"defaultHeaders");
        this.serverUrl = serverUrl;
        this.defaultHeaders = defaultHeaders;
    }

    public /* synthetic */ DefaultHttpRequestComposer(String string, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        this(string, map);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0006\u001a\u00020\u0004\"\b\b\u0000\u0010\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J6\u0010\u0011\u001a\u00020\u0012\"\b\b\u0000\u0010\u0007*\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ8\u0010\u0013\u001a\u00020\u0014\"\b\b\u0000\u0010\u0007*\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004J\u001c\u0010\u0016\u001a\u00020\u00122\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00190\u0018H\u0002JD\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0018\"\b\b\u0000\u0010\u0007*\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002JN\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00190\u0018\"\b\b\u0000\u0010\u0007*\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004H\u0002J \u0010\u001e\u001a\u00020\u0004*\u00020\u00042\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/apollographql/apollo3/api/http/DefaultHttpRequestComposer$Companion;", "", "()V", "HEADER_APOLLO_OPERATION_ID", "", "HEADER_APOLLO_OPERATION_NAME", "buildGetUrl", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "serverUrl", "operation", "Lcom/apollographql/apollo3/api/Operation;", "responseAdapterCache", "Lcom/apollographql/apollo3/api/ResponseAdapterCache;", "autoPersistQueries", "", "sendDocument", "buildParamsMap", "Lcom/apollographql/relocated/okio/ByteString;", "buildPostBody", "Lcom/apollographql/apollo3/api/http/HttpBody;", "query", "buildUploadMap", "uploads", "", "Lcom/apollographql/apollo3/api/Upload;", "composeGetParams", "composePostParams", "writer", "Lcom/apollographql/apollo3/api/json/JsonWriter;", "appendQueryParameters", "parameters", "apollo-api"})
    public static final class Companion {
        private final <D extends Operation.Data> String buildGetUrl(String serverUrl, Operation<D> operation, ResponseAdapterCache responseAdapterCache, boolean autoPersistQueries, boolean sendDocument) {
            return this.appendQueryParameters(serverUrl, this.composeGetParams(operation, responseAdapterCache, autoPersistQueries, sendDocument));
        }

        private final <D extends Operation.Data> Map<String, Upload> composePostParams(JsonWriter writer, Operation<D> operation, ResponseAdapterCache responseAdapterCache, boolean autoPersistQueries, String query) {
            Map<String, Upload> uploads = null;
            JsonWriter $this$writeObject$iv = writer;
            boolean $i$f$writeObject = false;
            boolean bl = false;
            $this$writeObject$iv.beginObject();
            JsonWriter $this$writeObject = $this$writeObject$iv;
            boolean bl2 = false;
            $this$writeObject.name("operationName");
            $this$writeObject.value(operation.name());
            $this$writeObject.name("variables");
            FileUploadAwareJsonWriter uploadAwareWriter = new FileUploadAwareJsonWriter($this$writeObject);
            JsonWriter $this$writeObject$iv2 = uploadAwareWriter;
            boolean $i$f$writeObject2 = false;
            boolean bl3 = false;
            $this$writeObject$iv2.beginObject();
            JsonWriter $this$writeObject2 = $this$writeObject$iv2;
            boolean bl4 = false;
            operation.serializeVariables($this$writeObject2, responseAdapterCache);
            $this$writeObject$iv2.endObject();
            uploads = uploadAwareWriter.collectedUploads();
            if (query != null) {
                $this$writeObject.name("query");
                $this$writeObject.value(query);
            }
            if (autoPersistQueries) {
                $this$writeObject.name("extensions");
                $this$writeObject$iv2 = $this$writeObject;
                $i$f$writeObject2 = false;
                bl3 = false;
                $this$writeObject$iv2.beginObject();
                $this$writeObject2 = $this$writeObject$iv2;
                boolean bl5 = false;
                $this$writeObject2.name("persistedQuery");
                JsonWriter $this$writeObject$iv3 = $this$writeObject2;
                boolean $i$f$writeObject3 = false;
                boolean bl6 = false;
                $this$writeObject$iv3.beginObject();
                JsonWriter $this$writeObject3 = $this$writeObject$iv3;
                boolean bl7 = false;
                $this$writeObject3.name("version").value(1);
                $this$writeObject3.name("sha256Hash").value(operation.id());
                $this$writeObject$iv3.endObject();
                $this$writeObject$iv2.endObject();
            }
            $this$writeObject$iv.endObject();
            return uploads;
        }

        private final <D extends Operation.Data> Map<String, String> composeGetParams(Operation<D> operation, ResponseAdapterCache responseAdapterCache, boolean autoPersistQueries, boolean sendDocument) {
            boolean bl = false;
            Map queryParams = new LinkedHashMap();
            queryParams.put("operationName", operation.name());
            boolean $i$f$buildJsonString = false;
            boolean bl2 = false;
            Buffer buffer$iv = new Buffer();
            JsonWriter $this$buildJsonString2 = new BufferedSinkJsonWriter(buffer$iv);
            boolean bl3 = false;
            FileUploadAwareJsonWriter uploadAwareWriter = new FileUploadAwareJsonWriter($this$buildJsonString2);
            JsonWriter $this$writeObject$iv22 = uploadAwareWriter;
            boolean $i$f$writeObject = false;
            boolean bl4 = false;
            $this$writeObject$iv22.beginObject();
            JsonWriter $this$writeObject = $this$writeObject$iv22;
            boolean bl5 = false;
            operation.serializeVariables($this$writeObject, responseAdapterCache);
            $this$writeObject$iv22.endObject();
            boolean $this$writeObject$iv22 = uploadAwareWriter.collectedUploads().isEmpty();
            $i$f$writeObject = false;
            bl4 = false;
            if (!$this$writeObject$iv22) {
                boolean bl6 = false;
                String string = "FileUpload and Http GET are not supported at the same time";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            String variables = buffer$iv.readUtf8();
            queryParams.put("variables", variables);
            if (sendDocument) {
                queryParams.put("query", operation.document());
            }
            if (autoPersistQueries) {
                boolean $i$f$buildJsonString2 = false;
                boolean $this$buildJsonString2 = false;
                Buffer buffer$iv2 = new Buffer();
                JsonWriter $this$buildJsonString3 = new BufferedSinkJsonWriter(buffer$iv2);
                boolean bl7 = false;
                JsonWriter $this$writeObject$iv = $this$buildJsonString3;
                $i$f$writeObject = false;
                bl4 = false;
                $this$writeObject$iv.beginObject();
                $this$writeObject = $this$writeObject$iv;
                boolean bl8 = false;
                $this$writeObject.name("persistedQuery");
                JsonWriter $this$writeObject$iv3 = $this$writeObject;
                boolean $i$f$writeObject2 = false;
                boolean bl9 = false;
                $this$writeObject$iv3.beginObject();
                JsonWriter $this$writeObject2 = $this$writeObject$iv3;
                boolean bl10 = false;
                $this$writeObject2.name("version").value(1);
                $this$writeObject2.name("sha256Hash").value(operation.id());
                $this$writeObject$iv3.endObject();
                $this$writeObject$iv.endObject();
                String extensions = buffer$iv2.readUtf8();
                queryParams.put("extensions", extensions);
            }
            return queryParams;
        }

        private final String appendQueryParameters(String $this$appendQueryParameters, Map<String, String> parameters) {
            boolean bl = false;
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder $this$buildString = stringBuilder;
            boolean bl5 = false;
            $this$buildString.append($this$appendQueryParameters);
            boolean hasQuestionMark = StringsKt.contains$default((CharSequence)$this$appendQueryParameters, (CharSequence)"?", (boolean)false, (int)2, null);
            Iterable $this$forEach$iv = parameters.entrySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl6 = false;
                if (hasQuestionMark) {
                    $this$buildString.append('&');
                } else {
                    hasQuestionMark = true;
                    $this$buildString.append('?');
                }
                $this$buildString.append(UrlEncodeKt.urlEncode$default((String)it.getKey(), false, 1, null));
                $this$buildString.append('=');
                $this$buildString.append(UrlEncodeKt.urlEncode$default((String)it.getValue(), false, 1, null));
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        @NotNull
        public final <D extends Operation.Data> HttpBody buildPostBody(@NotNull Operation<D> operation, @NotNull ResponseAdapterCache responseAdapterCache, boolean autoPersistQueries, @Nullable String query) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)responseAdapterCache, (String)"responseAdapterCache");
            Map uploads = null;
            boolean $i$f$buildJsonByteString = false;
            boolean bl = false;
            Buffer buffer$iv = new Buffer();
            JsonWriter $this$buildJsonByteString = new BufferedSinkJsonWriter(buffer$iv);
            boolean bl2 = false;
            uploads = Companion.composePostParams($this$buildJsonByteString, operation, responseAdapterCache, autoPersistQueries, query);
            ByteString operationByteString = buffer$iv.readByteString();
            if (uploads.isEmpty()) {
                return new HttpBody(operationByteString){
                    @NotNull
                    private final String contentType;
                    private final long contentLength;
                    final /* synthetic */ ByteString $operationByteString;

                    @NotNull
                    public String getContentType() {
                        return this.contentType;
                    }

                    public long getContentLength() {
                        return this.contentLength;
                    }

                    public void writeTo(@NotNull BufferedSink bufferedSink) {
                        Intrinsics.checkNotNullParameter((Object)bufferedSink, (String)"bufferedSink");
                        bufferedSink.write(this.$operationByteString);
                    }
                    {
                        this.$operationByteString = $captured_local_variable$0;
                        this.contentType = "application/json";
                        this.contentLength = $captured_local_variable$0.size();
                    }
                };
            }
            return new HttpBody(operationByteString, uploads){
                private final String boundary;
                @NotNull
                private final String contentType;
                private final long contentLength;
                final /* synthetic */ ByteString $operationByteString;
                final /* synthetic */ Map $uploads;

                @NotNull
                public String getContentType() {
                    return this.contentType;
                }

                public long getContentLength() {
                    return this.contentLength;
                }

                /*
                 * WARNING - void declaration
                 */
                public void writeTo(@NotNull BufferedSink bufferedSink) {
                    Intrinsics.checkNotNullParameter((Object)bufferedSink, (String)"bufferedSink");
                    bufferedSink.writeUtf8("--" + this.boundary + "\r\n");
                    bufferedSink.writeUtf8("Content-Disposition: form-data; name=\"operations\"\r\n");
                    bufferedSink.writeUtf8("Content-Type: application/json\r\n");
                    bufferedSink.writeUtf8("Content-Length: " + this.$operationByteString.size() + "\r\n");
                    bufferedSink.writeUtf8("\r\n");
                    bufferedSink.write(this.$operationByteString);
                    ByteString uploadsMap = com.apollographql.apollo3.api.http.DefaultHttpRequestComposer$Companion.access$buildUploadMap(DefaultHttpRequestComposer.Companion, this.$uploads);
                    bufferedSink.writeUtf8("\r\n--" + this.boundary + "\r\n");
                    bufferedSink.writeUtf8("Content-Disposition: form-data; name=\"map\"\r\n");
                    bufferedSink.writeUtf8("Content-Type: application/json\r\n");
                    bufferedSink.writeUtf8("Content-Length: " + uploadsMap.size() + "\r\n");
                    bufferedSink.writeUtf8("\r\n");
                    bufferedSink.write(uploadsMap);
                    Iterable $this$forEachIndexed$iv = this.$uploads.values();
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (T item$iv : $this$forEachIndexed$iv) {
                        void upload;
                        int n = index$iv++;
                        boolean bl = false;
                        if (n < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        Upload upload2 = (Upload)item$iv;
                        int index = n;
                        boolean bl2 = false;
                        bufferedSink.writeUtf8("\r\n--" + this.boundary + "\r\n");
                        bufferedSink.writeUtf8("Content-Disposition: form-data; name=\"" + index + '\"');
                        if (upload.getFileName() != null) {
                            bufferedSink.writeUtf8("; filename=\"" + upload.getFileName() + '\"');
                        }
                        bufferedSink.writeUtf8("\r\n");
                        bufferedSink.writeUtf8("Content-Type: " + upload.getContentType() + "\r\n");
                        long contentLength = upload.getContentLength();
                        if (contentLength != -1L) {
                            bufferedSink.writeUtf8("Content-Length: " + contentLength + "\r\n");
                        }
                        bufferedSink.writeUtf8("\r\n");
                        upload.writeTo(bufferedSink);
                    }
                    bufferedSink.writeUtf8("\r\n--" + this.boundary + "--\r\n");
                }
                {
                    this.$operationByteString = $captured_local_variable$0;
                    this.$uploads = $captured_local_variable$1;
                    boolean $i$f$uuid4 = false;
                    UUID uUID = UUID.randomUUID();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"UUID.randomUUID()");
                    String string = uUID.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uuid4().toString()");
                    this.boundary = string;
                    this.contentType = "multipart/form-data; boundary=" + this.boundary;
                    this.contentLength = -1L;
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        private final ByteString buildUploadMap(Map<String, ? extends Upload> uploads) {
            Collection<Pair> collection;
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            boolean $i$f$buildJsonByteString = false;
            boolean bl = false;
            Buffer buffer$iv = new Buffer();
            JsonWriter $this$buildJsonByteString = new BufferedSinkJsonWriter(buffer$iv);
            boolean bl2 = false;
            Iterable iterable = uploads.entrySet();
            ResponseAdapterCache responseAdapterCache = ResponseAdapterCache.Key.getDEFAULT();
            JsonWriter jsonWriter = $this$buildJsonByteString;
            AnyResponseAdapter anyResponseAdapter = AnyResponseAdapter.INSTANCE;
            boolean $i$f$mapIndexed = false;
            void var11_12 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void entry;
                void index;
                int n = index$iv$iv++;
                boolean bl3 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Map.Entry entry2 = (Map.Entry)item$iv$iv;
                int n2 = n;
                collection = destination$iv$iv;
                boolean bl4 = false;
                Pair pair = TuplesKt.to((Object)String.valueOf((int)index), (Object)CollectionsKt.listOf(entry.getKey()));
                collection.add(pair);
            }
            collection = (List)destination$iv$iv;
            anyResponseAdapter.toResponse(jsonWriter, responseAdapterCache, MapsKt.toMap((Iterable)collection));
            return buffer$iv.readByteString();
        }

        @NotNull
        public final <D extends Operation.Data> ByteString buildParamsMap(@NotNull Operation<D> operation, @NotNull ResponseAdapterCache responseAdapterCache, boolean autoPersistQueries, boolean sendDocument) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)responseAdapterCache, (String)"responseAdapterCache");
            boolean $i$f$buildJsonByteString = false;
            boolean bl = false;
            Buffer buffer$iv = new Buffer();
            JsonWriter $this$buildJsonByteString = new BufferedSinkJsonWriter(buffer$iv);
            boolean bl2 = false;
            String query = sendDocument ? operation.document() : null;
            Companion.composePostParams($this$buildJsonByteString, operation, responseAdapterCache, autoPersistQueries, query);
            return buffer$iv.readByteString();
        }

        private Companion() {
        }

        public static final /* synthetic */ ByteString access$buildUploadMap(Companion $this, Map uploads) {
            return $this.buildUploadMap(uploads);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

