/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.rx2;

import com.apollographql.apollo.ApolloCall;
import com.apollographql.apollo.ApolloPrefetch;
import com.apollographql.apollo.ApolloQueryWatcher;
import com.apollographql.apollo.ApolloSubscriptionCall;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.normalized.ApolloStoreOperation;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.internal.subscription.ApolloSubscriptionTerminatedException;
import com.apollographql.apollo.internal.util.Cancelable;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Completable;
import io.reactivex.CompletableEmitter;
import io.reactivex.CompletableOnSubscribe;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import io.reactivex.annotations.CheckReturnValue;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import org.jetbrains.annotations.NotNull;

public class Rx2Apollo {
    private Rx2Apollo() {
        throw new AssertionError((Object)"This class cannot be instantiated");
    }

    @CheckReturnValue
    @NotNull
    public static <T> Observable<Response<T>> from(final @NotNull ApolloQueryWatcher<T> watcher) {
        Utils.checkNotNull(watcher, (Object)"watcher == null");
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Response<T>>(){

            public void subscribe(final ObservableEmitter<Response<T>> emitter) throws Exception {
                Rx2Apollo.cancelOnObservableDisposed(emitter, (Cancelable)watcher);
                watcher.enqueueAndWatch(new ApolloCall.Callback<T>(){

                    public void onResponse(@NotNull Response<T> response) {
                        if (!emitter.isDisposed()) {
                            emitter.onNext(response);
                        }
                    }

                    public void onFailure(@NotNull ApolloException e) {
                        Exceptions.throwIfFatal((Throwable)e);
                        if (!emitter.isDisposed()) {
                            emitter.onError((Throwable)e);
                        }
                    }
                });
            }
        });
    }

    @CheckReturnValue
    @NotNull
    public static <T> Observable<Response<T>> from(final @NotNull ApolloCall<T> call) {
        Utils.checkNotNull(call, (Object)"call == null");
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Response<T>>(){

            public void subscribe(final ObservableEmitter<Response<T>> emitter) throws Exception {
                Rx2Apollo.cancelOnObservableDisposed(emitter, (Cancelable)call);
                call.enqueue(new ApolloCall.Callback<T>(){

                    public void onResponse(@NotNull Response<T> response) {
                        if (!emitter.isDisposed()) {
                            emitter.onNext(response);
                        }
                    }

                    public void onFailure(@NotNull ApolloException e) {
                        Exceptions.throwIfFatal((Throwable)e);
                        if (!emitter.isDisposed()) {
                            emitter.onError((Throwable)e);
                        }
                    }

                    public void onStatusEvent(@NotNull ApolloCall.StatusEvent event) {
                        if (event == ApolloCall.StatusEvent.COMPLETED && !emitter.isDisposed()) {
                            emitter.onComplete();
                        }
                    }
                });
            }
        });
    }

    @CheckReturnValue
    @NotNull
    public static Completable from(final @NotNull ApolloPrefetch prefetch) {
        Utils.checkNotNull((Object)prefetch, (Object)"prefetch == null");
        return Completable.create((CompletableOnSubscribe)new CompletableOnSubscribe(){

            public void subscribe(final CompletableEmitter emitter) {
                Rx2Apollo.cancelOnCompletableDisposed(emitter, (Cancelable)prefetch);
                prefetch.enqueue(new ApolloPrefetch.Callback(){

                    public void onSuccess() {
                        if (!emitter.isDisposed()) {
                            emitter.onComplete();
                        }
                    }

                    public void onFailure(@NotNull ApolloException e) {
                        Exceptions.throwIfFatal((Throwable)e);
                        if (!emitter.isDisposed()) {
                            emitter.onError((Throwable)e);
                        }
                    }
                });
            }
        });
    }

    @CheckReturnValue
    @NotNull
    public static <T> Flowable<Response<T>> from(@NotNull ApolloSubscriptionCall<T> call) {
        return Rx2Apollo.from(call, BackpressureStrategy.LATEST);
    }

    @CheckReturnValue
    @NotNull
    public static <T> Flowable<Response<T>> from(final @NotNull ApolloSubscriptionCall<T> call, @NotNull BackpressureStrategy backpressureStrategy) {
        Utils.checkNotNull(call, (Object)"originalCall == null");
        Utils.checkNotNull((Object)backpressureStrategy, (Object)"backpressureStrategy == null");
        return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<Response<T>>(){

            public void subscribe(final FlowableEmitter<Response<T>> emitter) throws Exception {
                Rx2Apollo.cancelOnFlowableDisposed(emitter, (Cancelable)call);
                call.execute(new ApolloSubscriptionCall.Callback<T>(){

                    public void onResponse(@NotNull Response<T> response) {
                        if (!emitter.isCancelled()) {
                            emitter.onNext(response);
                        }
                    }

                    public void onFailure(@NotNull ApolloException e) {
                        Exceptions.throwIfFatal((Throwable)e);
                        if (!emitter.isCancelled()) {
                            emitter.onError((Throwable)e);
                        }
                    }

                    public void onCompleted() {
                        if (!emitter.isCancelled()) {
                            emitter.onComplete();
                        }
                    }

                    public void onTerminated() {
                        this.onFailure((ApolloException)new ApolloSubscriptionTerminatedException("Subscription server unexpectedly terminated connection"));
                    }

                    public void onConnected() {
                    }
                });
            }
        }, (BackpressureStrategy)backpressureStrategy);
    }

    @CheckReturnValue
    @NotNull
    public static <T> Single<T> from(final @NotNull ApolloStoreOperation<T> operation) {
        Utils.checkNotNull(operation, (Object)"operation == null");
        return Single.create((SingleOnSubscribe)new SingleOnSubscribe<T>(){

            public void subscribe(final SingleEmitter<T> emitter) {
                operation.enqueue(new ApolloStoreOperation.Callback<T>(){

                    public void onSuccess(T result) {
                        emitter.onSuccess(result);
                    }

                    public void onFailure(Throwable t) {
                        emitter.onError(t);
                    }
                });
            }
        });
    }

    private static void cancelOnCompletableDisposed(CompletableEmitter emitter, Cancelable cancelable) {
        emitter.setDisposable(Rx2Apollo.getRx2Disposable(cancelable));
    }

    private static <T> void cancelOnObservableDisposed(ObservableEmitter<T> emitter, Cancelable cancelable) {
        emitter.setDisposable(Rx2Apollo.getRx2Disposable(cancelable));
    }

    private static <T> void cancelOnFlowableDisposed(FlowableEmitter<T> emitter, Cancelable cancelable) {
        emitter.setDisposable(Rx2Apollo.getRx2Disposable(cancelable));
    }

    private static Disposable getRx2Disposable(final Cancelable cancelable) {
        return new Disposable(){

            public void dispose() {
                cancelable.cancel();
            }

            public boolean isDisposed() {
                return cancelable.isCanceled();
            }
        };
    }
}

