/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal;

import com.apollographql.apollo.ApolloCall;
import com.apollographql.apollo.ApolloMutationCall;
import com.apollographql.apollo.ApolloQueryCall;
import com.apollographql.apollo.api.Mutation;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.OperationName;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ScalarTypeAdapters;
import com.apollographql.apollo.api.cache.http.HttpCache;
import com.apollographql.apollo.api.cache.http.HttpCachePolicy;
import com.apollographql.apollo.api.internal.Action;
import com.apollographql.apollo.api.internal.ApolloLogger;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.ResponseFieldMapper;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.CacheHeaders;
import com.apollographql.apollo.cache.normalized.ApolloStore;
import com.apollographql.apollo.cache.normalized.internal.ResponseNormalizer;
import com.apollographql.apollo.exception.ApolloCanceledException;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloHttpException;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.exception.ApolloParseException;
import com.apollographql.apollo.fetcher.ApolloResponseFetchers;
import com.apollographql.apollo.fetcher.ResponseFetcher;
import com.apollographql.apollo.interceptor.ApolloAutoPersistedOperationInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.interceptor.ApolloInterceptorFactory;
import com.apollographql.apollo.internal.ApolloCallTracker;
import com.apollographql.apollo.internal.CallState;
import com.apollographql.apollo.internal.QueryReFetcher;
import com.apollographql.apollo.internal.RealApolloQueryWatcher;
import com.apollographql.apollo.internal.ResponseFieldMapperFactory;
import com.apollographql.apollo.internal.interceptor.ApolloCacheInterceptor;
import com.apollographql.apollo.internal.interceptor.ApolloParseInterceptor;
import com.apollographql.apollo.internal.interceptor.ApolloServerInterceptor;
import com.apollographql.apollo.internal.interceptor.RealApolloInterceptorChain;
import com.apollographql.apollo.request.RequestHeaders;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.Call;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RealApolloCall<T>
implements ApolloQueryCall<T>,
ApolloMutationCall<T> {
    final Operation operation;
    final HttpUrl serverUrl;
    final Call.Factory httpCallFactory;
    final HttpCache httpCache;
    final HttpCachePolicy.Policy httpCachePolicy;
    final ScalarTypeAdapters scalarTypeAdapters;
    final ApolloStore apolloStore;
    final CacheHeaders cacheHeaders;
    final RequestHeaders requestHeaders;
    final ResponseFetcher responseFetcher;
    final ApolloInterceptorChain interceptorChain;
    final Executor dispatcher;
    final ApolloLogger logger;
    final ApolloCallTracker tracker;
    final List<ApolloInterceptor> applicationInterceptors;
    final List<ApolloInterceptorFactory> applicationInterceptorFactories;
    final ApolloInterceptorFactory autoPersistedOperationsInterceptorFactory;
    final List<OperationName> refetchQueryNames;
    final List<Query> refetchQueries;
    final Optional<QueryReFetcher> queryReFetcher;
    final boolean enableAutoPersistedQueries;
    final AtomicReference<CallState> state = new AtomicReference<CallState>(CallState.IDLE);
    final AtomicReference<ApolloCall.Callback<T>> originalCallback = new AtomicReference();
    final Optional<Operation.Data> optimisticUpdates;
    final boolean useHttpGetMethodForQueries;
    final boolean useHttpGetMethodForPersistedQueries;
    final boolean writeToNormalizedCacheAsynchronously;

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    RealApolloCall(Builder<T> builder) {
        this.operation = builder.operation;
        this.serverUrl = builder.serverUrl;
        this.httpCallFactory = builder.httpCallFactory;
        this.httpCache = builder.httpCache;
        this.httpCachePolicy = builder.httpCachePolicy;
        this.scalarTypeAdapters = builder.scalarTypeAdapters;
        this.apolloStore = builder.apolloStore;
        this.responseFetcher = builder.responseFetcher;
        this.cacheHeaders = builder.cacheHeaders;
        this.requestHeaders = builder.requestHeaders;
        this.dispatcher = builder.dispatcher;
        this.logger = builder.logger;
        this.applicationInterceptors = builder.applicationInterceptors;
        this.applicationInterceptorFactories = builder.applicationInterceptorFactories;
        this.autoPersistedOperationsInterceptorFactory = builder.autoPersistedOperationsInterceptorFactory;
        this.refetchQueryNames = builder.refetchQueryNames;
        this.refetchQueries = builder.refetchQueries;
        this.tracker = builder.tracker;
        this.queryReFetcher = this.refetchQueries.isEmpty() && this.refetchQueryNames.isEmpty() || builder.apolloStore == null ? Optional.absent() : Optional.of((Object)QueryReFetcher.builder().queries(builder.refetchQueries).queryWatchers(this.refetchQueryNames).serverUrl(builder.serverUrl).httpCallFactory(builder.httpCallFactory).scalarTypeAdapters(builder.scalarTypeAdapters).apolloStore(builder.apolloStore).dispatcher(builder.dispatcher).logger(builder.logger).applicationInterceptors(builder.applicationInterceptors).applicationInterceptorFactories(builder.applicationInterceptorFactories).autoPersistedOperationsInterceptorFactory(builder.autoPersistedOperationsInterceptorFactory).callTracker(builder.tracker).build());
        this.useHttpGetMethodForQueries = builder.useHttpGetMethodForQueries;
        this.enableAutoPersistedQueries = builder.enableAutoPersistedQueries;
        this.useHttpGetMethodForPersistedQueries = builder.useHttpGetMethodForPersistedQueries;
        this.optimisticUpdates = builder.optimisticUpdates;
        this.writeToNormalizedCacheAsynchronously = builder.writeToNormalizedCacheAsynchronously;
        this.interceptorChain = this.prepareInterceptorChain(this.operation);
    }

    @Override
    public void enqueue(@Nullable ApolloCall.Callback<T> responseCallback) {
        try {
            this.activate(Optional.fromNullable(responseCallback));
        }
        catch (ApolloCanceledException e) {
            if (responseCallback != null) {
                responseCallback.onCanceledError(e);
            } else {
                this.logger.e((Throwable)((Object)e), "Operation: %s was canceled", new Object[]{this.operation().name().name()});
            }
            return;
        }
        ApolloInterceptor.InterceptorRequest request = ApolloInterceptor.InterceptorRequest.builder(this.operation).cacheHeaders(this.cacheHeaders).requestHeaders(this.requestHeaders).fetchFromCache(false).optimisticUpdates(this.optimisticUpdates).useHttpGetMethodForQueries(this.useHttpGetMethodForQueries).build();
        this.interceptorChain.proceedAsync(request, this.dispatcher, this.interceptorCallbackProxy());
    }

    @Override
    @NotNull
    public RealApolloQueryWatcher<T> watcher() {
        return new RealApolloQueryWatcher(this.clone(), this.apolloStore, this.logger, this.tracker, ApolloResponseFetchers.CACHE_FIRST);
    }

    @Override
    @NotNull
    public RealApolloCall<T> httpCachePolicy(@NotNull HttpCachePolicy.Policy httpCachePolicy) {
        if (this.state.get() != CallState.IDLE) {
            throw new IllegalStateException("Already Executed");
        }
        return ((Builder)((Builder)this.toBuilder()).httpCachePolicy((HttpCachePolicy.Policy)Utils.checkNotNull((Object)httpCachePolicy, (Object)"httpCachePolicy == null"))).build();
    }

    @Override
    @NotNull
    public RealApolloCall<T> responseFetcher(@NotNull ResponseFetcher fetcher) {
        if (this.state.get() != CallState.IDLE) {
            throw new IllegalStateException("Already Executed");
        }
        return ((Builder)((Builder)this.toBuilder()).responseFetcher((ResponseFetcher)Utils.checkNotNull((Object)fetcher, (Object)"responseFetcher == null"))).build();
    }

    @Override
    @NotNull
    public RealApolloCall<T> cacheHeaders(@NotNull CacheHeaders cacheHeaders) {
        if (this.state.get() != CallState.IDLE) {
            throw new IllegalStateException("Already Executed");
        }
        return ((Builder)((Builder)this.toBuilder()).cacheHeaders((CacheHeaders)Utils.checkNotNull((Object)cacheHeaders, (Object)"cacheHeaders == null"))).build();
    }

    @Override
    @NotNull
    public RealApolloCall<T> requestHeaders(@NotNull RequestHeaders requestHeaders) {
        if (this.state.get() != CallState.IDLE) {
            throw new IllegalStateException("Already Executed");
        }
        return ((Builder)((Builder)this.toBuilder()).requestHeaders((RequestHeaders)Utils.checkNotNull((Object)requestHeaders, (Object)"requestHeaders == null"))).build();
    }

    @Override
    public synchronized void cancel() {
        switch (this.state.get()) {
            case ACTIVE: {
                this.state.set(CallState.CANCELED);
                try {
                    this.interceptorChain.dispose();
                    if (!this.queryReFetcher.isPresent()) break;
                    ((QueryReFetcher)this.queryReFetcher.get()).cancel();
                    break;
                }
                finally {
                    this.tracker.unregisterCall(this);
                    this.originalCallback.set(null);
                }
            }
            case IDLE: {
                this.state.set(CallState.CANCELED);
                break;
            }
            case CANCELED: 
            case TERMINATED: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state");
            }
        }
    }

    @Override
    public boolean isCanceled() {
        return this.state.get() == CallState.CANCELED;
    }

    @Override
    @NotNull
    public RealApolloCall<T> clone() {
        return ((Builder)this.toBuilder()).build();
    }

    @Override
    @NotNull
    public ApolloMutationCall<T> refetchQueries(OperationName ... operationNames) {
        if (this.state.get() != CallState.IDLE) {
            throw new IllegalStateException("Already Executed");
        }
        return ((Builder)((Builder)this.toBuilder()).refetchQueryNames(Arrays.asList((Object[])Utils.checkNotNull((Object)operationNames, (Object)"operationNames == null")))).build();
    }

    @Override
    @NotNull
    public ApolloMutationCall<T> refetchQueries(Query ... queries) {
        if (this.state.get() != CallState.IDLE) {
            throw new IllegalStateException("Already Executed");
        }
        return ((Builder)((Builder)this.toBuilder()).refetchQueries(Arrays.asList((Object[])Utils.checkNotNull((Object)queries, (Object)"queries == null")))).build();
    }

    @Override
    @NotNull
    public Operation operation() {
        return this.operation;
    }

    private ApolloInterceptor.CallBack interceptorCallbackProxy() {
        return new ApolloInterceptor.CallBack(){

            @Override
            public void onResponse(@NotNull ApolloInterceptor.InterceptorResponse response) {
                Optional callback = RealApolloCall.this.responseCallback();
                if (!callback.isPresent()) {
                    RealApolloCall.this.logger.d("onResponse for operation: %s. No callback present.", new Object[]{RealApolloCall.this.operation().name().name()});
                    return;
                }
                ((ApolloCall.Callback)callback.get()).onResponse((Response)response.parsedResponse.get());
            }

            @Override
            public void onFailure(@NotNull ApolloException e) {
                Optional callback = RealApolloCall.this.terminate();
                if (!callback.isPresent()) {
                    RealApolloCall.this.logger.d((Throwable)e, "onFailure for operation: %s. No callback present.", new Object[]{RealApolloCall.this.operation().name().name()});
                    return;
                }
                if (e instanceof ApolloHttpException) {
                    ((ApolloCall.Callback)callback.get()).onHttpError((ApolloHttpException)e);
                } else if (e instanceof ApolloParseException) {
                    ((ApolloCall.Callback)callback.get()).onParseError((ApolloParseException)e);
                } else if (e instanceof ApolloNetworkException) {
                    ((ApolloCall.Callback)callback.get()).onNetworkError((ApolloNetworkException)e);
                } else {
                    ((ApolloCall.Callback)callback.get()).onFailure(e);
                }
            }

            @Override
            public void onCompleted() {
                Optional callback = RealApolloCall.this.terminate();
                if (RealApolloCall.this.queryReFetcher.isPresent()) {
                    ((QueryReFetcher)RealApolloCall.this.queryReFetcher.get()).refetch();
                }
                if (!callback.isPresent()) {
                    RealApolloCall.this.logger.d("onCompleted for operation: %s. No callback present.", new Object[]{RealApolloCall.this.operation().name().name()});
                    return;
                }
                ((ApolloCall.Callback)callback.get()).onStatusEvent(ApolloCall.StatusEvent.COMPLETED);
            }

            @Override
            public void onFetch(final ApolloInterceptor.FetchSourceType sourceType) {
                RealApolloCall.this.responseCallback().apply(new Action<ApolloCall.Callback<T>>(){

                    public void apply(@NotNull ApolloCall.Callback<T> callback) {
                        switch (sourceType) {
                            case CACHE: {
                                callback.onStatusEvent(ApolloCall.StatusEvent.FETCH_CACHE);
                                break;
                            }
                            case NETWORK: {
                                callback.onStatusEvent(ApolloCall.StatusEvent.FETCH_NETWORK);
                                break;
                            }
                        }
                    }
                });
            }
        };
    }

    @Override
    @NotNull
    public Builder<T> toBuilder() {
        return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)RealApolloCall.builder().operation(this.operation).serverUrl(this.serverUrl).httpCallFactory(this.httpCallFactory).httpCache(this.httpCache).httpCachePolicy(this.httpCachePolicy)).scalarTypeAdapters(this.scalarTypeAdapters).apolloStore(this.apolloStore).cacheHeaders(this.cacheHeaders)).requestHeaders(this.requestHeaders)).responseFetcher(this.responseFetcher)).dispatcher(this.dispatcher).logger(this.logger).applicationInterceptors(this.applicationInterceptors).applicationInterceptorFactories(this.applicationInterceptorFactories).autoPersistedOperationsInterceptorFactory(this.autoPersistedOperationsInterceptorFactory).tracker(this.tracker).refetchQueryNames((List)this.refetchQueryNames)).refetchQueries((List)this.refetchQueries)).enableAutoPersistedQueries(this.enableAutoPersistedQueries).useHttpGetMethodForQueries(this.useHttpGetMethodForQueries).useHttpGetMethodForPersistedQueries(this.useHttpGetMethodForPersistedQueries).optimisticUpdates(this.optimisticUpdates).writeToNormalizedCacheAsynchronously(this.writeToNormalizedCacheAsynchronously);
    }

    private synchronized void activate(Optional<ApolloCall.Callback<T>> callback) {
        switch (this.state.get()) {
            case IDLE: {
                this.originalCallback.set((ApolloCall.Callback<T>)callback.orNull());
                this.tracker.registerCall(this);
                callback.apply(new Action<ApolloCall.Callback<T>>(){

                    public void apply(@NotNull ApolloCall.Callback<T> callback) {
                        callback.onStatusEvent(ApolloCall.StatusEvent.SCHEDULED);
                    }
                });
                break;
            }
            case CANCELED: {
                throw new ApolloCanceledException();
            }
            case ACTIVE: 
            case TERMINATED: {
                throw new IllegalStateException("Already Executed");
            }
            default: {
                throw new IllegalStateException("Unknown state");
            }
        }
        this.state.set(CallState.ACTIVE);
    }

    synchronized Optional<ApolloCall.Callback<T>> responseCallback() {
        switch (this.state.get()) {
            case ACTIVE: 
            case CANCELED: {
                return Optional.fromNullable(this.originalCallback.get());
            }
            case IDLE: 
            case TERMINATED: {
                throw new IllegalStateException(CallState.IllegalStateMessage.forCurrentState(this.state.get()).expected(CallState.ACTIVE, CallState.CANCELED));
            }
        }
        throw new IllegalStateException("Unknown state");
    }

    synchronized Optional<ApolloCall.Callback<T>> terminate() {
        switch (this.state.get()) {
            case ACTIVE: {
                this.tracker.unregisterCall(this);
                this.state.set(CallState.TERMINATED);
                return Optional.fromNullable(this.originalCallback.getAndSet(null));
            }
            case CANCELED: {
                return Optional.fromNullable(this.originalCallback.getAndSet(null));
            }
            case IDLE: 
            case TERMINATED: {
                throw new IllegalStateException(CallState.IllegalStateMessage.forCurrentState(this.state.get()).expected(CallState.ACTIVE, CallState.CANCELED));
            }
        }
        throw new IllegalStateException("Unknown state");
    }

    private ApolloInterceptorChain prepareInterceptorChain(Operation operation) {
        HttpCachePolicy.Policy httpCachePolicy = operation instanceof Query ? this.httpCachePolicy : null;
        ResponseFieldMapper responseFieldMapper = operation.responseFieldMapper();
        ArrayList<ApolloInterceptor> interceptors = new ArrayList<ApolloInterceptor>();
        for (ApolloInterceptorFactory factory : this.applicationInterceptorFactories) {
            ApolloInterceptor interceptor = factory.newInterceptor(this.logger, operation);
            if (interceptor == null) continue;
            interceptors.add(interceptor);
        }
        interceptors.addAll(this.applicationInterceptors);
        interceptors.add(this.responseFetcher.provideInterceptor(this.logger));
        interceptors.add(new ApolloCacheInterceptor(this.apolloStore, responseFieldMapper, this.dispatcher, this.logger, this.writeToNormalizedCacheAsynchronously));
        if (this.autoPersistedOperationsInterceptorFactory != null) {
            ApolloInterceptor interceptor = this.autoPersistedOperationsInterceptorFactory.newInterceptor(this.logger, operation);
            if (interceptor != null) {
                interceptors.add(interceptor);
            }
        } else if (this.enableAutoPersistedQueries && (operation instanceof Query || operation instanceof Mutation)) {
            interceptors.add(new ApolloAutoPersistedOperationInterceptor(this.logger, this.useHttpGetMethodForPersistedQueries && !(operation instanceof Mutation)));
        }
        interceptors.add(new ApolloParseInterceptor(this.httpCache, (ResponseNormalizer<Map<String, Object>>)this.apolloStore.networkResponseNormalizer(), responseFieldMapper, this.scalarTypeAdapters, this.logger));
        interceptors.add(new ApolloServerInterceptor(this.serverUrl, this.httpCallFactory, httpCachePolicy, false, this.scalarTypeAdapters, this.logger));
        return new RealApolloInterceptorChain(interceptors);
    }

    public static final class Builder<T>
    implements ApolloQueryCall.Builder<T>,
    ApolloMutationCall.Builder<T> {
        Operation operation;
        HttpUrl serverUrl;
        Call.Factory httpCallFactory;
        HttpCache httpCache;
        HttpCachePolicy.Policy httpCachePolicy;
        ScalarTypeAdapters scalarTypeAdapters;
        ApolloStore apolloStore;
        ResponseFetcher responseFetcher;
        CacheHeaders cacheHeaders;
        RequestHeaders requestHeaders = RequestHeaders.NONE;
        Executor dispatcher;
        ApolloLogger logger;
        List<ApolloInterceptor> applicationInterceptors;
        List<ApolloInterceptorFactory> applicationInterceptorFactories;
        ApolloInterceptorFactory autoPersistedOperationsInterceptorFactory;
        List<OperationName> refetchQueryNames = Collections.emptyList();
        List<Query> refetchQueries = Collections.emptyList();
        ApolloCallTracker tracker;
        boolean enableAutoPersistedQueries;
        Optional<Operation.Data> optimisticUpdates = Optional.absent();
        boolean useHttpGetMethodForQueries;
        boolean useHttpGetMethodForPersistedQueries;
        boolean writeToNormalizedCacheAsynchronously;

        public Builder<T> operation(Operation operation) {
            this.operation = operation;
            return this;
        }

        public Builder<T> serverUrl(HttpUrl serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public Builder<T> httpCallFactory(Call.Factory httpCallFactory) {
            this.httpCallFactory = httpCallFactory;
            return this;
        }

        public Builder<T> httpCache(HttpCache httpCache) {
            this.httpCache = httpCache;
            return this;
        }

        @Deprecated
        public Builder<T> responseFieldMapperFactory(ResponseFieldMapperFactory responseFieldMapperFactory) {
            return this;
        }

        public Builder<T> scalarTypeAdapters(ScalarTypeAdapters scalarTypeAdapters) {
            this.scalarTypeAdapters = scalarTypeAdapters;
            return this;
        }

        public Builder<T> apolloStore(ApolloStore apolloStore) {
            this.apolloStore = apolloStore;
            return this;
        }

        @Override
        @NotNull
        public Builder<T> cacheHeaders(@NotNull CacheHeaders cacheHeaders) {
            this.cacheHeaders = cacheHeaders;
            return this;
        }

        @Override
        @NotNull
        public Builder<T> httpCachePolicy(@NotNull HttpCachePolicy.Policy httpCachePolicy) {
            this.httpCachePolicy = httpCachePolicy;
            return this;
        }

        @Override
        @NotNull
        public Builder<T> responseFetcher(@NotNull ResponseFetcher responseFetcher) {
            this.responseFetcher = responseFetcher;
            return this;
        }

        @Override
        @NotNull
        public Builder<T> requestHeaders(@NotNull RequestHeaders requestHeaders) {
            this.requestHeaders = requestHeaders;
            return this;
        }

        @Override
        @NotNull
        public Builder<T> refetchQueryNames(@NotNull List<OperationName> refetchQueryNames) {
            this.refetchQueryNames = new ArrayList<OperationName>(refetchQueryNames);
            return this;
        }

        @Override
        @NotNull
        public Builder<T> refetchQueries(@NotNull List<Query> refetchQueries) {
            this.refetchQueries = new ArrayList<Query>(refetchQueries);
            return this;
        }

        public Builder<T> dispatcher(Executor dispatcher) {
            this.dispatcher = dispatcher;
            return this;
        }

        public Builder<T> logger(ApolloLogger logger) {
            this.logger = logger;
            return this;
        }

        public Builder<T> tracker(ApolloCallTracker tracker) {
            this.tracker = tracker;
            return this;
        }

        public Builder<T> applicationInterceptors(List<ApolloInterceptor> applicationInterceptors) {
            this.applicationInterceptors = applicationInterceptors;
            return this;
        }

        public Builder<T> applicationInterceptorFactories(List<ApolloInterceptorFactory> applicationInterceptorFactories) {
            this.applicationInterceptorFactories = applicationInterceptorFactories;
            return this;
        }

        public Builder<T> autoPersistedOperationsInterceptorFactory(ApolloInterceptorFactory interceptorFactory) {
            this.autoPersistedOperationsInterceptorFactory = interceptorFactory;
            return this;
        }

        public Builder<T> enableAutoPersistedQueries(boolean enableAutoPersistedQueries) {
            this.enableAutoPersistedQueries = enableAutoPersistedQueries;
            return this;
        }

        public Builder<T> optimisticUpdates(Optional<Operation.Data> optimisticUpdates) {
            this.optimisticUpdates = optimisticUpdates;
            return this;
        }

        public Builder<T> useHttpGetMethodForQueries(boolean useHttpGetMethodForQueries) {
            this.useHttpGetMethodForQueries = useHttpGetMethodForQueries;
            return this;
        }

        public Builder<T> useHttpGetMethodForPersistedQueries(boolean useHttpGetMethodForPersistedQueries) {
            this.useHttpGetMethodForPersistedQueries = useHttpGetMethodForPersistedQueries;
            return this;
        }

        public Builder<T> writeToNormalizedCacheAsynchronously(boolean writeToNormalizedCacheAsynchronously) {
            this.writeToNormalizedCacheAsynchronously = writeToNormalizedCacheAsynchronously;
            return this;
        }

        Builder() {
        }

        @Override
        @NotNull
        public RealApolloCall<T> build() {
            return new RealApolloCall(this);
        }
    }
}

