/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal;

import com.apollographql.apollo.ApolloCall;
import com.apollographql.apollo.ApolloMutationCall;
import com.apollographql.apollo.ApolloPrefetch;
import com.apollographql.apollo.ApolloQueryCall;
import com.apollographql.apollo.ApolloQueryWatcher;
import com.apollographql.apollo.IdleResourceCallback;
import com.apollographql.apollo.api.Mutation;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.OperationName;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.internal.Utils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public final class ApolloCallTracker {
    private final Map<OperationName, Set<ApolloPrefetch>> activePrefetchCalls = new HashMap<OperationName, Set<ApolloPrefetch>>();
    private final Map<OperationName, Set<ApolloQueryCall>> activeQueryCalls = new HashMap<OperationName, Set<ApolloQueryCall>>();
    private final Map<OperationName, Set<ApolloMutationCall>> activeMutationCalls = new HashMap<OperationName, Set<ApolloMutationCall>>();
    private final Map<OperationName, Set<ApolloQueryWatcher>> activeQueryWatchers = new HashMap<OperationName, Set<ApolloQueryWatcher>>();
    private final AtomicInteger activeCallCount = new AtomicInteger();
    private IdleResourceCallback idleResourceCallback;

    void registerCall(@NotNull ApolloCall call) {
        Utils.checkNotNull((Object)call, (Object)"call == null");
        Operation operation = call.operation();
        if (operation instanceof Query) {
            this.registerQueryCall((ApolloQueryCall)call);
        } else if (operation instanceof Mutation) {
            this.registerMutationCall((ApolloMutationCall)call);
        } else {
            throw new IllegalArgumentException("Unknown call type");
        }
    }

    void unregisterCall(@NotNull ApolloCall call) {
        Utils.checkNotNull((Object)call, (Object)"call == null");
        Operation operation = call.operation();
        if (operation instanceof Query) {
            this.unregisterQueryCall((ApolloQueryCall)call);
        } else if (operation instanceof Mutation) {
            this.unregisterMutationCall((ApolloMutationCall)call);
        } else {
            throw new IllegalArgumentException("Unknown call type");
        }
    }

    void registerPrefetchCall(@NotNull ApolloPrefetch apolloPrefetch) {
        Utils.checkNotNull((Object)apolloPrefetch, (Object)"apolloPrefetch == null");
        OperationName operationName = apolloPrefetch.operation().name();
        this.registerCall(this.activePrefetchCalls, operationName, apolloPrefetch);
    }

    void unregisterPrefetchCall(@NotNull ApolloPrefetch apolloPrefetch) {
        Utils.checkNotNull((Object)apolloPrefetch, (Object)"apolloPrefetch == null");
        OperationName operationName = apolloPrefetch.operation().name();
        this.unregisterCall(this.activePrefetchCalls, operationName, apolloPrefetch);
    }

    @NotNull
    Set<ApolloPrefetch> activePrefetchCalls(@NotNull OperationName operationName) {
        return this.activeCalls(this.activePrefetchCalls, operationName);
    }

    void registerQueryCall(@NotNull ApolloQueryCall apolloQueryCall) {
        Utils.checkNotNull((Object)apolloQueryCall, (Object)"apolloQueryCall == null");
        OperationName operationName = apolloQueryCall.operation().name();
        this.registerCall(this.activeQueryCalls, operationName, apolloQueryCall);
    }

    void unregisterQueryCall(@NotNull ApolloQueryCall apolloQueryCall) {
        Utils.checkNotNull((Object)apolloQueryCall, (Object)"apolloQueryCall == null");
        OperationName operationName = apolloQueryCall.operation().name();
        this.unregisterCall(this.activeQueryCalls, operationName, apolloQueryCall);
    }

    @NotNull
    Set<ApolloQueryCall> activeQueryCalls(@NotNull OperationName operationName) {
        return this.activeCalls(this.activeQueryCalls, operationName);
    }

    void registerMutationCall(@NotNull ApolloMutationCall apolloMutationCall) {
        Utils.checkNotNull((Object)apolloMutationCall, (Object)"apolloMutationCall == null");
        OperationName operationName = apolloMutationCall.operation().name();
        this.registerCall(this.activeMutationCalls, operationName, apolloMutationCall);
    }

    void unregisterMutationCall(@NotNull ApolloMutationCall apolloMutationCall) {
        Utils.checkNotNull((Object)apolloMutationCall, (Object)"apolloMutationCall == null");
        OperationName operationName = apolloMutationCall.operation().name();
        this.unregisterCall(this.activeMutationCalls, operationName, apolloMutationCall);
    }

    @NotNull
    Set<ApolloMutationCall> activeMutationCalls(@NotNull OperationName operationName) {
        return this.activeCalls(this.activeMutationCalls, operationName);
    }

    void registerQueryWatcher(@NotNull ApolloQueryWatcher queryWatcher) {
        Utils.checkNotNull((Object)queryWatcher, (Object)"queryWatcher == null");
        OperationName operationName = queryWatcher.operation().name();
        this.registerCall(this.activeQueryWatchers, operationName, queryWatcher);
    }

    void unregisterQueryWatcher(@NotNull ApolloQueryWatcher queryWatcher) {
        Utils.checkNotNull((Object)queryWatcher, (Object)"queryWatcher == null");
        OperationName operationName = queryWatcher.operation().name();
        this.unregisterCall(this.activeQueryWatchers, operationName, queryWatcher);
    }

    @NotNull
    Set<ApolloQueryWatcher> activeQueryWatchers(@NotNull OperationName operationName) {
        return this.activeCalls(this.activeQueryWatchers, operationName);
    }

    public synchronized void setIdleResourceCallback(IdleResourceCallback idleResourceCallback) {
        this.idleResourceCallback = idleResourceCallback;
    }

    public int activeCallsCount() {
        return this.activeCallCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <CALL> void registerCall(Map<OperationName, Set<CALL>> registry, OperationName operationName, CALL call) {
        Map<OperationName, Set<CALL>> map = registry;
        synchronized (map) {
            Set<CALL> calls = registry.get(operationName);
            if (calls == null) {
                calls = new HashSet<CALL>();
                registry.put(operationName, calls);
            }
            calls.add(call);
        }
        this.activeCallCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <CALL> void unregisterCall(Map<OperationName, Set<CALL>> registry, OperationName operationName, CALL call) {
        Map<OperationName, Set<CALL>> map = registry;
        synchronized (map) {
            Set<CALL> calls = registry.get(operationName);
            if (calls == null || !calls.remove(call)) {
                throw new AssertionError((Object)"Call wasn't registered before");
            }
            if (calls.isEmpty()) {
                registry.remove(operationName);
            }
        }
        if (this.activeCallCount.decrementAndGet() == 0) {
            this.notifyIdleResource();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <CALL> Set<CALL> activeCalls(Map<OperationName, Set<CALL>> registry, @NotNull OperationName operationName) {
        Utils.checkNotNull((Object)operationName, (Object)"operationName == null");
        Map<OperationName, Set<CALL>> map = registry;
        synchronized (map) {
            Set<CALL> calls = registry.get(operationName);
            return calls != null ? new HashSet<CALL>(calls) : Collections.emptySet();
        }
    }

    private void notifyIdleResource() {
        IdleResourceCallback callback = this.idleResourceCallback;
        if (callback != null) {
            callback.onIdle();
        }
    }
}

