/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal;

import com.apollographql.apollo.ApolloSubscriptionCall;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ResponseFieldMapper;
import com.apollographql.apollo.api.Subscription;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.CacheHeaders;
import com.apollographql.apollo.cache.normalized.ApolloStore;
import com.apollographql.apollo.cache.normalized.ApolloStoreOperation;
import com.apollographql.apollo.cache.normalized.Record;
import com.apollographql.apollo.exception.ApolloCanceledException;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.internal.ApolloLogger;
import com.apollographql.apollo.internal.CallState;
import com.apollographql.apollo.internal.ResponseFieldMapperFactory;
import com.apollographql.apollo.internal.cache.normalized.ResponseNormalizer;
import com.apollographql.apollo.internal.cache.normalized.Transaction;
import com.apollographql.apollo.internal.cache.normalized.WriteableStore;
import com.apollographql.apollo.internal.subscription.ApolloSubscriptionException;
import com.apollographql.apollo.internal.subscription.SubscriptionManager;
import com.apollographql.apollo.internal.subscription.SubscriptionResponse;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RealApolloSubscriptionCall<T>
implements ApolloSubscriptionCall<T> {
    private final Subscription<?, T, ?> subscription;
    private final SubscriptionManager subscriptionManager;
    private final ApolloStore apolloStore;
    private final ApolloSubscriptionCall.CachePolicy cachePolicy;
    private final Executor dispatcher;
    private final ResponseFieldMapperFactory responseFieldMapperFactory;
    private final ApolloLogger logger;
    private final AtomicReference<CallState> state = new AtomicReference<CallState>(CallState.IDLE);
    private SubscriptionManagerCallback<T> subscriptionCallback;

    public RealApolloSubscriptionCall(@NotNull Subscription<?, T, ?> subscription, @NotNull SubscriptionManager subscriptionManager, @NotNull ApolloStore apolloStore, @NotNull ApolloSubscriptionCall.CachePolicy cachePolicy, @NotNull Executor dispatcher, @NotNull ResponseFieldMapperFactory responseFieldMapperFactory, @NotNull ApolloLogger logger) {
        this.subscription = subscription;
        this.subscriptionManager = subscriptionManager;
        this.apolloStore = apolloStore;
        this.cachePolicy = cachePolicy;
        this.dispatcher = dispatcher;
        this.responseFieldMapperFactory = responseFieldMapperFactory;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(final @NotNull ApolloSubscriptionCall.Callback<T> callback) throws ApolloCanceledException {
        Utils.checkNotNull(callback, (Object)"callback == null");
        RealApolloSubscriptionCall realApolloSubscriptionCall = this;
        synchronized (realApolloSubscriptionCall) {
            switch (this.state.get()) {
                case IDLE: {
                    this.state.set(CallState.ACTIVE);
                    if (this.cachePolicy == ApolloSubscriptionCall.CachePolicy.CACHE_AND_NETWORK) {
                        this.dispatcher.execute(new Runnable(){

                            @Override
                            public void run() {
                                Response cachedResponse = RealApolloSubscriptionCall.this.resolveFromCache();
                                if (cachedResponse != null) {
                                    callback.onResponse(cachedResponse);
                                }
                            }
                        });
                    }
                    this.subscriptionCallback = new SubscriptionManagerCallback<T>(callback, this);
                    this.subscriptionManager.subscribe(this.subscription, this.subscriptionCallback);
                    break;
                }
                case CANCELED: {
                    throw new ApolloCanceledException("Call is cancelled.");
                }
                case TERMINATED: 
                case ACTIVE: {
                    throw new IllegalStateException("Already Executed");
                }
                default: {
                    throw new IllegalStateException("Unknown state");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        RealApolloSubscriptionCall realApolloSubscriptionCall = this;
        synchronized (realApolloSubscriptionCall) {
            switch (this.state.get()) {
                case IDLE: {
                    this.state.set(CallState.CANCELED);
                    break;
                }
                case ACTIVE: {
                    try {
                        this.subscriptionManager.unsubscribe(this.subscription);
                        break;
                    }
                    finally {
                        this.state.set(CallState.CANCELED);
                        this.subscriptionCallback.release();
                    }
                }
                case CANCELED: 
                case TERMINATED: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown state");
                }
            }
        }
    }

    @Override
    public ApolloSubscriptionCall<T> clone() {
        return new RealApolloSubscriptionCall<T>(this.subscription, this.subscriptionManager, this.apolloStore, this.cachePolicy, this.dispatcher, this.responseFieldMapperFactory, this.logger);
    }

    @Override
    public boolean isCanceled() {
        return this.state.get() == CallState.CANCELED;
    }

    @Override
    @NotNull
    public ApolloSubscriptionCall<T> cachePolicy(@NotNull ApolloSubscriptionCall.CachePolicy cachePolicy) {
        Utils.checkNotNull((Object)((Object)cachePolicy), (Object)"cachePolicy is null");
        return new RealApolloSubscriptionCall<T>(this.subscription, this.subscriptionManager, this.apolloStore, cachePolicy, this.dispatcher, this.responseFieldMapperFactory, this.logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminate() {
        RealApolloSubscriptionCall realApolloSubscriptionCall = this;
        synchronized (realApolloSubscriptionCall) {
            switch (this.state.get()) {
                case ACTIVE: {
                    this.state.set(CallState.TERMINATED);
                    this.subscriptionCallback.release();
                    break;
                }
                case CANCELED: {
                    break;
                }
                case IDLE: 
                case TERMINATED: {
                    throw new IllegalStateException(CallState.IllegalStateMessage.forCurrentState(this.state.get()).expected(CallState.ACTIVE, CallState.CANCELED));
                }
                default: {
                    throw new IllegalStateException("Unknown state");
                }
            }
        }
    }

    private Response<T> resolveFromCache() {
        ResponseNormalizer<Record> responseNormalizer = this.apolloStore.cacheResponseNormalizer();
        ResponseFieldMapper responseFieldMapper = this.responseFieldMapperFactory.create((Operation)this.subscription);
        ApolloStoreOperation<Response<T>> apolloStoreOperation = this.apolloStore.read(this.subscription, responseFieldMapper, responseNormalizer, CacheHeaders.NONE);
        Response<T> cachedResponse = null;
        try {
            cachedResponse = apolloStoreOperation.execute();
        }
        catch (Exception e) {
            this.logger.e((Throwable)e, "Failed to fetch subscription `%s` from the store", new Object[]{this.subscription});
        }
        if (cachedResponse != null && cachedResponse.data() != null) {
            this.logger.d("Cache HIT for subscription `%s`", new Object[]{this.subscription});
            return cachedResponse;
        }
        this.logger.d("Cache MISS for subscription `%s`", new Object[]{this.subscription});
        return null;
    }

    private void cacheResponse(final SubscriptionResponse<T> networkResponse) {
        if (networkResponse.cacheRecords.isEmpty() || this.cachePolicy == ApolloSubscriptionCall.CachePolicy.NO_CACHE) {
            return;
        }
        this.dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                Set<String> cacheKeys;
                try {
                    cacheKeys = RealApolloSubscriptionCall.this.apolloStore.writeTransaction(new Transaction<WriteableStore, Set<String>>(){

                        @Override
                        @Nullable
                        public Set<String> execute(WriteableStore cache) {
                            return cache.merge(networkResponse.cacheRecords, CacheHeaders.NONE);
                        }
                    });
                }
                catch (Exception e) {
                    RealApolloSubscriptionCall.this.logger.e((Throwable)e, "Failed to cache response for subscription `%s`", new Object[]{RealApolloSubscriptionCall.this.subscription});
                    return;
                }
                try {
                    RealApolloSubscriptionCall.this.apolloStore.publish(cacheKeys);
                }
                catch (Exception e) {
                    RealApolloSubscriptionCall.this.logger.e((Throwable)e, "Failed to publish cache changes for subscription `%s`", new Object[]{RealApolloSubscriptionCall.this.subscription});
                }
            }
        });
    }

    private static final class SubscriptionManagerCallback<T>
    implements SubscriptionManager.Callback<T> {
        private ApolloSubscriptionCall.Callback<T> originalCallback;
        private RealApolloSubscriptionCall<T> delegate;

        SubscriptionManagerCallback(ApolloSubscriptionCall.Callback<T> originalCallback, RealApolloSubscriptionCall<T> delegate) {
            this.originalCallback = originalCallback;
            this.delegate = delegate;
        }

        @Override
        public void onResponse(@NotNull SubscriptionResponse<T> response) {
            ApolloSubscriptionCall.Callback callback = this.originalCallback;
            if (callback != null) {
                ((RealApolloSubscriptionCall)this.delegate).cacheResponse(response);
                callback.onResponse(response.response);
            }
        }

        @Override
        public void onError(@NotNull ApolloSubscriptionException error) {
            ApolloSubscriptionCall.Callback<T> callback = this.originalCallback;
            if (callback != null) {
                callback.onFailure(error);
            }
            this.terminate();
        }

        @Override
        public void onNetworkError(@NotNull Throwable t) {
            ApolloSubscriptionCall.Callback<T> callback = this.originalCallback;
            if (callback != null) {
                callback.onFailure(new ApolloNetworkException("Subscription failed", t));
            }
            this.terminate();
        }

        @Override
        public void onCompleted() {
            ApolloSubscriptionCall.Callback<T> callback = this.originalCallback;
            if (callback != null) {
                callback.onCompleted();
            }
            this.terminate();
        }

        @Override
        public void onTerminated() {
            ApolloSubscriptionCall.Callback<T> callback = this.originalCallback;
            if (callback != null) {
                callback.onTerminated();
            }
            this.terminate();
        }

        @Override
        public void onConnected() {
            ApolloSubscriptionCall.Callback<T> callback = this.originalCallback;
            if (callback != null) {
                callback.onConnected();
            }
        }

        void terminate() {
            RealApolloSubscriptionCall<T> delegate = this.delegate;
            if (delegate != null) {
                ((RealApolloSubscriptionCall)delegate).terminate();
            }
        }

        void release() {
            this.originalCallback = null;
            this.delegate = null;
        }
    }
}

