/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.cache.normalized;

import com.apollographql.apollo.api.InputFieldWriter;
import com.apollographql.apollo.api.InputType;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.internal.cache.normalized.CacheKeyBuilder;
import com.apollographql.apollo.internal.json.JsonWriter;
import com.apollographql.apollo.internal.json.SortedInputFieldMapWriter;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;

public class RealCacheKeyBuilder
implements CacheKeyBuilder {
    private final Comparator<String> argumentNameComparator = new Comparator<String>(){

        @Override
        public int compare(String first, String second) {
            return first.compareTo(second);
        }
    };

    @Override
    @NotNull
    public String build(@NotNull ResponseField field, @NotNull Operation.Variables variables) {
        Utils.checkNotNull((Object)field, (Object)"field == null");
        Utils.checkNotNull((Object)variables, (Object)"variables == null");
        if (field.arguments().isEmpty()) {
            return field.fieldName();
        }
        Map<String, Object> resolvedArguments = this.resolveArguments(field.arguments(), variables);
        try {
            Buffer buffer = new Buffer();
            JsonWriter jsonWriter = JsonWriter.of((BufferedSink)buffer);
            jsonWriter.setSerializeNulls(true);
            com.apollographql.apollo.internal.json.Utils.writeToJson(resolvedArguments, jsonWriter);
            jsonWriter.close();
            return String.format("%s(%s)", field.fieldName(), buffer.readUtf8());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, Object> resolveArguments(Map<String, Object> objectMap, Operation.Variables variables) {
        TreeMap<String, Object> result = new TreeMap<String, Object>(this.argumentNameComparator);
        for (Map.Entry<String, Object> entry : objectMap.entrySet()) {
            if (entry.getValue() instanceof Map) {
                Map nestedObjectMap = (Map)entry.getValue();
                if (ResponseField.isArgumentValueVariableType((Map)nestedObjectMap)) {
                    result.put(entry.getKey(), this.resolveVariableArgument(nestedObjectMap, variables));
                    continue;
                }
                result.put(entry.getKey(), this.resolveArguments(nestedObjectMap, variables));
                continue;
            }
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private Object resolveVariableArgument(Map<String, Object> objectMap, Operation.Variables variables) {
        Object variable = objectMap.get("variableName");
        Object resolvedVariable = variables.valueMap().get(variable);
        if (resolvedVariable == null) {
            return null;
        }
        if (resolvedVariable instanceof Map) {
            return this.resolveArguments((Map)resolvedVariable, variables);
        }
        if (resolvedVariable instanceof InputType) {
            try {
                SortedInputFieldMapWriter inputFieldMapWriter = new SortedInputFieldMapWriter(this.argumentNameComparator);
                ((InputType)resolvedVariable).marshaller().marshal((InputFieldWriter)inputFieldMapWriter);
                return this.resolveArguments(inputFieldMapWriter.map(), variables);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return resolvedVariable;
    }
}

