/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.json;

import com.apollographql.apollo.internal.json.JsonScope;
import com.apollographql.apollo.internal.json.JsonUtf8Writer;
import com.apollographql.apollo.json.JsonDataException;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import okio.BufferedSink;
import org.jetbrains.annotations.Nullable;

public abstract class JsonWriter
implements Closeable,
Flushable {
    int stackSize = 0;
    final int[] scopes = new int[32];
    final String[] pathNames = new String[32];
    final int[] pathIndices = new int[32];
    String indent;
    boolean lenient;
    boolean serializeNulls;
    boolean promoteValueToName;

    public static JsonWriter of(BufferedSink sink) {
        return new JsonUtf8Writer(sink);
    }

    JsonWriter() {
    }

    final int peekScope() {
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        return this.scopes[this.stackSize - 1];
    }

    final void pushScope(int newTop) {
        if (this.stackSize == this.scopes.length) {
            throw new JsonDataException("Nesting too deep at " + this.getPath() + ": circular reference?");
        }
        this.scopes[this.stackSize++] = newTop;
    }

    final void replaceTop(int topOfStack) {
        this.scopes[this.stackSize - 1] = topOfStack;
    }

    public void setIndent(String indent) {
        this.indent = !indent.isEmpty() ? indent : null;
    }

    public final String getIndent() {
        return this.indent != null ? this.indent : "";
    }

    public final void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public final boolean isLenient() {
        return this.lenient;
    }

    public final void setSerializeNulls(boolean serializeNulls) {
        this.serializeNulls = serializeNulls;
    }

    public final boolean getSerializeNulls() {
        return this.serializeNulls;
    }

    public abstract JsonWriter beginArray() throws IOException;

    public abstract JsonWriter endArray() throws IOException;

    public abstract JsonWriter beginObject() throws IOException;

    public abstract JsonWriter endObject() throws IOException;

    public abstract JsonWriter name(String var1) throws IOException;

    public abstract JsonWriter value(@Nullable String var1) throws IOException;

    public abstract JsonWriter nullValue() throws IOException;

    public abstract JsonWriter value(boolean var1) throws IOException;

    public abstract JsonWriter value(@Nullable Boolean var1) throws IOException;

    public abstract JsonWriter value(double var1) throws IOException;

    public abstract JsonWriter value(long var1) throws IOException;

    public abstract JsonWriter value(@Nullable Number var1) throws IOException;

    final void promoteValueToName() throws IOException {
        int context = this.peekScope();
        if (context != 5 && context != 3) {
            throw new IllegalStateException("Nesting problem.");
        }
        this.promoteValueToName = true;
    }

    public final String getPath() {
        return JsonScope.getPath(this.stackSize, this.scopes, this.pathNames, this.pathIndices);
    }
}

