/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.normalized;

import com.apollographql.apollo.api.internal.Action;
import com.apollographql.apollo.api.internal.Function;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.CacheHeaders;
import com.apollographql.apollo.cache.normalized.CacheKey;
import com.apollographql.apollo.cache.normalized.CacheReference;
import com.apollographql.apollo.cache.normalized.NormalizedCache;
import com.apollographql.apollo.cache.normalized.Record;
import com.nytimes.android.external.cache.Cache;
import com.nytimes.android.external.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OptimisticNormalizedCache
extends NormalizedCache {
    private final Cache<String, RecordJournal> lruCache = CacheBuilder.newBuilder().build();

    @Override
    @Nullable
    public Record loadRecord(final @NotNull String key, final @NotNull CacheHeaders cacheHeaders) {
        Utils.checkNotNull((Object)key, (Object)"key == null");
        Utils.checkNotNull((Object)cacheHeaders, (Object)"cacheHeaders == null");
        try {
            Optional nonOptimisticRecord = this.nextCache().flatMap((Function)new Function<NormalizedCache, Optional<Record>>(){

                @NotNull
                public Optional<Record> apply(@NotNull NormalizedCache cache) {
                    return Optional.fromNullable((Object)cache.loadRecord(key, cacheHeaders));
                }
            });
            final RecordJournal journal = (RecordJournal)this.lruCache.getIfPresent((Object)key);
            if (journal != null) {
                return (Record)nonOptimisticRecord.map((Function)new Function<Record, Record>(){

                    @NotNull
                    public Record apply(@NotNull Record record) {
                        Record result = record.clone();
                        result.mergeWith(journal.snapshot);
                        return result;
                    }
                }).or((Object)journal.snapshot.clone());
            }
            return (Record)nonOptimisticRecord.orNull();
        }
        catch (Exception ignore) {
            return null;
        }
    }

    @Override
    public void clearAll() {
        this.lruCache.invalidateAll();
        this.nextCache().apply((Action)new Action<NormalizedCache>(){

            public void apply(@NotNull NormalizedCache cache) {
                cache.clearAll();
            }
        });
    }

    @Override
    public boolean remove(final @NotNull CacheKey cacheKey, final boolean cascade) {
        Utils.checkNotNull((Object)cacheKey, (Object)"cacheKey == null");
        boolean result = (Boolean)this.nextCache().map((Function)new Function<NormalizedCache, Boolean>(){

            @NotNull
            public Boolean apply(@NotNull NormalizedCache cache) {
                return cache.remove(cacheKey, cascade);
            }
        }).or((Object)Boolean.FALSE);
        RecordJournal recordJournal = (RecordJournal)this.lruCache.getIfPresent((Object)cacheKey.key());
        if (recordJournal != null) {
            this.lruCache.invalidate((Object)cacheKey.key());
            result = true;
            if (cascade) {
                for (CacheReference cacheReference : recordJournal.snapshot.referencedFields()) {
                    result &= this.remove(CacheKey.from(cacheReference.key()), true);
                }
            }
        }
        return result;
    }

    @NotNull
    public Set<String> mergeOptimisticUpdates(@NotNull Collection<Record> recordSet) {
        LinkedHashSet<String> aggregatedDependentKeys = new LinkedHashSet<String>();
        for (Record record : recordSet) {
            aggregatedDependentKeys.addAll(this.mergeOptimisticUpdate(record));
        }
        return aggregatedDependentKeys;
    }

    @NotNull
    public Set<String> mergeOptimisticUpdate(@NotNull Record record) {
        Utils.checkNotNull((Object)record, (Object)"record == null");
        RecordJournal journal = (RecordJournal)this.lruCache.getIfPresent((Object)record.key());
        if (journal == null) {
            this.lruCache.put((Object)record.key(), (Object)new RecordJournal(record));
            return Collections.singleton(record.key());
        }
        return journal.commit(record);
    }

    @NotNull
    public Set<String> removeOptimisticUpdates(@NotNull UUID mutationId) {
        Utils.checkNotNull((Object)mutationId, (Object)"mutationId == null");
        HashSet<String> changedCacheKeys = new HashSet<String>();
        HashSet<String> removedKeys = new HashSet<String>();
        ConcurrentMap recordJournals = this.lruCache.asMap();
        for (Map.Entry entry : recordJournals.entrySet()) {
            String cacheKey = (String)entry.getKey();
            RecordJournal journal = (RecordJournal)entry.getValue();
            changedCacheKeys.addAll(journal.revert(mutationId));
            if (!journal.history.isEmpty()) continue;
            removedKeys.add(cacheKey);
        }
        this.lruCache.invalidateAll(removedKeys);
        return changedCacheKeys;
    }

    @Override
    @NotNull
    protected Set<String> performMerge(@NotNull Record apolloRecord, @NotNull CacheHeaders cacheHeaders) {
        return Collections.emptySet();
    }

    @Override
    public Map<Class, Map<String, Record>> dump() {
        LinkedHashMap records = new LinkedHashMap();
        for (Map.Entry entry : this.lruCache.asMap().entrySet()) {
            records.put(entry.getKey(), ((RecordJournal)entry.getValue()).snapshot);
        }
        LinkedHashMap<Class, Map<String, Record>> dump = new LinkedHashMap<Class, Map<String, Record>>();
        dump.put(this.getClass(), Collections.unmodifiableMap(records));
        if (this.nextCache().isPresent()) {
            dump.putAll(((NormalizedCache)this.nextCache().get()).dump());
        }
        return dump;
    }

    private static final class RecordJournal {
        Record snapshot;
        final List<Record> history = new ArrayList<Record>();

        RecordJournal(Record mutationRecord) {
            this.snapshot = mutationRecord.clone();
            this.history.add(mutationRecord.clone());
        }

        Set<String> commit(Record record) {
            this.history.add(this.history.size(), record.clone());
            return this.snapshot.mergeWith(record);
        }

        Set<String> revert(UUID mutationId) {
            int recordIndex = -1;
            for (int i = 0; i < this.history.size(); ++i) {
                if (!mutationId.equals(this.history.get(i).mutationId())) continue;
                recordIndex = i;
                break;
            }
            if (recordIndex == -1) {
                return Collections.emptySet();
            }
            HashSet<String> changedKeys = new HashSet<String>();
            changedKeys.add(this.history.remove(recordIndex).key());
            for (int i = Math.max(0, recordIndex - 1); i < this.history.size(); ++i) {
                Record record = this.history.get(i);
                if (i == Math.max(0, recordIndex - 1)) {
                    this.snapshot = record.clone();
                    continue;
                }
                changedKeys.addAll(this.snapshot.mergeWith(record));
            }
            return changedKeys;
        }
    }
}

