/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.response;

import com.apollographql.apollo.internal.json.Utils;
import java.util.List;
import java.util.Map;

public abstract class CustomTypeValue<T> {
    public final T value;

    public static CustomTypeValue fromRawValue(Object value) {
        if (value instanceof Map || value instanceof List) {
            try {
                return new GraphQLJsonString(Utils.toJsonString(value));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (value instanceof Boolean) {
            return new GraphQLBoolean((Boolean)value);
        }
        if (value instanceof Number) {
            return new GraphQLNumber((Number)value);
        }
        return new GraphQLString(value.toString());
    }

    private CustomTypeValue(T value) {
        this.value = value;
    }

    public static class GraphQLJsonString
    extends CustomTypeValue<String> {
        public GraphQLJsonString(String value) {
            super(value);
        }
    }

    public static class GraphQLNumber
    extends CustomTypeValue<Number> {
        public GraphQLNumber(Number value) {
            super(value);
        }
    }

    public static class GraphQLBoolean
    extends CustomTypeValue<Boolean> {
        public GraphQLBoolean(Boolean value) {
            super(value);
        }
    }

    public static class GraphQLString
    extends CustomTypeValue<String> {
        public GraphQLString(String value) {
            super(value);
        }
    }
}

