/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.fetcher;

import com.apollographql.apollo.fetcher.ResponseFetcher;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.internal.ApolloLogger;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;

public final class NetworkOnlyFetcher
implements ResponseFetcher {
    @Override
    public ApolloInterceptor provideInterceptor(ApolloLogger apolloLogger) {
        return new NetworkOnlyInterceptor();
    }

    private static final class NetworkOnlyInterceptor
    implements ApolloInterceptor {
        private NetworkOnlyInterceptor() {
        }

        @Override
        public void interceptAsync(@Nonnull ApolloInterceptor.InterceptorRequest request, @Nonnull ApolloInterceptorChain chain, @Nonnull Executor dispatcher, @Nonnull ApolloInterceptor.CallBack callBack) {
            ApolloInterceptor.InterceptorRequest networkRequest = request.toBuilder().fetchFromCache(false).build();
            chain.proceedAsync(networkRequest, dispatcher, callBack);
        }

        @Override
        public void dispose() {
        }
    }
}

