/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.fetcher;

import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.fetcher.ResponseFetcher;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.internal.ApolloLogger;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;

public final class CacheFirstFetcher
implements ResponseFetcher {
    @Override
    public ApolloInterceptor provideInterceptor(ApolloLogger apolloLogger) {
        return new CacheFirstInterceptor();
    }

    private static final class CacheFirstInterceptor
    implements ApolloInterceptor {
        volatile boolean disposed;

        private CacheFirstInterceptor() {
        }

        @Override
        public void interceptAsync(final @Nonnull ApolloInterceptor.InterceptorRequest request, final @Nonnull ApolloInterceptorChain chain, final @Nonnull Executor dispatcher, final @Nonnull ApolloInterceptor.CallBack callBack) {
            ApolloInterceptor.InterceptorRequest cacheRequest = request.toBuilder().fetchFromCache(true).build();
            chain.proceedAsync(cacheRequest, dispatcher, new ApolloInterceptor.CallBack(){

                @Override
                public void onResponse(@Nonnull ApolloInterceptor.InterceptorResponse response) {
                    callBack.onResponse(response);
                }

                @Override
                public void onFailure(@Nonnull ApolloException e) {
                    if (!CacheFirstInterceptor.this.disposed) {
                        ApolloInterceptor.InterceptorRequest networkRequest = request.toBuilder().fetchFromCache(false).build();
                        chain.proceedAsync(networkRequest, dispatcher, callBack);
                    }
                }

                @Override
                public void onCompleted() {
                    callBack.onCompleted();
                }

                @Override
                public void onFetch(ApolloInterceptor.FetchSourceType sourceType) {
                    callBack.onFetch(sourceType);
                }
            });
        }

        @Override
        public void dispose() {
            this.disposed = true;
        }
    }
}

