/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.json;

import com.apollographql.apollo.CustomTypeAdapter;
import com.apollographql.apollo.api.InputFieldMarshaller;
import com.apollographql.apollo.api.InputFieldWriter;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.internal.json.JsonWriter;
import com.apollographql.apollo.response.ScalarTypeAdapters;
import java.io.IOException;
import javax.annotation.Nonnull;

public class InputFieldJsonWriter
implements InputFieldWriter {
    private final JsonWriter jsonWriter;
    private final ScalarTypeAdapters scalarTypeAdapters;

    public InputFieldJsonWriter(JsonWriter jsonWriter, ScalarTypeAdapters scalarTypeAdapters) {
        this.jsonWriter = jsonWriter;
        this.scalarTypeAdapters = scalarTypeAdapters;
    }

    public void writeString(@Nonnull String fieldName, String value) throws IOException {
        Utils.checkNotNull((Object)fieldName, (Object)"fieldName == null");
        if (value != null) {
            this.jsonWriter.name(fieldName).value(value);
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    public void writeInt(@Nonnull String fieldName, Integer value) throws IOException {
        Utils.checkNotNull((Object)fieldName, (Object)"fieldName == null");
        if (value != null) {
            this.jsonWriter.name(fieldName).value(value);
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    public void writeLong(@Nonnull String fieldName, Long value) throws IOException {
        Utils.checkNotNull((Object)fieldName, (Object)"fieldName == null");
        if (value != null) {
            this.jsonWriter.name(fieldName).value(value);
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    public void writeDouble(@Nonnull String fieldName, Double value) throws IOException {
        Utils.checkNotNull((Object)fieldName, (Object)"fieldName == null");
        if (value != null) {
            this.jsonWriter.name(fieldName).value(value);
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    public void writeBoolean(@Nonnull String fieldName, Boolean value) throws IOException {
        Utils.checkNotNull((Object)fieldName, (Object)"fieldName == null");
        if (value != null) {
            this.jsonWriter.name(fieldName).value(value);
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    public void writeCustom(@Nonnull String fieldName, ScalarType scalarType, Object value) throws IOException {
        Utils.checkNotNull((Object)fieldName, (Object)"fieldName == null");
        if (value != null) {
            CustomTypeAdapter<Object> customTypeAdapter = this.scalarTypeAdapters.adapterFor(scalarType);
            this.writeString(fieldName, customTypeAdapter.encode(value));
        } else {
            this.writeString(fieldName, null);
        }
    }

    public void writeObject(@Nonnull String fieldName, InputFieldMarshaller marshaller) throws IOException {
        Utils.checkNotNull((Object)fieldName, (Object)"fieldName == null");
        if (marshaller != null) {
            this.jsonWriter.name(fieldName).beginObject();
            marshaller.marshal((InputFieldWriter)this);
            this.jsonWriter.endObject();
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    public void writeList(@Nonnull String fieldName, InputFieldWriter.ListWriter listWriter) throws IOException {
        Utils.checkNotNull((Object)fieldName, (Object)"fieldName == null");
        if (listWriter != null) {
            this.jsonWriter.name(fieldName).beginArray();
            listWriter.write((InputFieldWriter.ListItemWriter)new JsonListItemWriter(this.jsonWriter, this.scalarTypeAdapters));
            this.jsonWriter.endArray();
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    private static final class JsonListItemWriter
    implements InputFieldWriter.ListItemWriter {
        private final JsonWriter jsonWriter;
        private final ScalarTypeAdapters scalarTypeAdapters;

        JsonListItemWriter(JsonWriter jsonWriter, ScalarTypeAdapters scalarTypeAdapters) {
            this.jsonWriter = jsonWriter;
            this.scalarTypeAdapters = scalarTypeAdapters;
        }

        public void writeString(String value) throws IOException {
            if (value == null) {
                this.jsonWriter.nullValue();
            } else {
                this.jsonWriter.value(value);
            }
        }

        public void writeInt(Integer value) throws IOException {
            if (value == null) {
                this.jsonWriter.nullValue();
            } else {
                this.jsonWriter.value(value);
            }
        }

        public void writeLong(Long value) throws IOException {
            if (value == null) {
                this.jsonWriter.nullValue();
            } else {
                this.jsonWriter.value(value);
            }
        }

        public void writeDouble(Double value) throws IOException {
            if (value == null) {
                this.jsonWriter.nullValue();
            } else {
                this.jsonWriter.value(value);
            }
        }

        public void writeBoolean(Boolean value) throws IOException {
            if (value == null) {
                this.jsonWriter.nullValue();
            } else {
                this.jsonWriter.value(value);
            }
        }

        public void writeCustom(ScalarType scalarType, Object value) throws IOException {
            if (value == null) {
                this.jsonWriter.nullValue();
            } else {
                CustomTypeAdapter<Object> customTypeAdapter = this.scalarTypeAdapters.adapterFor(scalarType);
                this.writeString(customTypeAdapter.encode(value));
            }
        }

        public void writeObject(InputFieldMarshaller marshaller) throws IOException {
            if (marshaller == null) {
                this.jsonWriter.nullValue();
            } else {
                this.jsonWriter.beginObject();
                marshaller.marshal((InputFieldWriter)new InputFieldJsonWriter(this.jsonWriter, this.scalarTypeAdapters));
                this.jsonWriter.endObject();
            }
        }

        public void writeList(InputFieldWriter.ListWriter listWriter) throws IOException {
            if (listWriter == null) {
                this.jsonWriter.nullValue();
            } else {
                listWriter.write((InputFieldWriter.ListItemWriter)new JsonListItemWriter(this.jsonWriter, this.scalarTypeAdapters));
            }
        }
    }
}

