/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.normalized;

import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.internal.cache.normalized.RecordWeigher;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Record {
    private static final int UNKNOWN_SIZE_ESTIMATE = -1;
    private final String key;
    private final Map<String, Object> fields;
    private volatile UUID mutationId;
    private volatile int sizeInBytes = -1;

    public static Builder builder(@Nonnull String key) {
        return new Builder((String)Utils.checkNotNull((Object)key, (Object)"key == null"), new LinkedHashMap<String, Object>(), null);
    }

    public Builder toBuilder() {
        return new Builder(this.key(), this.fields, this.mutationId);
    }

    Record(String key, Map<String, Object> fields, UUID mutationId) {
        this.key = key;
        this.fields = fields;
        this.mutationId = mutationId;
    }

    public Object field(String fieldKey) {
        return this.fields.get(fieldKey);
    }

    public boolean hasField(String fieldKey) {
        return this.fields.containsKey(fieldKey);
    }

    public String key() {
        return this.key;
    }

    public UUID mutationId() {
        return this.mutationId;
    }

    public Record clone() {
        return this.toBuilder().build();
    }

    public Set<String> mergeWith(Record otherRecord) {
        HashSet<String> changedKeys = new HashSet<String>();
        for (Map.Entry<String, Object> field : otherRecord.fields.entrySet()) {
            Object newFieldValue = field.getValue();
            boolean hasOldFieldValue = this.fields.containsKey(field.getKey());
            Object oldFieldValue = this.fields.get(field.getKey());
            if (hasOldFieldValue && (oldFieldValue != null || newFieldValue == null) && (oldFieldValue == null || oldFieldValue.equals(newFieldValue))) continue;
            this.fields.put(field.getKey(), newFieldValue);
            changedKeys.add(this.key() + "." + field.getKey());
            this.adjustSizeEstimate(newFieldValue, oldFieldValue);
        }
        this.mutationId = otherRecord.mutationId;
        return changedKeys;
    }

    public Map<String, Object> fields() {
        return this.fields;
    }

    public int sizeEstimateBytes() {
        if (this.sizeInBytes == -1) {
            this.sizeInBytes = RecordWeigher.calculateBytes(this);
        }
        return this.sizeInBytes;
    }

    private void adjustSizeEstimate(Object newFieldValue, Object oldFieldValue) {
        if (this.sizeInBytes != -1) {
            this.sizeInBytes += RecordWeigher.byteChange(newFieldValue, oldFieldValue);
        }
    }

    public static class Builder {
        private final Map<String, Object> fields;
        private final String key;
        private UUID mutationId;

        public Builder(String key, Map<String, Object> fields, UUID mutationId) {
            this.key = key;
            this.fields = new LinkedHashMap<String, Object>(fields);
            this.mutationId = mutationId;
        }

        public Builder addField(@Nonnull String key, @Nullable Object value) {
            this.fields.put((String)Utils.checkNotNull((Object)key, (Object)"key == null"), value);
            return this;
        }

        public Builder addFields(@Nonnull Map<String, Object> fields) {
            Utils.checkNotNull(fields, (Object)"fields == null");
            this.fields.putAll(fields);
            return this;
        }

        public String key() {
            return this.key;
        }

        public Builder mutationId(UUID mutationId) {
            this.mutationId = mutationId;
            return this;
        }

        public Record build() {
            return new Record(this.key, this.fields, this.mutationId);
        }
    }
}

