/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.cache.CacheHeaders;
import com.apollographql.apollo.exception.ApolloCanceledException;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloHttpException;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.exception.ApolloParseException;
import com.apollographql.apollo.internal.util.Cancelable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ApolloCall<T>
extends Cancelable {
    public void enqueue(@Nullable Callback<T> var1);

    @Nonnull
    public ApolloCall<T> cacheHeaders(@Nonnull CacheHeaders var1);

    @Nonnull
    public ApolloCall<T> clone();

    @Nonnull
    public Operation operation();

    @Override
    public void cancel();

    public static enum StatusEvent {
        SCHEDULED,
        FETCH_CACHE,
        FETCH_NETWORK,
        COMPLETED;

    }

    public static abstract class Callback<T> {
        public abstract void onResponse(@Nonnull Response<T> var1);

        public abstract void onFailure(@Nonnull ApolloException var1);

        public void onStatusEvent(@Nonnull StatusEvent event) {
        }

        public void onHttpError(@Nonnull ApolloHttpException e) {
            this.onFailure(e);
            okhttp3.Response response = e.rawResponse();
            if (response != null) {
                response.close();
            }
        }

        public void onNetworkError(@Nonnull ApolloNetworkException e) {
            this.onFailure(e);
        }

        public void onParseError(@Nonnull ApolloParseException e) {
            this.onFailure(e);
        }

        public void onCanceledError(@Nonnull ApolloCanceledException e) {
            this.onFailure(e);
        }
    }
}

